/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-10-15/LGPL Deployment (2025-10-15)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @type FieldName
// Name for a field.
// <p>
// Must be unique across all fields of its containing field container as well as a valid
// JavaScript identifier, as specified by ECMA-262 Section 7.6.
// <p>
// Note: The <smartclient>+link{String.isValidID()}</smartclient>
// <smartgwt>StringUtil.isValidID()</smartgwt> function can be used to test whether a name is
// a valid JavaScript identifier.
// @baseType Identifier
// @serverDS allowed
// @visibility external
//<


//> @object Field
// Base type representing a field.
// <p>
// Field container implementations may extend this type with additional attributes and/or
// methods. For example, +link{DataSource} uses +link{DataSourceField}, +link{DataBoundComponent}
// uses +link{DBCField}, and +link{ListGrid} uses +link{ListGridField} (itself an extension of
// <code>DBCField</code>).
// <p>
// In general, <code>Field</code> instances should not be shared with multiple field containers.
// @treeLocation Client Reference/Data Binding
// @visibility external
//<


//> @attr Field.name (FieldName : null : IR)
// Name of the field.
// @visibility external
//<

//> @attr Field.type (Identifier : null : IR)
// Type of the field. This may be a built-in +link{FieldType}, the +link{SimpleType.name, name}
// of a +link{SimpleType}, or the +link{DataSource.ID, ID} of a +link{DataSource}.
// @visibility external
//<

//> @attr Field.title (HTMLString : null : IRW)
// An +link{HTMLString} to use as the displayable title for this field outside the context of
// a field container.
// <p>
// Within a +link{DataBoundComponent}:
// <ul>
// <li>A field's title may be set with +link{DataBoundComponent.setFieldTitle()}.
// <li>Always call the +link{DataBoundComponent.getFieldTitle()} method to obtain the field's title.
// </ul>

// @see Field.exportTitle
// @visibility external
//<

//> @attr Field.exportTitle (HTMLString : null : IR)
// Optional title HTML to use for the field in exports.
// @visibility external
//<

//> @attr Field.escapeHTML (Boolean : null : IRW)
// If set to <code>true</code>, then values for the field will be HTML-escaped.
// @visibility external
//<

//> @attr Field.multiple (Boolean : null : IR)
// If set to <code>true</code>, then the field is array-valued.
// @visibility external
//<

//> @attr Field.required (Boolean : null : IR)
// If set to <code>true</code>, then a value for this field is required to pass validation.
// @visibility external
//<

//> @attr Field.canEdit (Boolean : null : IR)
// If set to <code>true</code>, then values for the field are considered editable. If set to
// <code>false</code>, then values for the field cannot be edited. If <code>null</code>,
// then the determination is left to the field container.
// @visibility external
//<

//> @attr Field.canExport (Boolean : null : IR)
// If set to <code>true</code>, then values for the field are considered exportable. If set to
// <code>false</code>, then values for the field will not be exported. If <code>null</code>,
// then the determination is left to the field container.
// @visibility external
//<

//> @attr Field.sortByField (FieldName : null : IR)
// If set to a field name, causes the field to be sorted by the values in the specified field,
// for both client- and server-side sorting.
// @visibility external
//<

//> @attr Field.valueMap (ValueMap : null : IR)
// If set, specifies the set of legal values for the field.
// @visibility external
//<


//> @interface FieldContainer
// Base interface for an object which contains fields.
// @treeLocation Client Reference/Data Binding

//<
isc.defineInterface("FieldContainer");

isc.Class.addProperties({
    //> @attr Class.unknownFieldTitle (HTMLString : "[Unknown field]" : RW)
    // Substitute title to use for an unknown field.
    // @group i18nMessages
    // @visibility external
    //<
    unknownFieldTitle: "[Unknown field]",

    //> @attr Class.unnamedFieldTitle (HTMLString : "[Unnamed field]" : RW)
    // Substitute title to use for a title-less, unnamed field.
    // @group i18nMessages
    // @visibility external
    //<
    unnamedFieldTitle: "[Unnamed field]"
});
isc.Class.addProperties({
    

    //> @method FieldContainer.getAllFields()
    // Returns the set of all fields contained in this field container.
    // <p>
    // The returned array is <strong>read-only</strong>.
    //
    // @return (Array of Field) The fields in this field container, or possibly <code>null</code>
    // or an empty array if this field container has no fields.
    
    //<

    //> @method FieldContainer.getAllFieldNames()
    // Returns the set of names of all fields contained in this field container.
    // <p>
    // The returned array is <strong>read-only</strong>.
    //
    // @return (Array of FieldName) The names of all fields in this field container, or
    // possibly <code>null</code> or an empty array if this field container has no named fields.
    
    //<
    getAllFieldNames : function () {
        var allFields = this.getAllFields();
        if (!allFields) return null;
        var allNamedFields = allFields.filter(function (field) {
            return !!field && isc.isA.nonemptyString(field.name);
        });
        return allNamedFields.getProperty("name");
    },

    //> @method FieldContainer.getFieldByName()
    // Returns the specified field in this field container.
    //
    // @param fieldId (FieldName) The name or other identifier of the field.
    // @return (Field) The field, or possibly <code>null</code> if this field container does not
    // contain such a field.
    
    //<

    //> @method FieldContainer.getUnderlyingField()
    // Returns a +link{Field} for the specified field, if any information about such a field
    // is known.
    // <p>
    // Some field containers are a fa&ccedil;ade around one or more other field containers,
    // called underlying field containers, whose fields are called underlying fields. Even
    // though this field container might not add a field for an underlying field to its set of
    // all fields (meaning that +link{getFieldByName()} would return <code>null</code>),
    // getUnderlyingField() can be used to retrieve an underlying field.
    // <p>
    // If this field container has a <code>Field</code> with the specified name, then that
    // <code>Field</code> will be returned. Otherwise, this field container will attempt to
    // return a <code>Field</code> from an underlying field container.
    //
    // @param fieldId (FieldName) The name or other identifier of the field.
    // @return (Field)
    
    //<
    getUnderlyingField : function (fieldId) {
        return this.getFieldByName(fieldId);
    },

    //> @method FieldContainer.getFieldTitle()
    // Returns an +link{HTMLString} to use as the displayable title for the specified field.
    // <p>
    // Even though a <code>Field</code> object has a +link{Field.title, title} property, this
    // method should be used to obtain the field's title in the context of this field container,
    // because the field container implementation may offer further customization of the field's
    // title HTML.
    //
    // @param fieldId (FieldName) The name or other identifier of the field.
    // @return (HTMLString) The specified field's title.
    
    //<
    getFieldTitle : function (fieldId) {
        var field = isc.isA.String(fieldId) || !isc.isAn.Object(fieldId) ? this.getUnderlyingField(fieldId) : fieldId;
        if (!field) return this.unknownFieldTitle;
        if (isc.isA.String(field.title)) return field.title;
        return field.name || this.unnamedFieldTitle;
    },

    //> @method FieldContainer.setFieldTitle()
    // Sets the title of the specified field.
    //
    // @param fieldId (FieldName | Field) The field to update.
    // @param newTitle (HTMLString) The new title.
    
    //<
    setFieldTitle : function (fieldId, newTitle) {
        var field = isc.isA.String(fieldId) || !isc.isAn.Object(fieldId) ? this.getFieldByName(fieldId) : fieldId;
        if (!isc.isAn.Object(field)) {
            var message = "No such field " + (!fieldId ? fieldId : "'" + fieldId + "'");
            if (this.logWarn) this.logWarn(message);
            else isc.Log.logWarn(message);
            return;
        }
        field.title = newTitle;
    },

    getFieldTitleForMessages : function (fieldId) {
        var title = this.getFieldTitle(fieldId);
        if (title != this.unknownFieldTitle &&
            title != this.unnamedFieldTitle &&
            String.isWhiteSpace(String.htmlStringToString(title)))
        {
            title = "<q>" + title + "</q>";
        }
        return title;
    }
});

isc.defineClass("FieldContainerUtil").addClassProperties({
    _getFieldTitle : function (fieldId, fieldContainer) {
        if (fieldContainer) return fieldContainer.getFieldTitle(fieldId);

        if (fieldId == null) return isc.Class.getInstanceProperty("unknownFieldTitle");
        if (isc.isA.String(fieldId) || !isc.isAn.Object(fieldId)) {
            return String(fieldId);
        }
        var field = fieldId;
        if (isc.isA.String(field.title)) return field.title;
        if (field.name) return field.name;
        return isc.Class.getInstanceProperty("unnamedFieldTitle");
    },

    _getFieldTitleForMessages : function (fieldId, fieldContainer) {
        if (fieldContainer) return fieldContainer.getFieldTitleForMessages(fieldId);

        var title = this._getFieldTitle(fieldId, null);
        if (title != isc.Class.getInstanceProperty("unknownFieldTitle") &&
            title != isc.Class.getInstanceProperty("unnamedFieldTitle") &&
            String.isWhiteSpace(String.htmlStringToString(title)))
        {
            title = "<q>" + title + "</q>";
        }
        return title;
    }
});


//> @interface DynamicFieldContainer
// Base type representing a dynamic field container: a field container whose set of fields
// can be changed after creation.
// @inheritsFrom FieldContainer
// @treeLocation Client Reference/Data Binding/FieldContainer

//<
isc.defineInterface("DynamicFieldContainer", "FieldContainer");
