/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a request to AI to suggest an appropriate title for a new field that will contain AI-generated record
 * summaries.
 */
@BeanFactory.FrameworkClass
public class SuggestRecordSummaryTitleRequest extends DataBoundAIRequest {

    public static SuggestRecordSummaryTitleRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SuggestRecordSummaryTitleRequest) {
            existingObj.setJsObj(jsObj);
            return (SuggestRecordSummaryTitleRequest)existingObj;
        } else

        {
            return new SuggestRecordSummaryTitleRequest(jsObj);
        }
    }
        


    public SuggestRecordSummaryTitleRequest(){
        
    }

    public SuggestRecordSummaryTitleRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * 
     *
     * @param aiRequest New aiRequest value. Default value is null
     * @return {@link com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest SuggestRecordSummaryTitleRequest} instance, for chaining setter calls
     */
    public SuggestRecordSummaryTitleRequest setAIRequest(SingleSourceAIRequest aiRequest) {
        return (SuggestRecordSummaryTitleRequest)setAttribute("aiRequest", aiRequest == null ? null : aiRequest.getJsObj());
    }

    /**
     * 
     *
     * @return Current aiRequest value. Default value is null
     */
    public SingleSourceAIRequest getAIRequest()  {
        return SingleSourceAIRequest.getOrCreateRef(getAttributeAsJavaScriptObject("aiRequest"));
    }
    

    /**
     * The source of the {@link com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest#getAIRequest aiRequest}.
     *
     * @param aiRequestSource New aiRequestSource value. Default value is null
     * @return {@link com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest SuggestRecordSummaryTitleRequest} instance, for chaining setter calls
     */
    public SuggestRecordSummaryTitleRequest setAIRequestSource(AIMessageSource aiRequestSource) {
        return (SuggestRecordSummaryTitleRequest)setAttribute("aiRequestSource", aiRequestSource == null ? null : aiRequestSource.getValue());
    }

    /**
     * The source of the {@link com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest#getAIRequest aiRequest}.
     *
     * @return Current aiRequestSource value. Default value is null
     */
    public AIMessageSource getAIRequestSource()  {
        return EnumUtil.getEnum(AIMessageSource.values(), getAttribute("aiRequestSource"));
    }
    

    /**
     * The list of field names that are considered visible. <p> By default: <ul> <li>If a {@link
     * com.smartgwt.client.util.AsyncDataBoundOperationParams#getComponent component} is set, then its visible fields will be
     * used. <li>The fields of the {@link com.smartgwt.client.util.AsyncDataBoundOperationParams#getDataSource dataSource}
     * which do not have {@link com.smartgwt.client.data.DataSourceField#getCanView DataSourceField.canView} explicitly set to
     * <code>false</code> and additionally do not have {@link com.smartgwt.client.data.DataSourceField#getHidden
     * DataSourceField.hidden} explicitly set to <code>true</code> are considered the visible fields. </ul>
     *
     * @param visibleFieldNames New visibleFieldNames value. Default value is null
     * @return {@link com.smartgwt.client.ai.SuggestRecordSummaryTitleRequest SuggestRecordSummaryTitleRequest} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public SuggestRecordSummaryTitleRequest setVisibleFieldNames(String... visibleFieldNames) {
        return (SuggestRecordSummaryTitleRequest)setAttribute("visibleFieldNames", visibleFieldNames);
    }

    /**
     * The list of field names that are considered visible. <p> By default: <ul> <li>If a {@link
     * com.smartgwt.client.util.AsyncDataBoundOperationParams#getComponent component} is set, then its visible fields will be
     * used. <li>The fields of the {@link com.smartgwt.client.util.AsyncDataBoundOperationParams#getDataSource dataSource}
     * which do not have {@link com.smartgwt.client.data.DataSourceField#getCanView DataSourceField.canView} explicitly set to
     * <code>false</code> and additionally do not have {@link com.smartgwt.client.data.DataSourceField#getHidden
     * DataSourceField.hidden} explicitly set to <code>true</code> are considered the visible fields. </ul>
     *
     * @return Current visibleFieldNames value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String[] getVisibleFieldNames()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("visibleFieldNames"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
