/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-25/LGPL Deployment (2026-02-25)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @groupDef reactSupport
// SmartClient has robust & comprehensive support for React, including full support for JSX
// and the complete SmartClient API, hundreds of samples, and full support for our low code
// platform, Reify.
// <p>
// All SmartClient components are available in React by importing our
// +link{group:npmjs, npm module}.  React JSX can be used to create and configure SmartClient
// components, including things like ListGrids and their field definitions.  The JSX syntax we
// support is essentially the same as our existing Component XML standard, with minor
// differences that are explained below.  For post-render changes, such as hiding or showing a
// ListGrid field, the full SmartClient API is available in React via the standard "ref"
// mechanism - the same approach used in other popular React frameworks like agGrid, Sencha and
// Kendo (examples are below).
// <p>
// In the SmartClient Showcase, you can click on the React  and see hundreds of samples -
// the same sample set we offer for SmartClient usage in normal JavaScript.  Reify screens can
// be loaded into a React app with a single method call (Reify.loadProject()), or, since Reify
// screens are Component XML, screens created in Reify can be integrated as JSX.  As with
// SmartClient in general, you can use the SmartClient Java Server, or any other server
// technology (via REST and various other built-in integration strategies).
// <p>
// <h4>Installing SmartClient support for React</h4>
// <p>
// To install support for SmartClient Eval, SmartClient LGPL, or another licensed SmartClient
// product for your React app, go to your app's root directory, and then follow the
// instructions for +link{group:npmjs, installing SmartClient with npm}.  This will place the
// SmartClient framework under <code>isomorphic/</code> in your project's root directory, and
// install the SmartClient React support under <code>isomorphic/</code> in your project's source
// directory.  So from your project's root directory, you might invoke the command line:
// <pre>
// npm install smartclient-eval --branch=13.1</pre>
// <p>
// <h4>React JSX and differences from Component XML</h4>
// <p>
// React JSX (shown in blue) can be used to declare SmartClient components as in this sample file:
// <pre>
// import React from 'react';
// import 'smartclient-eval/release';
// import 'smartclient-eval/skins/Tahoe';
// import { SC, IButton } from 'smartclient-eval/react';
//
// SC.render(
//     <span style="color:blue">&lt;DynamicForm numCols="3" autoFocus="true"&gt;
//         &lt;items&gt;
//             &lt;TextItem defaultValue="my friend" name="you" title="Enter your name"
//                       wrapTitle="false" selectOnFocus="true"/&gt;
//             &lt;ButtonItem icon="[SAMPLE]icons/16/message.png" title="Hello" width="80"
//                         startRow="false" click={onButtonItemClick}/&gt;
//         &lt;/items&gt;
//     &lt;/DynamicForm&gt;</span>,
//     document.getElementById("app")
// );</pre>
// where the SmartClient utility class <code>SC</code> provides a <code>render()</code> method
// that internally calls <code>ReactDOM.render()</code> in React pre-18, and
// <code>ReactDOM.createRoot().render()</code> in React 18+, so we don't need different code
// per React version, yet still avoid deprecation warnings.
// <p>
// With a few exceptions, you should be able to use +link{componentXML,Component XML} syntax
// to specify widgets and objects in JSX:<ul>
// <li> +link{Canvas.children} should be specified in JSX with the tag
// <code>childComponents</code> instead, since React reserves the use of
// the <code>children</code> property.
// <li> +link{ListGridField,ListGridFIelds} should be declared in JSX via the tag
// <code>LGField</code> rather than <code>field</code> as in Component XML, since in React
// types are expected to be capitalized and clearly denote the underlying object type.  The
// same applies to +link{DataSource,DataSources} and other +link{dataBoundComponent,DBCs}, such
// as +link{TreeGrid,TreeGrids}, +link{TileGrid,TileGrids} and
// +link{DetailViewer,DetailViewers}, where respectively the tags to use are
// <code>DSField</code>, <code>TGField</code>, and then <code>DVField</code> (for both TileGrid
// and DetailViewer fields).<p>For example:
// <pre>
// &lt;ListGrid ID="myGrid" width="100%"&gt;
//     &lt;fields&gt;
//         &lt;LGField name="countryName" title="Country Name" width="200"/&gt;
//         &lt;LGField name="population"  title="Population" type="integer"/&gt;
//         &lt;LGField name="area"        title="Land Area" type="integer"/&gt;
//     &lt;/fields&gt;
// &lt;/ListGrid&gt;</pre>
// <li> +link{FormItem,FormItems} in a +link{DynamicForm} should be specified with the actual
// tag name of the form item class, such as <code>TextItem</code> or <code>ButtonItem</code>.
// <li> While string methods can be specified in both JSX and Component XML by just assigning
// the string to an attribute, JSX does not support Component XML's <code>JS</code> tag for
// declaring a JavaScript method inside an element.  Instead, you should assign methods by
// using the inline JS syntax for JSX that assigns JavaScript directly to attributes:
// <pre>
// let myHover = function () {
//     return "Hello on " + new Date();
// }
// SC.render(
//     &lt;Canvas border="2px solid red" backgroundColor="yellow" canHover="true" getHoverHTML={myHover}/&gt;,
//     document.getElementById("app")
// );</pre>
// <li>+link{ValueMap,ValueMaps} or other JS objects that have capitalized property names, or
// property names that aren't valid +link{Identifier,Identifiers} will not parse as React JSX.
// So the following Component XML, for example, declared as the value of the
// <code>valueMap</code> property for a component, is <i>not</i> valid JSX:
// <pre>
// &lt;valueMap&gt;
//     &lt;Weather&gt;Current Weather&lt;/Weather&gt;
//     &lt;Year&gt;Expedition Year&lt;/Year&gt;
// &lt;/valueMap&gt;</pre>
// You must instead inline the values as attributes:
// <pre>
// &lt;valueMap Weather="Current Weather" Year="Expedition Year"/&gt;</pre>
// or you can switch to lowercased ValueMap value tags.  This also applies to generic JS
// objects you're assigning as component properties, if they have capitalized property names.
// <p>
// If the ValueMap tag names aren't even valid identifiers, inlining as above  won't work, but
// you can use the alternate ValueMap syntax.  So for example:
// <pre>
// &lt;SelectItem name="level"&gt;
//     &lt;valueMap&gt;
//         &lt;value ID="1"&gt;debug&lt;/value&gt;
//         &lt;value ID="2"&gt;notify&lt;/value&gt;
//         &lt;value ID="3"&gt;warning&lt;/value&gt;
//         &lt;value ID="4"&gt;error&lt;/value&gt;
//    &lt;/valueMap&gt;
// &lt;/SelectItem&gt;</pre>
// In all of these cases, you also have the option of just moving the ValueMap or JS object
// definition up before the JSX and declaring it as JS, and then inlining it by reference as
// was shown earlier for functions.
// <li>React JSX doesn't support redeclaring components defined earlier by applying the
// <code>withID</code> attribute like Component XML.  If you need to refer to other components,
// such as for example with the +link{Layout.minBreadthMember} property, you should just refer
// to them by global ID, where the Framework supports it.  You can also refer to components
// directly via the inline JS syntax for JSX, but only for components defined before the
// current JSX hierarchy, as JS inlining is applied to the entire hierarchy before any of
// components in it are created.
// </ul>
// Your component's definition can be split between JS and JSX, with most of the configuration
// remaining in JS if you prefer.  For example:
// <pre>
// let fields = [{
//     name: "countryName", title: "Country Name", width: 150
// }, {
//     name: "population", title: "Population", type: "integer"
// }, {
//     name: "area", title: "Land Area", type: "integer"
// }];
// let gridConfig = {
//     width: 400, height: 200,
//     canEdit: true, autoFitFieldWidths: true,
//     initialCriteria: {countryName: "United States"}
// };
// SC.render(
//    &lt;ListGrid ID="countryGrid" fields={fields} {...gridConfig} /&gt;,
//    document.getElementById("app")
// );</pre>
// Here, the ListGridFields have been defined in JavaScript, and applied using the inline JS
// syntax for JSX, while the rest of the grid's configuration has been applied using the
// JavaScript ES6 spread operator.  The spread operator allows you to merge JS config with JSX
// attributes while declaring a SmartClient React component.
// <p>
// <h4>Component lifecycle</h4>
// <p>
// SmartClient React support works with the standard
// +externalLink{https://medium.com/codex/the-lifecycle-of-a-react-component-8e01332a068d,React lifecycle}
// and provides helper methods on a component if you need to have access to them.  The
// available functions are:<ul>
//  <li>beforeRender()
//  <li>beforeComponentDidMount()
//  <li>afterComponentDidMount()
//  <li>beforeComponentDidUpdate()
//  <li>afterComponentDidUpdate()
//  <li>beforeComponentWillUnmount()
//  <li>afterComponentWillUnmount()</ul>
// For example:
// <pre>
// import React from 'react';
// import ReactDOM from 'react-dom';
// 
// import 'smartclient-eval/release';
// import 'smartclient-eval/skins/Tahoe';
// 
// import { Button } from 'smartclient-eval/react';
// 
// let beforeComponentDidMount = function() {
//     console.log('Will be executed before componentDidMount step');
// };
// 
// ReactDOM.render(
//     &lt;Button title="Hello, world" width="150" 
//         beforeComponentDidMount={beforeComponentDidMount} /&gt;, 
//     document.getElementById("app")
// );</pre>
// <p>
// <h4>Post-render component changes</h4>
// <p>
// To call SmartClient widget APIs after the component has been rendered, you can just assign
// the component an ID (which will be passed to the underlying widget), and then use it to
// refer to the widget in methods.
// <p>
// Here's a modified version of the
// +externalLink{https://smartclient.com/smartclient-latest/showcase/?id=fetchOperationFS&react,"Live Grid" Showcase sample}
// that illustrates the concept:
// <pre>
// SC.render(
//     &lt;&gt;
//         &lt;ListGrid ID="scGrid" dataSource="supplyItem" width="100%" height="200" autoFetchData="true"/&gt;
//         &lt;Button top="225" title="Start Editing" click="scGrid.startEditing()"/&gt;
//     &lt;/&gt;,
//     document.getElementById("app")
// );</pre>
// where the button click has been made to call a function that starts a row edit operation on
// the grid.
// <p>
// If you need to call React component APIs after the component has been rendered, you can use "React
// refs."  Here's the same sample using React refs:
// <pre>
// let gridRef = React.createRef();
// let editRow = function () {
//     let reactGrid = gridRef.current;
//     reactGrid.getSCComponent().startEditing();
// }
// SC.render(
//     &lt;&gt;
//         &lt;ListGrid dataSource="supplyItem" width="100%" height="200" autoFetchData="true" ref={gridRef}/&gt;
//         &lt;Button top="225" title="Start Editing" click={editRow}/&gt;
//     &lt;/&gt;,
//     document.getElementById("app")
// );</pre>
// <p>
// <h4>Conditional JSX</h4>
// <p>
// We support JSX that contains conditional child elements, such as:<pre>
// &lt;DynamicForm ID="form1" width="621"&gt;
//        &lt;fields&gt;
//               &lt;TextItem name="text" title="Text" hint="A plain text field" defaultValue=""
//                   wrapHintText="false" /&gt;
//                {showPicker && &ltColorItem title="Color Picker" name="colorPicker" /&gt;}
//                &ltTextAreaItem name="textArea" title="TextArea" /&gt;
//        &lt;/fields&gt;
// &lt;/DynamicForm&gt;</pre>
// as well as conditional JSX in attributes assigned via inlined JavaScript.
// <p>
// We recommend using React refs to reconfigure components after construction, as discussed
// above, rather than re-rendering conditional JSX child elements, for the best performance,
// readabillity, and maintainability.
// <p>
// When using conditional JSX, keep in mind:<ul>
// <li>When JSX is re-rendered, React will call <b>componentDidUpdate()</b>, which will cause
// us to apply any detected property changes via +link{class.setProperty(),setters}.  This is
// limited to +link{group:flags,writable properties}.  The underlying SmartClient widget will
// not be recreated.
// <li>To destroy and recreate the SC widget in <b>componentDidUpdate()</b>, you can set the
// attribute <code>recreateOnReactComponentUpdate</code> true on the component.
// <li>Alternatively, if you set the <code>key</code> attribute on the component to a unique
// number, that will force React to re-create and remount the component, so that
// <b>componentDidMount()</b> gets called against, recreating the underlying SC widget.
// <li>When declaring properties that can contain objects, like +link{Window.headerControls()}
// (a list of strings naming specific controls or Canvas instances), any falsy value will
// be considered an excluded child element and skipped.
// <li>For other properties declared with conditional JSX, your conditional element must
// actually evaluate to <code>false</code> to be excluded from the declaration.</ul>
// <p>
// For an example of re-rendering, see the
// +externalLink{https://smartclient.com/smartclient-latest/showcase/?id=gridSavedSearchBuiltin&react,"Saved Search > Built-in" Showcase sample}
// <p>
// <h4>Loading Reify screens</h4>
// <p>
// Suppose you've created a screen in Reify that you want to load into your React app.  You can
// do it via +link{Reify.loadProject()} as in this sample:
// <pre>
// let loadProject = function () {
//     isc.Reify.loadProject("Test Project", function (project, projects, rpcResponse) {
//         isc.RPCManager.getLoadProjectErrorMessage(rpcResponse);
//         if (mainLayout.getMembersLength() > 2) mainLayout.removeMember(2);
// 
//         let screenTitle = project.screens[0].ID,
//             screen = project.createScreen(screenTitle);
//         mainLayout.addMember(screen);
// 
//         isc.notify("Reify '" + screenTitle + "' added");
//     }, {
//         userName: "testuser",
//         password: "password",
//         serverURL: "https://create.reify.com"
//     });
// };
// 
// SC.render(
//     &lt;VLayout ID="mainLayout" width="100%" height="100%" membersMargin="10"
//              defaultLayoutAlign="right"&gt;
//         &lt;members&gt;
//             &lt;Label contents="Loading a screen from Reify into a React Project" height="1"
//                    width="100%" align="center" styleName="pageTitle"/&gt;
//             &lt;Button name="loadProject" title="Load Project" click={loadProject} /&gt;
//         &lt;/members&gt;  
//     &lt;/VLayout&gt;,
//     document.getElementById("app")
// );</pre>
// which assumes your Reify project is named "Test Project", and that it's in a Reify account
// with username "testuser" and password "password".  When the button is clicked, the first
// screen from "Test Project" will be added (or replaced) as the last member of the VLayout.
// For the full sample, please see
// +externalLink{https://smartclient.com/smartclient-latest/showcase/?id=projectLoadingReify&react,"Project Loading" Showcase sample}.
// <p>
// You can also integrate the Component XML from your Reify screen directly into your React
// app.  Suppose you built a screen in Reify consisting of a button and databound grid, so that
// clicking the button started editing the grid.  If you then clicked on "Show code for screen"
// in the "More screen actions" menu, you might see the following Component XML:
// <pre>
// &lt;DataSources loadID="ApplePie,Customer,Employee,Order,OrderLine,Payment,Product,ProductLine,Sale,Salesperson,Office"/&gt;
// 
// &lt;IButton autoID="pressMeButton"&gt;
//     &lt;title&gt;Press Me&lt;/title&gt;
//     &lt;click&gt;
//         &lt;Action target="officeGrid" name="startEditing"/&gt;
//     &lt;/click&gt;
// &lt;/IButton&gt;
// 
// &lt;ListGrid dataSource="Office" autoID="officeGrid" autoFetchData="true"&gt;
//     &lt;fields&gt;
//         &lt;LGField name="officeCode"/&gt;
//         &lt;LGField name="city"/&gt;
//         &lt;LGField name="phone"/&gt;
//         &lt;LGField name="addressLine1"/&gt;
//         &lt;LGField name="addressLine2"/&gt;
//         &lt;LGField name="state"/&gt;
//         &lt;LGField name="country"/&gt;
//         &lt;LGField name="postalCode"/&gt;
//         &lt;LGField name="territory"/&gt;
//     &lt;/fields&gt;
// &lt;/ListGrid&gt;
// 
// &lt;DataView overflow="hidden" autoID="newScreen9" width="100%" height="100%" autoDraw="true"&gt;
//     &lt;members&gt;
//         &lt;Canvas withID="pressMeButton"/&gt;
//         &lt;Canvas withID="officeGrid"/&gt;
//     &lt;/members&gt;
// &lt;/DataView&gt;</pre>
// To add this screen to your React app, you'd first need to make sure to load the
// <code>Office</code>  DataSource used by the grid, by calling +link{DataSource.load()} from
// your app or invoking DataSourceLoader from your app's root HTML.
// <p>
// Then you can just render the Component XML as JSX, remembering to inline the
// <code>withID</code> references since they aren't supported by JSX, and replace the
// <code>DataView</code> with a <code>VLayout</code>:
// <pre>
// SC.render(
//     &lt;VLayout overflow="hidden" width="100%" height="100%" autoDraw="true"&gt;
//         &lt;members&gt;
//             &lt;IButton&gt;
//                 &lt;title&gt;Press Me&lt;/title&gt;
//                 &lt;click&gt;
//                     &lt;Action target="officeGrid" name="startEditing"/&gt;
//                 &lt;/click&gt;
//             &lt;/IButton&gt;
//             &lt;ListGrid dataSource="Office" autoID="officeGrid" autoFetchData="true"&gt;
//                 &lt;fields&gt;
//                     &lt;LGField name="officeCode"/&gt;
//                     &lt;LGField name="city"/&gt;
//                     &lt;LGField name="phone"/&gt;
//                     &lt;LGField name="addressLine1"/&gt;
//                     &lt;LGField name="addressLine2"/&gt;
//                     &lt;LGField name="state"/&gt;
//                     &lt;LGField name="country"/&gt;
//                     &lt;LGField name="postalCode"/&gt;
//                     &lt;LGField name="territory"/&gt;
//                 &lt;/fields&gt;
//             &lt;/ListGrid&gt;
//         &lt;/members&gt;
//     &lt;/VLayout&gt;,
//     document.getElementById("app")
// );</pre>
// Note that we've dropped the autoID attributes, except for <code>officeGrid</code> since we
// need to refer to it in the button's click method.
// <p>
// <h4>Mixing React HTML and SmartClient components</h4>
// <p>
// SmartClient components can be rendered into any DOM element in your app, not just the root,
// allowing you to mix React HTML and SmartClient components.  For example, consider this
// modified version of the default App.js file created for a new React app:
// <pre>
// import React from 'react';
// import logo from './logo.svg';
// import './App.css';
//
// import 'smartclient-eval/release';
// import 'smartclient-eval/skins/Tahoe';
// import { Label } from 'smartclient-eval/react';
//
// function App() {
//     return (
//         &lt;div className="App"&gt;
//             &lt;header className="App-header"&gt;
//             <span style="color:green">&lt;div id="logo"&gt;</span>
//                 &lt;img src={logo} className="App-logo" alt="logo" /&gt;
//             <span style="color:green">&lt;/div&gt;</span><span style="color:blue">
//             &lt;Label backgroundColor="yellow" width="200" height="1" align="center"
//                    contents="SmartClient inside" styleName="pageTitle"/&gt;</span>
//             &lt;p&gt;
//             Edit &lt;code&gt;src/App.tsx&lt;/code&gt; and save to reload.
//             &lt;/p&gt;
//             &lt;a className="App-link" href="https://reactjs.org"
//                target="_blank" rel="noopener noreferrer"&gt;
//             Learn React
//             &lt;/a&gt;
//             &lt;/header&gt;
//         &lt;/div&gt;
//     );
// }
// export default App;</pre>
// A SmartClient Label (shown in blue above) titled "SmartClient inside" has been added under
// the React logo.  This will appear in the DOM underneath the React logo if the app is run,
// showing that you can easily mix React HTML and SmartClient components.
// <p>
// DOM elements created by React HTML can also be replaced dynamically.  In the sample above,
// the React logo itself has also been wrapped in a div (shown in green) with the id "logo" so
// that in another file of the app (or in the click handler of the yellow Label) you can write:
// <pre>
// SC.render(
//     &lt;Label width="150" height="150" margin="20" backgroundColor="green" border="5px solid #ADD8E6"/&gt;,
//     document.getElementById("logo")
// );</pre>
// to replace the logo with a square green SmartClient Label.
// <p>
// <h4>Custom Components</h4>
// <p>
// This section discusses how to extend SmartClient React components to create new custom
// components.  For composition, where you just want to include SmartClient React components in
// your own component, nothing special like this is required.
// <p>
// To define a custom SmartClient framework subclass and automatically create the corresponding
// SmartClient React wrapper class, you can just call the <code>defineClass()</code> method on
// the React <code>SC</code> utility class:
// <pre>
// import React from 'react';
// import ReactDOM from 'react-dom';
//
// import 'smartclient-eval/release';
// import 'smartclient-eval/skins/Tahoe';
// import { SC, Canvas } from 'smartclient-eval/react';
//
// let isc = window.isc;
//
// const MyCanvas = SC.defineClass("MyCanvas", Canvas);
// isc.MyCanvas.addProperties({
//     backgroundColor: "purple",
//     border: "2px solid red",
//     click: "isc.alert('You clicked me!');
// });</pre>
// where the call to <code>defineClass()</code> defines the class for you in both React and
// SmartClient, returning a reference to the React class, so you then must configure your class
// by calling +link{class.addProperties(),addProperties()} on the underlying SmartClient class.
// This is appropriate if you just want to add specific default properties for your class, or
// override documented framework methods. See
// +link{classMethod:classFactory.defineClass(),isc.defineClass()} for further details.
// <p>
// After this JS, you can declare a <code>MyCanvas</code> in your JSX just as if it
// were a built-in framework React class that you imported:
// <pre>
// &lt;MyCanvas width="100" height="200" opacity="20"/&gt;</pre>
// <p>
// If on the other hand, you want to integrate a completely custom React class around your
// SmartClient subclass, you'll have to do a bit more work.  Instead of calling
// <code>SC.defineClass()</code>, you'll need to explictly define your class with ES6 syntax
// like:
// <pre>
// // ... standard imports (see first sample)
// import { Canvas } from 'smartclient-eval/react';
//
// let isc = window.isc;
// isc.defineClass("MyCanvas", isc.Canvas).addProperties({
//     /// ... customize defaults of underlying SmartClient class
// });
//
// class MyCanvas extends Canvas {
//     static ISC_CLASS_NAME = "MyCanvas";
//     static IS_CLASS = true;
//
//     // ... your custom component code
// }</pre>
// and then register it by calling
// <pre>
// ReactComponent.registerClass("MyCanvas", MyCanvas);</pre>
// <p>
// Note that the <code>isc.defineClass()</code> call above is only required if you need to
// also extend the underlying SmartClient class with custom defaults, and have overridden
// <code>ISC_CLASS_NAME</code> in your new React component class.  By convention, the
// underlying SmartClient class is named the same as the React component class that wraps it.
// <p>
// If you create the custom component with <code>SC.defineClass()</code> in one place, you can
// import it elsewhere using <code>SC.importClass()</code>.  On the other hand, if you decide
// to declare your new React wrapper class explicitly like "class MyCanvas extends ..." then
// if you need to use it in multiple files you should move the class definition into its own
// module, and you can then import it wherever needed using standard ES6 module import syntax.
// <p>
// Your custom React component will typically extend a built-in SmartClient React class, like
// <code>Canvas</code>, but all of the SmartClient React support classes ultimately
// extend either <code>IBaseComponent</code> or <code>ILogicalComponent</code>:
// <ul>
//     <li>IBaseComponent.  The base class for components that should be rendered in the DOM:
// ListGrid, Button, etc&hellip;</li>
//     <li>ILogicalComponent.  The base class for components that should <i>not</i> be rendered
// in the DOM: LGField, DSField.</li>
// </ul>
// Note that <code>ISC_CLASS_NAME</code> declares the name of the underlying SmartClient
// framework class used by your new React component.  So if you've not defined such a custom
// subclass (e.g. via SmartClient framework method
// +link{classMethod:classFactory.defineClass(),isc.defineClass()} then you should exclude that
// line.
// <p>
// Be careful overriding built-in React component methods like <code>render()</code>. Often it
// doesn't make sense to override <code>render()</code> when extending a SmartClient React
// component. For example if you extended the SmartClient React class <code>Canvas</code> and
// then overrode <code>render()</code> in that new component class to return &lt;Canvas/&gt;
// you'd actually be rendering a separate new <code>Canvas</code> on top of your new component.
// If you want to control placement of SmartClient React components, you may be better off
// building a container via composition.
// <p>
// <h4>Namespacing</h4>
// <p>
// JavaScript ES6 provide built-in namespacing control to your React files via declared
// imports, so it's unlikely you will have collisions when importing the built-in
// SmartClient React classes.  However, if you do, you can always alias them during import.
// <p>
// So instead of
// <pre>
// import { Canvas } from 'smartclient-eval/react';</pre>
// you can write something like
// <pre>
// import { Canvas as MyCanvas } from 'smartclient-eval/react';</pre>
// to import one or more classes under other names, or
// <pre>
// import * as ReactSC from 'smartclient-eval/react';</pre>
// to import all the SmartClient React classes as a single object.  For further details, read
// about JavaScript import syntax
// +externalLink{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import,here}.
// <p>
// <h4>Further Examples</h4>
// <p>
// We've only covered a relatively small range of features above, but all SmartClient
// features are available, and you can use the full SmartClient Showcase (with over 880
// samples) with React.  For many Showcase samples, the React JSX version can be shown by
// +externalLink{https://smartclient.com/smartclient-latest/showcase/?react,toggling the Showcase to React mode},
// and for the others, they can be ported to a combination of React JSX and JavaScript by
// following the +link{showcasePorting,porting guidelines}.
// <p>
// <h4>Debugging</h4>
// <p>
// Your React app will contain your React components and the React framework, as well as the
// SmartClient framework and any SmartClient widgets or classes you have defined yourself.  All
// of this will be loaded by your browser as one or more fragments created by webpack.  The
// recommended approach depends on how you want to treat the app:<ul>
// <li><b>React App</b>.  Any existing tool designed for React apps can help you.  For
// example, +externalLink{https://raygun.com/blog/react-debugging-guide/,here} is an
// introduction to debugging a React app with the browser inspector, with an example.  Or, for
// an overview of how to run Visual Studio Code inside a browser, so you can target a React +
// SmartClient app, see
// +externalLink{https://code.visualstudio.com/docs/editor/vscode-web,this guide}.
// <li><b>SmartClient app</b>.  Alternatively, if you know the issue directly relates to
// SmartClient widgets or APIs, you can look over the SmartClient +link{debugging} help topic
// and use the Developer Console and the techniques there.</ul>
// <p>
// <h4>Server Installation</h4>
// <p>
// SmartClient's React support allows you to integrate your React apps client side, but your
// apps can also use SmartClient's +link{iscServer,Java server technology}, or with any other
// technology accessible via +link{RestDataSource,REST}, +link{wsdlBinding,WSDL} or
// +link{platformDependencies,HTTP} in general.
//
// @visibility smartclient
// @treeLocation Concepts
// @title Using SmartClient with React
// @see reactIntegration
// @see showcasePorting
//<

//> @groupDef reactIntegration
// <i><b>See +link{npmjs,NPMJS} for how to install SmartClient in a React app, and
// +link{reactSupport} if you are building a new application using SmartClient and React.
// </b></i><p>
// If you have a pre-existing, already-built SmartClient application, and you want to integrate
// it into a pre-existing, already-built React application, the fastest way is to import the
// ExternalPane class defined by SmartClient's React support, and use it to create your
// top-level widget by overriding the <code>buildPane()</code> method of ExternalPane with JS
//  returning a new instance of your SmartClient UI.
// <p>
// For example:
// <pre>
// import React    from 'react';
// import ReactDOM from 'react-dom';
// import 'smartclient-eval/release';
// import 'smartclient-eval/skins/Tahoe';
//
// import { ExternalPane } from 'smartclient-eval/react';
//
// import '/MyGrid.js'; // load the SmartClient UI
//
// class MyPane extends ExternalPane {
//     buildPane() {
//         return isc.MyGrid.create({
//             width: 500, height: 300,
//             bodyProperties: {
//                 backgroundColor: "#FFFFAA"
//             }
//         });
//     }
//  }
//
// ReactDOM.render(
//     &lt;MyPane/&gt;,
//     document.getElementById("targetElement")
// );</pre>
// where <code>MyGrid.js</code> in this case contains the SmartClient UI classes:
// <pre>
// isc.defineClass("MyGrid", isc.ListGrid).addProperties({
//     emptyMessage: "No commands have been loaded",
//
//     defaultFields: [{
//         name: "command", title: "Command"
//     }, {
//         name: "argument 1", title: "Argument 1"
//     }, {
//         name: "argument 2", title: "Argument 2"
//     }]
// });
// </pre>
// This will render the SmartClient UI you create into the DOM element in your React App with
// id <code>targetElement</code>
// @title Integrating Pre-Existing SmartClient Apps with React
// @visibility smartclient
// @see reactSupport
//<

//> @groupDef showcasePorting
// Converting a Showcase sample to a React app involves porting all of tabs in the sample that
// represent client-side code.  There are several types of tabs to consider.
// <h4>Main code tab</h4>
// The main code tab is generally JavaScript, and often represents the complete sample, except
// for +link{DataSource,DataSources}.  You can port this code to a mixture of React JSX and
// JavaScript, following the rules described in the +link{reactIntegration} help topic.
// <p>
// In a few cases, the main tab is +link{componentXML} to illustrate that format.  Sometimes,
// you'll find the same sample is also present in the Showcase in JavaScript form.  Component
// XML format is similar to SmartClient React JSX syntax, making porting straightfoward.  For
// details of the differences between the formats, see the discussion at the bottom of the
// +link{reactIntegration} help topic.
// <h4>Extra code tabs</h4>
// One or more additional code tabs may be present, typically widgets or data definitions in
// JavaScript, referenced by the main code.  The sample was likely split into pieces just
// to make it easier to view and/or edit, so there's no requirement that your translated React
// app must preserve that separation.  If you do decide to create separate files in your app
// for each sample tab, you'll need to assign a global ID to any widgets or data structures
// so they can be referenced cross-file.
// <p>
// If a tab declares an array of records, you may be better off just keeping that data as JS in
// your React app if the records contain non-string data, such as numbers or booleans, since
// SmartClient React JSX does not capture types.  To convert such records to React JSX
// properly, you'd need to define a +link{dataSource.clientOnly,client-only} DataSource with
// those records as its +link{dataSource.cacheData,initial data}.
// <h4>DataSource tabs</h4>
// Another common tab in Showcase samples is a +link{DataSource} definition.  This will either
// be XML representing a server-based DataSource file or possibly JS representing a client-only
// DataSource.
// <p>
// If the tab contains the XML defining a server-based DataSource, it's just there for
// reference, and you don't need to port it as +link{iscServer,SmartClient server technology}
// can be used directly, unchanged, by your React app.  You just need to make sure your app
// +link{dataSourceDeclaration,loads the DataSource} before using it.
// <h4>Comparison with Official React Showcase samples</h4>
// In the Showcase, you can see React versions of several samples.  You may see multiple tabs
// of React files, and in each there will be a call to <code>ReactDOM.render()</code>.  This
// illustrates how you can target distinct DOM elements
// when inserting widgets hierarchies of SmartClient React JSX and allows the Showcase to load
// the tabs separately.
// <p>
// However, if you're porting a Showcase sample yourself, and want to split a widget hierarchy
// across files, it's suggested that you add an ID to the inner widget, and then reference it
// in the parent, which means that the DOM target passed to <code>ReactDOM.render()</code> for
// the inner widget will only be used to temporarily hold that widget before its attached to
// the parent.
//
// @visibility smartclient
// @title Porting Showcase samples to React
// @see reactSupport
//<

//> @class React
// Container for various helper methods used by our React wrapper classes.
// @treeLocation Client Reference/System
// @visibility external
//<
isc.defineClass("React").addClassMethods({

    // structured comment file markers

    sourceJSFileMarkers: {
        editModeMarker:     "ReactEditModeJS",
        copyBeforeMarker:   "ReactCopyBeforeJS",
        jsxReferenceMarker: "ReactJSXReferenceJS",
        beforeRenderMarker: "ReactBeforeRenderJS",
        afterRenderMarker:  "ReactAfterRenderJS",
        neverShipMarker:    "NeverShip"
    },
    autoGenFileMarker: "/* Auto-Generated React */",

    //> @classMethod React.getRenderTarget()
    // Returns the DOM element ID that should be used by ReactDOM.render() for any webpacked
    // React code evaluated by +link{renderFragment()} or +link{renderJSX()}.  In React code,
    // this method is called via <code>SC.getRenderTarget()</code>.
    // @return (String) the DOM ID
    //<
    getRenderTarget : function () {
        var target = this.renderTarget;
        if (isc.isAn.Array(target)) target = target.shift();
        if (target instanceof Element) target = target.getAttribute("id");
        return target;
    },

    _validateElements : function (elements) {
        if (!isc.isAn.Array(elements)) elements= [elements];

        for (var i = 0; i < elements.length; i++) {
            if (!(elements[i] instanceof Element)) {
                elements[i] = document.getElementById(elements[i]);
            }
            if (!(elements[i] instanceof Element)) {
                this.logWarn(elements[i] + " is not a DOM Element, nor an ID bound to a DOM " +
                             "Element; unable to render the supplied React code");
                return;
            }
        }
        return elements;
    },

    //> @classAttr Canvas.parseDatesWithDateUtil (boolean : true : IRW)
    // Should dates in React JSX be parsed with the framework's DateUtil.parseInput(), or
    // should the JSX parser instead use the native browser JavaScript API Date.parse().
    //<
    parseDatesWithDateUtil: true,

    //> @classMethod React.canRenderAsync()
    // Internal method to check whether asynchronous rendering is supported.
    // @return (boolean) whether React support should render asynchronously
    //<
    canRenderAsync : function () {
        return !this.synchronousRender;
    },

    //> @classMethod React.renderFragment()
    // Evaluates the supplied webpacked React code with +link{getRenderTarget()} configured to
    // return the DOMElement ID passed in (or the ID of the DOMElement passed in).  It is an
    // error if the ID is not present in the DOM, or if the supplied DOMElement has no ID.
    // @param code (String)  webpacked React code in the form of a string of JS
    // @param element (DOMElement | ID)  DOMElement with an ID or ID of a DOMElement
    //<
    
    renderFragment : function (code, element) {
        // if element is an array (and so mutable) make a copy of it
        if (isc.isAn.Array(element)) element = element.duplicate();
        // ensure element refers to valid DOM element(s)
        if (!this._validateElements(element)) return;

        var originalTarget = this.renderTarget;
        this.renderTarget = element;

        try {
            isc.eval(code);
        } finally {
            if (!originalTarget) delete this.renderTarget;
            else this.renderTarget = originalTarget;
        }
    },

    //> @classMethod React.renderJSX()
    // Creates a new canvas with the supplied properties, and then calls renderFragment() to eval the supplied JSX
    // with the SmartClientReact.getRenderTarget() set to the DOMElement ID associated with the new canvas.
    // @param code (String)  webpacked React code in the form of a string of JS
    // @param props (Canvas Properties) properties for the canvas to be created
    // @return (Canvas) the canvas created
    //<
    renderJSX : function (code, props) {
        var canvas = isc.isA.Canvas(props) ? props : isc.Canvas.create(props);
        this.renderFragment(code, canvas.getCanvasName());
        return canvas;
    },

    //> @classMethod React.buildPane()
    // Evaluates the supplied function, assumed to be JavaScript code that creates one or more
    // SmartClient +link{Canvas,canvii}.  If more than one top-level canvas is created, this
    // method will automatically wrap them in a new top-level canvas so that there is always
    // only one top-level canvas.
    // <p> Finally, the supplied DOM +link{canvas.htmlElement,HTML element} will be set into
    // the top-level canvas, so that when drawn, it's rendered into that element.
    // @param buildPaneFunc (Function) JavaScript code function that creates one or more canvii
    // @param htmlElement (DOMElement) the DOM HTML element into which to render the canvii
    // @return (Canvas) the top-level canvas created (by <code>buildPaneFunc</code>, or
    //                  automatically)
    //<
    buildPane : function (buildPaneFunc, htmlElement) {
        isc.noAutoDraw = true;

        var topCanvas;

        try {
            isc.Class.globalEvalWithCapture("buildPane()", function (globals, error, idsToFree)
            {
                var topCanvii = [];
                for (var i = 0; i < globals.length; i++) {
                    var canvas = isc.Canvas.getById(globals[i]);
                    if (canvas && !canvas.getParentCanvas()) topCanvii.add(canvas);
                }
                topCanvas = topCanvii.length > 1 ? isc.Canvas.create({children: topCanvii}) :
                                                                                topCanvii[0];
                if (topCanvas) {
                    topCanvas.setHtmlElement(htmlElement);
                    topCanvas.draw();
                    return topCanvas;
                }

            }, {buildPane: buildPaneFunc});

        } finally {
            isc.noAutoDraw = true;
        }

        return topCanvas;
    },

    
    componentContainerMethods: {

            _getComponentElementID : function () {
                return "component__" + this.getID();
            },

            getInnerHTML : function () {
                return "<div ID='" + this._getComponentElementID() + "'></div>";
            },

            adjustOverflow : function () {
                if (this._componentRendered) {
                    return this.Super("adjustOverflow", arguments);
                }
                this._renderComponent();

                var targetID = this._getComponentElementID(),
                    target = document.getElementById(targetID);
                if (!target || !target.parentElement) {
                    return this.Super("adjustOverflow", arguments);
                }
                target = target.parentElement;

                var _this = this, _arguments = arguments;

                var targetObserver = new MutationObserver(function (mutationsList) {
                    targetObserver.disconnect();
                    _this.Super("adjustOverflow", _arguments);
                });
                targetObserver.observe(target, {childList: true});
            },

            draw : function () {
                delete this._componentRendered;
                return this.Super("draw", arguments);
            },

            redraw : function () {
                delete this._componentRendered;
                return this.Super("redraw", arguments);
            },

            _renderComponent : function () {
                var renderComponent = this.renderComponent;
                

                if (renderComponent) {
                    var targetID = this._getComponentElementID(),
                        target = document.getElementById(targetID);
                    if (target) {
                        renderComponent(target.parentElement || target);
                        this._componentRendered = true;
                    }
                }
            }
    }

});
