/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.tools;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Configuration to control how excessive overflow is reported when you're {@link
 * com.smartgwt.client.widgets.Canvas#startDebuggingOverflow debugging overflow}. <p> The general approach is that we track
 * a maximum of {@link com.smartgwt.client.tools.DebugOverflowSettings#getMaxTrackedOverflows maxTrackedOverflows} per
 * canvas across a period of {@link com.smartgwt.client.tools.DebugOverflowSettings#getTrackingDuration trackingDuration},
 * and if a canvas overflows more than {@link com.smartgwt.client.tools.DebugOverflowSettings#getSelfOverflowThreshold
 * selfOverflowThreshold} times not due to any child (checked by looking at the {@link
 * com.smartgwt.client.widgets.Canvas#getVisibleWidth visible rect} of each child, then we log a message from the affected
 * canvas reporting the threshold was exceeded.
 * @see com.smartgwt.client.widgets.Canvas#startDebuggingOverflow
 * @see com.smartgwt.client.widgets.Canvas#stopDebuggingOverflow
 */
@BeanFactory.FrameworkClass
public class DebugOverflowSettings extends DataClass {

    public static DebugOverflowSettings getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new DebugOverflowSettings(jsObj);
    }
        


    public DebugOverflowSettings(){
        
    }

    public DebugOverflowSettings(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Logging level to use when reporting that the {@link
     * com.smartgwt.client.tools.DebugOverflowSettings#getSelfOverflowThreshold overflow threshold} was exceeded.
     *
     * @param loggingLevel New loggingLevel value. Default value is Log.WARN
     * @return {@link com.smartgwt.client.tools.DebugOverflowSettings DebugOverflowSettings} instance, for chaining setter calls
     */
    public DebugOverflowSettings setLoggingLevel(LogPriority loggingLevel) {
        return (DebugOverflowSettings)setAttribute("loggingLevel", loggingLevel == null ? null : loggingLevel.getValue());
    }

    /**
     * Logging level to use when reporting that the {@link
     * com.smartgwt.client.tools.DebugOverflowSettings#getSelfOverflowThreshold overflow threshold} was exceeded.
     *
     * @return Current loggingLevel value. Default value is Log.WARN
     */
    public LogPriority getLoggingLevel()  {
        return EnumUtil.getEnum(LogPriority.values(), getAttribute("loggingLevel"));
    }
    

    /**
     * How often to log the {@link com.smartgwt.client.tools.DebugOverflowSettings#getSelfOverflowThreshold overflow threshold}
     * being crossed, expressed in milliseconds.  A setting of null or zero disable the limitation. <p> If this property is a
     * positive number, and fewer than that many milliseconds have elapsed since the last time we logged an overflow problem
     * for a canvas, then logging will be skipped for that canvas.
     *
     * @param loggingTimeout New loggingTimeout value. Default value is null
     * @return {@link com.smartgwt.client.tools.DebugOverflowSettings DebugOverflowSettings} instance, for chaining setter calls
     */
    public DebugOverflowSettings setLoggingTimeout(Integer loggingTimeout) {
        return (DebugOverflowSettings)setAttribute("loggingTimeout", loggingTimeout);
    }

    /**
     * How often to log the {@link com.smartgwt.client.tools.DebugOverflowSettings#getSelfOverflowThreshold overflow threshold}
     * being crossed, expressed in milliseconds.  A setting of null or zero disable the limitation. <p> If this property is a
     * positive number, and fewer than that many milliseconds have elapsed since the last time we logged an overflow problem
     * for a canvas, then logging will be skipped for that canvas.
     *
     * @return Current loggingTimeout value. Default value is null
     */
    public Integer getLoggingTimeout()  {
        return getAttributeAsInt("loggingTimeout");
    }
    

    /**
     * Maximum number of overflows to track for each canvas when debugging overflow.
     *
     * @param maxTrackedOverflows New maxTrackedOverflows value. Default value is 10
     * @return {@link com.smartgwt.client.tools.DebugOverflowSettings DebugOverflowSettings} instance, for chaining setter calls
     */
    public DebugOverflowSettings setMaxTrackedOverflows(int maxTrackedOverflows) {
        return (DebugOverflowSettings)setAttribute("maxTrackedOverflows", maxTrackedOverflows);
    }

    /**
     * Maximum number of overflows to track for each canvas when debugging overflow.
     *
     * @return Current maxTrackedOverflows value. Default value is 10
     */
    public int getMaxTrackedOverflows()  {
        return getAttributeAsInt("maxTrackedOverflows");
    }
    

    /**
     * At what threshold should excessive self-overflows be reported?  This value must not exceed {@link
     * com.smartgwt.client.tools.DebugOverflowSettings#getMaxTrackedOverflows maxTrackedOverflows}.
     *
     * @param selfOverflowThreshold New selfOverflowThreshold value. Default value is 5
     * @return {@link com.smartgwt.client.tools.DebugOverflowSettings DebugOverflowSettings} instance, for chaining setter calls
     */
    public DebugOverflowSettings setSelfOverflowThreshold(int selfOverflowThreshold) {
        return (DebugOverflowSettings)setAttribute("selfOverflowThreshold", selfOverflowThreshold);
    }

    /**
     * At what threshold should excessive self-overflows be reported?  This value must not exceed {@link
     * com.smartgwt.client.tools.DebugOverflowSettings#getMaxTrackedOverflows maxTrackedOverflows}.
     *
     * @return Current selfOverflowThreshold value. Default value is 5
     */
    public int getSelfOverflowThreshold()  {
        return getAttributeAsInt("selfOverflowThreshold");
    }
    

    /**
     * Maximum time interval past which overflow data will be discarded when debugging overflow, measured in milliseconds.
     *
     * @param trackingDuration New trackingDuration value. Default value is 10000
     * @return {@link com.smartgwt.client.tools.DebugOverflowSettings DebugOverflowSettings} instance, for chaining setter calls
     */
    public DebugOverflowSettings setTrackingDuration(int trackingDuration) {
        return (DebugOverflowSettings)setAttribute("trackingDuration", trackingDuration);
    }

    /**
     * Maximum time interval past which overflow data will be discarded when debugging overflow, measured in milliseconds.
     *
     * @return Current trackingDuration value. Default value is 10000
     */
    public int getTrackingDuration()  {
        return getAttributeAsInt("trackingDuration");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
