/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Builds an {@link com.smartgwt.client.ai.AIFieldRequest} from a {@link com.smartgwt.client.ai.UserAIRequest} containing a
 * natural language description of the per-record values to generate for a new AI-generated field.
 * @see com.smartgwt.client.ai.AI#buildAIFieldRequest
 */
@BeanFactory.FrameworkClass
public class BuildAIFieldRequestRequest extends BuildViaAIRequest {

    public static BuildAIFieldRequestRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof BuildAIFieldRequestRequest) {
            existingObj.setJsObj(jsObj);
            return (BuildAIFieldRequestRequest)existingObj;
        } else

        {
            return new BuildAIFieldRequestRequest(jsObj);
        }
    }
        


    public BuildAIFieldRequestRequest(){
        
    }

    public BuildAIFieldRequestRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} that will display the AI-generated field. <p>
     * The component should be bound to the same {@link com.smartgwt.client.ai.BuildAIFieldRequestRequest#getDataSource
     * dataSource} of the request or a <code>DataSource</code> inheriting from it.
     *
     * @param component New component value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildAIFieldRequestRequest BuildAIFieldRequestRequest} instance, for chaining setter calls
     */
    public BuildAIFieldRequestRequest setComponent(DataBoundComponent component) {
        return (BuildAIFieldRequestRequest)setAttribute("component", component == null ? null : ((Canvas)component).getOrCreateJsObj());
    }

    /**
     * If specified, the {@link com.smartgwt.client.widgets.DataBoundComponent} that will display the AI-generated field. <p>
     * The component should be bound to the same {@link com.smartgwt.client.ai.BuildAIFieldRequestRequest#getDataSource
     * dataSource} of the request or a <code>DataSource</code> inheriting from it.
     *
     * @return Current component value. Default value is null
     */
    public DataBoundComponent getComponent()  {
        return (DataBoundComponent)Canvas.getByJSObject(getAttributeAsJavaScriptObject("component"));
    }
    

    /**
     * The {@link com.smartgwt.client.data.DataSource} that the AI-generated field will be considered to augment. <p> If {@link
     * com.smartgwt.client.ai.BuildAIFieldRequestRequest#getComponent component} is also specified, then the component should
     * be bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @param dataSource New dataSource value. Default value is null
     * @return {@link com.smartgwt.client.ai.BuildAIFieldRequestRequest BuildAIFieldRequestRequest} instance, for chaining setter calls
     */
    public BuildAIFieldRequestRequest setDataSource(DataSource dataSource) {
        return (BuildAIFieldRequestRequest)setAttribute("dataSource", dataSource == null ? null : dataSource.getOrCreateJsObj());
    }

    /**
     * The {@link com.smartgwt.client.data.DataSource} that the AI-generated field will be considered to augment. <p> If {@link
     * com.smartgwt.client.ai.BuildAIFieldRequestRequest#getComponent component} is also specified, then the component should
     * be bound to the same <code>DataSource</code> or a <code>DataSource</code> inheriting from it.
     *
     * @return Current dataSource value. Default value is null
     */
    public DataSource getDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("dataSource"));
    }
    

    /**
     * Whether to show a progress dialog to inform the user about the processing of the build-request. <p> The default value is
     * <code>false</code>.
     *
     * @param showProgressDialog New showProgressDialog value. Default value is false
     * @return {@link com.smartgwt.client.ai.BuildAIFieldRequestRequest BuildAIFieldRequestRequest} instance, for chaining setter calls
     */
    public BuildAIFieldRequestRequest setShowProgressDialog(Boolean showProgressDialog) {
        return (BuildAIFieldRequestRequest)setAttribute("showProgressDialog", showProgressDialog);
    }

    /**
     * Whether to show a progress dialog to inform the user about the processing of the build-request. <p> The default value is
     * <code>false</code>.
     *
     * @return Current showProgressDialog value. Default value is false
     */
    public Boolean getShowProgressDialog()  {
        Boolean result = getAttributeAsBoolean("showProgressDialog", true);
        return result == null ? false : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
