
package com.smartgwt.client.docs;

/**
 * <h3>Integrating AI Technology</h3>
 * AI technology is woven into the Smart GWT framework, not only at a base level, but also
 *  systemically. With only minimal changes to application code, surprisingly sophisticated,
 *  AI-powered enhancements can be enabled that have the ability to turn the users of your
 *  application into power users. For example, users of your application can use natural language
 *  to:
 *  <ul>
 * <li>Filter a {@link com.smartgwt.client.widgets.grid.ListGrid} according to their description
 * of the records to include or exclude.
 * <li>Add a custom field to a <code>ListGrid</code>, combining data from the underlying
 * dataSource or augmenting
 *      the data with AI-provided knowledge.
 * <li>Sort the data of a <code>ListGrid</code> according to the user's description of how the
 * data should be ordered.
 * <li>Build a custom {@link com.smartgwt.client.widgets.DataBoundComponent} using available
 * dataSources according to the user's
 *      description of what they would like to see.
 *  </ul>
 * 
 *  <h3>The <code>AIEngine</code> class</h3>
 * Communication with AI services is performed by instances of the {@link
 * com.smartgwt.client.ai.AIEngine} class.  The
 *  following engines are built-in and don't require registration.  Just put the appropriate API
 *  key in your {@link com.smartgwt.client.docs.Server_properties server configuration file}.
 *  <p>
 * <div id="noVisionRequestSupportDisclaimer" style="display:none">Note that this engine does not
 * support vision requests.</div>
 *  <table border="1" cellpadding="3">
 *    <thead>
 *      <tr>
 *        <th>Engine ID</th>
 *        <th>Provider</th>
 *        <th>Name</th>
 *        <th>Additional Installation Notes</th>
 *      </tr>
 *    </thead>
 *    <tbody>
 *      <tr>
 * <td id="gpt35TurboEngineIdCell" bgcolor="AntiqueWhite" aria-describedby="gpt35TurboEngineIdCell
 * noVisionRequestSupportDisclaimer"><code>"gpt-3.5-turbo"</code></td>
 *        <td>OpenAI</td>
 *        <td>GPT-3.5 Turbo</td>
 *        <td rowspan="6">
 * You must obtain an API key having access to the model(s) from: <a
 * href="https://platform.openai.com/api-keys">https://platform.openai.com/api-keys</a><br>
 * Then, the value of server configuration property <code>OpenAI.api.key</code> must be set to
 * your API key.
 *          <p>
 *          The o1-preview and o1-mini models may require higher tier API access.
 *        </td>
 *      </tr>
 *      <tr>
 * <td id="gpt4EngineIdCell" bgcolor="AntiqueWhite" aria-describedby="gpt4EngineIdCell
 * noVisionRequestSupportDisclaimer"><code>"gpt-4"</code></td>
 *        <td>OpenAI</td>
 *        <td>GPT-4</td>
 *      </tr>
 *      <tr>
 *        <td><code>"gpt-4-turbo"</code></td>
 *        <td>OpenAI</td>
 *        <td>GPT-4 Turbo</td>
 *      </tr>
 *      <tr>
 *        <td><code>"gpt-4o"</code></td>
 *        <td>OpenAI</td>
 *        <td>GPT-4o</td>
 *      </tr>
 *      <tr>
 * <td id="o1PreviewEngineIdCell" bgcolor="AntiqueWhite" aria-describedby="o1PreviewEngineIdCell
 * noVisionRequestSupportDisclaimer"><code>"o1-preview"</code></td>
 *        <td>OpenAI</td>
 *        <td>o1-preview</td>
 *      </tr>
 *      <tr>
 * <td id="o1MiniEngineIdCell" bgcolor="AntiqueWhite" aria-describedby="o1MiniEngineIdCell
 * noVisionRequestSupportDisclaimer"><code>"o1-mini"</code></td>
 *        <td>OpenAI</td>
 *        <td>o1-mini</td>
 *      </tr>
 *      <tr>
 *        <td><code>"gemini-pro"</code></td>
 *        <td>Google</td>
 *        <td>Gemini Pro &amp; Gemini Pro Vision</td>
 *        <td>
 * You must obtain an API key having access to these models from: <a
 * href="https://makersuite.google.com/app/apikey?authuser=1">https://makersuite.google.com/app/apikey?authuser=1</a><br>
 * Then, the value of server configuration property <code>Gemini.api.key</code> must be set to
 * your API key.
 *        </td>
 *      </tr>
 *    </tbody>
 *  </table>
 * <div style="margin-top:6px" role="presentation">Note: The AI services corresponding to the IDs
 * in <a style="padding:3px;background-color:AntiqueWhite">AntiqueWhite</a> do not support vision
 * requests.</div>
 * 
 *  <h3>Enabling AI</h3>
 *  AI is disabled by default. To enable AI within your application, just set
 * {@link com.smartgwt.client.ai.AI#defaultEngineId defaultEngineId} to a different engine ID if
 * you don't like the default, and then
 *  set {@link com.smartgwt.client.ai.AI#disabled disabled} to <code>false</code>.
 *  <p>
 *  Here is sample Smart GWT code that enables AI using GPT-4 Turbo:
 *  <pre>
 *  AI.setDefaultEngineId("gpt-4-turbo");
 *  AI.setDisabled(false);</pre>
 *  <b>Note:</b> If your application will need to ask AI to analyze images,
 *  you'll need an <code>AIEngine</code> that supports vision requests.  Check the table above
 *  to see which built-in engines support vision, or you can register your own (covered below).
 * 
 *  <h3>Adding your own AIEngine</h3>
 * If the built-in {@link com.smartgwt.client.ai.AIEngine AI Engines} aren't enough, you can
 * implement your own for the
 * generative AI service that you would like to use, and {@link
 * com.smartgwt.client.ai.AI#registerEngine register} it
 * with the framework.  You can then set your engine's ID into {@link
 * com.smartgwt.client.ai.AI#defaultEngineId defaultEngineId}.
 *  <p>
 * You can also {@link com.smartgwt.client.ai.AI#unregisterEngine unregister} an engine, or grab
 * the
 *  <code>AIEngine</code> instance of a built-in or manually registered engine by passing the ID
 *  to {@link com.smartgwt.client.ai.AI#getEngine AI.getEngine()}.
 * 
 *  <h3>AI Component Views and <code>AIServiceMode</code></h3>
 * AI can be used to set up the view settings of a {@link
 * com.smartgwt.client.widgets.grid.ListGrid}, such as filters, sorts,
 *  and record hilites, according to the user's natural-language request for how the records
 *  should be filtered, sorted, and hilited. These AI-generated view settings are saved in the
 *  component {@link com.smartgwt.client.docs.ViewState}.
 *  <p>
 * With each AI component view feature, there is an associated {@link
 * com.smartgwt.client.types.AIServiceMode}
 *  setting that controls the mode for how AI should respond to user requests:
 *  <table border="1">
 *    <tbody>
 *      <tr>
 *        <td>Filtering</td>
 *   <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getFilterViaAIMode filterViaAIMode}</td>
 *      </tr>
 *      <tr>
 *        <td>Sorting</td>
 *  <td>{@link com.smartgwt.client.widgets.DataBoundComponent#getSortViaAIMode sortViaAIMode}</td>
 *      </tr>
 *      <tr>
 *        <td>Hiliting</td>
 *   <td>{@link com.smartgwt.client.widgets.grid.ListGrid#getHiliteViaAIMode hiliteViaAIMode}</td>
 *      </tr>
 *    </tbody>
 *  </table>
 *  <p>
 *  With respect to AI component views, the supported AI service modes are:
 *  <ul>
 *  <li>AI Assist - AI drives existing UI on the user's behalf according to the request.
 *  An example of this is: AI converts the user's description of what records they would like
 * to see into {@link com.smartgwt.client.data.AdvancedCriteria} that is then set as the filter
 * criterion of a
 *  <code>DataBoundComponent</code>.
 *  <li>AIDE (AI Data Enhance) - per-record augmentation or enhancements provided via AI.
 *  Examples of this are AI-generated fields, where the field values are not derived from the
 *  records, but rather, supplied via AI.
 *  <li>Hybrid - a combination of AI Assist and AIDE, where AI decides whether AI Assist,
 *  AIDE, or some combination of both approaches should be used to best respond to the request.
 *  </ul>
 *  <p>
 *  The amount of interaction with AI is lowest in AI Assist mode. AIDE requires more interaction
 *  with AI, and Hybrid mode requires the most amount of interaction. More interaction with AI
 *  generally requires more time to process the component view request.
 * 
 *  <h4>Requirements for AI Component Views to be Enabled</h4>
 * With respect to a particular {@link com.smartgwt.client.widgets.DataBoundComponent}, the
 * requirements for AI component views
 *  to be enabled are:
 *  <ul>
 *  <li>AI must be enabled: {@link com.smartgwt.client.ai.AI#isEnabled AI.isEnabled()}
 *  <li>A globally-installed {@link com.smartgwt.client.data.DataSource} with a primary key and
 * {@link com.smartgwt.client.data.DataSource#supportsAdvancedCriteria supporting
 * AdvancedCriteria} must be set.
 *  <li>The <code>DataSource</code> cannot have a composite primary key.
 *  <li>The number of data-records must be known, and the total number of records must be less
 * than the DBC's {@link com.smartgwt.client.widgets.DataBoundComponent#getAiMaxRecords
 * aiMaxRecords}.
 *  </ul>
 */
public interface IntegratingAI {
}
