/*

  SmartClient Ajax RIA system
  Version v13.1p_2025-11-29/LGPL Deployment (2025-11-29)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// AggregationEditor requires DynamicForm but is loaded in a separate module. 
// Ensure AE is present before attempting to initialize
if (isc.DynamicForm) {



//> @class SummaryFunctionItem
// A ComboBoxItem that allows the user to choose a +link{type:SummaryFunction} for a given
// +link{summaryFunctionItem.fieldType,fieldType}.
//
// @inheritsFrom ComboBoxItem
// @treeLocation Client Reference/Forms/Form Items
// @visibility aggregation
//<
isc.defineClass("SummaryFunctionItem", "ComboBoxItem").addClassProperties({
    getFunctionTitle : function (summaryFunction) {
        var titleProperty = summaryFunction + "FunctionTitle",
            title = isc.SummaryFunctionItem.getInstanceProperty(titleProperty);
        return title;
    }
});

isc.SummaryFunctionItem.addProperties({

    //> @attr summaryFunctionItem.fieldType (FieldType : null : IWR)
    // Field type to be summarized. Used to restrict +link{type:SummaryFunction,summary function}
    // choices. If no field type is provided, the default is "text".
    // @setter setFieldType
    // @visibility aggregation
    //<

    //> @attr summaryFunctionItem.maxFunctionTitle (String : "maximum value in any matching records" : IRWA)
    // The title for the "max" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    maxFunctionTitle: "maximum value in any matching records",

    //> @attr summaryFunctionItem.minFunctionTitle (String : "minimum value in any matching records" : IRWA)
    // The title for the "min" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    minFunctionTitle: "minimum value in any matching records",

    //> @attr summaryFunctionItem.avgFunctionTitle (String : "average of all values in matching records" : IRWA)
    // The title for the "avg" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    avgFunctionTitle: "average of all values in matching records",

    //> @attr summaryFunctionItem.sumFunctionTitle (String : "total of all values in all matching records" : IRWA)
    // The title for the "sum" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    sumFunctionTitle: "total of all values in all matching records",

    //> @attr summaryFunctionItem.countFunctionTitle (String : "count of all matching records" : IRWA)
    // The title for the "count" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    countFunctionTitle: "count of all matching records",

    //> @attr summaryFunctionItem.concatFunctionTitle (String : "combined text values in all matching records" : IRWA)
    // The title for the "concat" summary function.
    // @group i18nMessages
    // @visibility aggregation
    //<
    concatFunctionTitle: "combined text values in all matching records",

    valueField: "value",
    displayField: "title",
    allowEmptyValue: true,
    cachePickListResults: false,
    getClientPickListData : function () {
        if (this.fieldType == null || this.fieldType == "text") {
            return [
                { value: "concat", title: this.concatFunctionTitle },
                { value: "count", title: this.countFunctionTitle },
                { value: "max", title: this.maxFunctionTitle },
                { value: "min", title: this.minFunctionTitle }
            ]
        } else if (this.fieldType == "date" || this.fieldType == "dateTime" || this.fieldType == "time") {
            
            return [
                { value: "count", title: this.countFunctionTitle },
                { value: "max", title: this.maxFunctionTitle },
                { value: "min", title: this.minFunctionTitle }
            ]
        } else {
            return [
                { value: "sum", title: this.sumFunctionTitle },
                { value: "count", title: this.countFunctionTitle },
                { value: "avg", title: this.avgFunctionTitle },
                { value: "max", title: this.maxFunctionTitle },
                { value: "min", title: this.minFunctionTitle },
                { value: "concat", title: this.concatFunctionTitle }
            ]
        }
    },

    //> @method summaryFunctionItem.setFieldType()
    // Setter for +link{fieldType}.
    // @param fieldType (String) new fieldType value.
    // @visibility aggregation
    //<
    setFieldType : function (fieldType) {
        if (this.fieldType != fieldType) {
            this.fieldType = fieldType;
            var data = this.filterClientPickListData(),
                value = this.getValue(),
                valueFieldName = this.getValueFieldName(),
                displayFieldName = this.getDisplayFieldName(),
                valueMap = {}
            ;
            for (var i = 0; i < data.length; i++) {
                valueMap[data[i][valueFieldName]] = data[i][displayFieldName];
            }
            this.setValueMap(valueMap);

            // If current selection is no longer valid, clear the value
            if (!data.getProperty("value").contains(value)) {
                this.clearValue();
                delete this._manuallySet;
            }
        }
    }
});


//> @class AggregationEditor
// A form that allows the user to define aggregation details for a +link{DSRequest},
// +link{Criterion.fieldQuery} or +link{Criterion.valueQuery}. The
// properties include <code>groupBy</code> and <code>summaryFunctions</code> with
// optional properties <code>criteria</code> and <code>queryOutput</code>.
// <P>
// The +link{DSRequest} object produced by an AggregationEditor can be used by the
// +link{DataSource} subsystem to affect fetches.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Forms
// @visibility aggregation
//<
isc.defineClass("AggregationEditor", "VLayout");

isc.AggregationEditor.addProperties({

// Layout: be a minimum height stack by default
// ---------------------------------------------------------------------------------------
// vertical:false,
// vPolicy:"none",
height:1,
defaultWidth:800,
membersMargin: 10,

//> @attr aggregationEditor.showDataSourcePicker (Boolean : null : IR)
// Should a Datasource picker be shown to choose target +link{dataSource} from +link{dataSources}?
//
// @visibility aggregation
//< 

//> @attr aggregationEditor.rootDS (DataSource | ID : null : IR)
// DataSource this editor should use as the root of hierarchical tree of related DataSources
// when +link{showDataSourcePicker} is true.
//
// @visibility aggregation
//<

dataSourcePickerDefaults: {
    _constructor: "SubqueryDataSourcePicker",
    width: "100%",
    colWidths: [10,"*"],
    autoFocus: true,
    dsNameChanged : function (dsName, queryFK) {
        this.creator.dataSourceChanged(dsName, queryFK);
    }
},

//> @attr aggregationEditor.showCriteriaEditor (Boolean : null : IR)
// Should a FilterBuilder be shown to define request criteria?
//
// @visibility aggregation
//< 

filterBuilderConstructor: "FilterBuilder",
filterBuilderDefaults: {
    inheritedClauseProperties: {
        // Apply subQuery window placement to created window, if provided
        createSubQueryWindow : function () {
            var window = this.Super("createSubQueryWindow", arguments);

            var builder = this.creator,
                editor = builder.creator;
            if (editor.subQueryWindowLeft != null || editor.subQueryWindowTop != null) {
                window.setAutoCenter(false);
                if (editor.subQueryWindowLeft != null) window.setPageLeft(editor.subQueryWindowLeft);
                if (editor.subQueryWindowTop != null) window.setPageTop(editor.subQueryWindowTop);
            }

            return window;
        }
    }
},

//> @attr aggregationEditor.allowCriteriaAggregates (Boolean : null : IR)
// Should the FilterBuilder, shown +link{showCriteriaEditor,optionally} for editing criteria,
// allow aggregates? This value is directly applied to +link{FilterBuilder.allowAggregates}.
//
// @visibility aggregation
//< 

//> @attr aggregationEditor.sortFields (Boolean : true : IR)
// Should the +link{fieldPicker} and +link{aggregationClause.fieldPicker} items be sorted
// alphabetically in the drop-down list.
// @visibility aggregation
//<
sortFields:true,

//> @attr aggregationEditor.fieldPicker (MultiAutoChild PickList : null : IR)
// AutoChild for the +link{FormItem} that allows a user to pick a DataSource field when 
// creating aggregation clauses.
// <P>
// This will be a +link{ComboBoxItem} by default.
//
// @visibility aggregation
//<

fieldPickerDefaults: { 
    name: "fieldName", 
    editorType: "ComboBoxItem", 
    textMatchStyle: "startsWith",
    showTitle: false,
    hint: "field name",
    showHintInField: true,
    // don't allow addUnknownValues - it's a fixed list fields
    addUnknownValues: false,
    // Add a special value to clear value - not required
    // specialValues: { "**emptyValue**": "None" },
    // separateSpecialValues: true,
    changed : function () { this.form.creator.fieldNameChanged(this.form); }
},

//> @attr aggregationEditor.fieldPickerProperties (FormItem Properties : null : IR)
// Properties to combine with the +link{fieldPicker} autoChild FormItem.
//
// @visibility aggregation
//<

//> @attr aggregationEditor.functionPicker (AutoChild SelectItem : null : IR)
// AutoChild for the +link{SummaryFunctionItem} that allows a user to select the summary function
// when creating aggregation clauses. Each clause will create a functionPicker automatically.
// To customize this item, use +link{functionPickerProperties}
//
// @visibility aggregation
//<

//> @attr aggregationEditor.functionPickerProperties (FormItem Properties : null : IR)
// Properties to combine with the +link{functionPicker} autoChild FormItem.
//
// @visibility aggregation
//<
functionPickerDefaults : {
    name:"function", 
    editorType: "SummaryFunctionItem", 
    showTitle:false, 
    hint: "summary function",
    showHintInField: true,
    // don't allow addUnknownValues - it's a fixed list applicable to the selected field
    addUnknownValues:false, 
    changed : function () { this.form.creator.functionChanged(this.form); }
},

//> @attr aggregationEditor.fieldPickerWidth (Integer | String : 150 : IR)
// Width for the field picker formItem displayed in clauses within this AggregationEditor.
// @visibility aggregation
//<
fieldPickerWidth: 150,

//> @attr aggregationEditor.functionPickerWidth (Integer | String : 325 : IR)
// Width for the summary function picker formItem displayed in clauses within
// this AggregationEditor.
// @visibility aggregation
//<
functionPickerWidth: 325,

// Schema and operators
// ---------------------------------------------------------------------------------------

//> @attr aggregationEditor.dataSource (DataSource | ID : null : IRW)
// DataSource this editor should use for field definitions.
// @visibility aggregation
//< 
setDataSource : function(ds, queryFK) {
    var aDS = isc.DataSource.get(ds);
    if (!aDS || !this.dataSource || (isc.DataSource.get(this.dataSource).ID != aDS.ID)) {
        this.dataSource = aDS;
        if (this.dataSourcePicker) {
            var baseDSName = (isc.isA.DataSource(this.rootDS) ? this.rootDS.getID() : this.rootDS),
                dsName = (this.dataSource ? this.dataSource.getID() : null)
            ;
            this.dataSourcePicker.setValues({
                baseDSName: baseDSName,
                dsName: dsName,
                queryFK: queryFK
            });
        }
        if (this.filterBuilder) {
            this.filterBuilder.setDataSource(aDS);
        }
        if (this.clauses) {
            if (this.groupByForm) this.groupByForm.getField("groupBy").setValueMap(this.getFieldNamesValueMap());
            this._setRequest();
        } else {
            this.rebuild();
        }
        if (this.sortByPicker) {
            this.sortByPicker.setDataSource(aDS);
        }
        if (this.queryOutputForm) {
            this.updateQueryOutputPickerValueMap(null);
            this.queryOutputForm.getField("outputField").defaultValue = this.getQueryOutputPickerDefaultValue();
            this.queryOutputForm.getField("outputField").clearValue();
        }
    }
},

//> @attr aggregationEditor.dataSources (List of DataSource : null : IR)
// List of DataSources to choose from when +link{showDataSourcePicker} is enabled.
// @visibility aggregation
//< 

//> @attr aggregationEditor.request (DSRequest : null : IRW)
// Initial aggregation request.
// <P>
// When initialized with a request, appropriate clauses for editing the provided request will
// be automatically generated.
//
// @visibility aggregation
//<

//> @attr aggregationEditor.showHiddenFields (Boolean : null : IR)
// By default only non-hidden fields are shown for selection. To include hidden fields for
// selection set this property to <code>true</code>.
//
// @visibility aggregation
//< 

//> @attr aggregationEditor.showFieldTitles (Boolean : true : IR)
// If true (the default), show field titles in the drop-down box used to select a field for querying.
// If false, show actual field names instead.
//
// @visibility aggregation
//< 
showFieldTitles: true,

//> @attr aggregationEditor.allowedFields (Array of String : null : IR)
// List of explicit fields for user field selection. If not specified, the list of fields is
// derived from the +link{aggregationEditor.dataSource,dataSource}.
//
// @see showHiddenFields
// @visibility aggregation
//< 

// Add/remove buttons
// ---------------------------------------------------------------------------------------

//> @attr aggregationEditor.scalarMode (Boolean : null : IR)
// If set, a maximum of one summary function is allowed and selection of
// +link{AdvancedCriterionSubquery.queryOutput} is allowed when there are no summary functions.
// @visibility aggregation
//<

//> @attr aggregationEditor.showRemoveButton (Boolean : true : IR)
// If set, a button will be shown for each clause allowing it to be removed.
// @visibility aggregation
//<
showRemoveButton:true,

//> @attr aggregationEditor.removeButtonPrompt (String : "Remove" : IR)
// The hover prompt text for the clause remove button. If there is only one clause
// +link{lastClauseRemoveButtonPrompt} will be used instead.
//
// @group i18nMessages 
// @visibility aggregation
//<
removeButtonPrompt: "Remove",

//> @attr aggregationEditor.removeButton (AutoChild ImgButton : null : IR)
// The removal ImgButton that appears before each clause if
// +link{showRemoveButton} is set.
// @visibility aggregation
//<
removeButtonDefaults : {
    _constructor:isc.ImgButton,
    width:18, height:18, layoutAlign:"center",
    src:"[SKIN]/actions/remove.png",
    showRollOver:false, showDown:false,
    click: function () { this.creator.removeButtonClick(this.clause); }
},

//> @attr aggregationEditor.showAddButton (Boolean : true : IR)
// If set, a button will be shown underneath all current clauses allowing a new clause to be
// added.
// @visibility aggregation
//<
showAddButton:true,

//> @attr aggregationEditor.addButtonPrompt (String : "Add" : IR)
// The hover prompt text for the add button.
//
// @group i18nMessages 
// @visibility aggregation
//<
addButtonPrompt: "Add", 

//> @attr aggregationEditor.addButton (AutoChild ImgButton : null : IR)
// An ImgButton that allows new clauses to be added if +link{showAddButton}
// is set.
// @visibility aggregation
//<
addButtonDefaults : {
    _constructor:isc.ImgButton,
    autoParent:"buttonBar",
    layoutAlign: "center",
    width:18, height:18, 
    imageWidth: 10, imageHeight: 10,
    src:"[SKIN]/actions/add.png",
    showRollOver:false, showDown:false, 
    //prompt:"Add",
    click: function () {
        this.creator.updateButtons(false);
        this.creator.addButtonClick(this.clause);
        this.creator.updateButtons(true);
    }
},

buttonBarDefaults : {
    _constructor:isc.HStack,
    autoParent:"clauseStack",
    membersMargin:4, 
    defaultLayoutAlign:"center",
    height:1
},

addButtonClick : function () {
    this.addNewClause();
},

removeButtonClick : function (clause) {
    if (!clause) return;
    this.removeClause(clause);
},

//> @method aggregationEditor.removeClause()
// Remove a clause this AggregationEditor is currently showing.
// @param clause (AggregationClause) clause as retrieved from aggregationEditor.clauseStack
// @visibility aggregation
//<
removeClause : function (clause) {
    var removingFirstClause = (this.clauses.indexOf(clause) == 0);
    // remove the clause from the clauses array and destroy it
    this.clauses.remove(clause);
    if (this.clauseStack) {
        this.clauseStack.hideMember(clause, function () { clause.destroy(); });
    }
    // update the last addButton to show
    this.updateLastAddButton();
    clause.aggregationEditor = null;
    this.fireAggregationChanged();

    if (this.clauses.length == 0) {
        this.clauseStack.hide();
        this.emptyClausesLayout.show();
    } else if (removingFirstClause) {
        this.clauses[0].updateClausePrefixMessage();
    }
},

updateLastAddButton : function () {
    var clauses = this.clauses,
        lastClause = clauses && clauses[clauses.length-1]
    ;
    if (lastClause) {
        lastClause.showAddButton = true;
    }
},

isFirstClause : function (clause) {
    return this.clauses.length == 0 || this.clauses[0] == clause;
},
 
//> @attr aggregationEditor.showSortByPicker (Boolean : null : IR)
// Should a sort by picker be shown to choose query sort order?
//
// @visibility aggregation
//< 

sortByPickerConstructor: "SortByEditor",
sortByPickerDefaults: {
},



//> @attr aggregationEditor.subQueryWindowTop (number : null : IWR)
// The page-relative top coordinate to place sub-query dialogs. If not specified,
// the dialogs are auto-centered.
//
// @visibility aggregation
//< 

//> @attr aggregationEditor.subQueryWindowLeft (number : null : IWR)
// The page-relative left coordinate to place sub-query dialogs. If not specified,
// the dialogs are auto-centered.
//
// @visibility aggregation
//< 

// Init
// ---------------------------------------------------------------------------------------

initWidget : function () {
    this.Super("initWidget", arguments);



    this.rebuild();
},

rebuild : function () {
    if (isc.isA.String(this.dataSource)) {
        this.dataSource = isc.DS.get(this.dataSource);
    }

    this.clauses = [];

    var showDataSourcePicker = false,
        showCriteriaEditor = false;



    if (this.showAggregationLayout != false) {
        this.addAutoChild("aggregationLayout", {
            groupTitle: (showDataSourcePicker ? "Aggregation" : null)
        });

        this.addAutoChild("groupByLayout");
        this.addAutoChild("groupByTitleLabel", { contents: this.groupByTitle });

        var _this = this;
        var groupByField = isc.addProperties({}, this.groupByFieldDefaults, {
            valueMap: this.getFieldNamesValueMap()
        });
        groupByField.comboBoxProperties = isc.addProperties({},
            { hint: this.groupByPickerHint }, groupByField.comboBoxProperties);

        this.addAutoChild("groupByForm", { fields: [ groupByField ] });

        this.addAutoChild("clauseStack");
        this.clauseStack.hide();
        this.addAutoChild("emptyClausesLayout");
        if (this.scalarMode) {
            var autoParent = "emptyClausesLayout";

            this.addAutoChild("emptyClausesLabel", {
                autoParent: autoParent,
                contents: this.emptyClauseOutputPrefixMessage
            });

            var queryOutputField = isc.addProperties({}, this.queryOutputFieldDefaults, {
                width: this.fieldPickerWidth,
                valueMap: this.updateQueryOutputPickerValueMap()
            });
            this.addAutoChild("queryOutputForm", {
                autoParent: autoParent,
                width: this.fieldPickerWidth,
                fields: [ queryOutputField ]
            });

            this.addAutoChild("queryOutputSuffixLabel", {
                autoParent: autoParent,
                contents: this.emptyClauseOutputSuffixMessage
            });
        } else {
            this.addAutoChild("emptyClausesLabel", {
                contents: this.emptyClausesMessage
            });
        }
        this.addAutoChild("emptyClausesAddButton", {
            prompt: this.emptyClausesAddButtonPrompt
        });

    
    } else if (this.showQueryOutputPicker) {
        this.addAutoChild("queryOutputLayout");
        var autoParent = "queryOutputLayout";

        this.addAutoChild("queryOutputPrefixLabel", {
            autoParent: autoParent,
            contents: this.queryOutputPrefixMessage
        });

        var queryOutputField = isc.addProperties({}, this.queryOutputFieldDefaults, {
            width: this.fieldPickerWidth,
            valueMap: this.updateQueryOutputPickerValueMap(),
            defaultValue: this.getQueryOutputPickerDefaultValue()
        });
        this.addAutoChild("queryOutputForm", {
            autoParent: autoParent,
            fields: [ queryOutputField ]
        });

        this.addAutoChild("queryOutputSuffixLabel", {
            autoParent: autoParent,
            contents: this.queryOutputSuffixMessage
        });
    }

    this._setRequest(this.request);
},

aggregationLayoutDefaults: {
    _constructor: isc.VLayout
},

// groupBy Form
// ---------------------------------------------------------------------------------------

//> @attr aggregationEditor.groupByTitle (String : "Combine records that have the same value for" : IR)
// The title for the group by picker.
//
// @group i18nMessages 
// @visibility aggregation
//<
groupByTitle: "Combine records that have the same value for",

//> @attr aggregationEditor.groupByPickerHint (String : "Select fields..." : IR)
// The hint to show in the group by picker.
//
// @group i18nMessages 
// @visibility aggregation
//<
groupByPickerHint: "Select fields...",

groupByLayoutDefaults: { 
    _constructor:isc.HLayout,
    autoParent: "aggregationLayout",
    width: "100%",
    height: 1,
    membersMargin: 4,
    layoutAlign: "center"
},

groupByTitleLabelDefaults: {
    _constructor:isc.Label,
    autoParent: "groupByLayout",
    width: 1,
    height: 1,
    layoutAlign: "center",
    wrap: false
},

groupByFormDefaults: {
    _constructor: "DynamicForm",
    autoParent: "groupByLayout",
    width: "100%",
    numCols: 1
},

groupByFieldDefaults: {
    name: "groupBy",
    showTitle: false,
    editorType: "MultiComboBoxItem",
    layoutStyle: "flow",
    addUnknownValues: false,
    width: "*",
    changed: function () {
        this.form.creator.groupByFieldChanged();
    }
},

getFieldNamesValueMap : function () {
    if (this.allowedFields) return this.allowedFields;
    if (this.dataSource) {
        var ds = this.getDataSource(),
            fieldNames = ds.getFieldNames(!this.showHiddenFields),
            valueMap = fieldNames
        ;
        if (this.showFieldTitles) {
            valueMap = {};
            for (var i = 0; i < fieldNames.length; i++) {
                var fieldName = fieldNames[i],
                    field = ds.getField(fieldName)
                ;
                valueMap[fieldName] = field.summaryTitle || field.title || fieldName;
            }
        }
        return valueMap;
    }
},

itemChanged : function () {
    this.fireAggregationChanged();
},

groupByFieldChanged : function () {
    var groupedFields = this.groupByForm.getValue("groupBy");

    if (groupedFields != null && groupedFields.length > 0) {
        // Set defaults on the first summary clause if the user hasn't selected values
        var firstClause = (this.clauses.length > 0 ? this.clauses[0] : null);
        if (this.dataSource && !firstClause || firstClause.canDefaultField()) {
            // Find first, non-grouped numeric field
            var ds = this.getDataSource(),
                fieldNames = ds.getFieldNames(),
                defaultFieldName,
                defaultFieldType;
            for (var i = 0; i < fieldNames.length; i++) {
                var field = ds.getField(fieldNames[i]);
                if (!groupedFields.contains(field.name) &&
                    (field.type == "integer" || field.type == "float") &&
                    !field.foreignKey)
                {
                    defaultFieldName = field.name;
                    defaultFieldType = field.type;
                    break;
                }
            }
            if (defaultFieldName) {
                if (!firstClause) {
                    firstClause = this.addNewClause();
                }
                // Set the firstClause fieldName
                firstClause.setDefaultField(defaultFieldName, defaultFieldType);
                if (firstClause.canDefaultFunction()) {
                    // Find first numeric validation function and select it
                    firstClause.setDefaultFunction();
                }
            }
        }
    } else {
        // No groupBy field is specified. Clear any clauses because they are no longer
        // applicable.
        for (var i = 0; i < this.clauses.length; i++) {
            this.removeClause(this.clauses[i]);
        }
    }
    this.fireAggregationChanged();
},

outputFieldChanged : function () {
    this.fireAggregationChanged();
},

fireAggregationChanged : function () {
    if (this._settingRequest) return;
    this.updateQueryOutputPickerValueMap(this._getRequest());
    if (isc.isA.Function(this.aggregationChanged)) {
        this.aggregationChanged();
    }
},

//> @attr aggregationEditor.clauseStack (AutoChild VStack : null : IR)
// VStack of all summary function clauses.
// @visibility aggregation
//<
clauseStackDefaults : {
    _constructor:isc.VStack,
    autoParent: "aggregationLayout",
    width: "100%",
    height:1,
    animateMembers: true,
    animateMemberTime: 150
},

emptyClausesLayoutDefaults: {
    _constructor:isc.HStack,
    autoParent: "aggregationLayout",
    width: "100%",
    height:1,
    membersMargin: 5
},

emptyClausesLabelDefaults: {
    _constructor:isc.Label,
    autoParent:"emptyClausesLayout",
    width:1,
    height:1,
    layoutAlign: "center",
    wrap: false
},

//> @attr aggregationEditor.emptyClausesMessage (String : "Return all unique combinations of combined fields" : IR)
// The message shown when no clauses are configured and not editing a new aggregation.
//
// @group i18nMessages 
// @visibility aggregation
//<
emptyClausesMessage: "Return all unique combinations of combined fields",

//> @attr aggregationEditor.emptyClauseOutputPrefixMessage (String : "Pick the value of the" : IR)
// The prefix message shown when no clauses are configured and not editing a new aggregation
// in +link{scalarMode}. Message is followed by the output field picker and then
// +link{emptyClauseOutputSuffixMessage}.
//
// @group i18nMessages 
// @visibility aggregation
//<
emptyClauseOutputPrefixMessage: "Pick the value of the",

//> @attr aggregationEditor.emptyClauseOutputSuffixMessage (String : "field from the first record" : IR)
// The suffix message shown when no clauses are configured and not editing a new aggregation
// in +link{scalarMode}. This message follows +link{emptyClauseOutputPrefixMessage} and the
// output field picker.
//
// @group i18nMessages 
// @visibility aggregation
//<
emptyClauseOutputSuffixMessage: "field from the first record",

queryOutputLayoutDefaults: {
    _constructor:isc.HStack,
    width: "100%",
    height:1,
    membersMargin: 5
},

queryOutputPrefixLabelDefaults: {
    _constructor:isc.Label,
    width:1,
    height:1,
    layoutAlign: "center",
    wrap: false
},

queryOutputSuffixLabelDefaults: {
    _constructor:isc.Label,
    width: 1,
    height: 1,
    layoutAlign: "center",
    wrap: false
},

queryOutputFormDefaults: {
    _constructor: "DynamicForm",
    width: 1,
    numCols: 1
},

queryOutputFieldDefaults: {
    name: "outputField",
    showTitle: false,
    width: "*",
    editorType: "ComboBoxItem",
    addUnknownValues: false,
    showHintInField: true,
    hint: "field name",
    changed: function () {
        this.form.creator.outputFieldChanged();
    }
},

//> @attr aggregationEditor.queryOutputPrefixMessage (String : "Pick the value of the" : IR)
// The prefix message shown when no clauses are configured and not editing a new aggregation
// in +link{scalarMode}. Message is followed by the output field picker and then
// +link{emptyClauseOutputSuffixMessage}.
//
// @group i18nMessages 
// @visibility aggregation
//<
queryOutputPrefixMessage: "Pick the value of the",

//> @attr aggregationEditor.queryOutputSuffixMessage (String : "field from the first record" : IR)
// The suffix message shown when no clauses are configured and not editing a new aggregation
// in +link{scalarMode}. This message follows +link{emptyClauseOutputPrefixMessage} and the
// output field picker.
//
// @group i18nMessages 
// @visibility aggregation
//<
queryOutputSuffixMessage: "field from each record",

//> @attr aggregationEditor.emptyClausesAddButtonPrompt (String : "Add summary functions" : IR)
// The hover prompt text for the empty clauses add button.
//
// @group i18nMessages 
// @visibility aggregation
//<
emptyClausesAddButtonPrompt: "Add summary functions",

//> @attr aggregationEditor.emptyClausesAddButton (AutoChild ImgButton : null : IR)
// The add ImgButton that appears after the +link{emptyClausesMessage} to allow adding
// summary function clauses.
// @visibility aggregation
//<
emptyClausesAddButtonDefaults : {
    _constructor:isc.ImgButton,
    autoParent:"emptyClausesLayout",
    width:18, height:18, layoutAlign:"center",
    src:"[SKIN]/actions/add.png",
    showRollOver:false, showDown:false,
    click: function () {
        this.creator.addNewClause();
    }
},

// Clause creation
// ---------------------------------------------------------------------------------------

//> @attr aggregationEditor.lastClauseRemoveButtonPrompt (String : "If you remove all aggregation functions, the returned data will be all unique combinations of the combined fields" : IR)
// The hover prompt text for the last (only) clause remove button. Otherwise, the
// +link{removeButtonPrompt} value is used.
//
// @group i18nMessages 
// @visibility aggregation
//<
lastClauseRemoveButtonPrompt: "If you remove all aggregation functions, the returned data will be all unique combinations of the combined fields",

clauseConstructor: "AggregationClause",

addNewClause : function (fieldName, summaryFunction) {
    if (!this.clauseStack) return;
    var aggregation = (fieldName && summaryFunction ? 
            { fieldName: fieldName, summaryFunction: summaryFunction } : null);

    var aggregationClause = this.createAutoChild("clause", 
      isc.addProperties({}, {
        visibility: "hidden",
        aggregation: aggregation,

        dataSource: this.dataSource,

        sortFields: this.sortFields,
        showFieldTitles: this.showFieldTitles,
        showHiddenFields: this.showHiddenFields,

        showAddButton: this.showAddButton,
        showRemoveButton: this.showRemoveButton,
        removeButtonPrompt: this.removeButtonPrompt,

        fieldPickerDefaults: this.fieldPickerDefaults,
        fieldPickerProperties: this.fieldPickerProperties,
        
        fieldPickerWidth: this.fieldPickerWidth,
        functionPickerWidth: this.functionPickerWidth,

        functionPickerDefaults: this.functionPickerDefaults,
        functionPickerProperties: this.functionPickerProperties,
        remove : function () {
            this.creator.removeClause(this);
        },
        fieldNameChanged : function () {
            this.Super("fieldNameChanged", arguments);
            this.creator.fieldNameChanged(this);
        },
        getRemovePrompt : function () {
            var editor = this.getAggregationEditor(),
                prompt = editor.removeButtonPrompt;
            if (editor.isFirstClause(this) && editor.clauses.length == 1) {
                prompt = editor.lastClauseRemoveButtonPrompt;
            }
            return prompt;
        },

        aggregationEditor: this,
        width: "100%"
      })
    );

    if (this.clausesStack && this.clauses.length == 0) {
        this.emptyClausesLayout.hide();
        this.clauseStack.show();
    }

    return this._addClause(aggregationClause);
},

_addClause : function (aggregationClause) {
    aggregationClause.aggregationEditor = this;

    // Refresh the clause's fields so it can
    // pick up context from the filterBuilder
    // aggregationClause.updateFields();
    this.clauses.add(aggregationClause);

    var clauseStack = this.clauseStack;

    // Remove add button from the current last clause as it will be on the new one
    var clauses = clauseStack.getMembers(),
        lastClause = clauses && clauses[clauses.length-1]
    ;
    if (lastClause) {
        lastClause.showAddButton = false;
    }

    clauseStack.addMember(aggregationClause);
    clauseStack.showMember(aggregationClause);

    this.fireAggregationChanged();
    return aggregationClause;
},

//> @method aggregationEditor.validate
// Validate the clauses of this AggregationEditor.
// @return (Boolean) true if all clauses are valid, false otherwise
// @visibility aggregation
//<
validate : function () {
    var valid = true;
    for (var i = 0; i < this.clauses.length; i++) {
        if (!this.clauses[i].validate()) valid = false;
    }
    return valid;
},

// Deriving DSRequest
// ---------------------------------------------------------------------------------------

//> @method aggregationEditor.getRequest()
// Get the aggregation request entered by the user. 
//
// @return (DSRequest)
// @visibility aggregation
//<
getRequest : function () {
    return this._getRequest();
},


_getRequest : function () {
    if (this._initializingClauses) {
        // if we were initialized with a request and the clauses are still being created, just 
        // return the request we were initialized with
        return this.request;
    }
    
    var request = {},
        groupBy = this.groupByForm && this.groupByForm.getValue("groupBy")
    ;
    if (groupBy) {
        request.groupBy = groupBy;
    }

    for (var i = 0; i < this.clauses.length; i++) {
        var clause = this.clauses[i],
            aggregation = clause.getAggregation(),
            skipAggregation = (!aggregation.fieldName || !aggregation.summaryFunction)
        ;
        if (!skipAggregation) {
            if (!request.summaryFunctions) {
                request.summaryFunctions = {};
            }
            request.summaryFunctions[aggregation.fieldName] = aggregation.summaryFunction;
        } 
    }
    if (!request.summaryFunctions && this.queryOutputForm) {
        var outputField = this.queryOutputForm.getValue("outputField");
        if (outputField) request.queryOutput = outputField;
    }

    if (this.filterBuilder) {
        var criteria = isc.DS.checkEmptyCriteria(this.filterBuilder.getCriteria());
        if (criteria) request.criteria = criteria;
    }
    if (this.sortByPicker) {
        var sortBy = this.sortByPicker.getSort();
        if (sortBy) request.sortBy = sortBy;
    }
    if (!isc.isAn.emptyObject(request) && this.dataSourcePicker) {
        var dsName = this.dataSourcePicker.getValue("dsName"),
            queryFK = this.dataSourcePicker.getValue("queryFK")
        ;
        request.dataSource = dsName;
        if (queryFK != null) {
            request.queryFK = queryFK;
        }
    }

    return request;
},

// fired when this editor is ready for interactive use
editorReady : function () { },

//> @method aggregationEditor.setRequest()
// Set new +link{DSRequest, aggregation request} for editing.  
// <P>
// An interface for editing the provided request will be generated identically to what happens
// when initialized with +link{request}.
// <P>
// Any existing request values entered by the user will be discarded.  
// 
// @param request (DSRequest) new request.  Pass null or {} to effectively reset the
//                            aggregationEditor to it's initial state when no values are
//                            specified
// @visibility aggregation
//<
setRequest : function (request) {
    this._setRequest(request);
},

_setRequest : function (request) {
    if (this._settingRequest) return;

    this._settingRequest = true;
    this.clearRequest();

    if (!request) {
        this.addNewClause();
        if (this.clauseStack) this.clauseStack.show();
        this._settingRequest = false;
        this.redraw();
        this.editorReady();
        return;
    }

    if (!request.dataSource) request.dataSource = this.getDataSource();
    
    var animation = this.clauseStack ? this.clauseStack.animateMembers : null;
    if (this.clauseStack) this.clauseStack.animateMembers = false;

    if (request.dataSource && this.dataSourcePicker) {
        this.setDataSource(request.dataSource, request.queryFK);
    }
    if (request.criteria && this.filterBuilder) {
        this.filterBuilder.setCriteria(request.criteria);
    }

    if (this.groupByForm && request.groupBy) {
        this.groupByForm.setValue("groupBy", request.groupBy);
    }

    if (request.summaryFunctions) {
        var map = request.summaryFunctions;
        for (var fieldName in map) {
            this.addClause(fieldName, map[fieldName]);
        }
        if (this.clauses.length == 0 && !this.allowEmpty) this.addNewClause();
    }

    if (this.queryOutputForm && request.queryOutput) {
        this.queryOutputForm.setValue("outputField", request.queryOutput);
    }

    if (this.sortByPicker) {
        if (request.dataSource) {
            this.sortByPicker.setDataSource(request.dataSource);
        }
        if (request.sortBy) {
            this.sortByPicker.setSort(request.sortBy);
        }
    }

    if (this.queryOutputForm) {
        this.updateQueryOutputPickerValueMap(request);
    }

    this._settingRequest = false;
    if (this.clauseStack) this.clauseStack.show();
    this.delayCall("redraw");

    if (this.clauseStack) this.clauseStack.animateMembers = animation;
    this.editorReady();
},

updateQueryOutputPickerValueMap : function (request) {
    if (this.queryOutputForm) {
        var pickerField = this.queryOutputForm.getField("outputField"),
            valueMap = this.getQueryOutputPickerValueMap(request)
        ;
        if (pickerField) {
            pickerField.setValueMap(valueMap);
            var currentValue = pickerField.getValue();
            if (currentValue && !valueMap.contains(currentValue)) {
                pickerField.clearValue();
            }
        }
    }
},

getQueryOutputPickerValueMap : function (request) {
    var ds = this.getDataSource(),
        valueMap = []
    ;
    if (ds) {
        valueMap = ds.getFieldNames();
    }
    return valueMap.sort();
},

getQueryOutputPickerDefaultValue : function (request) {
    var value;
    // if (request) {
    //     if (request.summaryFunctions) {
    //         var summaryFunctions = request.summaryFunctions;
    //         if (summaryFunctions) {
    //             for (var summaryFunction in summaryFunctions) {
    //                 value = summaryFunction;
    //                 break;
    //             }
    //         }
    //     } else if (request.groupBy) {
    //         var groupBy = request.groupBy;
    //         value = (isc.isA.String(groupBy) ? groupBy : (groupBy.length > 0 ? groupBy[0] : null));
    //     }
    // }
    // if (!value) {
    //     var ds = this.getDataSource();
    //     if (ds) {
    //         var fields = ds.getFields();
    //         for (var fieldName in fields) {
    //             var field = fields[fieldName];
    //             if (field.type == "integer" || field.type == "float") {
    //                 value = fieldName;
    //                 break;
    //             }
    //         }
    //     }
    // }
    return value;
},

//> @method aggregationEditor.clearRequest()
// Clear all current aggregation details.
// @visibility aggregation
//<
clearRequest : function (dontCheckEmpty) {
    if (this.groupBy) this.groupByForm.clearValues();
    if (this.sortByPicker) this.sortByPicker.setSort(null);

    
    var animation = this.clauseStack ? this.clauseStack.animateMembers : null;
    if (this.clauseStack) this.clauseStack.animateMembers = false;

    while (this.clauses.length > 0) {
        this.removeClause(this.clauses[0]);
    }

    if (this.clauseStack) this.clauseStack.animateMembers = animation;
},

//> @method aggregationEditor.addClause()
// Add a new aggregation clause.
// 
// @param [fieldName] (String) selected field for the clause
// @param [summaryFunction] (String) selected summary function for the clause
// @visibility aggregation
//<
addClause : function (fieldName, summaryFunction) {
    this.addNewClause(fieldName, summaryFunction);
},

fieldNameChanged : function (aggregationClause) {
},

dataSourceChanged : function (dataSource, queryFK) {
    this.setDataSource(dataSource, queryFK);
} 

});

//> @class AggregationClause
// A horizontal, Layout-based widget that allows a user to input a single aggregation based on 
// one field and one summary function.
// <P>
// Note that AggregationClause must be used in conjunction with a +link{class:AggregationEditor}.
// By default the AggregationEditor will auto-generate its clauses based on specified request,
// but for advanced usage a AggregationClause may be instantiated directly and passed to a
// AggregationEditor via +link{aggregationEditor.addClause()}.
// 
// @inheritsFrom Layout
// @treeLocation Client Reference/Forms/AggregationEditor
// @visibility aggregation
//<
isc.defineClass("AggregationClause", "Layout").addProperties({
    // props from HLayout
    orientation:"horizontal",
    defaultWidth: "100%",
    width: "100%",
    height: 20,
    membersMargin: 4,

    isRuleScope: true,

    //> @attr aggregationClause.fieldName (FieldName : null : IRW)
    // Initial summary function target field name for this AggregationClause.
    // @visibility aggregation
    //<

    //> @attr aggregationClause.summaryFunction (SummaryFunction : null : IRW)
    // Initial summary function for this AggregationClause.
    // <P>
    // When initialized with a summaryFunction or +link{fieldName}, the clause will be
    // automatically set up for editing the supplied aggregation.
    // <P>
    // Note that an empty or partial aggregation is allowed, for example, it may specify
    // +link{fieldName} only and will generate an expression with the summary function not chosen.
    // @visibility aggregation
    //<
    
    // Clause creation
    // ---------------------------------------------------------------------------------------
    
    //> @attr aggregationClause.firstClausePrefixMessage (String : "Then calculate the value for" : IR)
    // The message prefix to show before the field picker for the first clause.
    //
    // @see clausePrefixMessage
    // @group i18nMessages 
    // @visibility aggregation
    //<
    firstClausePrefixMessage: "Then calculate the value for",

    //> @attr aggregationClause.clausePrefixMessage (String : "and the value for" : IR)
    // The message prefix to show before the field picker for each clause after the first.
    //
    // @see firstClausePrefixMessage
    // @group i18nMessages 
    // @visibility aggregation
    //<
    clausePrefixMessage: "and the value for",

    //> @attr aggregationClause.clauseSummaryMessage (String : "as the" : IR)
    // The message to show after the field picker but before the summary function picker.
    //
    // @group i18nMessages 
    // @visibility aggregation
    //<
    clauseSummaryMessage: "as the",

    // Note that fieldPicker and functionPicker defaults and properties
    // may be overridden at the aggregationEditor level
    fieldPickerWidth: 200,
    functionPickerWidth: 325,
    
    fieldPickerDefaults: { 
        name: "fieldName", 
        editorType: "ComboBoxItem",
        showTitle: false, 
        textMatchStyle: "startsWith",
        changed : function () { this.form.creator.fieldNameChanged(this.form); }
    },
    
    //> @attr aggregationClause.fieldPicker (AutoChild PickList : null : IR)
    // @include aggregationEditor.fieldPicker
    //
    // @visibility aggregation
    //<
    
    //> @attr aggregationClause.fieldPickerProperties (FormItem Properties : null : IR)
    // Properties to combine with the +link{fieldPicker} autoChild FormItem.
    //
    // @visibility aggregation
    //<
    
    fieldPickerFormDefaults: {
        _constructor:isc.DynamicForm,
        autodraw: false,
        height: 1,
        numCols: 1

        // initWidget : function () {
        //     this.Super("initWidget", arguments);
        //     // Autosize picker to width of the picklist
        //     var field = this.getItem("fieldName");
        //     field.makePickList();
        //     var pickList = field.pickList;
        //     if (!pickList.isDrawn()) {
        //         isc.Canvas.moveOffscreen(pickList);
        //         pickList.setVisibility("hidden");
        //         pickList.draw();
        //     }
        //     field.getPickerIcon();
        //     this.setWidth(pickList.getVisibleWidth()+field._pickerIcon.width+field.iconHSpace);
        // }
    },

    //> @attr aggregationClause.functionPicker (AutoChild SummaryFunctionItem : null : IR)
    // AutoChild for the +link{FormItem} that allows a user to select the summary function
    // when creating aggregation clauses. Each clause will create a functionPicker automatically.
    // To customize this item, use +link{functionPickerProperties}
    //
    // @visibility aggregation
    //<

    //> @attr aggregationClause.functionPickerProperties (FormItem Properties : null : IR)
    // Properties to combine with the +link{functionPicker} autoChild FormItem.
    //
    // @visibility aggregation
    //<
    functionPickerDefaults : {
        name:"function", 
        editorType: "SummaryFunctionItem",
        showTitle:false, 
        // don't allow addUnknownValues - it's a fixed list applicable to the selected field
        addUnknownValues:false, 
        changed : function () { this.form.creator.functionChanged(this.form); }
    },

    functionPickerFormDefaults: {
        _constructor:isc.DynamicForm,
        autodraw: false,
        width: 1,
        height: 1,
        numCols: 1
    },

    buttonBarDefaults: { 
        _constructor:isc.HLayout,
        width:"*",
        layoutAlign: "center"
    },

    //> @attr aggregationClause.showRemoveButton (Boolean : true : IR)
    // If set, show a button for this clause allowing it to be removed.
    // @visibility aggregation
    //<
    showRemoveButton:true,
    
    //> @attr aggregationClause.removeButtonPrompt (String : "Remove" : IR)
    // The hover prompt text for the remove button. 
    //
    // @group i18nMessages 
    // @visibility aggregation
    //<
    removeButtonPrompt: "Remove",
    
    //> @attr aggregationClause.removeButton (AutoChild ImgButton : null : IR)
    // The clause removal ImgButton that appears after this clause if
    // +link{showRemoveButton} is set.
    // @visibility aggregation
    //<
    removeButtonDefaults : {
        _constructor:isc.ImgButton,
        autoParent:"buttonBar",
        width:18, height:18, layoutAlign:"center",
        src:"[SKIN]/actions/remove.png",
        showRollOver:false, showDown:false,
        click: function () { this.creator.remove(); }
    },
    
    //> @attr aggregationClause.showAddButton (Boolean : true : IRW)
    // If set, show a button for this clause allowing a new one to be added below it.
    // @visibility aggregation
    //<
    showAddButton:true,
    
    //> @attr aggregationClause.addButtonPrompt (String : "Add" : IR)
    // The hover prompt text for the add button.
    //
    // @group i18nMessages 
    // @visibility aggregation
    //<
    addButtonPrompt: "Add",
    
    //> @attr aggregationClause.addButton (AutoChild ImgButton : null : IR)
    // The clause add ImgButton that appears after this clause if
    // +link{showAddButton} is set.
    // @visibility aggregation
    //<
    addButtonDefaults : {
        _constructor:isc.ImgButton,
        autoParent:"buttonBar",
        width:18, height:18, layoutAlign:"center",
        src:"[SKIN]/actions/add.png",
        showRollOver:false, showDown:false,
        click: function () {
            this.creator.updateButtons(false);
            this.creator.addButtonClick();
            this.creator.updateButtons(true);
        }
    }
});
    
isc.AggregationClause.addMethods({
    
    initWidget : function () {
        this.Super("initWidget", arguments);
        this.setupClause();
        this.setAggregation(this.aggregation);
    },
    
    //> @method aggregationClause.getAggregationEditor()
    // Returns the +link{class:aggregationEditor,aggregationEditor} containing this clause,
    // or null if this aggregationClause is not embedded in an aggregationEditor.
    // @visibility aggregation
    //<
    getAggregationEditor : function () {
        // aggregationEditor attribute is set by aggregationEditor.addClause()
        return this.aggregationEditor;
    },
    
    //> @object Aggregation
    // Represents a single aggregation that is handled in +link{AggregationClause}.
    // @treeLocation Client Reference/Forms/AggregationEditor
    // @visibility aggregation
    //<

    //> @attr aggregation.fieldName (String : null : IRW)
    // Field name to be summarized.
    //
    // @visibility aggregation
    //<

    //> @attr aggregation.summaryFunction (SummaryFunction : null : IRW)
    // Summary function to be applied to +link{fieldName}.
    //
    // @visibility aggregation
    //<

    //> @method aggregationClause.getAggregation()
    // Return the aggregation details specified by this AggregationClause.
    // 
    // @return (Aggregation) The aggregation for this AggregationClause
    // @visibility aggregation
    //<
    getAggregation : function (includeEmptyValues) {
        var fieldName = this.fieldPickerForm.getValue("fieldName"),
            summaryFunction = this.functionPickerForm.getValue("function")
        ;
        return (fieldName != null ? {
                    fieldName: fieldName,
                    summaryFunction: summaryFunction
                } : {});
    },

    setAggregation : function (aggregation) {
        var fieldName = aggregation && aggregation.fieldName,
            summaryFunction = aggregation && aggregation.summaryFunction
        ;
        this.fieldPickerForm.setValue("fieldName", fieldName);
        this.fieldNameChanged(this.fieldPickerForm);
        this.functionPickerForm.setValue("function", summaryFunction);
    },

    getFieldNamesValueMap : function () {
        if (this.allowedFields) return this.allowedFields;
        if (this.dataSource) {
            var ds = this.getDataSource(),
                fieldNames = ds.getFieldNames(!this.showHiddenFields),
                valueMap = fieldNames
            ;
            if (this.showFieldTitles) {
                valueMap = {};
                for (var i = 0; i < fieldNames.length; i++) {
                    var fieldName = fieldNames[i],
                        field = ds.getField(fieldName)
                    ;
                    valueMap[fieldName] = field.summaryTitle || field.title || fieldName;
                }
            }
            return valueMap;
        }
    },
    
    // setupClause initializes autoChildren etc.
    setupClause : function () {
        this._clauseInitialized = true;
        if (this.dataSource && !isc.isA.DataSource(this.dataSource)) {
            this.dataSource = isc.DataSource.get(this.dataSource);
        }

        var editor = this.getAggregationEditor(),
            prefixMessage = (editor.isFirstClause(this) ?
                                this.firstClausePrefixMessage :
                                this.clausePrefixMessage)
        ;

        var leadingMessageLabel = isc.Label.create({
            autoDraw: false,
            width: editor._clausePrefixLabelWidth || 1,
            height: 1,
            layoutAlign: "center",
            align: "right",
            wrap: false,
            contents: prefixMessage
        });

        // The first prefix message will be the longest one and others should be forced
        // to the same width and right-aligned. The first time through grab the drawn
        // width of the first message.
        if (!editor._clausePrefixLabelWidth) {
            // Draw offscreen to obtain drawn width
            leadingMessageLabel.setTop(-9999);
            leadingMessageLabel.draw();
            editor._clausePrefixLabelWidth = leadingMessageLabel.getVisibleWidth();
        }

        var middleMessageLabel = isc.Label.create({
            autoDraw: false,
            width: 1,
            height: 1,
            layoutAlign: "center",
            wrap: false,
            contents: this.clauseSummaryMessage
        });

        var fieldPickerItem = isc.addProperties({}, this.fieldPickerDefaults, 
            {
                width: this.fieldPickerWidth,
                sortField: (this.sortFields ? "fieldName" : null)
            }, 
            this.fieldPickerProperties,
            {name:"fieldName"},
            {valueMap:this.getFieldNamesValueMap()}
        );
        this.fieldPickerForm = this.createAutoChild("fieldPickerForm", {
            fields: [ fieldPickerItem ]
        });

        var fieldPickerFormID = this.fieldPickerForm.ID;
        var functionPickerItem = isc.addProperties({}, this.functionPickerDefaults, 
            { width: this.functionPickerWidth }, 
            this.summaryPickerProperties,
            { name:"function",
                requiredWhen: {
                    _constructor:isc.AdvancedCriteria,
                    operator: "and",
                    criteria: [
                        { fieldName: fieldPickerFormID + ".values.fieldName", operator: "notBlank" }
                    ]
                }
            }
        );
        this.functionPickerForm = this.createAutoChild("functionPickerForm", {
            fields: [ functionPickerItem ]
        });

        this.addMembers([ leadingMessageLabel, this.fieldPickerForm, middleMessageLabel, this.functionPickerForm]);

        this.addAutoChild("buttonBar");
        // Buttons are always created and shown on mouse-over if allowed
        this.addAutoChild("removeButton", { prompt: this.removeButtonPrompt, visibility: "hidden" });
        this.addAutoChild("addButton", { prompt: this.addButtonPrompt, visibility: "hidden" });
    },

    updateClausePrefixMessage : function () {
        var leadingMessageLabel = this.members[0],
            editor = this.getAggregationEditor(),
            prefixMessage = (editor.isFirstClause(this) ?
                this.firstClausePrefixMessage :
                this.clausePrefixMessage)
        ;
        leadingMessageLabel.setContents(prefixMessage);
    },

    fieldNameChanged : function (form) {
        var value = form.getValue("fieldName");
        if (value) {
            var dsField = this.dataSource && this.dataSource.getField(value),
                fieldType = dsField && dsField.type || "text"
            ;
            this.functionPickerForm.getItem("function").setFieldType(fieldType);
            this.creator.itemChanged();

            form.getField("fieldName")._manuallySet = true;
        }
    },

    functionChanged : function (form) {
        this.creator.itemChanged();

        form.getField("function")._manuallySet = true;
    },

    //> @method aggregationClause.remove()
    // Remove this clause by destroy()ing it.
    // 
    // @visibility aggregation
    //<
    remove : function () {
        this.markForDestroy();
    },

    //> @method aggregationClause.validate
    // Validate the clause.
    // @return (Boolean) true if the clause is valid, false otherwise
    // @visibility aggregation
    //<
    validate : function () {
        return this.fieldPickerForm.validate() && this.functionPickerForm.validate();
    },

    addButtonClick : function () {
        var editor = this.getAggregationEditor();
        if (editor) {
            editor.addNewClause();
        }
    },

    // Hide/show clause action buttons when mousing over clause

    mouseOver : function () {
        this.updateButtons(true);
    },

    mouseOut : function() {
        this.updateButtons(false);
    },

    updateButtons : function (over) {
        if (over && this.showRemoveButton) {
            if (this.getRemovePrompt) {
                this.removeButton.prompt = this.getRemovePrompt();
            }
            this.removeButton.show();
        } else if (this.showRemoveButton) {
            this.removeButton.hide();
        }
        if (over && this.showAddButton) {
            this.addButton.show();
        } else if (this.showAddButton) {
            this.addButton.hide();
        }
    },

    canDefaultField : function () {
        return !this.fieldPickerForm.getField("fieldName")._manuallySet;
    },

    canDefaultFunction : function () {
        return !this.functionPickerForm.getField("function")._manuallySet;
    },

    setDefaultField : function (fieldName, fieldType) {
        this.fieldPickerForm.setValue("fieldName", fieldName);
        if (fieldType) {
            this.functionPickerForm.getItem("function").setFieldType(fieldType);
        }
    },

    setDefaultFunction : function () {
        // Pick first valid function for field type as default
        var field = this.functionPickerForm.getItem("function"),
            valueMap = field.getValueMap(),
            keys = valueMap && isc.getKeys(valueMap)
        ;
        if (keys && keys.length > 0) {
            this.functionPickerForm.setValue("function", keys[0]);
        }
    }
});

isc.AggregationEditor.registerStringMethods({
    //> @method aggregationEditor.aggregationChanged()
    // Handler fired when there is a change within the editor.
    //
    // @visibility aggregation
    //< 
    aggregationChanged : ""
});

//> @class OptionalAggregationEditor
// A form that allows an optional set of aggregation properties to be defined via an embedded
// +link{AggregationEditor}. When no +link{DSRequest} object is provided the form just
// displays a checkbox to enable aggregation details. Once checked or if a DSRequest object
// is provided, an +link{aggregationEditor} is shown.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Forms
// @visibility aggregation
//<
isc.defineClass("OptionalAggregationEditor","VLayout").addProperties({
    defaultWidth: 800,
    height: 1,

    //> @attr optionalAggregationEditor.useAggregationTitle (String : "Use aggregation" : IR)
    // The title for the checkbox to enable/disable aggregation.
    // @group i18nMessages
    // @visibility aggregation
    //<
    useAggregationTitle: "Use aggregation",

    //> @attr optionalAggregationEditor.useAggregationPrompt (String : "Aggregation combines records from your DataSource together, so that you can compute sums (like the total value of an Order), or find the record with the largest or smallest value for a field, or compute other quantities." : IR)
    // The title for the checkbox to enable/disable aggregation.
    // @group i18nMessages
    // @visibility aggregation
    //<
    useAggregationPrompt: "Aggregation combines records from your DataSource together, so that you can compute sums (like the total value of an Order), or find the record with the largest or smallest value for a field, or compute other quantities.",

    //> @attr optionalAggregationEditor.removeAggregationConfirmationText (String : "This will remove aggregation. Proceed?" : IR)
    // The contents of the confirmation dialog presented to the user when unchecking the
    // use aggregation checkbox.
    // @group i18nMessages
    // @visibility aggregation
    //<
    removeAggregationConfirmationText: "This will remove aggregation. Proceed?",

    unusedFormDefaults: {
        _constructor:isc.DynamicForm,
        width: "*",
        height: 1,
        numCols: 1
    },
     
    useAggregationItemDefaults: {
        name: "useAggregation",
        type: "boolean",
        title: "Use aggregation",
        showTitle: false,
        change : function (form, item, value) {
            this.form.creator.useAggregationChanged(value);
            return false;
        }
    },

    aggregationEditorContainerDefaults: {
        _constructor: isc.VLayout,
        width: "100%",
        height: "100%",
        isGroup: true,
        groupTitle: "Use aggregation",  // something is required to go with isGroup
        visibility: "hidden",

        initWidget : function () {
            this.Super("initWidget", arguments);
            // Create the "groupLabel" before it would normally get created so that
            // no eventProxy is assigned and therefore mouse clicks are correctly handled
            this.groupLabel = this.createAutoChild("groupLabel", { autoDraw: false });
        },
        
        groupLabelProperties:{
            _constructor:isc.DynamicForm,
            // which fits its content
            width: 1,
            height: 1,
            numCols: 1,
            _resizeWithMaster:false,
            // center in both directions
            vAlign:"center", align:"center",

            useAggregationFieldDefaults: {
                name: "useAggregation",
                type: "boolean",
                showTitle: false,
                defaultValue: true,
                change : function (form, item, value) {
                    this.form.creator.creator.useAggregationChanged(value);
                    return false;
                }
            },

            initWidget : function () {
                this.fields = [
                    isc.addProperties({}, this.useAggregationFieldDefaults, {
                        title: this.creator.useAggregationTitle,
                        prompt: this.creator.useAggregationPrompt
                    })
                ];
                this.Super("initWidget", arguments);
            },
    
            redraw : function () {
                var ret = this.Super("redraw", arguments);
                this.creator._moveGroupLabelIntoPlace();
                return ret;
            },
            handleParentMoved : function () {
                this.Super("handleParentMoved", arguments);
                this.creator._moveGroupLabelIntoPlace();
            }
        }
    },

    //> @attr optionalAggregationEditor.aggregationEditor (AutoChild AggregationEditor : null : IR)
    // AutoChild for the +link{AggregationEditor}.
    //
    // @visibility aggregation
    //<
    aggregationEditorDefaults: {
        _constructor:isc.AggregationEditor,
        autoParent:"aggregationEditorContainer"
    },

    initWidget : function () {
        this.Super("initWidget", arguments);

        this.addAutoChild("unusedForm", {
            fields: [
                isc.addProperties({}, this.useAggregationItemDefaults, {
                    title: this.useAggregationTitle,
                    prompt: this.useAggregationPrompt
                })
            ]
        });

        this.addAutoChild("aggregationEditorContainer", {
            useAggregationTitle: this.useAggregationTitle,
            useAggregationPrompt: this.useAggregationPrompt
        });
        var editorProperties = {
            dataSource: this.dataSource,
            dataSources: this.dataSources,
            showDataSourcePicker: this.showDataSourcePicker,
            showCriteriaEditor: this.showCriteriaEditor,
            request: this.request
        };
        if (this.aggregationChanged) {
            // Setup pass-through event handler such that the "this" is as expected
            var _this = this;
            editorProperties.aggregationChanged = function () {
                _this.aggregationChanged();
            }
        }
        this.addAutoChild("aggregationEditor", editorProperties);
        if (this.request) {
            this.useAggregationChanged(true);
        }
    },
    
    usingAggregation: false,

    useAggregationChanged : function (value) {
        if (this.usingAggregation == value) return;
        this.usingAggregation = value;

        if (value) {
            this.unusedForm.hide();
            this.aggregationEditorContainer.show();
        } else {
            var _this = this;
            isc.confirm(this.removeAggregationConfirmationText, function (response) {
                if (response) {
                    _this._removeAggregation();
                }
            }, {
                buttons: [isc.Dialog.CANCEL, isc.Dialog.OK],
                autoFocusButton: 1
            });
        }
    },

    _removeAggregation : function () {
        this.aggregationEditorContainer.hide();
        this.unusedForm.show();
    },

    //> @attr optionalAggregationEditor.dataSource (DataSource | ID : null : IRW)
    // DataSource this editor should use for field definitions.  Passed through to
    // +link{aggregationEditor}.
    // @visibility aggregation
    //< 
    setDataSource : function(ds, queryFK) {
        this.aggregationEditor.setDataSource(ds, queryFK);
    },

    //> @method optionalAggregationEditor.validate
    // Validate the clauses of this AggregationEditor. Passed through to
    // +link{aggregationEditor}.
    // @return (Boolean) true if all clauses are valid, false otherwise
    // @visibility aggregation
    //<
    validate : function () {
        return this.aggregationEditor.validate();
    },

    // DSRequest
    // ---------------------------------------------------------------------------------------

    //> @method optionalAggregationEditor.clearRequest()
    // Clear all current aggregation details.
    // @visibility aggregation
    //<
    clearRequest : function () {
        this.aggregationEditor.clearRequest();
    },

    //> @method optionalAggregationEditor.getRequest()
    // Get the aggregation request entered by the user. The result is always <code>null</code>
    // if aggregation is not enabled.
    //
    // @return (DSRequest)
    // @visibility aggregation
    //<
    getRequest : function () {
        // If aggregration is not enabled, there is no aggregation to retrieve
        return (this.usingAggregation ? this.aggregationEditor.getRequest() : null);
    },

    //> @attr optionalAggregationEditor.request (DSRequest : null : IRW)
    // Initial aggregation request.  Passed through to +link{aggregationEditor}.
    // <P>
    // When initialized with a request, appropriate clauses for editing the provided request will
    // be automatically generated.
    //
    // @visibility aggregation
    //<

    //> @method optionalAggregationEditor.setRequest()
    // Set new +link{DSRequest, aggregation request} for editing. Passed through to
    // +link{aggregationEditor}.+link{aggregationEditor.setRequest,setRequest()}. 
    // <P>
    // An interface for editing the provided request will be generated identically to what happens
    // when initialized with +link{request}.
    // <P>
    // Any existing request values entered by the user will be discarded.  
    // 
    // @param request (DSRequest) new request.  Pass null or {} to effectively reset the
    //                            aggregationEditor to it's initial state when no values are
    //                            specified
    // @visibility aggregation
    //<
    setRequest : function (request) {
        this.aggregationEditor.setRequest(request);
        // If a request is specified, automatically enable aggregation
        var useAggregation = (request != null &&
            !isc.isAn.emptyObject(request) &&
            (request.groupBy != null || request.summaryFunctions != null));
        this.useAggregationChanged(useAggregation);
    }
});

//> @class RelatedCriteriaEditor
// A form that allows the user to define related criteria details for a +link{DSRequest},
// +link{Criterion.fieldQuery} or +link{Criterion.valueQuery}. The
// properties include <code>DataSource</code>, <code>criteria</code> and <code>queryOutput</code>.
// <P>
// The +link{DSRequest} object produced by an RelatedCriteriaEditor can be used by the
// +link{DataSource} subsystem to affect fetches.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Forms
// @visibility aggregation
//<
isc.defineClass("RelatedCriteriaEditor", "AggregationEditor");
isc.RelatedCriteriaEditor.addProperties({
    showDataSourcePicker: true,
    showCriteriaEditor: true,
    showQueryOutputPicker: true,

    showSortByPicker: false,
    showAggregationLayout: false,

    separateIndirectRecords: false,
    // showForeignKeyTitle: true,
    // alwaysShowForeignKey: false,
    canSelectIndirectRecord: true,

    _getRequest : function () {
        var request = this.Super("_getRequest", arguments);
        
        if (request) request.queryFK = "*none*";
        return request;
    }
});


isc.defineClass("SortByEditor", "HLayout");

isc.SortByEditor.addProperties({
    width: "100%",
    height: 30,
    membersMargin: 20,

    sortPickerDefaults: {
        name: "sortField",
        type: "SelectItem",
        title: "Sort by",
        width: "*",
        allowEmptyValue: true,
        emptyDisplayValue: "None"
    },

    sortDirectionDefaults: {
        name: "sortDirection",
        type: "RadioGroupItem",
        showTitle: false,
        defaultValue: "ascending",
        vertical: false,
        valueMap: {
            "ascending":  "Ascending",
            "descending":  "Descending"
        },
        readOnlyWhen: {
            _constructor: "AdvancedCriteria",
            criteria: [
                { fieldName: "sortField", operator: "isNull" }
            ]
        }
    },

    multiSortDisplayDefaults: {
        name: "multiSort",
        type: "StaticTextItem",
        title: "Sort by",
        height: isc.TextItem.getInstanceProperty("height"),
        width: "*",
        wrap: false,
        clipValue: true,
        showIf: false,  // by default
        icons: [{
            src: "[SKINIMG]actions/edit.png",
            prompt: "Edit sort",
            click : function (form,item,icon) {
                form.creator.showAdvancedSortDialog();
            }
        }]
    },

    sortEditorDefaults: {
        _constructor: "DynamicForm",
        layoutAlign: "center",
        width: 100,
        wrapItemTitles: false,
        numCols: 3,
        colWidths: [50, 200, "*"]
    },

    //> @attr SortByEditor.advancedSortMessage (String : "Advanced.." : IR)
    // Title for the "Advanced.." sort label
    // @group i18nMessages
    //<
    advancedSortMessage: "Advanced..",

    advancedSortLinkDefaults : {
        _constructor: "Label",
        height:30,
        autoFit:true,
        layoutAlign: "center",
        wrap:false,
        cursor:"pointer",
        click : function () {
            this.creator.showAdvancedSortDialog();
        }
    },

    initWidget : function () {
        this.Super("initWidget", arguments);

        var fields = [
            isc.addProperties({}, this.sortPickerDefaults, this.sortPickerProperties),
            isc.addProperties({}, this.sortDirectionDefaults, this.sortDirectionProperties),
            isc.addProperties({}, this.multiSortDisplayDefaults, this.multiSortDisplayProperties)
        ];
        this.addAutoChild("sortEditor", { fields: fields });
        this.sortEditor.setValues({});

        if (isc.MultiSortDialog) {
            var contents = "<span style='color:blue;text-decoration:underline;'>" +
                this.advancedSortMessage + "</span>";
            this.addAutoChild("advancedSortLink", { contents: contents });
        }
    },

    setDataSource : function (dataSource) {
        this.dataSource = dataSource = isc.DS.get(dataSource);

        var fieldNames = dataSource && dataSource.getFieldNames(),
            valueMap = {}
        ;
        if (fieldNames) {
            for (var i = 0; i < fieldNames.length; i++) {
                var fieldName = fieldNames[i],
                    field = dataSource.getField(fieldName),
                    title = field.title || dataSource.getAutoTitle(fieldName)
                ;
                valueMap[fieldName] = title;
            }
        }
        this.sortEditor.getField("sortField").setValueMap(valueMap);
    },

    setSort : function (sort) {
        if (sort && (isc.isA.String(sort) || sort.length == 1)) {
            // single sort
            var sortField,
                sortDirection
            ;
            if (isc.isA.String(sort)) {
                sortField = (sort.startsWith("-") ? sort.substring(1) : sort);
                sortDirection = (sort.startsWith("-") ? "descending" : "ascending");
            } else {
                sortField = sort[0].property;
                sortDirection = sort[0].direction;
            }
            this.sortEditor.setValue("sortField", sortField);
            this.sortEditor.setValue("sortDirection", sortDirection);
            if (!this.sortEditor.getField("sortField").isVisible()) {
                this.sortEditor.getField("sortField").show();
                this.sortEditor.getField("sortDirection").show();
                this.sortEditor.getField("multiSort").hide();
                this.advancedSortLink.show();
            }
            delete this.multiSort;
        } else if (sort) {
            // multisort
            this.multiSort = sort;
            this.sortEditor.setValue("multiSort", isc.DS.getSortBy(sort).join(" then "));

            this.sortEditor.getField("sortField").hide();
            this.sortEditor.getField("sortDirection").hide();
            this.sortEditor.getField("multiSort").show();
            this.advancedSortLink.hide();
        } else {
            this.sortEditor.getField("sortField").show();
            this.sortEditor.getField("sortDirection").show();
            this.sortEditor.getField("multiSort").hide();
            this.advancedSortLink.show();
        }
    },

    getSort : function () {
        var sortField = this.sortEditor.getValue("sortField"),
            sortDirection = this.sortEditor.getValue("sortDirection"),
            sortSpecifier = sortField && { property: sortField, direction: sortDirection },
            sortSpecifiers
        ;
        if (this.multiSort) {
            sortSpecifiers = this.multiSort;
        } else {
            sortSpecifiers = sortSpecifier && isc.DS.getSortBy([sortSpecifier])[0];
        }
        return sortSpecifiers;
    },

    showAdvancedSortDialog : function () {
        var sortSpecifiers = this.getSort();
        if (isc.isA.String(sortSpecifiers)) {
            sortSpecifiers = [{
                property: (sortSpecifiers.startsWith("-") ? sortSpecifiers.substring(1) : sortSpecifiers),
                direction: (sortSpecifiers.startsWith("-") ? "descending" : "ascending")
            }];
        }
        isc.MultiSortDialog.askForSort(
            this.dataSource, 
            sortSpecifiers, 
            {target:this, methodName:"multiSortReply"}
        );
    },

    multiSortReply : function (sortLevels) {
        if (sortLevels != null) {
            sortLevels.clearProperty("normalizer");
            this.setSort(sortLevels);
        }
    }
});

isc.defineClass("SubqueryDataSourceDS", "DataSource");
isc.SubqueryDataSourceDS.addClassProperties({
    getPathQueryFK : function (path) {
        var parts = (path ? path.split("/") : null);
        if (!parts) return null;

        var regexp = new RegExp("\\[(\\w+)(?:,(\\w+))?\\]");
        var getDSName = function(dsName) {
            return (dsName.indexOf("[") >= 0 ? dsName.substring(0, dsName.indexOf("[")) : dsName);
        };
        var getFKName = function(dsName) {
            var match = regexp.exec(dsName);
            return match && match[1];
        };
        var queryFK = [],
            lastDSName = parts[0]
        ;
        for (var i = 1; i < parts.length; i++) {
            var dsName = getDSName(parts[i]),
                fkName = getFKName(parts[i]),
                ds = isc.DS.get(lastDSName)
            ;
            if (!fkName) {
                var fieldNames = (ds ? ds.getFieldNames() : []),
                    field
                ;
                // Look for direct relation
                for (var j = 0; j < fieldNames.length; j++) {
                    field = ds.getField(fieldNames[j]);
                    if (field.foreignKey && field.foreignKey.startsWith(dsName + ".")) {
                        fkName = fieldNames[j];
                        break;
                    }
                }
                // Look for indirect relation if direct one not found
                if (!fkName) {
                    ds = isc.DS.get(dsName);
                    fieldNames = (ds ? ds.getFieldNames() : []);

                    for (var j = 0; j < fieldNames.length; j++) {
                        field = ds.getField(fieldNames[j]);
                        if (field.foreignKey && field.foreignKey.startsWith(lastDSName + ".")) {
                            fkName = dsName + "." + fieldNames[j];
                            break;
                        }
                    }
                }
            } else {
                // Determine which direction the relationship is to correctly
                // assign the queryFK path
                var fkField = ds && ds.getField(fkName);
                if (fkField && fkField.foreignKey != null) {
                    var foreignDSName = isc.DS.getForeignDSName(fkField, ds);
                    if (foreignDSName != dsName) {
                        fkName = dsName + "." + fkName;
                    }
                } else {
                    fkName = dsName + "." + fkName;
                }
            }
            if (fkName) {
                queryFK.add(fkName);
            }
            lastDSName = dsName;
        }
        return queryFK.join(":");
    },

    getQueryFKPath : function (baseDSName, queryFK) {
        var parts = (queryFK ? queryFK.split(":") : null);
        if (!parts || queryFK == "*none*") return baseDSName;

        var currentDSName = baseDSName,
            path = [baseDSName]
        ;

        for (var i = 0; i < parts.length; i++) {
            var currentDS = isc.DS.get(currentDSName);

            var segment = parts[i];
            if (segment.indexOf(".") > 0) {
                // segment has an explicit DataSource prefix
                // target is currentDSName
                var dsName = segment.substring(0, segment.indexOf(".")),
                    fieldName = segment.substring(segment.indexOf(".")+1)
                ;
                // FK is on dsName
                var ds = isc.DS.get(dsName),
                    field = ds.getField(fieldName),
                    // foreignKey = field.foreignKey,
                    targetDSName = isc.DS.getForeignDSName(field, dsName)
                ;

                var fkFields = ds.getForeignKeyFields();
                if (isc.getValues(fkFields).filter(function (f) {
                    return (isc.DS.getForeignDSName(f, currentDSName) == targetDSName);
                }).length > 1) {
                    // Ambiguous field
                    path.add(dsName + "[" + fieldName + "]");
                } else {
                    // Unambiguous field
                    path.add(dsName);
                }

                currentDSName = dsName;
            } else {
                // segment is a foreignKey field on the source DS
                var ds = currentDS,
                    field = ds.getField(segment),
                    foreignKey = field.foreignKey,
                    targetDSName = (foreignKey ? isc.DS.getForeignDSName(field, currentDSName) : currentDSName)
                ;

                var fkFields = ds.getForeignKeyFields();
                if (isc.getValues(fkFields).filter(function (f) {
                    return (isc.DS.getForeignDSName(f, currentDSName) == targetDSName);
                }).length > 1) {
                    // Ambiguous field
                    path.add(targetDSName + "[" + segment + "]");
                } else {
                    // Unambiguous field
                    path.add(targetDSName);
                }

                currentDSName = targetDSName;
            }
        }
        return path.join("/");
    }
});

isc.SubqueryDataSourceDS.addProperties({
    clientOnly: true,

    dataProtocol: "clientCustom",
    titleField: "title",

    //> @attr SubqueryDataSourceDS.rootDS (String : null : IR)
    // DataSource ID of the DataSource to be the root of the tree.
    //<

    //> @attr SubqueryDataSourceDS.separateIndirectRecords (Boolean : true : IR)
    // Should indirect records be shown separately from the direct records? When
    // <code>true</code>, direct records are listed first followed by a separator
    // record and then the indirect records.
    // <p>
    // Note: indirect records are any that are related by a foreignKey in the
    // related DataSource.
    //<
    separateIndirectRecords: true,

    //> @attr SubqueryDataSourceDS.canSelectIndirectRecord (Boolean : false : IR)
    // Can indirect records be selected?
    //<
    canSelectIndirectRecord: false,

    //> @attr SubqueryDataSourceDS.showForeignKeyTitle (Boolean : true : IR)
    // When a foreign key is shown with the DataSource ID because either there
    // are multiple foreignKeys to the same DataSource or +link{alwaysShowForeignKey}
    // is enabled, should the field title or an auto-created one be shown? Otherwise
    // the field name is shown.
    //<
    showForeignKeyTitle: true,

    //> @attr SubqueryDataSourceDS.alwaysShowForeignKey (Boolean : null : IR)
    // Should each DataSource record always show its foreignKey? If not set,
    // only relations where multiple foreignKeys point to the same DataSource
    // will include the foreignKey to disambiguate the relations.
    //<

    init : function () {
        this.Super("init", arguments);

        this.rootNode = {
            id: this.rootDS,
            title: this.rootDS
        };
    },

    transformRequest : function (dsRequest) {
        if (dsRequest.operationType !== "fetch") return;

        var dsResponse = {
            data: this.getChildNodes(dsRequest.data)
        };

        this.processResponse(dsRequest.requestId, dsResponse);
    },

    getChildNodes : function (criteria) {
        var criteriaValues = this.splitCriteria(criteria, ["id", "parentId"]),
            id = criteriaValues.id,
            parentId = criteriaValues.parentId
        ;
        if (id && id.indexOf("/") >= 0) {
            // Fetch of a single node - typically for mapping an id for display
            var parts = id.split("/");
            parentId = parts.slice(0, parts.length - 1).join("/");
            var node = this.getChildNodes({ parentId: parentId }).find("id", id);
            return [node];
        } else if (!parentId || parentId == "") {
            return [this.rootNode];
        }

        var parentDS = this.getLastDataSourceFromPath(parentId),
            allDataSourceNames = isc.DS.getRegisteredDataSources(),
            allDataSources = allDataSourceNames.map(function (dsName) {
                return isc.DS.get(dsName);
            })
                .filter(function (ds) {
                    return ds != null &&
                        !ds.componentSchema &&
                        !ds.builtinSchema &&
                        ds.addGlobalId != false &&
                        !ds._internal &&
                        !ds._autoAssignedID;
                }),
            dsRelations = isc.DSRelations.create({
                dataSources: allDataSources
            })
        ;

        if (!parentDS) {
            // Parent DataSource is not loaded so no children can be derived
            return [];
        }

        // Get relation details for DataSources related to the selected DataSource
        var parentRelations = dsRelations.getRelationsForDataSource(parentDS.getID()),
            directRecords = this.getDirectAggregates(parentId, parentRelations, dsRelations),
            indirectRecords = this.getIndirectAggregates(parentId, parentRelations, dsRelations),
            nodes = []
        ;

        nodes.addList(directRecords);

        if (indirectRecords && indirectRecords.length > 0) {
            if (this.separateIndirectRecords) {
                nodes.add({
                    parentId: parentId,
                    id: parentId + "/_indAgg_",
                    title: "= Indirect Aggregation =",
                    enabled: false,
                    isFolder: false
                });
            }
            nodes.addList(indirectRecords);

            // If not showing indirect records separately, sort them in with the other nodes
            if (!this.separateIndirectRecords) {
                nodes = nodes.sortByProperty("title", true);
            }
        }

        return nodes;
    },

    getLastDataSourceFromPath : function (path) {
        var pathParts = path.split("/"),
            lastElement = pathParts[pathParts.length-1],
            dataSourceName = lastElement.substring(0, (lastElement.indexOf("[") >= 0 ? lastElement.indexOf("[") : lastElement.length))
        ;
        return (dataSourceName ? isc.DS.get(dataSourceName) : null);
    },

    getLastFKFieldFromPath : function (path) {
        var pathParts = path.split("/"),
            lastElement = pathParts[pathParts.length-1],
            regexp = new RegExp("\\[(\\w+)(?:,(\\w+))?\\]"),
            match = regexp.exec(lastElement)
        ;
        return (match ? match[1] : null);
    },

    getDirectAggregates : function (parentPath, parentRelations, dsRelations) {
        var fkFieldName = null, //this.getLastFKFieldFromPath(parentPath),
            parentDS = this.getLastDataSourceFromPath(parentPath),
            showForeignKeyTitle = this.showForeignKeyTitle,
            alwaysShowForeignKey = this.alwaysShowForeignKey,
            seenMap = { /* dsId -> count */ }
        ;

        return parentRelations.filter(function(relation) {
            return relation.type == "1-M" &&
                (!fkFieldName || relation.fieldName == fkFieldName);
        })
            .map(function(relation) {
                var dsId = relation.dsId;
                seenMap[dsId] = (seenMap[dsId] || 0) + 1;
                return relation;
            })
            .map(function(relation) {
                var childRelations = dsRelations.getRelationsForDataSource(relation.dsId),
                    hasChildren = (childRelations.length > 0),
                    usedCount = seenMap[relation.dsId],
                    isAmbiguousDS = (usedCount > 1),
                    showPKTitle = isAmbiguousDS || alwaysShowForeignKey,
                    pkTitle = (showForeignKeyTitle ?
                        relation.fieldTitle || isc.DS.getAutoTitle(relation.fieldName) :
                        relation.fieldName),
                    path = parentPath + "/" + relation.dsId + (isAmbiguousDS ? "[" + relation.fieldName + "]" : "")
                ;

                return {
                    parentId: parentPath,
                    id: path,
                    title: relation.dsId + (showPKTitle ? " [via " + pkTitle + "]" : ""),
                    queryFK: isc.SubqueryDataSourceDS.getPathQueryFK(path),
                    isFolder: hasChildren
                }
            })
            .sortByProperty("title", true);
    },

    getIndirectAggregates : function (parentPath, parentRelations, dsRelations) {
        var fkFieldName = this.getLastFKFieldFromPath(parentPath),
            parentDS = this.getLastDataSourceFromPath(parentPath),
            showForeignKeyTitle = this.showForeignKeyTitle,
            alwaysShowForeignKey = this.alwaysShowForeignKey,
            canSelectIndirectRecord = this.canSelectIndirectRecord,
            seenMap = { /* dsId -> count */ }
        ;

        return parentRelations.filter(function(relation) {
            return relation.type != "1-M";
        })
            .map(function(relation) {
                var dsId = relation.dsId;
                seenMap[dsId] = (seenMap[dsId] || 0) + 1;
                return relation;
            })
            .map(function(relation) {
                var childRelations = dsRelations.getRelationsForDataSource(relation.dsId),
                    hasChildren = (childRelations.length > 0),
                    usedCount = seenMap[relation.dsId],
                    isAmbiguousDS = (usedCount > 1),
                    showPKTitle = isAmbiguousDS || relation.type == "Self" || alwaysShowForeignKey,
                    pkTitle = (showForeignKeyTitle ?
                        relation.fieldTitle || isc.DS.getAutoTitle(relation.fieldName) :
                        relation.fieldName),
                    path = parentPath + "/" + relation.dsId +
                        (isAmbiguousDS ? "[" + relation.fieldName + "," + parentDS.getPrimaryKeyFieldName() + "]" : "")
                ;

                return {
                    parentId: parentPath,
                    id: path,
                    title: relation.dsId + (showPKTitle ? " [" + pkTitle + "]" : ""),
                    queryFK: isc.SubqueryDataSourceDS.getPathQueryFK(path),
                    canSelect: canSelectIndirectRecord,
                    isFolder: hasChildren
                } })
            .sortByProperty("title", true);
    }
});

isc.defineClass("SubqueryDataSourceItem", "ComboBoxItem");
isc.SubqueryDataSourceItem.addProperties({
    valueField: "id",
    displayField: "title",
    dataSetType: "tree",
    pickListWidth: 350,
    pickListProperties: {
        autoFitFieldWidths: true,
        autoFetchData: true,
        loadDataOnDemand: true,
        showNodeIcons: false,
        rowClick : function (record, recordNum, fieldNum) {
            if (recordNum < 0 || fieldNum < 0) return false; // not in body

            var node = this.getRecord(recordNum),
                isFolder = this.data.isFolder(node);
            if (isFolder && node.canSelect === false) {
                this.openFolder(node);
                return;
            }
            return this.Super("rowClick", arguments);
        }
    },

    // Open all children under the root node. Showing just the root node
    // is not very helpful.
    autoOpenTree: "all",

    formatOnBlur: true,
    formatValue : function (value, record, form, item) {
        var relationPath = this.getSelectedQueryFK(),
            relationPathSegments = relationPath && relationPath.split(":")
        ;
        if (relationPathSegments && (relationPathSegments.length > 1 ||
                                        (relationPathSegments.length > 0 && relationPathSegments[0].contains("."))))
        {
            // RelationPath is important
            return value + " (" + relationPath + ")";
        }
        return value;
    },

    selectDSDefaults: {
        _constructor: "SubqueryDataSourceDS"
    },

    setRootDS : function (dsName) {
        if (this.rootDS != dsName) {
            this.rootDS = dsName;

            var ds = this.getOptionDataSource();
            if (ds) ds.destroy();

            if (dsName) {
                var props = {
                    rootDS: dsName
                };
                // Apply configuration overrides
                if (this.separateIndirectRecords != null) props.separateIndirectRecords = this.separateIndirectRecords;
                if (this.showForeignKeyTitle != null) props.showForeignKeyTitle = this.showForeignKeyTitle;
                if (this.alwaysShowForeignKey != null) props.alwaysShowForeignKey = this.alwaysShowForeignKey;
                if (this.canSelectIndirectRecord != null) props.canSelectIndirectRecord = this.canSelectIndirectRecord;

                ds = this.createAutoChild("selectDS", props);
            }
            this.setOptionDataSource(ds);
        }
    },

    getSelectedDataSource : function (value) {
        value = value || this.getValue();
        if (!value) return null;

        var pathParts = value.split("/"),
            lastElement = pathParts[pathParts.length-1]
        ;
        return lastElement.substring(0, (lastElement.indexOf("[") >= 0 ?
            lastElement.indexOf("[") :
            lastElement.length))
    },

    getSelectedQueryFK : function () {
        return isc.SubqueryDataSourceDS.getPathQueryFK(this.getValue());
    }
});

isc.defineClass("SubqueryDataSourcePicker", "DynamicForm");
isc.SubqueryDataSourcePicker.addProperties({
    dsPickerFieldDefaults: {
        name: "dsPicker",
        type: "SubqueryDataSourceItem",
        title: "DataSource",
        required: true,
        addUnknownValues: true,
        width: 400,
        changed: function (form, item, value) {
            var dsName = item.getSelectedDataSource(),
                queryFK = item.getSelectedQueryFK()
            ;
            form.setValue("dsName", dsName);
            form.setValue("queryFK", queryFK);
            form.getItem("dsName").handleChanged(dsName);

            if (form.dsNameChanged) {
                form.dsNameChanged(dsName, queryFK);
            }
        }
    },

    dsNameFieldDefaults: {
        name: "dsName",
        hidden: true
    },

    initWidget : function () {
        var dsPickerValueMap = (this.dataSources || []);
        var dsPickerField = isc.addProperties({}, this.dsPickerFieldDefaults,
            this.dsPickerFieldProperties, {
            valueMap: dsPickerValueMap,
            separateIndirectRecords: this.separateIndirectRecords,
            showForeignKeyTitle: this.showForeignKeyTitle,
            alwaysShowForeignKey: this.alwaysShowForeignKey,
            canSelectIndirectRecord: this.canSelectIndirectRecord
        });
        var dsNameField = isc.addProperties({}, this.dsNameFieldDefaults, this.dsNameFieldProperties);
        this.fields = [dsPickerField, dsNameField];

        this.Super("initWidget", arguments);
    },

    setValues : function (newData) {
        var dsPickerValue;

        var baseDSName = newData.baseDSName;
        if (!this.baseDSName || (baseDSName && this.baseDSName != baseDSName)) {
            var dsPickerField = this.getField("dsPicker");
            dsPickerField.setRootDS(baseDSName);
        }

        // If setting actual data it should have the following fields:
        //      dsName
        //      queryFK (optional)
        //
        // Create internal dataSource path for the ComboBox (dsPicker)
        if (newData && baseDSName) {
            var dsName = newData.dsName || baseDSName,
                queryFK = newData.queryFK
            ;
            if (baseDSName && queryFK) {
                // Expand dsName using queryFK into an actual path for selection
                dsPickerValue = isc.SubqueryDataSourceDS.getQueryFKPath(baseDSName, queryFK);
            } else if (this.showAggregationLayout != false) {
                // Only applicable to aggregation query, not a related criteria.
                // Expand simple dsName to a default path if related
                if (dsName != baseDSName && dsName.indexOf("/") == -1) {
                    // current value is a single DS name but doesn't match our root
                    var rootDS = isc.DS.get(baseDSName),
                        targetDS = isc.DS.get(dsName)
                    ;
                    if (targetDS) {
                        var relationPath = rootDS.getDefaultPathToRelation(targetDS);
                        if (relationPath && relationPath.path) {
                            dsPickerValue = [baseDSName, relationPath.path].join("/");
                        }
                    }
                } else {
                    dsPickerValue = baseDSName;
                }
            }
        }
        if (dsPickerValue != null) {
            var clonedData = {};
            isc.DynamicForm._duplicateValues(this, newData, clonedData);
            clonedData.dsPicker = dsPickerValue;
            arguments[0] = clonedData;
        }

        this.Super("setValues", arguments);
    }
});

} // End of if (isc.DynamicForm)
