/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;

import com.smartgwt.logicalstructure.core.*;
import com.smartgwt.logicalstructure.widgets.*;
import com.smartgwt.logicalstructure.widgets.drawing.*;
import com.smartgwt.logicalstructure.widgets.plugins.*;
import com.smartgwt.logicalstructure.widgets.form.*;
import com.smartgwt.logicalstructure.widgets.tile.*;
import com.smartgwt.logicalstructure.widgets.grid.*;
import com.smartgwt.logicalstructure.widgets.chart.*;
import com.smartgwt.logicalstructure.widgets.layout.*;
import com.smartgwt.logicalstructure.widgets.menu.*;
import com.smartgwt.logicalstructure.widgets.rte.*;
import com.smartgwt.logicalstructure.widgets.ace.*;
import com.smartgwt.logicalstructure.widgets.tab.*;
import com.smartgwt.logicalstructure.widgets.tableview.*;
import com.smartgwt.logicalstructure.widgets.toolbar.*;
import com.smartgwt.logicalstructure.widgets.tree.*;
import com.smartgwt.logicalstructure.widgets.viewer.*;
import com.smartgwt.logicalstructure.widgets.calendar.*;
import com.smartgwt.logicalstructure.widgets.cube.*;
import com.smartgwt.logicalstructure.widgets.tools.*;
import com.smartgwt.logicalstructure.widgets.tour.*;
import com.smartgwt.logicalstructure.widgets.ai.*;

/**
 * Subclass of {@link com.smartgwt.client.widgets.HTMLFlow} configured to display HTML content in a pane of specified size.
 * If the HTML content is larger than the size of the pane, the pane will provide scrollbars for viewing clipped content.
 * <P> HTML content can be specified directly via {@link com.smartgwt.client.widgets.HTMLPane#getContents contents}, or
 * loaded from a  URL via the property {@link com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL}.  This
 * method of loading is for simple HTML content only; Smart GWT components should be loaded via the {@link
 * com.smartgwt.client.widgets.ViewLoader} class. <P> HTMLPanes have the ability to render snippets of HTML directly in the
 * document,  or use an IFRAME to render a complete HTML page. See {@link
 * com.smartgwt.client.widgets.HTMLPane#getContentsType contentsType} for more information <P> You can set the size of an
 * HTMLPane directly via the width and height properties, or indirectly by placing the HTMLPane in a container component
 * ({@link com.smartgwt.client.widgets.layout.Layout}, {@link com.smartgwt.client.widgets.Window},  {@link
 * com.smartgwt.client.widgets.layout.SectionStack}, etc) that manages the sizes of its members.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("HTMLPane")
public class HTMLPane extends HTMLFlow {

    public static HTMLPane getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;
        final BaseWidget refInstance = BaseWidget.getRef(jsObj);
        if (refInstance == null) {
            return new HTMLPane(jsObj);
        } else {
            assert refInstance instanceof HTMLPane;
            return (HTMLPane)refInstance;
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(HTMLPane.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.HTMLPane.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(HTMLPane.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.HTMLPane.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public HTMLPane(){
        scClassName = "HTMLPane";
    }

    public HTMLPane(JavaScriptObject jsObj){
        scClassName = "HTMLPane";
        setJavaScriptObject(jsObj);
    }

    protected native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        var scClassName = this.@com.smartgwt.client.widgets.BaseWidget::scClassName;
        var widget = $wnd.isc[scClassName].create(config);
        if ($wnd.isc.keepGlobals) this.@com.smartgwt.client.widgets.BaseWidget::internalSetID(Lcom/google/gwt/core/client/JavaScriptObject;)(widget);
        this.@com.smartgwt.client.widgets.BaseWidget::doInit()();
        return widget;
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * If {@link com.smartgwt.client.types.ContentsType} is not explicitly specified, should it be automatically derived? <P>
     * If set to true, this component will use {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} to
     * determine whether the contents are a standalone HTML page which should be rendered into an embedded IFRAME rather than
     * written directly into the component's handle in the DOM. <P> Note that this property will auto derive the appropriate
     * contents type for both  explicitly specified {@link com.smartgwt.client.widgets.HTMLPane#getContents contents} and for
     * HTML loaded from the {@link com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL} <P> See {@link
     * com.smartgwt.client.types.ContentsType} for further information on displaying complete HTML pages in an IFRAME.
     *
     * @param autoDeriveContentsType New autoDeriveContentsType value. Default value is false
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     */
    public HTMLPane setAutoDeriveContentsType(boolean autoDeriveContentsType) {
        return (HTMLPane)setAttribute("autoDeriveContentsType", autoDeriveContentsType, true);
    }

    /**
     * If {@link com.smartgwt.client.types.ContentsType} is not explicitly specified, should it be automatically derived? <P>
     * If set to true, this component will use {@link com.smartgwt.client.widgets.HTMLFlow#isPageHTML isPageHTML()} to
     * determine whether the contents are a standalone HTML page which should be rendered into an embedded IFRAME rather than
     * written directly into the component's handle in the DOM. <P> Note that this property will auto derive the appropriate
     * contents type for both  explicitly specified {@link com.smartgwt.client.widgets.HTMLPane#getContents contents} and for
     * HTML loaded from the {@link com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL} <P> See {@link
     * com.smartgwt.client.types.ContentsType} for further information on displaying complete HTML pages in an IFRAME.
     *
     * @return Current autoDeriveContentsType value. Default value is false
     */
    public boolean getAutoDeriveContentsType()  {
        Boolean result = getAttributeAsBoolean("autoDeriveContentsType");
        return result == null ? false : result;
    }
    

    /**
     * String of HTML contents for this component - may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType HTMLFlow.contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage HTMLFlow.supportsContentsAsPage}. <P> To load HTML
     * contents from a URL, use {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL HTMLFlow.contentsURL} instead of
     * this property. If <code>contentsURL</code> is non-null, <code>contents</code> will be ignored.
     *
     * @param contents New contents value. Default value is "&amp;nbsp;"
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.HTMLFlow#setContentsURL
     * @see com.smartgwt.client.widgets.HTMLFlow#setDynamicContents
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public HTMLPane setContents(String contents) {
        return (HTMLPane)setAttribute("contents", contents, true);
    }

    /**
     * String of HTML contents for this component - may be a fragment of HTML to display or a complete HTML page. See {@link
     * com.smartgwt.client.widgets.HTMLFlow#getContentsType HTMLFlow.contentsType} and {@link
     * com.smartgwt.client.widgets.HTMLFlow#getSupportsContentsAsPage HTMLFlow.supportsContentsAsPage}. <P> To load HTML
     * contents from a URL, use {@link com.smartgwt.client.widgets.HTMLFlow#getContentsURL HTMLFlow.contentsURL} instead of
     * this property. If <code>contentsURL</code> is non-null, <code>contents</code> will be ignored.
     *
     * @return Current contents value. Default value is "&amp;nbsp;"
     * @see com.smartgwt.client.widgets.HTMLFlow#getContentsURL
     * @see com.smartgwt.client.widgets.HTMLFlow#getDynamicContents
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getContents()  {
        return getAttributeAsString("contents");
    }
    

    /**
     * The <code>contentsType</code> attribute governs whether the contents  of this htmlFlow are a fragment of HTML to
     * inserted directly into the DOM,  or a complete HTML page to be displayed in an IFRAME. If not explicitly specified,
     * {@link com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} may be set to
     * automatically determine the appropriate contents type by analyzing the contents of the component. If
     * <code>autoDeriveContentsType</code> is false and <code>contentsType</code> is not explicitly specified, contents will
     * always be assumed to be <code>"fragment"</code>. <P> HTMLFlow contents may be {@link
     * com.smartgwt.client.widgets.HTMLPane#getContents directly specified} or loaded from a  {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL specified URL}. Note that if {@link
     * com.smartgwt.client.widgets.HTMLPane#getSupportsContentsAsPage supportsContentsAsPage} is  false and no {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL} is specified, the contents string will always be
     * assumed to be a fragment, even if {@link com.smartgwt.client.types.ContentsType} is explicitly set to
     * <code>"page"</code>. <P> Note that an HTMLFlow with contentsType:"page" should not be used to  load and display a page
     * containing a set of Smart GWT components into the application. To dynamically load Smart GWT components, use {@link
     * com.smartgwt.client.widgets.ViewLoader}, <b>never</b> this mechanism (click {@link com.smartgwt.client.docs.NoFrames
     * here} for why). <P> <b>Scripting, CSS and scoping considerations for HTMLFlow contents</b><br> The following
     * considerations apply to HTMLFlow contents, whether directly specified or loaded from a contentsURL. <P> When
     * contentsType is <code>"page"</code>, the HTML content will be rendered as  a standalone document using an IFRAME. Use
     * {@link com.smartgwt.client.widgets.HTMLFlow#getIframeSandbox iframeSandbox} to specify  IFRAME restrictions using the
     * native <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox' target='_blank'>sandbox
     * attribute</a>. Note that any script (if allowed) will be executed in the scope of the embedded IFRAME window, not the
     * main application window. Similarly, other features like css stylesheets loaded by the HTMLFlow will apply to the IFRAME
     * window only, and the IFRAME will not pick up css style from the main application by default. <P> When contentsType is
     * <code>"fragment"</code>, if script is encountered within the HTML  fragment it will be evaluated in the scope of the
     * main application if {@link com.smartgwt.client.widgets.HTMLFlow#getEvalScriptBlocks evalScriptBlocks} is enabled.
     * Developers should be aware that this evaluation occurs as part of the draw/redraw process, but unlike script embedded
     * directly in a static HTML page, it is not processed by the browser while the elements are being written into the DOM and
     * <code>document.write(...)</code> can not be used to modify the HTML as it is being rendered. In this mode, since the
     * contents is written directly into the DOM, standard css styling  for the page will be applied. <P> Note that if {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} is enabled, the default set of
     * recognized {@link com.smartgwt.client.widgets.HTMLFlow#getStructuralHTMLTags structuralHTMLTags} include
     * <code>&lt;script&gt</code>, so HTML contents  including script will display as <code>contentsType:"page"</code>. The
     * list of <code>structuralHTMLTags</code> can be modified to exclude script tags if desired.
     *
     * @param contentsType New contentsType value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     */
    public HTMLPane setContentsType(ContentsType contentsType) {
        return (HTMLPane)setAttribute("contentsType", contentsType == null ? null : contentsType.getValue(), true);
    }

    /**
     * The <code>contentsType</code> attribute governs whether the contents  of this htmlFlow are a fragment of HTML to
     * inserted directly into the DOM,  or a complete HTML page to be displayed in an IFRAME. If not explicitly specified,
     * {@link com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} may be set to
     * automatically determine the appropriate contents type by analyzing the contents of the component. If
     * <code>autoDeriveContentsType</code> is false and <code>contentsType</code> is not explicitly specified, contents will
     * always be assumed to be <code>"fragment"</code>. <P> HTMLFlow contents may be {@link
     * com.smartgwt.client.widgets.HTMLPane#getContents directly specified} or loaded from a  {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL specified URL}. Note that if {@link
     * com.smartgwt.client.widgets.HTMLPane#getSupportsContentsAsPage supportsContentsAsPage} is  false and no {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL} is specified, the contents string will always be
     * assumed to be a fragment, even if {@link com.smartgwt.client.types.ContentsType} is explicitly set to
     * <code>"page"</code>. <P> Note that an HTMLFlow with contentsType:"page" should not be used to  load and display a page
     * containing a set of Smart GWT components into the application. To dynamically load Smart GWT components, use {@link
     * com.smartgwt.client.widgets.ViewLoader}, <b>never</b> this mechanism (click {@link com.smartgwt.client.docs.NoFrames
     * here} for why). <P> <b>Scripting, CSS and scoping considerations for HTMLFlow contents</b><br> The following
     * considerations apply to HTMLFlow contents, whether directly specified or loaded from a contentsURL. <P> When
     * contentsType is <code>"page"</code>, the HTML content will be rendered as  a standalone document using an IFRAME. Use
     * {@link com.smartgwt.client.widgets.HTMLFlow#getIframeSandbox iframeSandbox} to specify  IFRAME restrictions using the
     * native <a href='https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox' target='_blank'>sandbox
     * attribute</a>. Note that any script (if allowed) will be executed in the scope of the embedded IFRAME window, not the
     * main application window. Similarly, other features like css stylesheets loaded by the HTMLFlow will apply to the IFRAME
     * window only, and the IFRAME will not pick up css style from the main application by default. <P> When contentsType is
     * <code>"fragment"</code>, if script is encountered within the HTML  fragment it will be evaluated in the scope of the
     * main application if {@link com.smartgwt.client.widgets.HTMLFlow#getEvalScriptBlocks evalScriptBlocks} is enabled.
     * Developers should be aware that this evaluation occurs as part of the draw/redraw process, but unlike script embedded
     * directly in a static HTML page, it is not processed by the browser while the elements are being written into the DOM and
     * <code>document.write(...)</code> can not be used to modify the HTML as it is being rendered. In this mode, since the
     * contents is written directly into the DOM, standard css styling  for the page will be applied. <P> Note that if {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} is enabled, the default set of
     * recognized {@link com.smartgwt.client.widgets.HTMLFlow#getStructuralHTMLTags structuralHTMLTags} include
     * <code>&lt;script&gt</code>, so HTML contents  including script will display as <code>contentsType:"page"</code>. The
     * list of <code>structuralHTMLTags</code> can be modified to exclude script tags if desired.
     *
     * @return Current contentsType value. Default value is null
     */
    public ContentsType getContentsType()  {
        return EnumUtil.getEnum(ContentsType.values(), getAttribute("contentsType"));
    }
    

    /**
     * If specified the HTMLFlow will load its contents from this URL instead of displaying {@link
     * com.smartgwt.client.widgets.HTMLPane#getContents this.contents}. May be combined with parameters if {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURLParams contentsURLParams} were specified. <P> The HTML retrieved from
     * the target URL may be a complete standalone page to be rendered into its own scope using an IFRAME, or a fragment of
     * HTML  to display within this component's handle. See {@link com.smartgwt.client.types.ContentsType} and {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} for more information. <P> Note
     * that the link{loadingMessage} and {@link com.smartgwt.client.widgets.HTMLFlow#getHttpMethod httpMethod} features only
     * apply if contentsURL was set and  contentsType was not explicitly set to  <code>"page"</code>
     *
     * @param contentsURL New contentsURL value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.URL URL 
     */
    public HTMLPane setContentsURL(String contentsURL) {
        return (HTMLPane)setAttribute("contentsURL", contentsURL, true);
    }

    /**
     * If specified the HTMLFlow will load its contents from this URL instead of displaying {@link
     * com.smartgwt.client.widgets.HTMLPane#getContents this.contents}. May be combined with parameters if {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURLParams contentsURLParams} were specified. <P> The HTML retrieved from
     * the target URL may be a complete standalone page to be rendered into its own scope using an IFRAME, or a fragment of
     * HTML  to display within this component's handle. See {@link com.smartgwt.client.types.ContentsType} and {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType autoDeriveContentsType} for more information. <P> Note
     * that the link{loadingMessage} and {@link com.smartgwt.client.widgets.HTMLFlow#getHttpMethod httpMethod} features only
     * apply if contentsURL was set and  contentsType was not explicitly set to  <code>"page"</code>
     *
     * @return Current contentsURL value. Default value is null
     * @see com.smartgwt.client.docs.URL URL 
     */
    public String getContentsURL()  {
        return getAttributeAsString("contentsURL");
    }
    

    /**
     * Parameters to be sent to the contentsURL when fetching content.
     *
     * @param contentsURLParams New contentsURLParams value. Default value is null
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     */
    public HTMLPane setContentsURLParams(Map contentsURLParams) {
        return (HTMLPane)setAttribute("contentsURLParams", contentsURLParams, true);
    }

    /**
     * Parameters to be sent to the contentsURL when fetching content.
     *
     * @return Current contentsURLParams value. Default value is null
     */
    public Map getContentsURLParams()  {
        return getAttributeAsMap("contentsURLParams");
    }
    

    /**
     * Default height for the component. <P> For a component that should potentially be sized automatically by a Layout, set
     * this property rather than {@link com.smartgwt.client.widgets.Canvas#getHeight height} directly, because Layouts regard a
     * height setting as an explicit size that shouldn't be changed.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param defaultHeight New defaultHeight value. Default value is 200
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public HTMLPane setDefaultHeight(int defaultHeight) {
        return (HTMLPane)setAttribute("defaultHeight", defaultHeight, true);
    }

    /**
     * Default height for the component. <P> For a component that should potentially be sized automatically by a Layout, set
     * this property rather than {@link com.smartgwt.client.widgets.Canvas#getHeight height} directly, because Layouts regard a
     * height setting as an explicit size that shouldn't be changed.
     *
     * @return Current defaultHeight value. Default value is 200
     * @see com.smartgwt.client.docs.Sizing Sizing overview and related methods
     */
    public int getDefaultHeight()  {
        return getAttributeAsInt("defaultHeight");
    }
    

    /**
     * HTMLPanes are <code>overflow:"auto"</code> by default. <P> Note that for {@link com.smartgwt.client.types.ContentsType
     * contentsType:"page"}, <code>overflow:"visible"</code> is not supported.
     *
     * @param overflow New overflow value. Default value is Canvas.AUTO
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     */
    public HTMLPane setOverflow(Overflow overflow) {
        return (HTMLPane)setAttribute("overflow", overflow == null ? null : overflow.getValue(), true);
    }

    /**
     * HTMLPanes are <code>overflow:"auto"</code> by default. <P> Note that for {@link com.smartgwt.client.types.ContentsType
     * contentsType:"page"}, <code>overflow:"visible"</code> is not supported.
     *
     * @return Current overflow value. Default value is Canvas.AUTO
     */
    public Overflow getOverflow()  {
        return EnumUtil.getEnum(Overflow.values(), getAttribute("overflow"));
    }
    

    /**
     * Can this component have its {@link com.smartgwt.client.widgets.HTMLPane#getContents contents} specified as a complete
     * standalone HTML page to be rendered into an embedded IFRAME? <P> If true, if {@link
     * com.smartgwt.client.types.ContentsType} is specified as, or {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType derived to be} "page", the contents will be rendered into
     * an embedded IFRAME using the <code>srcdoc</code> attribute rather than written directly into the component handle. <P>
     * If false, contentsType has no effect unless contents are being loaded from an explicitly specified {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL}
     *
     * @param supportsContentsAsPage New supportsContentsAsPage value. Default value is true
     * @return {@link com.smartgwt.client.widgets.HTMLPane HTMLPane} instance, for chaining setter calls
     */
    public HTMLPane setSupportsContentsAsPage(boolean supportsContentsAsPage) {
        return (HTMLPane)setAttribute("supportsContentsAsPage", supportsContentsAsPage, true);
    }

    /**
     * Can this component have its {@link com.smartgwt.client.widgets.HTMLPane#getContents contents} specified as a complete
     * standalone HTML page to be rendered into an embedded IFRAME? <P> If true, if {@link
     * com.smartgwt.client.types.ContentsType} is specified as, or {@link
     * com.smartgwt.client.widgets.HTMLPane#getAutoDeriveContentsType derived to be} "page", the contents will be rendered into
     * an embedded IFRAME using the <code>srcdoc</code> attribute rather than written directly into the component handle. <P>
     * If false, contentsType has no effect unless contents are being loaded from an explicitly specified {@link
     * com.smartgwt.client.widgets.HTMLPane#getContentsURL contentsURL}
     *
     * @return Current supportsContentsAsPage value. Default value is true
     */
    public boolean getSupportsContentsAsPage()  {
        Boolean result = getAttributeAsBoolean("supportsContentsAsPage");
        return result == null ? true : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties set on the SmartGWT class instance passed to this function before its
     * underlying SmartClient JS object was created.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param hTMLPaneProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(HTMLPane hTMLPaneProperties) /*-{
        if (hTMLPaneProperties.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(HTMLPane.@java.lang.Object::getClass()(), "setDefaultProperties", hTMLPaneProperties.@java.lang.Object::getClass()());
        }
        hTMLPaneProperties.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
    	var properties = hTMLPaneProperties.@com.smartgwt.client.widgets.BaseWidget::getConfig()();
        properties = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(properties,true);
        $wnd.isc.HTMLPane.addProperties(properties);
    }-*/;

    // ***********************************************************


    /**
     * Sets the {@link com.smartgwt.client.widgets.HTMLFlow#setContentsURL contentsURL} of this
     * HTMLPane to the supplied url, and the 
     * {@link com.smartgwt.client.widgets.HTMLFlow#setContentsType contentsType} to 
     * {@link com.smartgwt.client.types.ContentsType#PAGE}, provided the HTMLPane hasn't been
     * {@link com.smartgwt.client.Widgets.BaseWidget#isDrawn drawn}.  Throws an AssertionError
     * RuntimeException in GWT Classic DevMode if the HTMLPane has already been drawn.
     *
     * @param url the IFrame url
     */
    public void setIFrameURL(String url) {
        setContentsURL(url);
        if(!isDrawn()) {
            setContentsType(ContentsType.PAGE);
        } else {
            assert getContentsType() == ContentsType.PAGE : "This method cannot be called " +
                "on a HTMLPane that has a contentsType other than PAGE";
        }
    }

    /**
     * Setter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject setLogicalStructure(HTMLPaneLogicalStructure s) {
        super.setLogicalStructure(s);
        try {
            s.autoDeriveContentsType = getAttributeAsString("autoDeriveContentsType");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.autoDeriveContentsType:" + t.getMessage() + "\n";
        }
        try {
            s.contents = getAttributeAsString("contents");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.contents:" + t.getMessage() + "\n";
        }
        try {
            s.contentsType = getAttributeAsString("contentsType");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.contentsType:" + t.getMessage() + "\n";
        }
        try {
            s.contentsURL = getAttributeAsString("contentsURL");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.contentsURL:" + t.getMessage() + "\n";
        }
        try {
            s.contentsURLParams = getAttributeAsString("contentsURLParams");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.contentsURLParams:" + t.getMessage() + "\n";
        }
        try {
            s.defaultHeight = getAttributeAsString("defaultHeight");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.defaultHeight:" + t.getMessage() + "\n";
        }
        try {
            s.overflow = getAttributeAsString("overflow");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.overflow:" + t.getMessage() + "\n";
        }
        try {
            s.supportsContentsAsPage = getAttributeAsString("supportsContentsAsPage");
        } catch (Throwable t) {
            s.logicalStructureErrors += "HTMLPane.supportsContentsAsPage:" + t.getMessage() + "\n";
        }
        return s;
    }

    /**
     * Getter implementing the {@link com.smartgwt.client.core.LogicalStructure} interface,
     * which supports Eclipse's logical structure debugging facility.
     */
    public LogicalStructureObject getLogicalStructure() {
        HTMLPaneLogicalStructure s = new HTMLPaneLogicalStructure();
        setLogicalStructure(s);
        return s;
    }
}
