package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * You can use whatever cursors are valid for your deployment platforms, but keep in mind that visual representation may
 * vary by browser and OS. See the <a href='https://developer.mozilla.org/en-US/docs/Web/CSS/cursor' target='_blank'>MDN
 * <code>cursor</code> page</a> for a live demonstration.
 */
public enum Cursor implements ValueEnum {
    /**
     * Use the default arrow cursor for this browser/OS.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "default".
     */
    DEFAULT("default"),
    /**
     * Use the default cursor for this element type in this browser/OS
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "auto".
     */
    AUTO("auto"),
    /**
     * Use the wait cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "wait".
     */
    WAIT("wait"),
    /**
     * Use the hand cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "hand".
     */
    HAND("hand"),
    /**
     * Use the "move" (crosshairs) cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "move".
     */
    MOVE("move"),
    /**
     * Use the 'help' cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "help".
     */
    HELP("help"),
    /**
     * Use the 'text' (i-beam) cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "text".
     */
    TEXT("text"),
    /**
     * Use the normal hand pointer that appears when you hover over a link
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "pointer".
     */
    POINTER("pointer"),
    ARROW("arrow"),
    ALL_SCROLL("all-scroll"),
    /**
     * Use the 'crosshair' ( + ) cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "crosshair".
     */
    CROSSHAIR("crosshair"),
    /**
     * Use the column resize cursor (horizontal double-tipped arrow)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "col-resize".
     */
    COL_RESIZE("col-resize"),
    /**
     * Use the row resize cursor (vertical double-tipped arrow)
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "row-resize".
     */
    ROW_RESIZE("row-resize"),
    /**
     * Use the "east resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "e-resize".
     */
    E_RESIZE("e-resize"),
    /**
     * Use the "west resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "w-resize".
     */
    W_RESIZE("w-resize"),
    /**
     * Use the "north resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "n-resize".
     */
    N_RESIZE("n-resize"),
    /**
     * Use the "south resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "s-resize".
     */
    S_RESIZE("s-resize"),
    /**
     * Use the "south-east resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "se-resize".
     */
    SE_RESIZE("se-resize"),
    /**
     * Use the "north-east resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "ne-resize".
     */
    NE_RESIZE("ne-resize"),
    /**
     * Use the "north-west resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "nw-resize".
     */
    NW_RESIZE("nw-resize"),
    /**
     * Use the "south-west resize" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "sw-resize".
     */
    SW_RESIZE("sw-resize"),
    /**
     * Use the "not-allowed" cursor.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "not-allowed".
     */
    NOT_ALLOWED("not-allowed");
    private String value;

    Cursor(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
