/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SmartClientWebDriver;
import java.time.Duration;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class ScActions {
    private static final int MAX_STABLE_DRAG_PAUSE = 500;
    private long maxDragPauseMillis = 500L;
    private Actions actions;
    private boolean isLegacy;
    private JavascriptExecutor js;
    private Dimension viewportSize;
    private boolean edgeMotion;
    private boolean boundedMotion;

    public ScActions(SmartClientWebDriver driver) {
        this.isLegacy = driver.isLegacy();
        this.actions = new Actions((WebDriver)driver);
        this.js = driver;
    }

    protected void reset() {
        this.viewportSize = null;
    }

    protected void setViewportSize() {
        if (this.viewportSize == null) {
            long width = (Long)this.js.executeScript("return isc.Page.getWidth()", new Object[0]);
            long height = (Long)this.js.executeScript("return isc.Page.getHeight()", new Object[0]);
            this.viewportSize = new Dimension((int)width, (int)height);
        }
    }

    protected void setMaxDragPause(long maxDragPauseMillis) {
        this.maxDragPauseMillis = maxDragPauseMillis;
    }

    protected void bestMotion() {
        this.boundedMotion = false;
    }

    protected void boundedMotion() {
        this.boundedMotion = true;
    }

    protected void bodyMotion() {
        this.edgeMotion = false;
    }

    protected void edgeMotion() {
        this.edgeMotion = true;
    }

    private void moveIfNecessaryTo(WebElement element) {
        if (element != null) {
            this.actions.moveToElement(element);
        }
    }

    private void moveIfNecessaryTo(WebElement element, Point coords) {
        if (element == null) {
            return;
        }
        if (coords == null) {
            this.moveIfNecessaryTo(element);
        } else {
            Point leftTop = element.getLocation();
            int xElementOrigin = leftTop.x;
            int yElementOrigin = leftTop.y;
            if (this.isLegacy) {
                this.actions.moveToElement(element, coords.x - xElementOrigin, coords.y - yElementOrigin);
            } else {
                Dimension size = element.getSize();
                int width = size.width;
                int height = size.height;
                this.setViewportSize();
                if (width + xElementOrigin > this.viewportSize.width) {
                    width = this.viewportSize.width - xElementOrigin;
                }
                if (height + yElementOrigin > this.viewportSize.height) {
                    height = this.viewportSize.height - yElementOrigin;
                }
                yElementOrigin += height / 2;
                if (width % 2 == 1 && (xElementOrigin += width / 2) < coords.x) {
                    ++xElementOrigin;
                }
                if (height % 2 == 1 && yElementOrigin < coords.y) {
                    ++yElementOrigin;
                }
                if (!this.boundedMotion && !this.edgeMotion) {
                    this.actions.moveToElement(element);
                }
                int xOffset = coords.x - xElementOrigin;
                int yOffset = coords.y - yElementOrigin;
                if (this.boundedMotion || this.edgeMotion || yOffset != 0 || xOffset != 0) {
                    this.actions.moveToElement(element, xOffset, yOffset);
                }
            }
        }
    }

    public ScActions sendKeys(WebElement element, CharSequence ... keysToSend) {
        Boolean moveToElement;
        if (element != null && (moveToElement = (Boolean)this.js.executeScript("return isc.EH.lastTarget != isc.AutoTest.locateCanvasFromDOMElement(arguments[0]);", new Object[]{element})).booleanValue()) {
            this.actions.moveToElement(element);
        }
        this.actions.sendKeys(keysToSend);
        return this;
    }

    public ScActions keyDown(WebElement element, Keys keys) {
        this.moveIfNecessaryTo(element);
        this.actions.keyDown((CharSequence)keys);
        return this;
    }

    public ScActions keyUp(WebElement element, Keys keys) {
        this.moveIfNecessaryTo(element);
        this.actions.keyUp((CharSequence)keys);
        return this;
    }

    public ScActions click(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.click();
        return this;
    }

    public ScActions clickAt(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        this.actions.click();
        return this;
    }

    public ScActions doubleClick(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.doubleClick();
        return this;
    }

    public ScActions doubleClickAt(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        this.actions.doubleClick();
        return this;
    }

    public ScActions clickAndHold(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.clickAndHold();
        return this;
    }

    public ScActions clickAndHoldAt(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        this.actions.clickAndHold();
        return this;
    }

    public ScActions release(WebElement element) {
        this.moveIfNecessaryTo(element);
        this.actions.release();
        return this;
    }

    public ScActions releaseAt(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        if (!this.isLegacy && this.maxDragPauseMillis > 0L) {
            this.actions.pause(Duration.ofMillis(Math.min(this.maxDragPauseMillis, 200L)));
        }
        this.actions.release();
        return this;
    }

    public ScActions releaseAt(int xOffset, int yOffset) {
        this.actions.moveByOffset(xOffset, yOffset);
        if (!this.isLegacy && this.maxDragPauseMillis > 0L) {
            int maxOffset = Math.max(Math.abs(xOffset), Math.abs(yOffset));
            this.actions.pause(Duration.ofMillis(Math.min(this.maxDragPauseMillis, (long)(200 + maxOffset))));
        }
        this.actions.release();
        return this;
    }

    public ScActions contextClickAt(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        this.actions.contextClick();
        return this;
    }

    public ScActions moveToElement(WebElement element) {
        this.moveIfNecessaryTo(element);
        return this;
    }

    public ScActions moveToElement(WebElement element, Point coordinates) {
        this.moveIfNecessaryTo(element, coordinates);
        return this;
    }

    public ScActions dragAndDropBy(WebElement source, int xOffset, int yOffset) {
        this.moveIfNecessaryTo(source);
        this.actions.dragAndDropBy(source, xOffset, yOffset);
        return this;
    }

    public ScActions dragAndDropBy(WebElement source, Point coordinates, int xOffset, int yOffset) {
        WebElement rootClip = (WebElement)this.js.executeScript("var canvas = isc.AutoTest.locateCanvasFromDOMElement(arguments[0]);if (canvas) canvas = canvas.getTopLevelCanvas(); return canvas.getClipHandle()", new Object[]{source});
        if (rootClip != null) {
            source = rootClip;
        }
        this.clickAndHoldAt(source, coordinates);
        if (coordinates.x + xOffset < 0) {
            xOffset = -coordinates.x;
        }
        if (coordinates.y + yOffset < 0) {
            yOffset = -coordinates.y;
        }
        this.releaseAt(xOffset, yOffset);
        return this;
    }

    public void perform() {
        this.actions.perform();
    }

    @Deprecated
    public ScActions click(WebElement element, Point coordinates) {
        return this.clickAt(element, coordinates);
    }

    @Deprecated
    public ScActions doubleClick(WebElement element, Point coordinates) {
        return this.doubleClickAt(element, coordinates);
    }

    @Deprecated
    public ScActions clickAndHold(WebElement element, Point coordinates) {
        return this.clickAndHoldAt(element, coordinates);
    }

    @Deprecated
    public ScActions release(WebElement element, Point coordinates) {
        return this.releaseAt(element, coordinates);
    }

    @Deprecated
    public ScActions contextClick(WebElement element, Point coordinates) {
        return this.contextClickAt(element, coordinates);
    }

    @Deprecated
    public ScActions mouseMove(WebElement element) {
        return this.moveToElement(element);
    }

    @Deprecated
    public ScActions dragAndDrop(WebElement source, WebElement target) {
        this.moveIfNecessaryTo(source);
        Dimension size = target.getSize();
        this.actions.clickAndHold(source);
        this.actions.moveToElement(target, size.width - 1, size.height - 1);
        this.actions.release();
        return this;
    }

    @Deprecated
    public ScActions dragEdgeAndDropBy(WebElement webElement, int deltaX, int deltaY, int xOffset, int yOffset) {
        this.moveIfNecessaryTo(webElement);
        this.actions.moveToElement(webElement, deltaX, deltaY);
        this.actions.clickAndHold();
        this.actions.moveByOffset(xOffset, yOffset);
        this.actions.release();
        return this;
    }
}

