/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.data;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Base type representing a field. <p> Field container implementations may extend this type with additional attributes
 * and/or methods. For example, {@link com.smartgwt.client.data.DataSource} uses {@link
 * com.smartgwt.client.data.DataSourceField}, {@link com.smartgwt.client.widgets.DataBoundComponent} uses {@link
 * com.smartgwt.client.data.DBCField}, and {@link com.smartgwt.client.widgets.grid.ListGrid} uses {@link
 * com.smartgwt.client.widgets.grid.ListGridField} (itself an extension of <code>DBCField</code>). <p> In general,
 * <code>Field</code> instances should not be shared with multiple field containers.
 */
@BeanFactory.FrameworkClass
public class Field extends RefDataClass {

    public static Field getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof Field) {
            existingObj.setJsObj(jsObj);
            return (Field)existingObj;
        } else

        {
            return new Field(jsObj);
        }
    }
        


    public Field(){
        
    }

    public Field(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * If set to <code>true</code>, then values for the field are considered editable. If set to <code>false</code>, then
     * values for the field cannot be edited. If <code>null</code>, then the determination is left to the field container.
     *
     * @param canEdit New canEdit value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setCanEdit(Boolean canEdit) {
        return (Field)setAttribute("canEdit", canEdit);
    }

    /**
     * If set to <code>true</code>, then values for the field are considered editable. If set to <code>false</code>, then
     * values for the field cannot be edited. If <code>null</code>, then the determination is left to the field container.
     *
     * @return Current canEdit value. Default value is null
     */
    public Boolean getCanEdit()  {
        return getAttributeAsBoolean("canEdit", true);
    }
    

    /**
     * If set to <code>true</code>, then values for the field are considered exportable. If set to <code>false</code>, then
     * values for the field will not be exported. If <code>null</code>, then the determination is left to the field container.
     *
     * @param canExport New canExport value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setCanExport(Boolean canExport) {
        return (Field)setAttribute("canExport", canExport);
    }

    /**
     * If set to <code>true</code>, then values for the field are considered exportable. If set to <code>false</code>, then
     * values for the field will not be exported. If <code>null</code>, then the determination is left to the field container.
     *
     * @return Current canExport value. Default value is null
     */
    public Boolean getCanExport()  {
        return getAttributeAsBoolean("canExport", true);
    }
    

    /**
     * If set to <code>true</code>, then values for the field will be HTML-escaped.
     *
     * @param escapeHTML New escapeHTML value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setEscapeHTML(Boolean escapeHTML) {
        return (Field)setAttribute("escapeHTML", escapeHTML);
    }

    /**
     * If set to <code>true</code>, then values for the field will be HTML-escaped.
     *
     * @return Current escapeHTML value. Default value is null
     */
    public Boolean getEscapeHTML()  {
        return getAttributeAsBoolean("escapeHTML", true);
    }
    

    /**
     * Optional title HTML to use for the field in exports.
     *
     * @param exportTitle New exportTitle value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Field setExportTitle(String exportTitle) {
        return (Field)setAttribute("exportTitle", exportTitle);
    }

    /**
     * Optional title HTML to use for the field in exports.
     *
     * @return Current exportTitle value. Default value is null
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getExportTitle()  {
        return getAttributeAsString("exportTitle");
    }
    

    /**
     * If set to <code>true</code>, then the field is array-valued.
     *
     * @param multiple New multiple value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setMultiple(Boolean multiple) {
        return (Field)setAttribute("multiple", multiple);
    }

    /**
     * If set to <code>true</code>, then the field is array-valued.
     *
     * @return Current multiple value. Default value is null
     */
    public Boolean getMultiple()  {
        return getAttributeAsBoolean("multiple", true);
    }
    

    /**
     * Name of the field.
     *
     * @param name New name value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public Field setName(String name) {
        return (Field)setAttribute("name", name);
    }

    /**
     * Name of the field.
     *
     * @return Current name value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String getName()  {
        return getAttributeAsString("name");
    }
    

    /**
     * If set to <code>true</code>, indicates that the value for this field (together with the values of any other fields that
     * are also primaryKey:<code>true</code>) uniquely identify a record. <p> Note: the case where multiple fields are primary
     * key fields&mdash;called "composite" or "multipart" keys&mdash;is not recommended by Isomorphic. See {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey DataSourceField.primaryKey} for more information.
     *
     * @param primaryKey New primaryKey value. Default value is false
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setPrimaryKey(boolean primaryKey) {
        return (Field)setAttribute("primaryKey", primaryKey);
    }

    /**
     * If set to <code>true</code>, indicates that the value for this field (together with the values of any other fields that
     * are also primaryKey:<code>true</code>) uniquely identify a record. <p> Note: the case where multiple fields are primary
     * key fields&mdash;called "composite" or "multipart" keys&mdash;is not recommended by Isomorphic. See {@link
     * com.smartgwt.client.data.DataSourceField#getPrimaryKey DataSourceField.primaryKey} for more information.
     *
     * @return Current primaryKey value. Default value is false
     */
    public boolean getPrimaryKey()  {
        Boolean result = getAttributeAsBoolean("primaryKey", true);
        return result == null ? false : result;
    }
    

    /**
     * If set to <code>true</code>, then a value for this field is required to pass validation.
     *
     * @param required New required value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setRequired(Boolean required) {
        return (Field)setAttribute("required", required);
    }
    

    /**
     * If set to a field name, causes the field to be sorted by the values in the specified field, for both client- and
     * server-side sorting.
     *
     * @param sortByField New sortByField value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public Field setSortByField(String sortByField) {
        return (Field)setAttribute("sortByField", sortByField);
    }

    /**
     * If set to a field name, causes the field to be sorted by the values in the specified field, for both client- and
     * server-side sorting.
     *
     * @return Current sortByField value. Default value is null
     * @see com.smartgwt.client.docs.FieldName FieldName 
     */
    public String getSortByField()  {
        return getAttributeAsString("sortByField");
    }
    

    /**
     * An {@link com.smartgwt.client.docs.HTMLString} to use as the displayable title for this field outside the context of a
     * field container. <p> Within a {@link com.smartgwt.client.widgets.DataBoundComponent}: <ul> <li>A field's title may be
     * set with {@link com.smartgwt.client.widgets.DataBoundComponent#setFieldTitle DataBoundComponent.setFieldTitle()}.
     * <li>Always call the {@link com.smartgwt.client.widgets.DataBoundComponent#getFieldTitle
     * DataBoundComponent.getFieldTitle()} method to obtain the field's title. </ul>
     *
     * @param title New title value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     * @see com.smartgwt.client.data.Field#setExportTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public Field setTitle(String title) {
        return (Field)setAttribute("title", title);
    }

    /**
     * An {@link com.smartgwt.client.docs.HTMLString} to use as the displayable title for this field outside the context of a
     * field container. <p> Within a {@link com.smartgwt.client.widgets.DataBoundComponent}: <ul> <li>A field's title may be
     * set with {@link com.smartgwt.client.widgets.DataBoundComponent#setFieldTitle DataBoundComponent.setFieldTitle()}.
     * <li>Always call the {@link com.smartgwt.client.widgets.DataBoundComponent#getFieldTitle
     * DataBoundComponent.getFieldTitle()} method to obtain the field's title. </ul>
     *
     * @return Current title value. Default value is null
     * @see com.smartgwt.client.data.Field#getExportTitle
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getTitle()  {
        return getAttributeAsString("title");
    }
    
    

    /**
     * If set, specifies the set of legal values for the field.
     *
     * @param valueMap New valueMap value. Default value is null
     * @return {@link com.smartgwt.client.data.Field Field} instance, for chaining setter calls
     */
    public Field setValueMap(Map valueMap) {
        return (Field)setAttribute("valueMap", valueMap);
    }

    /**
     * If set, specifies the set of legal values for the field.
     *
     * @return Current valueMap value. Default value is null
     */
    public Map getValueMap()  {
        return getAttributeAsMap("valueMap");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
