/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * An object containing information about the result of an asynchronous operation.
 */
@BeanFactory.FrameworkClass
public class AsyncOperationResult extends RefDataClass {

    public static AsyncOperationResult getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof AsyncOperationResult) {
            existingObj.setJsObj(jsObj);
            return (AsyncOperationResult)existingObj;
        } else

        {
            return new AsyncOperationResult(jsObj);
        }
    }
        


    public AsyncOperationResult(){
        
    }

    public AsyncOperationResult(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * If this is a CANCELED-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement
     * to be displayed to the user of the reason for cancellation.
     *
     * @param cancellationReason New cancellationReason value. Default value is null
     * @return {@link com.smartgwt.client.util.AsyncOperationResult AsyncOperationResult} instance, for chaining setter calls
     * @see com.smartgwt.client.util.CancellationController#cancel
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public AsyncOperationResult setCancellationReason(String cancellationReason) {
        return (AsyncOperationResult)setAttribute("cancellationReason", cancellationReason);
    }

    /**
     * If this is a CANCELED-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement
     * to be displayed to the user of the reason for cancellation.
     *
     * @return Current cancellationReason value. Default value is null
     * @see com.smartgwt.client.util.CancellationController#cancel
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getCancellationReason()  {
        return getAttributeAsString("cancellationReason");
    }
    

    /**
     * If this is a DISABLED-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement
     * to be displayed to the user that the operation was disabled. This may include information about the reason why the
     * operation was disabled. <p> It is recommended to use the past tense, because this message may continue to be displayed
     * to the user when the conditions for the operation being disabled are no longer the case.
     *
     * @param disabledMessage New disabledMessage value. Default value is null
     * @return {@link com.smartgwt.client.util.AsyncOperationResult AsyncOperationResult} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public AsyncOperationResult setDisabledMessage(String disabledMessage) {
        return (AsyncOperationResult)setAttribute("disabledMessage", disabledMessage);
    }

    /**
     * If this is a DISABLED-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement
     * to be displayed to the user that the operation was disabled. This may include information about the reason why the
     * operation was disabled. <p> It is recommended to use the past tense, because this message may continue to be displayed
     * to the user when the conditions for the operation being disabled are no longer the case.
     *
     * @return Current disabledMessage value. Default value is null
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getDisabledMessage()  {
        return getAttributeAsString("disabledMessage");
    }
    

    /**
     * If this is an ERROR-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement to
     * be displayed to the user of the error that occurred.
     *
     * @param errorMessage New errorMessage value. Default value is null
     * @return {@link com.smartgwt.client.util.AsyncOperationResult AsyncOperationResult} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public AsyncOperationResult setErrorMessage(String errorMessage) {
        return (AsyncOperationResult)setAttribute("errorMessage", errorMessage);
    }

    /**
     * If this is an ERROR-{@link com.smartgwt.client.util.AsyncOperationResult#getType type} result, an optional statement to
     * be displayed to the user of the error that occurred.
     *
     * @return Current errorMessage value. Default value is null
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getErrorMessage()  {
        return getAttributeAsString("errorMessage");
    }
    

    /**
     * The result type. <p> <code>null</code> is interpreted as a non-successful result type.
     *
     * @param type New type value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.util.AsyncOperationResult AsyncOperationResult} instance, for chaining setter calls
     */
    public AsyncOperationResult setType(AsyncOperationResultType type) {
        return (AsyncOperationResult)setAttribute("type", type == null ? null : type.getValue());
    }

    /**
     * The result type. <p> <code>null</code> is interpreted as a non-successful result type.
     *
     * @return Current type value. Default value is *initialized by the implementation*
     */
    public AsyncOperationResultType getType()  {
        return EnumUtil.getEnum(AsyncOperationResultType.values(), getAttribute("type"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
