/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.log.Logger;
import java.util.Iterator;

public class StreamingResponseIterator
extends Base
implements Iterator {
    private Logger log = new Logger(this);
    private DSResponse dsResponse;
    private long count = 0L;

    public StreamingResponseIterator(DSResponse dsResponse) {
        this.dsResponse = dsResponse;
    }

    @Override
    public boolean hasNext() {
        return this.dsResponse.hasNextRecord();
    }

    public Object next() {
        try {
            if (++this.count % 10000L == 0L) {
                this.log.debug("Processing record: " + this.count);
            }
            return this.dsResponse.nextRecordAsObject();
        }
        catch (StreamingResponseException sre) {
            this.log.warn((Object)"Error calling nextRecordAsObject, abandoning iteration", sre);
            this.dsResponse._setHasNextRecord(false);
            return null;
        }
    }

    @Override
    public void remove() {
    }
}

