/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.synchronization.work.AbstractAuditWorkUnit;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.envers.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.synchronization.work.DelWorkUnit;
import org.hibernate.envers.synchronization.work.FakeBidirectionalRelationWorkUnit;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.envers.synchronization.work.WorkUnitMergeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionChangeWorkUnit
extends AbstractAuditWorkUnit
implements AuditWorkUnit {
    private final Object entity;

    public CollectionChangeWorkUnit(SessionImplementor session, String entityName, AuditConfiguration verCfg, Serializable id, Object entity) {
        super(session, entityName, verCfg, id, RevisionType.MOD);
        this.entity = entity;
    }

    @Override
    public boolean containsWork() {
        return true;
    }

    @Override
    public Map<String, Object> generateData(Object revisionData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.fillDataWithId(data, revisionData);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapToMapFromEntity(this.sessionImplementor, data, this.entity, null);
        return data;
    }

    @Override
    public AuditWorkUnit merge(AddWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(ModWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(DelWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit merge(CollectionChangeWorkUnit second) {
        return this;
    }

    @Override
    public AuditWorkUnit merge(FakeBidirectionalRelationWorkUnit second) {
        return second;
    }

    @Override
    public AuditWorkUnit dispatch(WorkUnitMergeVisitor first) {
        return first.merge(this);
    }
}

