/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents an Answer Engine operation.
 * @see com.smartgwt.client.docs.AnswerEngine AnswerEngine overview and related methods
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("AnswerEngineOperation")
public class AnswerEngineOperation extends BaseClass {

    public static AnswerEngineOperation getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (AnswerEngineOperation) obj;
        } else {
            return new AnswerEngineOperation(jsObj);
        }
    }

    public void setJavaScriptObject(JavaScriptObject jsObj) {
        internalSetID(jsObj);
        JSOHelper.setObjectAttribute(jsObj, SC.REF, this);
        JSOHelper.setObjectAttribute(jsObj, SC.MODULE, BeanFactory.getSGWTModule());
        if (!JSOHelper.isScClassInstance(jsObj)) {
            setConfig(jsObj);
            return;
        }
        JSOHelper.setObjectAttribute(getConfig(), SC.REF, this);
        JSOHelper.setObjectAttribute(getConfig(), SC.MODULE, BeanFactory.getSGWTModule());
        this.jsObj = jsObj;
        onBind();
    }
        


    public AnswerEngineOperation(){
        scClassName = "AnswerEngineOperation";
    }

    public AnswerEngineOperation(JavaScriptObject jsObj){
        scClassName = "AnswerEngineOperation";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;

    private JavaScriptObject jsObj;
    
    @Override
    public boolean isCreated(){
        return this.jsObj != null;
    }

    @Override
    public JavaScriptObject getJsObj(){
        return this.jsObj;
    }

    @Override
    public JavaScriptObject getOrCreateJsObj() {
        if (!isCreated()) {
            this.jsObj = createJsObj();
            doInit();
        }
        return this.jsObj;
    }


    // ********************* Properties / Attributes ***********************

    /**
     * Whether the result should be automatically shown to the user.
     *
     * @param autoShowResult New autoShowResult value. Default value is false
     * @return {@link com.smartgwt.client.ai.AnswerEngineOperation AnswerEngineOperation} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public AnswerEngineOperation setAutoShowResult(Boolean autoShowResult)  throws IllegalStateException {
        return (AnswerEngineOperation)setAttribute("autoShowResult", autoShowResult, false);
    }

    /**
     * Whether the result should be automatically shown to the user.
     *
     * @return Current autoShowResult value. Default value is false
     */
    public Boolean getAutoShowResult()  {
        Boolean result = getAttributeAsBoolean("autoShowResult");
        return result == null ? false : result;
    }
    

    /**
     * The data question that is the subject of this Answer Engine operation. This is required to be non-<code>null</code>.
     *
     * @param dataQuestion New dataQuestion value. Default value is null
     * @return {@link com.smartgwt.client.ai.AnswerEngineOperation AnswerEngineOperation} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public AnswerEngineOperation setDataQuestion(DataQuestion dataQuestion)  throws IllegalStateException {
        return (AnswerEngineOperation)setAttribute("dataQuestion", dataQuestion == null ? null : dataQuestion.getJsObj(), false);
    }

    /**
     * The data question that is the subject of this Answer Engine operation. This is required to be non-<code>null</code>.
     *
     * @return Current dataQuestion value. Default value is null
     */
    public DataQuestion getDataQuestion()  {
        return new DataQuestion(getAttributeAsJavaScriptObject("dataQuestion"));
    }
    

    /**
     * The array of available data sources.
     *
     * @param dataSources New dataSources value. Default value is null
     * @return {@link com.smartgwt.client.ai.AnswerEngineOperation AnswerEngineOperation} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public AnswerEngineOperation setDataSources(DataSource... dataSources)  throws IllegalStateException {
        return (AnswerEngineOperation)setAttribute("dataSources", dataSources, false);
    }

    /**
     * The array of available data sources.
     *
     * @return Current dataSources value. Default value is null
     */
    public DataSource[] getDataSources()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfDataSource(getAttributeAsJavaScriptObject("dataSources"));
    }
    

    /**
     * The maximum number of records that may be requested per query. Must be a positive integer.
     *
     * @param maxRecordsPerQuery New maxRecordsPerQuery value. Default value is 15
     * @return {@link com.smartgwt.client.ai.AnswerEngineOperation AnswerEngineOperation} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public AnswerEngineOperation setMaxRecordsPerQuery(Integer maxRecordsPerQuery)  throws IllegalStateException {
        return (AnswerEngineOperation)setAttribute("maxRecordsPerQuery", maxRecordsPerQuery, false);
    }

    /**
     * The maximum number of records that may be requested per query. Must be a positive integer.
     *
     * @return Current maxRecordsPerQuery value. Default value is 15
     */
    public Integer getMaxRecordsPerQuery()  {
        return getAttributeAsInt("maxRecordsPerQuery");
    }
    
    

    /**
     * Whether to show a notify for this Answer Engine operation. <p> If {@link
     * com.smartgwt.client.ai.AnswerEngineOperation#getAutoShowResult autoShowResult} is also enabled, the notify will be
     * dismissed when the result is shown.
     *
     * @param showNotify New showNotify value. Default value is false
     * @return {@link com.smartgwt.client.ai.AnswerEngineOperation AnswerEngineOperation} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     */
    public AnswerEngineOperation setShowNotify(Boolean showNotify)  throws IllegalStateException {
        return (AnswerEngineOperation)setAttribute("showNotify", showNotify, false);
    }

    /**
     * Whether to show a notify for this Answer Engine operation. <p> If {@link
     * com.smartgwt.client.ai.AnswerEngineOperation#getAutoShowResult autoShowResult} is also enabled, the notify will be
     * dismissed when the result is shown.
     *
     * @return Current showNotify value. Default value is false
     */
    public Boolean getShowNotify()  {
        Boolean result = getAttributeAsBoolean("showNotify");
        return result == null ? false : result;
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
