/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Holds information about the outcome of a settled Promise. <p> Note: This is the type of object returned by
 * Promise.allSettled().
 */
@BeanFactory.FrameworkClass
public class PromiseOutcome extends DataClass {

    public static PromiseOutcome getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        return new PromiseOutcome(jsObj);
    }
        


    public PromiseOutcome(){
        
    }

    public PromiseOutcome(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }


    // ********************* Properties / Attributes ***********************

    /**
     * Only if the {@link com.smartgwt.client.util.PromiseOutcome#getStatus status} is REJECTED, the reason that the
     * <code>Promise</code> rejected with.
     *
     * @param reason New reason value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.util.PromiseOutcome PromiseOutcome} instance, for chaining setter calls
     */
    public PromiseOutcome setReason(Object reason) {
        return (PromiseOutcome)setAttribute("reason", reason);
    }

    /**
     * Only if the {@link com.smartgwt.client.util.PromiseOutcome#getStatus status} is REJECTED, the reason that the
     * <code>Promise</code> rejected with.
     *
     * @return Current reason value. Default value is *initialized by the implementation*
     */
    public Object getReason()  {
        return getAttributeAsObject("reason");
    }
    

    /**
     * The state that the <code>Promise</code> settled into.
     *
     * @param status New status value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.util.PromiseOutcome PromiseOutcome} instance, for chaining setter calls
     */
    public PromiseOutcome setStatus(SettledPromiseStatus status) {
        return (PromiseOutcome)setAttribute("status", status == null ? null : status.getValue());
    }

    /**
     * The state that the <code>Promise</code> settled into.
     *
     * @return Current status value. Default value is *initialized by the implementation*
     */
    public SettledPromiseStatus getStatus()  {
        return EnumUtil.getEnum(SettledPromiseStatus.values(), getAttribute("status"));
    }
    

    /**
     * Only if the {@link com.smartgwt.client.util.PromiseOutcome#getStatus status} is FULFILLED, the value that the
     * <code>Promise</code> fulfilled with.
     *
     * @param value New value value. Default value is *initialized by the implementation*
     * @return {@link com.smartgwt.client.util.PromiseOutcome PromiseOutcome} instance, for chaining setter calls
     */
    public PromiseOutcome setValue(Object value) {
        return (PromiseOutcome)setAttribute("value", value);
    }

    /**
     * Only if the {@link com.smartgwt.client.util.PromiseOutcome#getStatus status} is FULFILLED, the value that the
     * <code>Promise</code> fulfilled with.
     *
     * @return Current value value. Default value is *initialized by the implementation*
     */
    public Object getValue()  {
        return getAttributeAsObject("value");
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
