/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.converter.CssElIf;
import com.google.gwt.resources.converter.CssElse;
import com.google.gwt.resources.converter.ExtendedCssVisitor;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCharset;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssFontFace;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssPageRule;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssUnknownAtRule;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParser;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParserException;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Splitter;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GssGenerationVisitor
extends ExtendedCssVisitor {
    private static final String AND = " && ";
    private static final String CHARSET = "@charset \"%s\";";
    private static final String DEF = "@def ";
    private static final String ELSE = "@else ";
    private static final String ELSE_IF = "@elseif (%s)";
    private static final String EVAL = "eval('%s')";
    private static final String EXTERNAL = "@external";
    private static final String GWT_SPRITE = "gwt-sprite: \"%s\"";
    private static final String IF = "@if (%s)";
    private static final String IMPORTANT = " !important";
    private static final String IS = "is(\"%s\", \"%s\")";
    private static final String NO_FLIP = "/* @noflip */";
    private static final String NOT = "!";
    private static final String OR = " || ";
    private static final Pattern UNESCAPE = Pattern.compile("\\\\");
    private static final Pattern UNESCAPE_EXTERNAL = Pattern.compile("\\\\|@external|,|\\n|\\r");
    private static final String URL = "resourceUrl(\"%s\")";
    private static final String VALUE = "value('%s')";
    private static final String VALUE_WITH_SUFFIX = "value('%s', '%s')";
    private static Pattern NOT_QUOTED_WITH_WITHESPACE = Pattern.compile("^[^'\"].*\\s.*[^'\"]$");
    private static Pattern BANG_OPERATOR = Pattern.compile("^(!+)(.*)");
    private final Map<String, String> cssToGssConstantMapping;
    private final TextOutput out;
    private final boolean lenient;
    private final TreeLogger treeLogger;
    private final Predicate<String> simpleBooleanConditionPredicate;
    private final List<CssExternalSelectors> wrongExternalNodes = new ArrayList<CssExternalSelectors>();
    private final List<CssDef> wrongDefNodes = new ArrayList<CssDef>();
    private boolean insideNoFlipNode;
    private boolean needsNewLine;
    private boolean needsOpenBrace;
    private boolean needsComma;
    private boolean insideMediaAtRule;
    private boolean previousNodeIsDef;
    private boolean previousNodeIsExternal;

    public GssGenerationVisitor(TextOutput out, Map<String, String> cssToGssConstantMapping, boolean lenient, TreeLogger treeLogger, Predicate<String> simpleBooleanConditionPredicate) {
        this.cssToGssConstantMapping = cssToGssConstantMapping;
        this.out = out;
        this.lenient = lenient;
        this.treeLogger = treeLogger;
        this.simpleBooleanConditionPredicate = simpleBooleanConditionPredicate;
    }

    public String getContent() {
        return this.out.toString();
    }

    @Override
    public void endVisit(CssFontFace x, Context ctx) {
        this.closeBrace();
    }

    @Override
    public void endVisit(CssMediaRule x, Context ctx) {
        this.closeBrace();
        this.insideMediaAtRule = false;
        this.maybePrintWrongExternalNodes();
        this.maybePrintWrongDefNodes(ctx);
    }

    @Override
    public void endVisit(CssPageRule x, Context ctx) {
        this.closeBrace();
    }

    @Override
    public void endVisit(CssUnknownAtRule x, Context ctx) {
        this.out.print(x.getRule());
    }

    @Override
    public boolean visit(CssSprite x, Context ctx) {
        return false;
    }

    @Override
    public void endVisit(CssSprite x, Context ctx) {
        this.needsComma = false;
        this.accept(x.getSelectors());
        this.openBrace();
        this.out.print(String.format(GWT_SPRITE, x.getResourceFunction().getPath()));
        this.semiColon();
        this.accept(x.getProperties());
        this.closeBrace();
    }

    @Override
    public boolean visit(CssDef x, Context ctx) {
        this.printDef(x, null, "def", false);
        this.previousNodeIsDef = true;
        this.previousNodeIsExternal = false;
        return false;
    }

    @Override
    public boolean visit(CssEval x, Context ctx) {
        this.printDef(x, EVAL, "eval", false);
        return false;
    }

    @Override
    public boolean visit(CssUrl x, Context ctx) {
        this.printDef(x, URL, "url", true);
        return false;
    }

    @Override
    public boolean visit(CssRule x, Context ctx) {
        this.maybePrintNewLine();
        this.needsOpenBrace = true;
        this.needsComma = false;
        this.needsNewLine = false;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    @Override
    public void endVisit(CssRule x, Context ctx) {
        this.maybePrintOpenBrace();
        this.closeBrace();
        this.needsNewLine = true;
    }

    @Override
    public boolean visit(CssNoFlip x, Context ctx) {
        this.insideNoFlipNode = true;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean visit(CssExternalSelectors x, Context ctx) {
        if (!this.insideMediaAtRule) {
            this.printExternal(x);
            return false;
        }
        if (this.lenient) {
            this.treeLogger.log(TreeLogger.Type.WARN, "An external at-rule is not allowed inside a @media at-rule. The following external at-rule [" + x + "] will be moved in the upper scope");
            this.wrongExternalNodes.add(x);
            return false;
        }
        this.treeLogger.log(TreeLogger.Type.ERROR, "An external at-rule is not allowed inside a @media at-rule. [" + x + "].");
        throw new Css2GssConversionException("An external at-rule is not allowed inside a @media at-rule.");
    }

    @Override
    public boolean visit(CssCharset x, Context ctx) {
        this.out.print(String.format(CHARSET, x.getCharset()));
        this.out.newlineOpt();
        this.needsNewLine = true;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    private void maybePrintWrongExternalNodes() {
        if (!this.lenient) {
            return;
        }
        for (CssExternalSelectors external : this.wrongExternalNodes) {
            this.printExternal(external);
        }
        this.wrongExternalNodes.clear();
    }

    private void maybePrintWrongDefNodes(Context ctx) {
        if (!this.lenient) {
            return;
        }
        for (CssDef def : this.wrongDefNodes) {
            if (def instanceof CssUrl) {
                this.visit((CssUrl)def, ctx);
                continue;
            }
            if (def instanceof CssEval) {
                this.visit((CssEval)def, ctx);
                continue;
            }
            this.visit(def, ctx);
        }
        this.wrongDefNodes.clear();
    }

    private void printExternal(CssExternalSelectors x) {
        boolean first = true;
        for (String selector : x.getClasses()) {
            String unescaped = this.unescapeExternalClass(selector);
            if (!this.validateExternalClass(selector) || Strings.isNullOrEmpty(unescaped)) continue;
            if (first) {
                if (!this.previousNodeIsExternal) {
                    this.maybePrintNewLine();
                }
                this.out.print(EXTERNAL);
                first = false;
            }
            this.out.print(" ");
            boolean needQuote = selector.endsWith("*");
            if (needQuote) {
                this.out.print("'");
            }
            this.out.printOpt(unescaped);
            if (!needQuote) continue;
            this.out.print("'");
        }
        if (!first) {
            this.semiColon();
        }
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = true;
    }

    private boolean validateExternalClass(String selector) {
        if (selector.contains(":")) {
            if (this.lenient) {
                this.treeLogger.log(TreeLogger.Type.WARN, "This invalid external selector will be skipped: " + selector);
                return false;
            }
            throw new Css2GssConversionException("One of your external statements contains a pseudo class: " + selector);
        }
        return true;
    }

    @Override
    public void endVisit(CssNoFlip x, Context ctx) {
        this.insideNoFlipNode = false;
    }

    @Override
    public boolean visit(CssProperty x, Context ctx) {
        this.maybePrintOpenBrace();
        StringBuilder propertyBuilder = new StringBuilder();
        if (this.insideNoFlipNode) {
            propertyBuilder.append(NO_FLIP);
            propertyBuilder.append(' ');
        }
        propertyBuilder.append(x.getName());
        propertyBuilder.append(": ");
        String valueListCss = this.printValuesList(x.getValues().getValues(), false);
        if ("font-family".equals(x.getName())) {
            valueListCss = this.quoteFontFamilyWithWhiteSpace(valueListCss);
        }
        propertyBuilder.append(valueListCss);
        if (x.isImportant()) {
            propertyBuilder.append(IMPORTANT);
        }
        String cssProperty = propertyBuilder.toString();
        try {
            new GssParser(new SourceCode(null, "body{" + cssProperty + "}")).parse();
        }
        catch (GssParserException e) {
            if (this.lenient) {
                this.treeLogger.log(TreeLogger.Type.WARN, "The following rule is not valid and will be skipped: " + cssProperty);
                return false;
            }
            this.treeLogger.log(TreeLogger.Type.ERROR, "The following rule is not valid. " + cssProperty);
            throw new Css2GssConversionException("Invalid css rule", e);
        }
        this.out.print(cssProperty);
        this.semiColon();
        return true;
    }

    private String quoteFontFamilyWithWhiteSpace(String cssProperty) {
        StringBuilder valueBuilder = new StringBuilder();
        boolean first = true;
        for (String subProperty : Splitter.on(",").trimResults().omitEmptyStrings().split(cssProperty)) {
            if (first) {
                first = false;
            } else {
                valueBuilder.append(",");
            }
            if (NOT_QUOTED_WITH_WITHESPACE.matcher(subProperty).matches()) {
                valueBuilder.append("'" + subProperty + "'");
                continue;
            }
            valueBuilder.append(subProperty);
        }
        return valueBuilder.toString();
    }

    @Override
    public boolean visit(CssElse x, Context ctx) {
        this.closeBrace();
        this.out.print(ELSE);
        this.openBrace();
        this.needsNewLine = false;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    @Override
    public boolean visit(CssElIf x, Context ctx) {
        this.closeBrace();
        this.openConditional(ELSE_IF, x);
        return true;
    }

    @Override
    public void endVisit(CssIf x, Context ctx) {
        this.closeBrace();
        this.needsNewLine = true;
    }

    @Override
    public boolean visit(CssIf x, Context ctx) {
        this.maybePrintNewLine();
        this.openConditional(IF, x);
        return true;
    }

    private void openConditional(String template, CssIf ifOrElif) {
        String runtimeCondition = this.extractExpression(ifOrElif);
        String condition = runtimeCondition != null ? (this.simpleBooleanConditionPredicate.apply(runtimeCondition) ? runtimeCondition : String.format(EVAL, runtimeCondition)) : this.printConditionnalExpression(ifOrElif);
        this.out.print(String.format(template, condition));
        this.openBrace();
        this.needsNewLine = false;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
    }

    private String extractExpression(CssIf ifOrElif) {
        Matcher m;
        String condition = ifOrElif.getExpression();
        if (condition == null) {
            return null;
        }
        if (condition.trim().startsWith("(")) {
            condition = condition.substring(1, condition.length() - 1);
        }
        if ((m = BANG_OPERATOR.matcher(condition)).matches()) {
            String bangs = m.group(1);
            String replacement = bangs.length() % 2 == 0 ? "" : NOT;
            condition = m.replaceFirst(replacement + "$2");
        }
        return condition;
    }

    @Override
    public boolean visit(CssFontFace x, Context ctx) {
        this.out.print("@font-face");
        this.openBrace();
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    @Override
    public boolean visit(CssMediaRule x, Context ctx) {
        this.maybePrintNewLine();
        this.insideMediaAtRule = true;
        this.out.print("@media");
        boolean isFirst = true;
        for (String m : x.getMedias()) {
            if (isFirst) {
                this.out.print(" ");
                isFirst = false;
            } else {
                this.comma();
            }
            this.out.print(m);
        }
        this.spaceOpt();
        this.out.print("{");
        this.out.newlineOpt();
        this.out.indentIn();
        this.needsNewLine = false;
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    @Override
    public boolean visit(CssPageRule x, Context ctx) {
        this.out.print("@page");
        if (x.getPseudoPage() != null) {
            this.out.print(" :");
            this.out.print(x.getPseudoPage());
        }
        this.spaceOpt();
        this.out.print("{");
        this.out.newlineOpt();
        this.out.indentIn();
        this.previousNodeIsDef = false;
        this.previousNodeIsExternal = false;
        return true;
    }

    @Override
    public boolean visit(CssSelector x, Context ctx) {
        if (this.needsComma) {
            this.comma(false);
        }
        this.maybePrintNewLine();
        this.needsComma = true;
        this.needsNewLine = true;
        this.out.print(this.unescape(x.getSelector()));
        return true;
    }

    private void printDef(CssDef def, String valueTemplate, String atRule, boolean insideUrlNode) {
        if (this.validateDefNode(def, atRule)) {
            if (!this.previousNodeIsDef) {
                this.maybePrintNewLine();
            }
            this.out.print(DEF);
            String name = this.cssToGssConstantMapping.get(def.getKey());
            if (name == null) {
                throw new Css2GssConversionException("unknown @" + atRule + " rule [" + def.getKey() + "]");
            }
            this.out.print(name);
            this.out.print(' ');
            String values = this.printValuesList(def.getValues(), insideUrlNode);
            if (valueTemplate != null) {
                this.out.print(String.format(valueTemplate, values));
            } else {
                this.out.print(values);
            }
            this.semiColon();
            this.previousNodeIsDef = true;
            this.needsNewLine = true;
        }
    }

    private boolean validateDefNode(CssDef def, String atRule) {
        if (this.insideMediaAtRule) {
            if (this.lenient) {
                this.treeLogger.log(TreeLogger.Type.WARN, "A " + atRule + " is not allowed inside a @media at-rule.The following " + atRule + " [" + def + "] will be moved in the upper scope");
                this.wrongDefNodes.add(def);
                return false;
            }
            this.treeLogger.log(TreeLogger.Type.ERROR, "A " + atRule + " is not allowed inside a @media at-rule. [" + def + "]");
            throw new Css2GssConversionException("A " + atRule + " is not allowed inside a @media at-rule.");
        }
        return true;
    }

    private void closeBrace() {
        this.out.indentOut();
        this.out.print('}');
        this.out.newlineOpt();
    }

    private void comma() {
        this.comma(true);
    }

    private void comma(boolean addSpace) {
        this.out.print(',');
        if (addSpace) {
            this.spaceOpt();
        }
    }

    private void openBrace() {
        this.spaceOpt();
        this.out.print('{');
        this.out.newlineOpt();
        this.out.indentIn();
    }

    private void semiColon() {
        this.out.print(';');
        this.out.newlineOpt();
    }

    private void spaceOpt() {
        this.out.printOpt(' ');
    }

    private void maybePrintOpenBrace() {
        if (this.needsOpenBrace) {
            this.openBrace();
            this.needsOpenBrace = false;
        }
    }

    private void maybePrintNewLine() {
        if (this.needsNewLine) {
            this.out.newlineOpt();
        }
    }

    private String printConditionnalExpression(CssIf x) {
        if (x == null || x.getExpression() != null) {
            throw new IllegalStateException();
        }
        StringBuilder builder = new StringBuilder();
        String propertyName = x.getPropertyName();
        for (String propertyValue : x.getPropertyValues()) {
            if (builder.length() != 0) {
                if (x.isNegated()) {
                    builder.append(AND);
                } else {
                    builder.append(OR);
                }
            }
            if (x.isNegated()) {
                builder.append(NOT);
            }
            builder.append(String.format(IS, propertyName, propertyValue));
        }
        return builder.toString();
    }

    private String printValuesList(List<CssProperty.Value> values, boolean insideUrlNode) {
        StringBuilder builder = new StringBuilder();
        for (CssProperty.Value value : values) {
            if (value.isSpaceRequired() && builder.length() != 0) {
                builder.append(' ');
            }
            String expression = value.toCss();
            if (value.isIdentValue() != null && this.cssToGssConstantMapping.containsKey(expression)) {
                expression = this.cssToGssConstantMapping.get(expression);
            } else if (value.isExpressionValue() != null) {
                expression = value.getExpression();
            } else if (value.isDotPathValue() != null) {
                CssProperty.DotPathValue dotPathValue = value.isDotPathValue();
                expression = insideUrlNode ? dotPathValue.getPath() : (Strings.isNullOrEmpty(dotPathValue.getSuffix()) ? String.format(VALUE, dotPathValue.getPath()) : String.format(VALUE_WITH_SUFFIX, dotPathValue.getPath(), dotPathValue.getSuffix()));
            } else if (value.isFunctionValue() != null) {
                CssProperty.FunctionValue functionValue = value.isFunctionValue();
                String arguments = this.printValuesList(functionValue.getValues().getValues(), insideUrlNode);
                expression = this.unescape(functionValue.getName()) + "(" + arguments + ")";
            }
            if (value.isStringValue() != null || value.isFunctionValue() != null) {
                builder.append(expression);
                continue;
            }
            builder.append(this.unescape(expression));
        }
        return builder.toString();
    }

    private String unescape(String toEscape) {
        return UNESCAPE.matcher(toEscape).replaceAll("");
    }

    private String unescapeExternalClass(String external) {
        return UNESCAPE_EXTERNAL.matcher(external).replaceAll("");
    }
}

