/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class DefaultSelectionEventManager<T>
implements CellPreviewEvent.Handler<T> {
    private HasData<T> lastDisplay;
    private int lastPageStart;
    private int lastSelectedIndex = -1;
    private boolean shiftAdditive;
    private int shiftAnchor = -1;
    private final EventTranslator<T> translator;

    public static <T> DefaultSelectionEventManager<T> createBlacklistManager(int ... blacklistedColumns) {
        return new DefaultSelectionEventManager(new BlacklistEventTranslator(blacklistedColumns));
    }

    public static <T> DefaultSelectionEventManager<T> createCheckboxManager() {
        return new DefaultSelectionEventManager(new CheckboxEventTranslator());
    }

    public static <T> DefaultSelectionEventManager<T> createCheckboxManager(int column) {
        return new DefaultSelectionEventManager(new CheckboxEventTranslator(column));
    }

    public static <T> DefaultSelectionEventManager<T> createCustomManager(EventTranslator<T> translator) {
        return new DefaultSelectionEventManager<T>(translator);
    }

    public static <T> DefaultSelectionEventManager<T> createDefaultManager() {
        return new DefaultSelectionEventManager<T>(null);
    }

    public static <T> DefaultSelectionEventManager<T> createWhitelistManager(int ... whitelistedColumns) {
        return new DefaultSelectionEventManager(new WhitelistEventTranslator(whitelistedColumns));
    }

    protected DefaultSelectionEventManager(EventTranslator<T> translator) {
        this.translator = translator;
    }

    public void doMultiSelection(MultiSelectionModel<? super T> selectionModel, HasData<T> display, int row, T rowValue, SelectAction action, boolean selectRange, boolean clearOthers) {
        boolean addToSelection = true;
        if (action != null) {
            switch (action) {
                case IGNORE: {
                    return;
                }
                case SELECT: {
                    addToSelection = true;
                    break;
                }
                case DESELECT: {
                    addToSelection = false;
                    break;
                }
                case TOGGLE: {
                    addToSelection = !selectionModel.isSelected(rowValue);
                }
            }
        }
        int pageStart = display.getVisibleRange().getStart();
        if (selectRange && pageStart == this.lastPageStart && this.lastSelectedIndex > -1 && this.shiftAnchor > -1 && display == this.lastDisplay) {
            int start = Math.min(this.shiftAnchor, row);
            int end = Math.max(this.shiftAnchor, row);
            if (this.lastSelectedIndex < start) {
                this.setRangeSelection(selectionModel, display, new Range(this.lastSelectedIndex, start - this.lastSelectedIndex), !this.shiftAdditive, false);
            } else if (this.lastSelectedIndex > end) {
                this.setRangeSelection(selectionModel, display, new Range(end + 1, this.lastSelectedIndex - end), !this.shiftAdditive, false);
            } else {
                this.shiftAdditive = addToSelection;
            }
            this.lastSelectedIndex = row;
            this.setRangeSelection(selectionModel, display, new Range(start, end - start + 1), this.shiftAdditive, clearOthers);
        } else {
            this.lastDisplay = display;
            this.lastPageStart = pageStart;
            this.lastSelectedIndex = row;
            this.shiftAnchor = row;
            this.selectOne(selectionModel, rowValue, addToSelection, clearOthers);
        }
    }

    @Override
    public void onCellPreview(CellPreviewEvent<T> event) {
        SelectAction action;
        if (event.isCellEditing() || event.isSelectionHandled()) {
            return;
        }
        HasData<T> display = event.getDisplay();
        SelectionModel<T> selectionModel = display.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        SelectAction selectAction = action = this.translator == null ? SelectAction.DEFAULT : this.translator.translateSelectionEvent(event);
        if (selectionModel instanceof MultiSelectionModel) {
            this.handleMultiSelectionEvent(event, action, (MultiSelectionModel)selectionModel);
        } else {
            this.handleSelectionEvent(event, action, selectionModel);
        }
    }

    protected void clearSelection(MultiSelectionModel<? super T> selectionModel) {
        selectionModel.clear();
    }

    protected void handleMultiSelectionEvent(CellPreviewEvent<T> event, SelectAction action, MultiSelectionModel<? super T> selectionModel) {
        int keyCode;
        NativeEvent nativeEvent = event.getNativeEvent();
        String type = nativeEvent.getType();
        if ("click".equals(type)) {
            boolean clearOthers;
            boolean ctrlOrMeta;
            boolean shift = nativeEvent.getShiftKey();
            boolean bl = ctrlOrMeta = nativeEvent.getCtrlKey() || nativeEvent.getMetaKey();
            boolean bl2 = this.translator == null ? !ctrlOrMeta : (clearOthers = this.translator.clearCurrentSelection(event));
            if (action == null || action == SelectAction.DEFAULT) {
                action = ctrlOrMeta ? SelectAction.TOGGLE : SelectAction.SELECT;
            }
            this.doMultiSelection(selectionModel, event.getDisplay(), event.getIndex(), event.getValue(), action, shift, clearOthers);
        } else if ("keyup".equals(type) && (keyCode = nativeEvent.getKeyCode()) == 32) {
            boolean clearOthers;
            boolean shift = nativeEvent.getShiftKey();
            boolean bl = clearOthers = this.translator == null ? false : this.translator.clearCurrentSelection(event);
            if (action == null || action == SelectAction.DEFAULT) {
                action = SelectAction.TOGGLE;
            }
            this.doMultiSelection(selectionModel, event.getDisplay(), event.getIndex(), event.getValue(), action, shift, clearOthers);
        }
    }

    protected void handleSelectionEvent(CellPreviewEvent<T> event, SelectAction action, SelectionModel<? super T> selectionModel) {
        int keyCode;
        NativeEvent nativeEvent;
        String type;
        T value = event.getValue();
        if (action != null) {
            switch (action) {
                case IGNORE: {
                    return;
                }
                case SELECT: {
                    selectionModel.setSelected(value, true);
                    return;
                }
                case DESELECT: {
                    selectionModel.setSelected(value, false);
                    return;
                }
                case TOGGLE: {
                    selectionModel.setSelected(value, !selectionModel.isSelected(value));
                    return;
                }
            }
        }
        if ("click".equals(type = (nativeEvent = event.getNativeEvent()).getType())) {
            if (nativeEvent.getCtrlKey() || nativeEvent.getMetaKey()) {
                selectionModel.setSelected(value, !selectionModel.isSelected(value));
            } else {
                selectionModel.setSelected(value, true);
            }
        } else if ("keyup".equals(type) && (keyCode = nativeEvent.getKeyCode()) == 32) {
            selectionModel.setSelected(value, !selectionModel.isSelected(value));
        }
    }

    protected void selectOne(MultiSelectionModel<? super T> selectionModel, T target, boolean selected, boolean clearOthers) {
        if (clearOthers) {
            this.clearSelection(selectionModel);
        }
        selectionModel.setSelected(target, selected);
    }

    protected void setRangeSelection(MultiSelectionModel<? super T> selectionModel, HasData<T> display, Range range, boolean addToSelection, boolean clearOthers) {
        ArrayList<T> toUpdate = new ArrayList<T>();
        int itemCount = display.getVisibleItemCount();
        int relativeStart = range.getStart() - display.getVisibleRange().getStart();
        int relativeEnd = relativeStart + range.getLength();
        for (int i = relativeStart; i < relativeEnd && i < itemCount; ++i) {
            toUpdate.add(display.getVisibleItem(i));
        }
        if (clearOthers) {
            this.clearSelection(selectionModel);
        }
        for (Object value : toUpdate) {
            selectionModel.setSelected(value, addToSelection);
        }
    }

    public static class WhitelistEventTranslator<T>
    implements EventTranslator<T> {
        private final Set<Integer> whitelist = new HashSet<Integer>();

        public WhitelistEventTranslator(int ... whitelistedColumns) {
            if (whitelistedColumns != null) {
                for (int i : whitelistedColumns) {
                    this.setColumnWhitelisted(i, true);
                }
            }
        }

        @Override
        public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
            return false;
        }

        public void clearWhitelist() {
            this.whitelist.clear();
        }

        public boolean isColumnWhitelisted(int index) {
            return this.whitelist.contains(index);
        }

        public void setColumnWhitelisted(int index, boolean isWhitelisted) {
            if (isWhitelisted) {
                this.whitelist.add(index);
            } else {
                this.whitelist.remove(index);
            }
        }

        @Override
        public SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
            return this.isColumnWhitelisted(event.getColumn()) ? SelectAction.DEFAULT : SelectAction.IGNORE;
        }
    }

    public static enum SelectAction {
        DEFAULT,
        SELECT,
        DESELECT,
        TOGGLE,
        IGNORE;

    }

    public static interface EventTranslator<T> {
        public boolean clearCurrentSelection(CellPreviewEvent<T> var1);

        public SelectAction translateSelectionEvent(CellPreviewEvent<T> var1);
    }

    public static class CheckboxEventTranslator<T>
    implements EventTranslator<T> {
        private final int column;

        public CheckboxEventTranslator() {
            this(-1);
        }

        public CheckboxEventTranslator(int column) {
            this.column = column;
        }

        @Override
        public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
            return false;
        }

        @Override
        public SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
            NativeEvent nativeEvent = event.getNativeEvent();
            if ("click".equals(nativeEvent.getType())) {
                InputElement input;
                if (this.column > -1 && this.column != event.getColumn()) {
                    return SelectAction.IGNORE;
                }
                Element target = (Element)nativeEvent.getEventTarget().cast();
                if ("input".equals(target.getTagName().toLowerCase(Locale.ROOT)) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase(Locale.ROOT))) {
                    input.setChecked(event.getDisplay().getSelectionModel().isSelected(event.getValue()));
                    return SelectAction.TOGGLE;
                }
                return SelectAction.IGNORE;
            }
            return SelectAction.DEFAULT;
        }
    }

    public static class BlacklistEventTranslator<T>
    implements EventTranslator<T> {
        private final Set<Integer> blacklist = new HashSet<Integer>();

        public BlacklistEventTranslator(int ... blacklistedColumns) {
            if (blacklistedColumns != null) {
                for (int i : blacklistedColumns) {
                    this.setColumnBlacklisted(i, true);
                }
            }
        }

        public void clearBlacklist() {
            this.blacklist.clear();
        }

        @Override
        public boolean clearCurrentSelection(CellPreviewEvent<T> event) {
            return false;
        }

        public boolean isColumnBlacklisted(int index) {
            return this.blacklist.contains(index);
        }

        public void setColumnBlacklisted(int index, boolean isBlacklisted) {
            if (isBlacklisted) {
                this.blacklist.add(index);
            } else {
                this.blacklist.remove(index);
            }
        }

        @Override
        public SelectAction translateSelectionEvent(CellPreviewEvent<T> event) {
            return this.isColumnBlacklisted(event.getColumn()) ? SelectAction.IGNORE : SelectAction.DEFAULT;
        }
    }
}

