/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.IsInteraction;
import org.openqa.selenium.interactions.KeyInput;
import org.openqa.selenium.interactions.PointerInput;

public class CompositeAction
implements Action,
IsInteraction {
    private final List<Action> actionsList = new ArrayList<Action>();

    @Override
    public void perform() {
        for (Action action : this.actionsList) {
            action.perform();
        }
    }

    public CompositeAction addAction(Action action) {
        Objects.requireNonNull(action, "Null actions are not supported.");
        this.actionsList.add(action);
        return this;
    }

    @Deprecated
    int getNumberOfActions() {
        return this.actionsList.size();
    }

    @Override
    public List<Interaction> asInteractions(PointerInput mouse, KeyInput keyboard) {
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        for (Action action : this.actionsList) {
            if (!(action instanceof IsInteraction)) {
                throw new IllegalArgumentException(String.format("Action must implement IsInteraction: %s", action));
            }
            interactions.addAll(((IsInteraction)((Object)action)).asInteractions(mouse, keyboard));
        }
        return Collections.unmodifiableList(interactions);
    }
}

