/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

public final class TidyMessage {
    private int line;
    private int column;
    private Level level;
    private String message;
    private int errorCode;

    public TidyMessage(int n, int n2, int n3, Level level, String string) {
        this.errorCode = n;
        this.line = n2;
        this.column = n3;
        this.level = level;
        this.message = string;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getColumn() {
        return this.column;
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLine() {
        return this.line;
    }

    public String getMessage() {
        return this.message;
    }

    public static final class Level
    implements Comparable {
        public static final Level SUMMARY = new Level(0);
        public static final Level INFO = new Level(1);
        public static final Level WARNING = new Level(2);
        public static final Level ERROR = new Level(3);
        private short code;

        private Level(int n) {
            this.code = (short)n;
        }

        public short getCode() {
            return this.code;
        }

        public static Level fromCode(int n) {
            switch (n) {
                case 0: {
                    return SUMMARY;
                }
                case 1: {
                    return INFO;
                }
                case 2: {
                    return WARNING;
                }
                case 3: {
                    return ERROR;
                }
            }
            return null;
        }

        public int compareTo(Object object) {
            return this.code - ((Level)object).code;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Level)) {
                return false;
            }
            return this.code == ((Level)object).code;
        }

        public String toString() {
            switch (this.code) {
                case 0: {
                    return "SUMMARY";
                }
                case 1: {
                    return "INFO";
                }
                case 2: {
                    return "WARNING";
                }
                case 3: {
                    return "ERROR";
                }
            }
            return "?";
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

