/*

  SmartClient Ajax RIA system
  Version SNAPSHOT_v15.0d_2026-02-25/LGPL Deployment (2026-02-25)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class DropZone
// Base class for drop zones that accept HTML5 drag-and-drop of files and/or content.
// <P>
// DropZone extends Label (StatefulCanvas), providing standard state-based styling for
// drag interactions. Subclasses can accept file drops (+link{canDropFiles}), content
// drops (+link{canDropContent}), or both.
// <P>
// For file-specific features like thumbnails, progress bars, and rich validation,
// see +link{FileDropZone}. For skin snapshot import, see +link{SkinSnapshotDropZone}.
//
// @inheritsFrom Label
// @treeLocation Client Reference/Foundation
// @visibility external
//<
isc.ClassFactory.defineClass("DropZone", "Label");

isc.DropZone.addClassProperties({

    //> @classAttr DropZone.emptyDropAreaMessage (String : "Drop here" : IR)
    // Default message shown when the drop zone is empty.
    // @group i18nMessages
    // @visibility external
    //<
    emptyDropAreaMessage: "Drop here"
});


isc.DropZone.addProperties({

    // Enable drop behavior - canAcceptDrop is required for EventHandler to recognize
    // this as a valid drop target during native drags
    canDrop: true,
    canAcceptDrop: true,

    // StatefulCanvas state management - enable rollOver for drag-over styling
    showRollOver: true,
    showDisabled: true,

    //> @attr dropZone.canDropFiles (Boolean : true : IR)
    // Whether this drop zone accepts file drops from the desktop.
    // When true, the +link{fileDrop()} notification fires when files are dropped.
    // @visibility external
    //<
    canDropFiles: true,

    //> @attr dropZone.canDropContent (Boolean : false : IR)
    // Whether this drop zone accepts content drops (text, HTML) from other applications.
    // When true, the +link{contentDrop()} notification fires when content is dropped.
    // @visibility external
    //<
    canDropContent: false,

    //> @attr dropZone.acceptedFileTypes (Array of String : null : IR)
    // Array of accepted MIME types (e.g., ["image/*", "application/pdf"]).
    // If null, all file types are accepted when +link{canDropFiles} is true.
    // @visibility external
    //<

    // Style properties
    //> @attr dropZone.baseStyle (CSSStyleName : "dropZone" : IR)
    // Base CSS class for the drop zone. Supports state suffixes: Over, Disabled.
    // @visibility external
    //<
    baseStyle: "dropZone",

    //> @attr dropZone.align (Alignment : "center" : IR)
    // Horizontal alignment for drop zone content.
    // @visibility external
    //<
    align: "center",

    //> @attr dropZone.valign (VerticalAlignment : "center" : IR)
    // Vertical alignment for drop zone content.
    // @visibility external
    //<

    // Default dimensions
    width: 200,
    height: 100
});


isc.DropZone.addMethods({

    initWidget : function () {
        this.Super("initWidget", arguments);

        // Set initial content
        this._updateDisplay();
    },

    // Update the display based on current state
    _updateDisplay : function () {
        var contents = this._getEmptyHTML();
        this.setContents(contents);
    },

    // Generate HTML for empty state - subclasses may override
    _getEmptyHTML : function () {
        var html = "<div class='dropZoneContent'>";
        html += "<div class='dropZoneMessage'>" +
                this._getMessage("emptyDropAreaMessage") + "</div>";
        html += "</div>";
        return html;
    },

    // Get message from instance or class properties
    _getMessage : function (messageName) {
        return this[messageName] || isc.DropZone[messageName];
    },

    // Handle drop event - dispatch to file or content handlers
    drop : function () {
        // Check for file drops first
        if (this.canDropFiles) {
            var files = isc.EH.getNativeDragData();
            if (files && files.length > 0) {
                // Convert FileList to Array
                files = Array.prototype.slice.call(files);

                // Validate file types if acceptedFileTypes is set
                if (this.acceptedFileTypes) {
                    var validFiles = [];
                    for (var i = 0; i < files.length; i++) {
                        if (this._isAcceptedFileType(files[i])) {
                            validFiles.push(files[i]);
                        }
                    }
                    if (validFiles.length > 0) {
                        this.fileDrop(validFiles);
                    }
                } else {
                    this.fileDrop(files);
                }
                return false;
            }
        }

        // Check for content drops
        if (this.canDropContent) {
            var nativeEvent = isc.EH.lastEvent ? isc.EH.lastEvent.DOMevent : null;
            if (nativeEvent && nativeEvent.dataTransfer) {
                var items = nativeEvent.dataTransfer.items;
                if (items) {
                    for (var i = 0; i < items.length; i++) {
                        var item = items[i];
                        if (item.kind === 'string') {
                            var _this = this;
                            // getAsString() is async-only
                            item.getAsString(function(content) {
                                _this.contentDrop(content);
                            });
                            return false;
                        }
                    }
                }
            }
        }

        return false;
    },

    // Check if a file matches the accepted file types
    _isAcceptedFileType : function (file) {
        if (!this.acceptedFileTypes || this.acceptedFileTypes.length == 0) {
            return true;
        }

        var fileType = file.type || "";
        var fileName = file.name || "";

        for (var i = 0; i < this.acceptedFileTypes.length; i++) {
            var accepted = this.acceptedFileTypes[i];

            // Check for wildcard MIME type (e.g., "image/*")
            if (accepted.endsWith("/*")) {
                var prefix = accepted.substring(0, accepted.length - 1);
                if (fileType.indexOf(prefix) == 0) return true;
            }
            // Check for exact MIME type match
            else if (accepted == fileType) {
                return true;
            }
            // Check for file extension (e.g., ".pdf")
            else if (accepted.indexOf(".") == 0) {
                if (fileName.toLowerCase().endsWith(accepted.toLowerCase())) {
                    return true;
                }
            }
        }
        return false;
    },

    // Handle drag over - StatefulCanvas handles the Over state via showRollOver
    dropOver : function () {
        this._dragOver = true;
        this.setState(isc.StatefulCanvas.STATE_OVER);
        return this.Super("dropOver", arguments);
    },

    // Handle drag out - reset to normal state
    dropOut : function () {
        this._dragOver = false;
        this.setState(isc.StatefulCanvas.STATE_UP);
        return this.Super("dropOut", arguments);
    },

    //> @method dropZone.fileDrop()
    // Notification fired when files are dropped onto the drop zone.
    // Only fires when +link{canDropFiles} is true.
    // @param files (Array of File) JavaScript File objects that were dropped
    // @visibility external
    //<
    fileDrop : function (files) {
        // Override point
    },

    //> @method dropZone.contentDrop()
    // Notification fired when content (text, HTML) is dropped from another application.
    // Only fires when +link{canDropContent} is true.
    // @param content (String) The dropped content
    // @visibility external
    //<
    contentDrop : function (content) {
        // Override point
    }
});
