/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, IButton, LGField, ListGrid } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onGovernmentHoverHTML = function(record,value,rowNum,colNum,grid) {return government_descriptions[record.government_desc]};
let onShowHoverOnEveryCellClick = function() {return countryList.canHover = true};
let onShowHoverOn_i_Government__i_CellsOnlyClick = function() {return countryList.canHover = null};
let onSuppressAllCellHoversClick = function() {return countryList.canHover = false};

var countryData = [
    {
        continent: 'North America',
        countryName: 'United States',
        countryCode: 'US',
        area: 9631420,
        population: 298444215,
        gdp: 12360,
        independence: new Date(1776, 6, 4),
        government: 'federal republic',
        government_desc: 2,
        capital: 'Washington, DC',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/United_states'
    },
    {
        continent: 'Asia',
        countryName: 'China',
        countryCode: 'CH',
        area: 9596960,
        population: 1313973713,
        gdp: 8859,
        government: 'Communist state',
        government_desc: 0,
        capital: 'Beijing',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/China'
    },
    {
        continent: 'Asia',
        countryName: 'Japan',
        countryCode: 'JA',
        area: 377835,
        population: 127463611,
        gdp: 4018,
        government: 'constitutional monarchy with parliamentary government',
        government_desc: 1,
        capital: 'Tokyo',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/Japan'
    },
    {
        continent: 'Asia',
        countryName: 'India',
        countryCode: 'IN',
        area: 3287590,
        population: 1095351995,
        gdp: 3611,
        independence: new Date(1947, 7, 15),
        government: 'federal republic',
        government_desc: 2,
        capital: 'New Delhi',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/India'
    },
    {
        continent: 'Europe',
        countryName: 'Germany',
        countryCode: 'GM',
        area: 357021,
        population: 82422299,
        gdp: 2504,
        independence: new Date(1871, 0, 18),
        government: 'federal republic',
        government_desc: 2,
        capital: 'Berlin',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/Germany'
    },
    {
        continent: 'Europe',
        countryName: 'United Kingdom',
        countryCode: 'UK',
        area: 244820,
        population: 60609153,
        gdp: 1830,
        independence: new Date(1801, 0, 1),
        government: 'constitutional monarchy',
        government_desc: 1,
        capital: 'London',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/United_kingdom'
    },
    {
        continent: 'Europe',
        countryName: 'France',
        countryCode: 'FR',
        area: 547030,
        population: 60876136,
        gdp: 1816,
        government: 'republic',
        government_desc: 5,
        capital: 'Paris',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/France'
    },
    {
        continent: 'Europe',
        countryName: 'Italy',
        countryCode: 'IT',
        area: 301230,
        population: 58133509,
        gdp: 1698,
        independence: new Date(1861, 2, 17),
        government: 'republic',
        government_desc: 5,
        capital: 'Rome',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/Italy'
    },
    {
        continent: 'Asia',
        countryName: 'Russia',
        countryCode: 'RS',
        area: 17075200,
        population: 142893540,
        gdp: 1589,
        independence: new Date(1991, 7, 24),
        government: 'federation',
        government_desc: 3,
        capital: 'Moscow',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/Russia'
    },
    {
        continent: 'South America',
        countryName: 'Brazil',
        countryCode: 'BR',
        area: 8511965,
        population: 188078227,
        gdp: 1556,
        independence: new Date(1822, 8, 7),
        government: 'federative republic',
        government_desc: 3,
        capital: 'Brasilia',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/Brazil'
    },
    {
        continent: 'North America',
        countryName: 'Canada',
        countryCode: 'CA',
        area: 9984670,
        population: 33098932,
        gdp: 1114,
        independence: new Date(1867, 6, 1),
        government: 'constitutional monarchy with parliamentary democracy and federation',
        government_desc: 1,
        capital: 'Ottawa',
        member_g8: true,
        article: 'http://en.wikipedia.org/wiki/Canada'
    },
    {
        continent: 'North America',
        countryName: 'Mexico',
        countryCode: 'MX',
        area: 1972550,
        population: 107449525,
        gdp: 1067,
        independence: new Date(1810, 8, 16),
        government: 'federal republic',
        government_desc: 2,
        capital: 'Mexico (Distrito Federal)',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/Mexico'
    },
    {
        continent: 'Europe',
        countryName: 'Spain',
        countryCode: 'SP',
        area: 504782,
        population: 40397842,
        gdp: 1029,
        independence: new Date(1492, 0, 1),
        government: 'parliamentary monarchy',
        government_desc: 4,
        capital: 'Madrid',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/Spain'
    },
    {
        continent: 'Asia',
        countryName: 'South Korea',
        countryCode: 'KS',
        area: 98480,
        population: 48846823,
        gdp: 965.3,
        independence: new Date(1945, 7, 15),
        government: 'republic',
        government_desc: 5,
        capital: 'Seoul',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/South_korea'
    },
    {
        continent: 'Asia',
        countryName: 'Indonesia',
        countryCode: 'ID',
        area: 1919440,
        population: 245452739,
        gdp: 865.6,
        independence: new Date(1945, 7, 17),
        government: 'republic',
        government_desc: 5,
        capital: 'Jakarta',
        member_g8: false,
        article: 'http://en.wikipedia.org/wiki/Indonesia'
    }
];
var government_descriptions = [
    '<b>Communism</b> - a system of government in which the state plans and controls the economy and a single - often authoritarian - party holds power; state controls are imposed with the elimination of private ownership of property or capital while claiming to make progress toward a higher social order in which all goods are equally shared by the people (i.e., a classless society).',
    '<b>Constitutional monarchy</b> - a system of government in which a monarch is guided by a constitution whereby his/her rights, duties, and responsibilities are spelled out in written law or by custom.',
    '<b>Federal republic</b> - a state in which the powers of the central government are restricted and in which the component parts (states, colonies, or provinces) retain a degree of self-government; ultimate sovereign power rests with the voters who chose their governmental representatives.',
    '<b>Federal (Federative)</b> - a form of government in which sovereign power is formally divided - usually by means of a constitution - between a central authority and a number of constituent regions (states, colonies, or provinces) so that each region retains some management of its internal affairs; differs from a confederacy in that the central government exerts influence directly upon both individuals as well as upon the regional units.',
    '<b>Parliamentary monarchy</b> - a state headed by a monarch who is not actively involved in policy formation or implementation (i.e., the exercise of sovereign powers by a monarch in a ceremonial capacity); true governmental leadership is carried out by a cabinet and its head - a prime minister, premier, or chancellor - who are drawn from a legislature (parliament).',
    '<b>Republic</b> - a representative democracy in which the people\'s elected deputies (representatives), not the people themselves, vote on legislation.'
];

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <>
        <ListGrid ID="countryList" data={countryData} cellHeight="32" wrapCells="true" width="500" height="224" hoverWidth="300">
            <fields>
                <LGField name="countryCode" type="image" title="Flag" width="65" imageURLPrefix="flags/24/" imageURLSuffix=".png"/>
                <LGField name="countryName" title="Country" width="120"/>
                <LGField name="government" title="Government" showHover="true" hoverHTML={onGovernmentHoverHTML}/>
            </fields>
        </ListGrid>

        <IButton radioGroup="canHover" actionType="radio" title="Show Hover on every cell" width="250" top="250" click={onShowHoverOnEveryCellClick}/>

        <IButton selected="true" radioGroup="canHover" actionType="radio" title="Show Hover on &lt;i&gt;Government&lt;/i&gt; cells only" width="250" top="300" click={onShowHoverOn_i_Government__i_CellsOnlyClick}/>

        <IButton radioGroup="canHover" actionType="radio" title="Suppress all cell hovers" width="250" top="350" click={onSuppressAllCellHoversClick}/>
    </>,
    document.getElementById(target)
);
