import React from 'react';
import { CanvasItem, CanvasItemProps } from './CanvasItem';
import { AsComponentXML } from './core/ReactComponent';


declare interface FileUploadItemProps extends CanvasItemProps {

/**
 * See {@link isc.FileUploadItem.canvasConstructor FileUploadItem.canvasConstructor}.
 */
canvasConstructor?: string;

/**
 * See {@link isc.FileUploadItem.endProcessing() FileUploadItem.endProcessing()}.
 */
endProcessing?: Function;

/**
 * See {@link isc.FileUploadItem.cancelButtonTitle FileUploadItem.cancelButtonTitle}.
 */
cancelButtonTitle?: string;

/**
 * See {@link isc.FileUploadItem.multipleFilesErrorMessage FileUploadItem.multipleFilesErrorMessage}.
 */
multipleFilesErrorMessage?: string;

/**
 * See {@link isc.FileUploadItem.canvasProperties FileUploadItem.canvasProperties}.
 */
canvasProperties?: FileDropZone;

/**
 * See {@link isc.FileUploadItem.emptyDropAreaMessage FileUploadItem.emptyDropAreaMessage}.
 */
emptyDropAreaMessage?: string;

/**
 * See {@link isc.FileUploadItem.processingMessage FileUploadItem.processingMessage}.
 */
processingMessage?: string;

/**
 * See {@link isc.FileUploadItem.duplicateFileNameMessage FileUploadItem.duplicateFileNameMessage}.
 */
duplicateFileNameMessage?: string;

/**
 * See {@link isc.FileUploadItem.showCancelButton FileUploadItem.showCancelButton}.
 */
showCancelButton?: boolean;

/**
 * See {@link isc.FileUploadItem.getSize() FileUploadItem.getSize()}.
 */
getSize?: Function;

/**
 * See {@link isc.FileUploadItem.getFiles() FileUploadItem.getFiles()}.
 */
getFiles?: Function;

/**
 * See {@link isc.FileUploadItem.minSize FileUploadItem.minSize}.
 */
minSize?: number;

/**
 * See {@link isc.FileUploadItem.thumbnailWidth FileUploadItem.thumbnailWidth}.
 */
thumbnailWidth?: number;

/**
 * See {@link isc.FileUploadItem.maxFileSizeErrorMessage FileUploadItem.maxFileSizeErrorMessage}.
 */
maxFileSizeErrorMessage?: string;

/**
 * See {@link isc.FileUploadItem.maxSize FileUploadItem.maxSize}.
 */
maxSize?: number;

/**
 * See {@link isc.FileUploadItem.showImagePreviews FileUploadItem.showImagePreviews}.
 */
showImagePreviews?: boolean;

/**
 * See {@link isc.FileUploadItem.canAddFilesOnClick FileUploadItem.canAddFilesOnClick}.
 */
canAddFilesOnClick?: boolean;

/**
 * See {@link isc.FileUploadItem.replaceFilesOnDrop FileUploadItem.replaceFilesOnDrop}.
 */
replaceFilesOnDrop?: boolean;

/**
 * See {@link isc.FileUploadItem.invalidFileTypeMessage FileUploadItem.invalidFileTypeMessage}.
 */
invalidFileTypeMessage?: string;

/**
 * See {@link isc.FileUploadItem.showFileThumbnails FileUploadItem.showFileThumbnails}.
 */
showFileThumbnails?: boolean;

/**
 * See {@link isc.FileUploadItem.getDataSource() FileUploadItem.getDataSource()}.
 */
getDataSource?: Function;

/**
 * See {@link isc.FileUploadItem.minSizeErrorMessage FileUploadItem.minSizeErrorMessage}.
 */
minSizeErrorMessage?: string;

/**
 * See {@link isc.FileUploadItem.startProcessing() FileUploadItem.startProcessing()}.
 */
startProcessing?: Function;

/**
 * See {@link isc.FileUploadItem.clickToAddMessage FileUploadItem.clickToAddMessage}.
 */
clickToAddMessage?: string;

/**
 * See {@link isc.FileUploadItem.dataSource FileUploadItem.dataSource}.
 */
dataSource?: DataSource;

/**
 * See {@link isc.FileUploadItem.thumbnailHeight FileUploadItem.thumbnailHeight}.
 */
thumbnailHeight?: number;

/**
 * See {@link isc.FileUploadItem.setFileProgress() FileUploadItem.setFileProgress()}.
 */
setFileProgress?: Function;

/**
 * See {@link isc.FileUploadItem.setProcessingProgress() FileUploadItem.setProcessingProgress()}.
 */
setProcessingProgress?: Function;

/**
 * See {@link isc.FileUploadItem.maxFileSize FileUploadItem.maxFileSize}.
 */
maxFileSize?: number;

/**
 * See {@link isc.FileUploadItem.canvasDefaults FileUploadItem.canvasDefaults}.
 */
canvasDefaults?: Object;

/**
 * See {@link isc.FileUploadItem.maxSizeErrorMessage FileUploadItem.maxSizeErrorMessage}.
 */
maxSizeErrorMessage?: string;

/**
 * See {@link isc.FileUploadItem.cancelProcessing() FileUploadItem.cancelProcessing()}.
 */
cancelProcessing?: Function;

/**
 * See {@link isc.FileUploadItem.maxFiles FileUploadItem.maxFiles}.
 */
maxFiles?: number;

/**
 * See {@link isc.FileUploadItem.multiple FileUploadItem.multiple}.
 */
multiple?: boolean;

/**
 * See {@link isc.FileUploadItem.maxFilesErrorMessage FileUploadItem.maxFilesErrorMessage}.
 */
maxFilesErrorMessage?: string;

/**
 * See {@link isc.FileUploadItem.acceptedFileTypes FileUploadItem.acceptedFileTypes}.
 */
acceptedFileTypes?: string[];


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * FileUploadItem wraps the SmartClient widget class
 * {@link isc.FileUploadItem FileUploadItem} for React, allowing you to import
 * FileUploadItem for use in React JS and JSX.
 * @class
 * @extends CanvasItem
 */
declare class FileUploadItem extends CanvasItem {
    props: AsComponentXML<FileUploadItemProps>;
}
