import React from 'react';
import { Task, TaskProps } from './Task';
import { AsComponentXML } from './core/ReactComponent';


declare interface CoTTaskProps extends TaskProps {

/**
 * See {@link isc.CoTTask.maxRetries CoTTask.maxRetries}.
 */
maxRetries?: number;

/**
 * See {@link isc.CoTTask.outputFields CoTTask.outputFields}.
 */
outputFields?: Field[];

/**
 * See {@link isc.CoTTask.stateUpdates CoTTask.stateUpdates}.
 */
stateUpdates?: Object | string;

/**
 * See {@link isc.CoTTask.getPromptContext() CoTTask.getPromptContext()}.
 */
getPromptContext?: Function;

/**
 * See {@link isc.CoTTask.outputDS CoTTask.outputDS}.
 */
outputDS?: DataSource | string;

/**
 * See {@link isc.CoTTask.transitions CoTTask.transitions}.
 */
transitions?: CoTTransition[];

/**
 * See {@link isc.CoTTask.errorsPrimer CoTTask.errorsPrimer}.
 */
errorsPrimer?: string;

/**
 * See {@link isc.CoTTask.prompt CoTTask.prompt}.
 */
prompt?: string;

/**
 * See {@link isc.CoTTask.mockOutput() CoTTask.mockOutput()}.
 */
mockOutput?: Function;

/**
 * See {@link isc.CoTTask.mockMode CoTTask.mockMode}.
 */
mockMode?: boolean;

/**
 * See {@link isc.CoTTask.processOutputs() CoTTask.processOutputs()}.
 */
processOutputs?: Function;

/**
 * See {@link isc.CoTTask.description CoTTask.description}.
 */
description?: string;

/**
 * See {@link isc.CoTTask.taskPrompt CoTTask.taskPrompt}.
 */
taskPrompt?: string;

/**
 * See {@link isc.CoTTask.title CoTTask.title}.
 */
title?: string;

/**
 * See {@link isc.CoTTask.aiEngineId CoTTask.aiEngineId}.
 */
aiEngineId?: string;

/**
 * See {@link isc.CoTTask.noHistory CoTTask.noHistory}.
 */
noHistory?: boolean;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * CoTTask wraps the SmartClient widget class
 * {@link isc.CoTTask CoTTask} for React, allowing you to import
 * CoTTask for use in React JS and JSX.
 * @class
 * @extends Task
 */
declare class CoTTask extends Task {
    props: AsComponentXML<CoTTaskProps>;
}
