import React from 'react';
import { Label, LabelProps } from './Label';
import { AsComponentXML } from './core/ReactComponent';


declare interface DropZoneProps extends LabelProps {

/**
 * See {@link isc.DropZone.baseStyle DropZone.baseStyle}.
 */
baseStyle?: string;

/**
 * See {@link isc.DropZone.acceptedFileTypes DropZone.acceptedFileTypes}.
 */
acceptedFileTypes?: string[];

/**
 * See {@link isc.DropZone.canDropFiles DropZone.canDropFiles}.
 */
canDropFiles?: boolean;

/**
 * See {@link isc.DropZone.contentDrop() DropZone.contentDrop()}.
 */
contentDrop?: Function;

/**
 * See {@link isc.DropZone.align DropZone.align}.
 */
align?: string;

/**
 * See {@link isc.DropZone.canDropContent DropZone.canDropContent}.
 */
canDropContent?: boolean;

/**
 * See {@link isc.DropZone.valign DropZone.valign}.
 */
valign?: string;

/**
 * See {@link isc.DropZone.fileDrop() DropZone.fileDrop()}.
 */
fileDrop?: Function;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * DropZone wraps the SmartClient widget class
 * {@link isc.DropZone DropZone} for React, allowing you to import
 * DropZone for use in React JS and JSX.
 * @class
 * @extends Label
 */
declare class DropZone extends Label {
    props: AsComponentXML<DropZoneProps>;
}
