/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.io.ByteCountingOutputStream;
import com.isomorphic.io.IByteCounter;
import com.isomorphic.log.Logger;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class ISCFileItem
implements FileItem<ISCFileItem> {
    private static Logger log = new Logger(ISCFileItem.class.getName());
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    String fieldName;
    String contentType;
    boolean isFormField;
    String fileName;
    private FileItemHeaders headers;
    private DeferredFileOutputStream dfos;
    private OutputStream os;
    IByteCounter byteCounter;
    private int sizeThreshold = 10240;
    private Path tempDirectory;
    long expectedSize = -1L;
    String shortFileName;

    public static Builder builder() {
        return new Builder();
    }

    public ISCFileItem(String fieldName) {
        this.fieldName = fieldName;
    }

    public ISCFileItem(String fieldName, String contentType, boolean isFormField, String fileName, IByteCounter byteCounter) {
        this(fieldName, contentType, isFormField, fileName, byteCounter, 10240, null);
    }

    public ISCFileItem(String fieldName, String contentType, boolean isFormField, String fileName, IByteCounter byteCounter, int sizeThreshold, Path tempDirectory) {
        this(fieldName);
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.byteCounter = byteCounter;
        this.sizeThreshold = sizeThreshold;
        this.tempDirectory = tempDirectory;
    }

    public ISCFileItem delete() {
        File tempFile;
        if (this.dfos != null && !this.dfos.isInMemory() && (tempFile = this.dfos.getFile()) != null && tempFile.exists() && !tempFile.delete()) {
            log.warn("Failed to delete temp file: " + tempFile.getAbsolutePath());
        }
        return this;
    }

    public byte[] get() {
        byte[] byArray;
        if (this.dfos == null) {
            return new byte[0];
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData();
        }
        File tempFile = this.dfos.getFile();
        if (tempFile == null || !tempFile.exists()) {
            return new byte[0];
        }
        FileInputStream fis = new FileInputStream(tempFile);
        try {
            byte[] data = new byte[(int)tempFile.length()];
            int bytesRead = 0;
            for (int offset = 0; offset < data.length && (bytesRead = fis.read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
            }
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error((Object)"Error reading uploaded file from disk", e);
                return new byte[0];
            }
        }
        fis.close();
        return byArray;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ISCFileItem setFieldName(String name) {
        this.fieldName = name;
        return this;
    }

    public String getName() {
        return this.fileName;
    }

    public InputStream getInputStream() {
        if (this.dfos == null) {
            return null;
        }
        if (this.dfos.isInMemory()) {
            byte[] data = this.dfos.getData();
            if (data != null && data.length > 0) {
                return new ByteArrayInputStream(data);
            }
            return null;
        }
        File tempFile = this.dfos.getFile();
        if (tempFile == null || !tempFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Temp file not found: " + tempFile.getAbsolutePath()), e);
            return null;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            File tempDir = this.tempDirectory != null ? this.tempDirectory.toFile() : null;
            String prefix = "isc_upload_";
            String suffix = ".tmp";
            this.dfos = DeferredFileOutputStream.builder().setThreshold(this.sizeThreshold).setDirectory(tempDir).setPrefix(prefix).setSuffix(suffix).get();
            this.os = this.dfos;
            if (this.byteCounter != null) {
                this.os = new ByteCountingOutputStream((OutputStream)this.dfos, this.byteCounter);
            }
        }
        return this.os;
    }

    public long getSize() {
        if (this.dfos == null) {
            return 0L;
        }
        if (this.dfos.isInMemory()) {
            byte[] data = this.dfos.getData();
            return data != null ? (long)data.length : 0L;
        }
        File tempFile = this.dfos.getFile();
        return tempFile != null ? tempFile.length() : 0L;
    }

    public String getString() {
        return new String(this.get());
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString(Charset encoding) throws UnsupportedEncodingException {
        return this.getString(encoding.name());
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public ISCFileItem setFormField(boolean state) {
        this.isFormField = state;
        return this;
    }

    public boolean isInMemory() {
        return this.dfos == null || this.dfos.isInMemory();
    }

    public File getTempFile() {
        if (this.dfos != null && !this.dfos.isInMemory()) {
            return this.dfos.getFile();
        }
        return null;
    }

    public ISCFileItem write(File file) throws IOException {
        IOUtil.atomicWrite(this.getInputStream(), file);
        return this;
    }

    public ISCFileItem write(Path file) throws IOException {
        this.write(file.toFile());
        return this;
    }

    public void setTotalSize(long size) {
        this.expectedSize = size;
    }

    public long getTotalSize() {
        if (this.expectedSize == -1L && this.byteCounter != null) {
            this.setTotalSize(this.byteCounter.getTotalBytes());
        }
        return this.expectedSize;
    }

    public String getFileName() {
        return this.getName();
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getShortFileName() {
        return this.shortFileName;
    }

    public void setShortFileName(String name) {
        this.shortFileName = name;
    }

    public void setErrors(List<?> errors) {
        this.byteCounter.setErrors(errors);
    }

    public List<?> getErrors() {
        return this.byteCounter.getErrors();
    }

    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    public ISCFileItem setHeaders(FileItemHeaders headers) {
        this.headers = headers;
        return this;
    }

    public static class Builder
    extends FileItemFactory.AbstractFileItemBuilder<ISCFileItem, Builder> {
        IByteCounter byteCounter;
        int sizeThreshold = 10240;
        Path tempDirectory;

        public Builder() {
            this.setCharset(StandardCharsets.ISO_8859_1);
            this.setCharsetDefault(DEFAULT_CHARSET);
        }

        public ISCFileItem get() {
            ISCFileItem iscFileItem = new ISCFileItem(this.getFieldName(), this.getContentType(), this.isFormField(), this.getFileName(), this.getByteCounter(), this.sizeThreshold, this.tempDirectory);
            FileItemHeaders headers = this.getFileItemHeaders();
            if (headers != null) {
                iscFileItem.setHeaders(headers);
            }
            return iscFileItem;
        }

        public IByteCounter getByteCounter() {
            return this.byteCounter;
        }

        public Builder setByteCounter(IByteCounter byteCounter) {
            this.byteCounter = byteCounter;
            return this;
        }

        public int getSizeThreshold() {
            return this.sizeThreshold;
        }

        public Builder setSizeThreshold(int sizeThreshold) {
            this.sizeThreshold = sizeThreshold;
            return this;
        }

        public Path getTempDirectory() {
            return this.tempDirectory;
        }

        public Builder setTempDirectory(Path tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }
    }
}

