/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.SubqueryMetadata;
import com.isomorphic.datasource.SummaryFunctions;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InMemorySubqueryResolver
implements SubqueryResolver {
    private static Logger log = new Logger(InMemorySubqueryResolver.class);
    private Map<String, List<Map>> dataSets;
    private BasicDataSource parentDS;

    public InMemorySubqueryResolver(Map<String, List<Map>> dataSets, BasicDataSource parentDS) {
        this.dataSets = dataSets;
        this.parentDS = parentDS;
    }

    @Override
    public Map resolveSubquery(Map subqueryConfig, boolean isFieldQuery) throws Exception {
        List<Map> filtered;
        String dsName = (String)subqueryConfig.get("dataSource");
        if (dsName == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query does not specify a dataSource");
        }
        BasicDataSource subDs = (BasicDataSource)DataSourceManager.get(dsName);
        if (subDs == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query specifies dataSource '" + dsName + "', which is not known");
        }
        List<Map> data = this.dataSets.get(dsName);
        if (data == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query references dataSource '" + dsName + "', but no in-memory data was provided for it");
        }
        Object subCriteria = subqueryConfig.get("criteria");
        if (subCriteria instanceof Map) {
            InMemorySubqueryResolver nested = new InMemorySubqueryResolver(this.dataSets, subDs);
            AdvancedCriteria.resolveSubqueries((Map)subCriteria, nested);
        }
        if (subCriteria != null) {
            AdvancedCriteria ac;
            Object criteriaToUse = subCriteria;
            if (subCriteria instanceof Map) {
                Map subCriteriaMap = (Map)subCriteria;
                boolean hasCriterionStructure = subCriteriaMap.containsKey("fieldName") || subCriteriaMap.containsKey("fieldQuery") || subCriteriaMap.containsKey("criteria");
                boolean isAlreadyAC = "AdvancedCriteria".equals(subCriteriaMap.get("_constructor"));
                if (hasCriterionStructure && !isAlreadyAC) {
                    HashMap<String, Object> wrapper = new HashMap<String, Object>();
                    wrapper.put("_constructor", "AdvancedCriteria");
                    wrapper.put("operator", "and");
                    ArrayList<Map> criteriaList = new ArrayList<Map>();
                    criteriaList.add(subCriteriaMap);
                    wrapper.put("criteria", criteriaList);
                    criteriaToUse = wrapper;
                }
            }
            filtered = (ac = AdvancedCriteria.fromCollections(criteriaToUse)) != null ? ac.filter(data) : new ArrayList<Map>(data);
        } else {
            filtered = new ArrayList<Map>(data);
        }
        SubqueryMetadata meta = SubqueryMetadata.fromConfig(subqueryConfig, subDs, this.parentDS, true);
        Map sf = (Map)subqueryConfig.get("summaryFunctions");
        ArrayList<String> groupBy = this.getGroupByList(subqueryConfig);
        if (sf != null && !sf.isEmpty() && meta.joinToParentDS && (groupBy == null || groupBy.isEmpty())) {
            groupBy = new ArrayList<String>();
            groupBy.add(meta.fromFieldName);
        }
        if (groupBy != null && !groupBy.isEmpty()) {
            filtered = this.applyGroupByAndAggregation(filtered, groupBy, sf, subDs);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fromFieldName", meta.fromFieldName);
        result.put("toFieldName", meta.toFieldName);
        result.put("records", filtered);
        result.put("subqueryOutputField", meta.outputFieldName);
        return result;
    }

    private List getGroupByList(Map subqueryConfig) {
        Object groupByObj = subqueryConfig.get("groupBy");
        if (groupByObj == null) {
            return null;
        }
        if (groupByObj instanceof List) {
            return (List)groupByObj;
        }
        ArrayList groupBy = new ArrayList();
        groupBy.add(groupByObj);
        return groupBy;
    }

    private List<Map> applyGroupByAndAggregation(List<Map> records, List groupBy, Map<String, String> summaryFunctions, BasicDataSource ds) throws Exception {
        LinkedHashMap<String, ArrayList<Map>> groups = new LinkedHashMap<String, ArrayList<Map>>();
        for (Map record : records) {
            StringBuilder keyBuilder = new StringBuilder();
            for (Object gbField : groupBy) {
                Object val = record.get(gbField);
                keyBuilder.append(val == null ? "null" : val.toString()).append("\u0000");
            }
            String key = keyBuilder.toString();
            ArrayList<Map> group = (ArrayList<Map>)groups.get(key);
            if (group == null) {
                group = new ArrayList<Map>();
                groups.put(key, group);
            }
            group.add(record);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        for (List group : groups.values()) {
            HashMap<Object, Object> outputRecord = new HashMap<Object, Object>();
            Map firstRecord = (Map)group.get(0);
            for (Object e : groupBy) {
                outputRecord.put(e, firstRecord.get(e));
            }
            if (summaryFunctions != null) {
                for (Map.Entry entry : summaryFunctions.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    String funcName = ((String)entry.getValue()).toLowerCase();
                    DSField field = ds.getField(fieldName);
                    if (field == null) {
                        log.warn("Summary function specified for field '" + fieldName + "' but DataSource '" + ds.getID() + "' has no such field");
                        continue;
                    }
                    try {
                        Object aggValue = SummaryFunctions.applySummaryFunction(group, ds, field, funcName);
                        outputRecord.put(fieldName, aggValue);
                    }
                    catch (SummaryFunctions.SummaryFunctionException e) {
                        log.warn("Error applying summary function '" + funcName + "' to field '" + fieldName + "': " + e.getMessage());
                        outputRecord.put(fieldName, null);
                    }
                }
            }
            result.add(outputRecord);
        }
        return result;
    }
}

