/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.MemoryDataSource;
import com.isomorphic.datasource.MemoryStore;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.xml.XML;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class FileDataSource
extends MemoryDataSource {
    private static Logger log = new Logger(FileDataSource.class.getName());

    @Override
    public void initRequest(DSRequest dsRequest) throws Exception {
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        String fileName = serverConfig.getString("fileName");
        if (fileName == null) {
            throw new Exception("You must define a fileName");
        }
        String dataFormat = serverConfig.getString("dataFormat", this.getConfig().getString("dataFormat"));
        if (dataFormat == null) {
            dataFormat = "json";
        }
        if (!"xml".equals(dataFormat) && !"json".equals(dataFormat)) {
            throw new Exception("Unsupported dataFormat: " + dataFormat);
        }
        this.getConfig().put("tableName", fileName);
        super.initRequest(dsRequest);
    }

    @Override
    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeRemove(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeCustom(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeReplace(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeDownload(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DSResponse processRequest(DSRequest dsRequest) throws Exception {
        this.initRequest(dsRequest);
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        String fileName = serverConfig.getString("fileName");
        String storeName = fileName.intern();
        String dataFormat = serverConfig.getString("dataFormat", this.getConfig().getString("dataFormat"));
        if (dataFormat == null) {
            dataFormat = "json";
        }
        String opType = dsRequest.getOperationType();
        DataSource dataSource = dsRequest.getDataSource();
        String string = storeName;
        synchronized (string) {
            DSResponse dsResponse;
            MemoryStore.deleteStore(storeName);
            MemoryStore.createStore(storeName, dataSource);
            Collection data = null;
            ISCFile iscFile = ISCFile.newInstance(fileName);
            if (iscFile.exists() && iscFile.length() != 0L) {
                Reader reader = iscFile.getReader();
                if ("json".equals(dataFormat)) {
                    data = (Collection)JSTranslater.instance().fromJS(iscFile.getReader());
                } else if ("xml".equals(dataFormat)) {
                    data = (Collection)XML.toDSRecords(iscFile);
                }
            } else {
                log.info("Will create: " + fileName);
                data = new ArrayList();
            }
            for (Map row : data) {
                MemoryStore.insert(storeName, row);
            }
            if (FileDataSource.isAdd(opType)) {
                dsResponse = super.executeAdd(dsRequest);
            } else if (FileDataSource.isUpdate(opType)) {
                dsResponse = super.executeUpdate(dsRequest);
            } else if (FileDataSource.isFetch(opType)) {
                dsResponse = super.executeFetch(dsRequest);
            } else if (FileDataSource.isRemove(opType)) {
                dsResponse = super.executeRemove(dsRequest);
            } else {
                throw new Exception("Operation: " + opType + " not supported");
            }
            if (!FileDataSource.isFetch(opType) || serverConfig.getBoolean((Object)"storeOnFetch", false)) {
                Collection<Map<String, Object>> store = MemoryStore.getStore(storeName);
                Writer writer = iscFile.getWriter();
                if ("json".equals(dataFormat)) {
                    JSTranslater.instance().enablePrettyPrinting().toJS(store, writer);
                } else if ("xml".equals(dataFormat)) {
                    XML.collectionsToXML(writer, store, "records");
                }
                writer.close();
            }
            MemoryStore.deleteStore(storeName);
            return dsResponse;
        }
    }
}

