/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.RestConnector;
import com.isomorphic.log.Logger;
import com.isomorphic.util.SimpleHttpResponse;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FTSOpenSearchConnector
extends RestConnector {
    private static Logger log = new Logger(FTSOpenSearchConnector.class.getName());
    private static Config config = Config.getGlobal();
    private static final String PROP_PREFIX = "fullText.openSearch.";
    private String currentTargetPrimaryKeyField;
    private String currentTargetFieldName;

    private static String getOpenSearchEndpoint() {
        String host = System.getenv("DEV_OPENSEARCH_HOST");
        String port = System.getenv("DEV_OPENSEARCH_HTTP_PORT");
        if (host != null && !host.isEmpty()) {
            if (port == null || port.isEmpty()) {
                port = "9200";
            }
            return "http://" + host + ":" + port;
        }
        return config.getString("fullText.openSearch.endpoint", "http://localhost:9200");
    }

    @Override
    protected DSResponse processRequest(DSRequest dsRequest, boolean skipExecution, RestConnector.RESTRequestElements elements) throws Exception {
        String targetDataSourceId;
        HashMap criteria = dsRequest.getCriteria();
        if (criteria == null) {
            criteria = new HashMap();
        }
        if ((targetDataSourceId = (String)criteria.get("targetDataSourceId")) == null) {
            throw new Exception("FTSOpenSearchConnector requires targetDataSourceId in criteria");
        }
        this.currentTargetPrimaryKeyField = (String)criteria.get("targetPrimaryKeyField");
        this.currentTargetFieldName = (String)criteria.get("targetFieldName");
        String endpoint = FTSOpenSearchConnector.getOpenSearchEndpoint();
        String indexName = targetDataSourceId.toLowerCase() + "_fts";
        String dynamicUrl = endpoint + "/" + indexName + "/_search";
        dsRequest.setAttribute("_ftsOpenSearchUrl", dynamicUrl);
        log.debug("FTS OpenSearch URL: " + dynamicUrl);
        return super.processRequest(dsRequest, skipExecution, elements);
    }

    @Override
    public DataTypeMap getServerConfig(DSRequest dsRequest) throws Exception {
        DataTypeMap serverConfig = super.getServerConfig(dsRequest);
        String dynamicUrl = (String)dsRequest.getAttribute("_ftsOpenSearchUrl");
        if (dynamicUrl != null) {
            serverConfig.put("dataURL", dynamicUrl);
        }
        String username = config.getString("fullText.openSearch.username");
        String password = config.getString("fullText.openSearch.password");
        if (username != null && !username.isEmpty()) {
            String auth = username + ":" + (password != null ? password : "");
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes("UTF-8"));
            DataTypeMap<String, CallSite> headers = (DataTypeMap<String, CallSite>)((Object)serverConfig.get("headers"));
            if (headers == null) {
                headers = new DataTypeMap<String, CallSite>();
                serverConfig.put("headers", headers);
            }
            headers.put("Authorization", (CallSite)((Object)("Basic " + encodedAuth)));
        }
        return serverConfig;
    }

    @Override
    public void applyValuesOrCriteriaToRequest(Map outboundData, DSRequest dsRequest) throws Exception {
        HashMap criteria = dsRequest.getCriteria();
        if (criteria == null) {
            criteria = new HashMap();
        }
        String targetFieldName = (String)criteria.get("targetFieldName");
        String queryText = (String)criteria.get("queryText");
        String operator = (String)criteria.get("operator");
        boolean wantSnippets = Boolean.TRUE.equals(criteria.get("wantSnippets"));
        boolean wantHighlights = Boolean.TRUE.equals(criteria.get("wantHighlights"));
        Long startRow = criteria.get("startRow") instanceof Number ? ((Number)criteria.get("startRow")).longValue() : 0L;
        Long endRow = criteria.get("endRow") instanceof Number ? ((Number)criteria.get("endRow")).longValue() : 75L;
        outboundData.put("from", startRow);
        outboundData.put("size", endRow - startRow);
        Object searchField = targetFieldName != null ? targetFieldName + "_content" : "_all";
        Map<String, Object> query = this.buildQuery((String)searchField, queryText, operator);
        outboundData.put("query", query);
        if (wantSnippets || wantHighlights) {
            outboundData.put("highlight", this.buildHighlightConfig((String)searchField));
        }
    }

    private Map<String, Object> buildQuery(String field, String queryText, String operator) {
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>();
        String normalizedOp = this.normalizeOperator(operator);
        if ("phrase".equals(normalizedOp) || "equals".equals(normalizedOp)) {
            LinkedHashMap<String, String> phraseQuery = new LinkedHashMap<String, String>();
            phraseQuery.put(field, queryText);
            query.put("match_phrase", phraseQuery);
        } else if ("near".equals(normalizedOp)) {
            int slop = config.getInteger((Object)"fullText.openSearch.nearSlop", 10);
            LinkedHashMap<String, Object> phraseConfig = new LinkedHashMap<String, Object>();
            phraseConfig.put("query", queryText);
            phraseConfig.put("slop", slop);
            LinkedHashMap<String, LinkedHashMap<String, Object>> phraseQuery = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            phraseQuery.put(field, phraseConfig);
            query.put("match_phrase", phraseQuery);
        } else if ("fuzzy".equals(normalizedOp)) {
            LinkedHashMap<String, String> matchConfig = new LinkedHashMap<String, String>();
            matchConfig.put("query", queryText);
            matchConfig.put("fuzziness", config.getString("fullText.openSearch.fuzziness", "AUTO"));
            LinkedHashMap<String, LinkedHashMap<String, String>> matchQuery = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            matchQuery.put(field, matchConfig);
            query.put("match", matchQuery);
        } else if ("prefixMatch".equals(normalizedOp) || "startsWith".equals(normalizedOp)) {
            LinkedHashMap<String, String> prefixQuery = new LinkedHashMap<String, String>();
            prefixQuery.put(field, queryText.toLowerCase());
            query.put("prefix", prefixQuery);
        } else {
            if ("endsWith".equals(normalizedOp) || "containsPattern".equals(normalizedOp) || "matchesPattern".equals(normalizedOp)) {
                log.warn("Operator '" + operator + "' not supported by OpenSearch provider, falling back to contains");
            }
            LinkedHashMap<String, String> matchQuery = new LinkedHashMap<String, String>();
            matchQuery.put(field, queryText);
            query.put("match", matchQuery);
        }
        return query;
    }

    private String normalizeOperator(String operator) {
        if (operator == null) {
            return "contains";
        }
        if (operator.startsWith("i") && operator.length() > 1 && Character.isUpperCase(operator.charAt(1))) {
            return Character.toLowerCase(operator.charAt(1)) + operator.substring(2);
        }
        return operator;
    }

    private Map<String, Object> buildHighlightConfig(String field) {
        LinkedHashMap<String, Object> highlight = new LinkedHashMap<String, Object>();
        highlight.put("pre_tags", Arrays.asList(config.getString("fullText.openSearch.highlightPreTag", "<em>")));
        highlight.put("post_tags", Arrays.asList(config.getString("fullText.openSearch.highlightPostTag", "</em>")));
        LinkedHashMap<String, Integer> fieldConfig = new LinkedHashMap<String, Integer>();
        fieldConfig.put("fragment_size", config.getInteger((Object)"fullText.openSearch.fragmentSize", 150));
        fieldConfig.put("number_of_fragments", config.getInteger((Object)"fullText.openSearch.numberOfFragments", 3));
        LinkedHashMap<String, LinkedHashMap<String, Integer>> fields = new LinkedHashMap<String, LinkedHashMap<String, Integer>>();
        fields.put(field, fieldConfig);
        highlight.put("fields", fields);
        return highlight;
    }

    @Override
    protected void onHttpResponseParsed(String opType, DataTypeMap serverConfig, SimpleHttpResponse httpResponse, Object responseData) {
        if (!(responseData instanceof Map)) {
            return;
        }
        Map response = (Map)responseData;
        Map hitsWrapper = (Map)response.get("hits");
        if (hitsWrapper == null) {
            return;
        }
        Object hitsObj = hitsWrapper.get("hits");
        if (!(hitsObj instanceof List)) {
            return;
        }
        List hits = (List)hitsObj;
        for (Object hitObj : hits) {
            Map highlight;
            if (!(hitObj instanceof Map)) continue;
            Map hit = (Map)hitObj;
            Map source = (Map)hit.get("_source");
            Object id = null;
            if (source != null && this.currentTargetPrimaryKeyField != null) {
                id = source.get(this.currentTargetPrimaryKeyField);
            }
            if (id == null && source != null) {
                id = source.get("id");
            }
            if (id == null) {
                id = hit.get("_id");
            }
            hit.put("id", id);
            if (hit.get("_score") != null) {
                hit.put("score", hit.get("_score"));
            }
            if (this.currentTargetFieldName != null) {
                hit.put("sourceField", this.currentTargetFieldName);
            }
            if ((highlight = (Map)hit.get("highlight")) == null || highlight.isEmpty()) continue;
            for (Object fragments : highlight.values()) {
                if (!(fragments instanceof List) || ((List)fragments).isEmpty()) continue;
                hit.put("snippet", ((List)fragments).get(0));
                hit.put("snippets", fragments);
                break;
            }
            hit.put("highlights", highlight);
        }
    }
}

