/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InformixDriver
extends SQLDriver {
    private static Logger log = new Logger(InformixDriver.class.getName());
    private static final Map<String, String> formulaReplacements;
    private static final SQLDriver.FormulaConfig formulaConfig;

    public InformixDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return this.getDatabaseMajorVersion() > 11 || this.getDatabaseMajorVersion() == 11 && this.getDatabaseMinorVersion() >= 5;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        String selectToken;
        Object q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? (String)q + " ORDER BY " : (String)q + ", ";
            q = (String)q + computedOrderClause;
        }
        if (!"SELECT".equalsIgnoreCase(selectToken = ((String)q).substring(0, "SELECT".length()))) {
            return q;
        }
        return "SELECT SKIP " + startRow + " FIRST " + batchSize + ((String)q).substring("SELECT".length());
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        log.debug((Object)("fetchLastRow data - primaryKeysPresent: " + primaryKeysPresent.toString() + "sequencesNotPresent: " + sequencesNotPresent.toString()));
        if (sequencesNotPresent.size() > 1) {
            throw new Exception("Informix can't handle more than one SERIAL primaryKey");
        }
        if (this.dbConnection == null && req == null) {
            throw new Exception("no connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        if (!sequencesNotPresent.isEmpty()) {
            String sequenceName = (String)sequencesNotPresent.get(0);
            throw new Exception("Sequence value missing for field " + sequenceName);
        }
        return primaryKeys;
    }

    @Override
    public void saveGeneratedKeys(Statement s, DSRequest req) throws Exception {
        SQLDataSource ds = (SQLDataSource)req.getDataSource();
        List pkNames = ds.getPrimaryKeys();
        String pkName = null;
        int count = 0;
        Iterator i = pkNames.iterator();
        while (i.hasNext()) {
            DSField pk = ds.getField((String)i.next());
            if (!"sequence".equals(pk.getType())) continue;
            ++count;
            pkName = pk.getName();
        }
        if (count != 1) {
            return;
        }
        if (!this.supportsGetGeneratedKeys(s.getConnection(), req.getDataSource())) {
            Method method = null;
            try {
                method = Reflection.findMethod((Object)s, (String)"getSerial8");
            }
            catch (NoSuchMethodException pk) {
                // empty catch block
            }
            if (method == null) {
                log.warn((Object)("Unable to retrieve last inserted PK value - Statement of class " + s.getClass().getName() + " does not implement a getSerial8() method"));
                return;
            }
            Object obj = method.invoke((Object)s, new Object[0]);
            if (obj == null || Long.parseLong(obj.toString()) == 0L) {
                method = null;
                try {
                    method = Reflection.findMethod((Object)s, (String)"getSerial");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method == null) {
                    log.warn((Object)("Unable to retrieve last inserted PK value - Statement of class " + s.getClass().getName() + " does not implement a getSerial() method"));
                    return;
                }
                obj = method.invoke((Object)s, new Object[0]);
            }
            if (obj == null) {
                log.warn((Object)"Unable to retrieve last inserted PK value - both getSerial8() and getSerial() returned null");
                return;
            }
            if (!(obj instanceof Integer) && !(obj instanceof Long)) {
                log.warn((Object)("Unable to retrieve last inserted PK value - either getSerial8() or getSerial() returned a " + obj.getClass().getName() + ", expected an Integer or a Long"));
                return;
            }
            long value = Long.parseLong(obj.toString());
            if (value == 0L) {
                log.warn((Object)"Unable to retrieve last inserted PK value - either getSerial8() or getSerial() returned 0, which is a special value meaning 'there was a problem'");
                return;
            }
            HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
            primaryKeys.put(pkName, value);
            req.setLastPrimaryKeys(primaryKeys);
        } else {
            super.saveGeneratedKeys(s, req);
        }
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        Object output = this.escapeColumnName(columnName);
        if (tableName != null) {
            output = tableName + "." + (String)output;
        }
        if (remapName != null && !columnName.equals(remapName)) {
            output = (String)output + " AS " + remapName;
        }
        return output;
    }

    @Override
    protected SQLDriver.FormulaConfig getFormulaConfig() {
        return formulaConfig;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value, false) + "'";
    }

    public String escapeValueForFilter(Object value) {
        return this.escapeValueForFilter(value, null);
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (!escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
        } else {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE_DOUBLE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.utcDateTimeFormatter.format((Date)value);
        }
        return value.toString();
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        return "0";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null && DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"time")) {
            return "CAST(" + result + " AS DATETIME)";
        }
        return super.sqlCast(result, field);
    }

    @Override
    public boolean fieldAssignableInline(DSField field) {
        if (!super.fieldAssignableInline(field)) {
            return false;
        }
        return !"text".equals(field.getType()) || field.getLength() == null || field.getLength() < 32739L;
    }

    @Override
    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    @Override
    public Object transformFieldValue(DSField field, Object obj) {
        if (obj instanceof byte[] && !field.isBinary()) {
            return new String((byte[])obj);
        }
        return obj;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toLowerCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT COUNT(*) FROM systables";
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 255L) {
            return "varchar(" + length + ")";
        }
        if (length < 32739L) {
            return "lvarchar(" + length + ")";
        }
        if (length <= Integer.MAX_VALUE) {
            return "text";
        }
        throw new Exception("Column length > 2GB is not supported by Informix");
    }

    @Override
    public String getFloatType() {
        return "float";
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ceiling", "ceil");
        m.put("max", "greatest");
        m.put("min", "least");
        m.put("pow", "power");
        m.put("random", "rand");
        m.put("len", "length");
        m.put("currentDateTime()", "current");
        m.put("now()", "current");
        formulaReplacements = Collections.synchronizedMap(m);
        formulaConfig = new SQLDriver.FormulaConfig(formulaReplacements);
    }
}

