isc.Label.create({
  ID: "deltaSharingInfo",
  contents: "To explore a specific Delta Sharing source, enter the endpoint and authorization token. The schemas will then be displayed below in a tree view.",
  width: "100%",
  height: 12,
  autoDraw: true
});

isc.DynamicForm.create({
  ID: "profileForm",
  width: "100%",
  titleWidth: 180,
  fields: [
    { name: "endpoint", title: "Delta Sharing Endpoint", value: "https://sharing.delta.io/delta-sharing/", type: "text", width: "100%" },
    { name: "token", title: "Bearer Token", value: "faaie590d541265bcab1f2de9813274bf233", type: "text", width: "100%" }
  ],
});

isc.IButton.create({
  ID: "loadButton",
  title: "Load Catalog",
  click: function loadCatalog() {
    const vals = profileForm.getValues();
    const ds = isc.DataSource.get("deltaShareCatalog");

    ds.fetchData(
      { endpoint: vals.endpoint, token: vals.token },
      function (resp) {
        if (resp.status < 0) {
          const err = (resp.data && resp.data[0] && resp.data[0].error) || "Unknown error";
          isc.warn("Connect error: " + err);
          return;
        }

        const nodes = createFileNodes(resp.data);
        const sharesTree = createFilesTree(nodes);

        if (window.topPane?.addMember) {
          window.topPane.addMember(sharesTree);
        }
      }
    );
  }
});

function createFileNodes(data) {

  let nodes = []

  data.forEach((node) => {
    if (node.type === "file") {

      const folder_node_id = `folder_${node.dsId}`;

      nodes.push({
        id: folder_node_id,
        parentId: node.parentId,
        name: `parquet: ${node.idInFile}`,
        isFolder: true,
      })

      nodes.push({
        id: `id_${node.dsId}`,
        parentId: folder_node_id,
        name: `id: ${node.idInFile}`,
        type: "identificator",
        isFolder: node.isFolder,
      });

      nodes.push({
        id: `file_size_${node.dsId}`,
        parentId: folder_node_id,
        name: `size: ${node.size} bytes`,
        type: "sizeFile",
        isFolder: node.isFolder,
      });

      nodes.push({
        id: `url_${node.dsId}`,
        parentId: folder_node_id,
        name: `url: ${node.name}`,
        type: "name",
        isFolder: node.isFolder,
      });

      nodes.push({
        id: `link_${node.dsId}`,
        dsId: node.dsId,
        parentId: folder_node_id,
        name: "load data",
        type: "url",
        isFolder: node.isFolder,
      });

    } else {
      nodes.push(node);
    }
  })

  return nodes;

}

function createFilesTree(nodes) {

  const tree = isc.Tree.create({
    modelType: "parent",
    idField: "id",
    parentIdField: "parentId",
    rootValue: "root",
    data: nodes
  });

  return isc.TreeGrid.create({
    ID: "shareSchemaTree",
    width: "100%",
    height: 200,
    data: tree,
    showHeader: true,
    nodeIcon: "[SAMPLE]icons/16/log.png",
    fields: [{ name: "name", title: "Shares found: " }],
    nodeClick(_, node) {
      if (node.type === "url") {
        isc.DataSource.load(node.dsId, function () {
          listGridContent.setDataSource(isc.DataSource.get(node.dsId));
          listGridContent.setShowFilterEditor(true);
          listGridContent.fetchData();
        });
      }
    }
  });
}

isc.ListGrid.create({
  ID: "listGridContent",
  width: "100%", height: 400,
  showFilterEditor: true,
});


isc.VLayout.create({
  ID: "bottomPane",
  padding: 12,
  height: "50%",
  width: "100%",
  members: [listGridContent]
});

isc.HLayout.create({
  ID: "getDataShareInfo",
  autoDraw: false,
  width: "100%",
  height: 30,
  membersMargin: 8,
  members: [
    profileForm,
    loadButton
  ]
});

isc.VLayout.create({
  ID: "topPane",
  membersMargin: 8,
  members: [getDataShareInfo, deltaSharingInfo],
  width: "100%",
  height: "50%",
  autoDraw: true
});


isc.VLayout.create({
  ID: "MainPane",
  membersMargin: 8,
  members: [topPane, bottomPane],
  width: "100%",
  height: "50%",
  autoDraw: true
})



