// Custom CanvasItem that renders base64-encoded image data as a data URI
isc.defineClass("Base64ImageItem", "CanvasItem").addProperties({
    shouldSaveValue: false,
    showTitle: false,
    colSpan: "*",
    height: 200,

    canvasConstructor: "HTMLFlow",
    canvasDefaults: {
        overflow: "auto",
        align: "center",
        valign: "center"
    },

    createCanvas : function () {
        var canvas = this.Super("createCanvas", arguments);
        this.updateCanvas();
        return canvas;
    },

    updateCanvas : function () {
        if (!this.canvas) return;

        var record = this.form.getValues(),
            fieldName = this.name,
            base64Data = record[fieldName],
            filenameField = fieldName + "_filename",
            filename = record[filenameField]
        ;

        if (base64Data && isc.isA.String(base64Data) && base64Data.length > 0) {
            // Render the base64 data as a data URI
            var mimeType = this.getMimeType(filename);
            var html = "<img src='data:" + mimeType + ";base64," + base64Data + "' " +
                       "style='max-width:100%;max-height:180px;'>";
            this.canvas.setContents(html);
        } else {
            this.canvas.setContents("No image data");
        }
    },

    getMimeType : function (filename) {
        // Simple mime type detection from filename
        if (!filename) return "image/jpeg";
        var ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
        if (ext == "png") return "image/png";
        if (ext == "gif") return "image/gif";
        if (ext == "svg") return "image/svg+xml";
        if (ext == "jpg" || ext == "jpeg") return "image/jpeg";
        return "image/jpeg";
    },

    setValue : function (newValue) {
        this.Super("setValue", arguments);
        this.updateCanvas();
    }
});

// ListGrid showing thumbnails of base64-encoded images
isc.ListGrid.create({
    ID: "imageGrid",
    width: "50%",
    height: "100%",
    dataSource: "mediaLibraryEncoded",
    autoFetchData: true,
    canEdit: false,

    fields: [
        { name: "title", width: "*" },
        {
            name: "image",
            width: 120,
            formatCellValue: function(value, record, rowNum, colNum) {
                // Render base64 data as thumbnail
                if (isc.isA.String(value) && value.length > 0) {
                    var filename = record.image_filename,
                        mimeType = "image/jpeg";

                    if (filename) {
                        var ext = filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
                        if (ext == "png") mimeType = "image/png";
                        if (ext == "gif") mimeType = "image/gif";
                        if (ext == "svg") mimeType = "image/svg+xml";
                        if (ext == "jpg" || ext == "jpeg") mimeType = "image/jpeg";
                    }

                    return "<img src='data:" + mimeType + ";base64," + value + "' " +
                           "style='max-width:100px;max-height:80px;'>";
                }
                return "";
            }
        }
    ],

    recordClick: function(viewer, record) {
        imageForm.editRecord(record);
    }
});

// DynamicForm with custom CanvasItem for displaying the full-size image
isc.DynamicForm.create({
    ID: "imageForm",
    width: "50%",
    height: "100%",
    dataSource: "mediaLibraryEncoded",
    canEdit: false,

    fields: [
        { name: "title", canEdit: false },
        { name: "image_filename", canEdit: false },
        {
            name: "image",
            editorType: "Base64ImageItem",
            canEdit: false
        }
    ]
});

isc.HLayout.create({
    width: "100%",
    height: "100%",
    members: [imageGrid, imageForm]
});
