import React from 'react';
import { Task, TaskProps } from './Task';
import { AsComponentXML } from './core/ReactComponent';


declare interface DSRequestTaskProps extends TaskProps {

/**
 * See {@link isc.DSRequestTask.passThruOutput DSRequestTask.passThruOutput}.
 */
passThruOutput?: boolean;

/**
 * See {@link isc.DSRequestTask.outputField DSRequestTask.outputField}.
 */
outputField?: string;

/**
 * See {@link isc.DSRequestTask.sort DSRequestTask.sort}.
 */
sort?: SortSpecifier[];

/**
 * See {@link isc.DSRequestTask.values DSRequestTask.values}.
 */
values?: Record;

/**
 * See {@link isc.DSRequestTask.fixedValues DSRequestTask.fixedValues}.
 */
fixedValues?: Record;

/**
 * See {@link isc.DSRequestTask.criteria DSRequestTask.criteria}.
 */
criteria?: Criteria;

/**
 * See {@link isc.DSRequestTask.dataSource DSRequestTask.dataSource}.
 */
dataSource?: DataSource | string;

/**
 * See {@link isc.DSRequestTask.operationId DSRequestTask.operationId}.
 */
operationId?: string;

/**
 * See {@link isc.DSRequestTask.exportFormat DSRequestTask.exportFormat}.
 */
exportFormat?: string;

/**
 * See {@link isc.DSRequestTask.groupBy DSRequestTask.groupBy}.
 */
groupBy?: string[];

/**
 * See {@link isc.DSRequestTask.outputFieldList DSRequestTask.outputFieldList}.
 */
outputFieldList?: string[];

/**
 * See {@link isc.DSRequestTask.operationType DSRequestTask.operationType}.
 */
operationType?: string;

/**
 * See {@link isc.DSRequestTask.fixedCriteria DSRequestTask.fixedCriteria}.
 */
fixedCriteria?: Criteria;

/**
 * See {@link isc.DSRequestTask.failureElement DSRequestTask.failureElement}.
 */
failureElement?: string;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * DSRequestTask wraps the SmartClient widget class
 * {@link isc.DSRequestTask DSRequestTask} for React, allowing you to import
 * DSRequestTask for use in React JS and JSX.
 * @class
 * @extends Task
 */
declare class DSRequestTask extends Task {
    props: AsComponentXML<DSRequestTaskProps>;
}
