/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.HttpUtil;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HttpProxyServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    public String proxyHost;
    public String rulesFile;
    public String webXmlRules;
    public boolean useURLCache = true;
    public int urlCacheSize = 4096;
    protected Map<String, RegexRule> urlCache;
    protected List<RegexRule> rules;
    public boolean acceptInvalidAndExpiredSSLCertificates = false;
    public String redirectStrategy = "default";
    public String sslTrustStrategy = "default";
    public boolean includeSOAPAttachments = true;
    public String SOAPAttachmentDataSource = "sessionFiles";
    public int proxyPort = -1;
    private static final Set<String> headersToNotRelay;
    private static final String[] headersToNotRelay_initiaData;

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public void setRulesFile(String value) {
        this.rulesFile = value;
    }

    public void setRules(String value) {
        this.webXmlRules = value;
    }

    public void setUseURLCache(String value) {
        this.useURLCache = Boolean.valueOf(value);
    }

    public void setUrlCacheSize(String value) {
        this.urlCacheSize = Integer.valueOf(value);
    }

    public void setAcceptInvalidAndExpiredSSLCertificates(String value) {
        this.acceptInvalidAndExpiredSSLCertificates = Boolean.valueOf(value);
    }

    public void setRedirectStrategy(String value) {
        this.redirectStrategy = value;
    }

    public void setSslTrustStrategy(String value) {
        this.sslTrustStrategy = value;
    }

    public void setIncludeSOAPAttachments(String value) {
        this.includeSOAPAttachments = Boolean.valueOf(value);
    }

    public void setSOAPAttachmentDataSource(String value) {
        this.SOAPAttachmentDataSource = value;
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.webXmlRules != null) {
            for (String rule : DataTools.simpleSplit(this.webXmlRules, "\n")) {
                if ((rule = rule.trim()).length() <= 1) continue;
                try {
                    if (this.rules == null) {
                        this.rules = new ArrayList<RegexRule>();
                    }
                    this.rules.add(new RegexRule(rule, "rules init-param in web.xml"));
                }
                catch (Exception e) {
                    this.log.warn(e.toString() + " - dropping this rule.");
                }
            }
        }
        if (this.rulesFile != null) {
            if (this.webXmlRules != null) {
                this.log.warn("Both the rules and rulesFile params are defined in web.xml. Rules defined in the rulesFile: " + this.rulesFile + " will be appended to those defined in the rules param in web.xml");
            }
            if (!this.rulesFile.startsWith("/")) {
                this.rulesFile = "/" + this.rulesFile;
            }
            List rulesFromFile = null;
            try {
                rulesFromFile = DataStructCache.getSingleList(webRoot + this.rulesFile);
            }
            catch (Exception e) {
                this.log.error("Failed to parse rules file: " + webRoot + this.rulesFile);
            }
            if (rulesFromFile != null) {
                for (String rule : rulesFromFile) {
                    try {
                        if (this.rules == null) {
                            this.rules = new ArrayList<RegexRule>();
                        }
                        this.rules.add(new RegexRule(rule, "rulesFile: " + this.rulesFile));
                    }
                    catch (Exception e) {
                        this.log.warn(e.toString() + " - dropping this rule.");
                    }
                }
            }
        }
        if (this.rules == null) {
            this.useURLCache = false;
            this.log.info("No rules defined - proxying all incoming URLs.");
        }
        if (this.useURLCache) {
            this.urlCache = Collections.synchronizedMap(new LRUMap(this.urlCacheSize));
            this.log.debug("URL Cache enabled - max size: " + this.urlCacheSize + " entries");
        }
    }

    public void setProxyPort(String value) {
        this.proxyPort = Integer.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            String username;
            Object requestBody;
            Map httpHeaders;
            Object httpRequest;
            HttpClientContext clientContext;
            HttpClient client;
            String method;
            HashMap<String, Object> params;
            Object url;
            Map data;
            block69: {
                String contentType;
                block74: {
                    block76: {
                        Iterator<Object> i;
                        Document doc;
                        block77: {
                            block72: {
                                block75: {
                                    String uploadFileName;
                                    block73: {
                                        block71: {
                                            HashMap<String, Object> map;
                                            String requestData = request.getParameter("data");
                                            ValidationContext vc = new ValidationContext();
                                            vc.setRestrictedXMLMode(true);
                                            data = (Map)XML.toDSRecords(new StringReader(requestData), vc);
                                            vc.freeResources();
                                            this.log.debug("ProxyData is: " + DataTools.prettyPrint(data));
                                            url = (String)data.get("url");
                                            if (this.rules != null) {
                                                RegexRule matchedRule = null;
                                                if (this.useURLCache) {
                                                    matchedRule = this.urlCache.get(url);
                                                }
                                                if (matchedRule == null) {
                                                    for (RegexRule rule : this.rules) {
                                                        boolean match = false;
                                                        try {
                                                            match = rule.match((String)url);
                                                        }
                                                        catch (Exception e) {
                                                            this.log.warn("Syntax error in rule: " + rule.toString() + " [" + e.getMessage() + "] - ignoring rule.");
                                                        }
                                                        if (!match) continue;
                                                        matchedRule = rule;
                                                        break;
                                                    }
                                                }
                                                if (matchedRule == null) {
                                                    String error = "HttpProxy to URL: " + (String)url + " DENIED.  The URL did not match any rule - returning HTTP code 403 (Forbidden) to client.";
                                                    this.log.warn(error);
                                                    response.sendError(403);
                                                    return;
                                                }
                                                String action = matchedRule.action;
                                                if ("block".equals(action) || "ignore".equals(action)) {
                                                    String error = "HttpProxy to URL: " + (String)url + " DENIED by rule " + matchedRule.toString() + " - returning HTTP code 403 (Forbidden) to client.";
                                                    this.log.warn(error);
                                                    response.sendError(403);
                                                    return;
                                                }
                                                if (this.useURLCache) {
                                                    this.urlCache.put((String)url, matchedRule);
                                                }
                                            }
                                            params = map = (HashMap<String, Object>)data.get("params");
                                            method = (String)data.get("httpMethod");
                                            if (method == null) {
                                                method = "GET";
                                            }
                                            uploadFileName = (String)data.get("uploadFileName");
                                            DataTypeMap<String, String> opts = new DataTypeMap<String, String>();
                                            if (this.acceptInvalidAndExpiredSSLCertificates) {
                                                this.log.warn("acceptInvalidAndExpiredSSLCertificates is deprecated, please switch to using sslTrustStrategy");
                                                opts.put("sslTrustStrategy", "trustAll");
                                            }
                                            opts.put("redirectStrategy", this.redirectStrategy);
                                            opts.put("sslTrustStrategy", this.sslTrustStrategy);
                                            client = HttpUtil.getHttpClient(opts);
                                            clientContext = null;
                                            httpRequest = null;
                                            httpHeaders = (Map)data.get("httpHeaders");
                                            requestBody = null;
                                            Object rbObj = data.get("requestBody");
                                            if (rbObj instanceof Map) {
                                                method = "POST";
                                                this.setIncludeSOAPAttachments("false");
                                                int start = requestData.indexOf("<requestBody");
                                                start = requestData.indexOf(">", start);
                                                int end = requestData.indexOf("</requestBody>");
                                                requestBody = requestData.substring(start + 1, end);
                                                requestBody = "<transaction xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" xsi:type=\"xsd:Object\"><operations xsi:type=\"xsd:List\"> <elem xsi:type=\"xsd:Object\"> " + (String)requestBody;
                                                requestBody = (String)requestBody + "</elem></operations></transaction>";
                                                if (params == null) {
                                                    params = new HashMap<String, Object>();
                                                }
                                                params.put("_transaction", requestBody);
                                                url = (String)url + "?isc_rpc=1&isc_xhr=1";
                                                requestBody = null;
                                            } else {
                                                requestBody = (String)data.get("requestBody");
                                                if ("".equals(requestBody)) {
                                                    requestBody = null;
                                                }
                                            }
                                            contentType = (String)data.get("contentType");
                                            if (!method.equals("PUT")) break block71;
                                            httpRequest = new HttpPut((String)url);
                                            if (contentType == null) {
                                                httpRequest.setEntity((HttpEntity)new StringEntity((String)requestBody));
                                                break block69;
                                            } else {
                                                httpRequest.setEntity((HttpEntity)new StringEntity((String)requestBody, ContentType.create((String)contentType)));
                                            }
                                            break block69;
                                        }
                                        if (!method.equals("POST")) break block72;
                                        if (requestBody != null || uploadFileName != null) break block73;
                                        httpRequest = new HttpPost((String)url);
                                        break block74;
                                    }
                                    if (uploadFileName == null) break block75;
                                    this.log.warn("uploading file: " + uploadFileName);
                                    ISCFile file = ISCFile.newInstance(String.valueOf(Config.getGlobal().get("webRoot")) + uploadFileName);
                                    httpRequest = new HttpXMLPost((String)url, file, method);
                                    break block74;
                                }
                                if (!this.includeSOAPAttachments || contentType == null || !contentType.contains("xml")) break block76;
                                doc = XML.parseXML(new InputSource(new StringReader((String)requestBody)));
                                DataTypeMap namespaces = DataTools.buildMap("xop", "http://www.w3.org/2004/08/xop/include");
                                List binaryNodes = XML.selectNodes(doc, "//xop:Include", (Map)((Object)namespaces));
                                i = binaryNodes.iterator();
                                break block77;
                            }
                            if (!method.equals("GET")) {
                                if (!method.equals("DELETE")) throw new Exception("Unsupported HTTP method: " + method);
                            }
                            httpRequest = method.equals("GET") ? new HttpGet((String)url) : new HttpDelete((String)url);
                            break block69;
                        }
                        while (i.hasNext()) {
                            RequestContext context;
                            Element node = (Element)i.next();
                            String primaryKey = node.getAttribute("href");
                            DSRequest dsRequest = new DSRequest(this.SOAPAttachmentDataSource, "fetch");
                            dsRequest.context = context = RequestContext.instance((Servlet)this, request, response);
                            dsRequest.setCriteria((Object)DataTools.buildMap("primaryKey", primaryKey));
                            DSResponse dsResponse = dsRequest.execute();
                            Map responseData = (Map)dsResponse.getData();
                            if (responseData == null) {
                                throw new Exception("Unable to locate binary file for primaryKey: " + primaryKey);
                            }
                            byte[] binary = (byte[])responseData.get("file_binary");
                            Base64 encoder = new Base64();
                            String binary64Text = new String(encoder.encode(binary));
                            Text newNode = doc.createTextNode(binary64Text);
                            Node parentNode = node.getParentNode();
                            parentNode.replaceChild(newNode, node);
                        }
                        requestBody = XML.toXML(doc);
                    }
                    httpRequest = new HttpXMLPost((String)url, (String)requestBody, method);
                }
                if (contentType != null) {
                    httpRequest.addHeader("Content-Type", contentType);
                }
            }
            if (this.proxyHost != null) {
                HttpHost ph = new HttpHost(this.proxyHost, this.proxyPort);
                RequestConfig hostConfig = RequestConfig.custom().setProxy(ph).build();
                httpRequest.setConfig(hostConfig);
            }
            if ((username = (String)data.get("username")) != null) {
                String password = (String)data.get("password");
                clientContext = HttpUtil.getClientContext((String)url, DataTools.buildMap("username", username, "password", password));
            }
            if (httpHeaders != null) {
                for (String headerName : httpHeaders.keySet()) {
                    httpRequest.setHeader(headerName, (String)httpHeaders.get(headerName));
                }
            }
            httpRequest.setProtocolVersion(new ProtocolVersion("HTTP", 1, 1));
            ArrayList<BasicNameValuePair> queryParamsList = new ArrayList<BasicNameValuePair>();
            String callbackParam = (String)data.get("callbackParam");
            if (callbackParam != null) {
                String callbackParamValue = request.getParameter(callbackParam);
                if (callbackParam != null && callbackParamValue != null) {
                    queryParamsList.add(new BasicNameValuePair(callbackParam, callbackParamValue));
                }
            }
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    Object value = params.get(key);
                    if (value == null) {
                        value = "";
                    }
                    if (value instanceof List) {
                        List valueList = (List)value;
                        for (int j = 0; j < valueList.size(); ++j) {
                            String nextValue = (String)valueList.get(j);
                            if (nextValue == null) {
                                value = "";
                            }
                            queryParamsList.add(new BasicNameValuePair(key, nextValue));
                        }
                        continue;
                    }
                    queryParamsList.add(new BasicNameValuePair(key, value.toString()));
                }
            }
            if (queryParamsList.size() > 0) {
                if (method.equals("POST") && requestBody == null) {
                    ((HttpPost)httpRequest).setEntity((HttpEntity)new UrlEncodedFormEntity(queryParamsList));
                } else {
                    URIBuilder uriBuilder = new URIBuilder(httpRequest.getURI());
                    uriBuilder.addParameters(queryParamsList);
                    httpRequest.setURI(uriBuilder.build());
                }
            }
            byte[] responseBody = null;
            HttpResponse httpResponse = null;
            try {
                httpResponse = clientContext != null ? client.execute((HttpUriRequest)httpRequest, (HttpContext)clientContext) : client.execute((HttpUriRequest)httpRequest);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode > 300) {
                    this.log.warn("Method failed: " + String.valueOf(httpResponse.getStatusLine()));
                } else {
                    this.log.info("Method succeeded: " + String.valueOf(httpResponse.getStatusLine()));
                }
                response.setStatus(statusCode);
                responseBody = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                if (responseBody == null) {
                    this.log.info("Empty response body");
                }
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)"Tried to proxy to unknown host, returning error", e);
                response.addHeader("X-ISC-HttpProxy-Status", "-91");
                response.setStatus(200);
            }
            catch (SocketException e) {
                this.log.warn((Object)"SocketException in proxy - is the remote server down? Returning error", e);
                response.addHeader("X-ISC-HttpProxy-Status", "-92");
                response.setStatus(200);
            }
            catch (IOException e) {
                this.log.warn((Object)"Fatal transport error", e);
            }
            finally {
                httpRequest.releaseConnection();
            }
            if (httpResponse != null) {
                Header cookieHeader = httpResponse.getFirstHeader("Set-Cookie");
                if (cookieHeader != null && cookieHeader.getValue() != null) {
                    response.addHeader("X-Proxied-Set-Cookie", cookieHeader.getValue());
                }
                Header[] responseHeaders = httpResponse.getAllHeaders();
                for (int hdrIdx = 0; hdrIdx < responseHeaders.length; ++hdrIdx) {
                    Header header = responseHeaders[hdrIdx];
                    if (headersToNotRelay.contains(header.getName()) || response.containsHeader(header.getName())) continue;
                    response.addHeader(header.getName(), header.getValue());
                }
            }
            if (responseBody == null) return;
            if (this.log.isInfoEnabled()) {
                this.log.info("Response:\n" + new String(responseBody));
            }
            IOUtil.copyStreams(new ByteArrayInputStream(responseBody), (OutputStream)response.getOutputStream());
            return;
        }
        catch (Throwable e) {
            this.handleError(response, e);
            return;
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException rule) {}
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    static {
        headersToNotRelay_initiaData = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Location", "Content-MD5", "Content-Range", "Cookie", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "Set-Cookie", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
        headersToNotRelay = new HashSet(headersToNotRelay_initiaData.length){

            @Override
            public boolean add(Object o) {
                return super.add(o.toString().toLowerCase());
            }

            @Override
            public boolean remove(Object o) {
                return super.remove(o.toString().toLowerCase());
            }

            @Override
            public boolean contains(Object o) {
                return super.contains(o.toString().toLowerCase());
            }
        };
        for (int i = 0; i < headersToNotRelay_initiaData.length; ++i) {
            headersToNotRelay.add(headersToNotRelay_initiaData[i]);
        }
    }

    class HttpXMLPost
    extends HttpEntityEnclosingRequestBase {
        private ISCFile _uploadFile = null;
        private String _requestBody = "<foo></foo>";
        private String _methodName = "POST";

        public HttpXMLPost(String url, String requestBody, String methodName) throws URISyntaxException, IOException {
            this.setURI(new URI(url));
            this._requestBody = requestBody;
            this._methodName = methodName;
            this.setEntity((HttpEntity)new StringEntity(requestBody));
        }

        public HttpXMLPost(String url, ISCFile file, String methodName) throws URISyntaxException, IOException {
            this.setURI(new URI(url));
            this._uploadFile = file;
            this._methodName = methodName;
            this.setEntity((HttpEntity)new InputStreamEntity(file.getInputStream()));
        }

        public String getName() {
            return this._methodName;
        }

        protected long getRequestContentLength() {
            return this._requestBody.length();
        }

        public String getMethod() {
            return this._methodName;
        }
    }
}

