/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class FileParquetDataSource
implements InputFile {
    private final byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileParquetDataSource(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try (InputStream in = conn.getInputStream();){
            this.data = in.readAllBytes();
        }
        finally {
            conn.disconnect();
        }
    }

    public long getLength() {
        return this.data.length;
    }

    public SeekableInputStream newStream() {
        return new SeekableInputStream(){
            private final ByteArrayInputStream bais;
            {
                this.bais = new ByteArrayInputStream(FileParquetDataSource.this.data);
            }

            public long getPos() {
                return FileParquetDataSource.this.data.length - this.bais.available();
            }

            public void seek(long pos) throws IOException {
                if (pos < 0L || pos > (long)FileParquetDataSource.this.data.length) {
                    throw new IOException("Invalid seek: " + pos);
                }
                this.bais.reset();
                this.bais.skip(pos);
            }

            public int read() throws IOException {
                return this.bais.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return this.bais.read(b, off, len);
            }

            public int read(ByteBuffer buf) throws IOException {
                if (!buf.hasRemaining()) {
                    return 0;
                }
                byte[] tmp = new byte[buf.remaining()];
                int r = this.bais.read(tmp);
                if (r > 0) {
                    buf.put(tmp, 0, r);
                }
                return r;
            }

            public void readFully(byte[] b) throws IOException {
                this.readFully(b, 0, b.length);
            }

            public void readFully(byte[] b, int off, int len) throws IOException {
                int r;
                for (int n = 0; n < len; n += r) {
                    r = this.bais.read(b, off + n, len - n);
                    if (r >= 0) continue;
                    throw new IOException("EOF while reading fully");
                }
            }

            public void readFully(ByteBuffer buf) throws IOException {
                byte[] tmp = new byte[buf.remaining()];
                this.readFully(tmp);
                buf.put(tmp);
            }

            public void close() throws IOException {
                this.bais.close();
            }
        };
    }
}

