/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DeltaShareCatalogFetch
extends DataSource {
    private static final Integer MAX_FILES_PER_TABLE = 5;
    private static final long MAX_FILE_SIZE_BYTES = 0xA00000L;

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse res = new DSResponse();
        Map values = req.getValues();
        String endpoint = DeltaShareCatalogFetch.trim(values, "endpoint");
        String token = DeltaShareCatalogFetch.trim(values, "token");
        if (endpoint == null || token == null) {
            return DeltaShareCatalogFetch.error(res, "Missing endpoint or token");
        }
        endpoint = endpoint.replaceAll("/+$", "");
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (String shareObjRaw : DeltaShareCatalogFetch.ndjsonOrJson(endpoint + "/shares", "GET", token, null)) {
            String shareName = DeltaShareCatalogFetch.extractString(shareObjRaw, "name");
            if (shareName == null) continue;
            rows.add(DeltaShareCatalogFetch.node("share:" + shareName, null, shareName, "share", null));
            String schemasUrl = endpoint + "/shares/" + DeltaShareCatalogFetch.enc(shareName) + "/schemas";
            for (String schemaObjRaw : DeltaShareCatalogFetch.ndjsonOrJson(schemasUrl, "GET", token, null)) {
                String schemaName = DeltaShareCatalogFetch.extractString(schemaObjRaw, "name");
                if (schemaName == null) continue;
                String schemaId = "schema:" + shareName + "/" + schemaName;
                rows.add(DeltaShareCatalogFetch.node(schemaId, "share:" + shareName, schemaName, "schema", null));
                String tablesUrl = endpoint + "/shares/" + DeltaShareCatalogFetch.enc(shareName) + "/schemas/" + DeltaShareCatalogFetch.enc(schemaName) + "/tables";
                block2: for (String tableObjRaw : DeltaShareCatalogFetch.ndjsonOrJson(tablesUrl, "GET", token, null)) {
                    String tableName = DeltaShareCatalogFetch.extractString(tableObjRaw, "name");
                    if (tableName == null) continue;
                    String tableId = "table:" + shareName + "/" + schemaName + "/" + tableName;
                    rows.add(DeltaShareCatalogFetch.node(tableId, schemaId, tableName, "table", null));
                    String queryUrl = endpoint + "/shares/" + DeltaShareCatalogFetch.enc(shareName) + "/schemas/" + DeltaShareCatalogFetch.enc(schemaName) + "/tables/" + DeltaShareCatalogFetch.enc(tableName) + "/query";
                    List<String> fileLines = DeltaShareCatalogFetch.ndjsonOrJson(queryUrl, "POST", token, "{}");
                    int count2 = 0;
                    for (String lineObj : fileLines) {
                        Long size;
                        String fileUrl;
                        String fileObj = DeltaShareCatalogFetch.extractObject(lineObj, "file");
                        if (fileObj == null || (fileUrl = DeltaShareCatalogFetch.extractString(fileObj, "url")) == null || (size = DeltaShareCatalogFetch.extractLong(fileObj, "size")) == null || size > 0xA00000L) continue;
                        String fileId = DeltaShareCatalogFetch.extractString(fileObj, "id");
                        String partitionValuesObj = DeltaShareCatalogFetch.extractObject(fileObj, "partitionValues");
                        Map<String, String> partitionValues = DeltaShareCatalogFetch.parseFlatStringMap(partitionValuesObj);
                        String leafId = "file:" + fileUrl;
                        Map<String, Object> r = DeltaShareCatalogFetch.node(leafId, tableId, DeltaShareCatalogFetch.shortUrl(fileUrl), "file", fileUrl);
                        r.put("dsId", "parquet-url-" + DeltaShareCatalogFetch.base64url(fileUrl));
                        if (fileId != null) {
                            r.put("idInFile", fileId);
                        }
                        if (size != null) {
                            r.put("size", size);
                        }
                        if (!partitionValues.isEmpty()) {
                            r.put("partitionValues", partitionValues);
                        }
                        rows.add(r);
                        if (MAX_FILES_PER_TABLE == null || ++count2 < MAX_FILES_PER_TABLE) continue;
                        continue block2;
                    }
                }
            }
        }
        res.setData(rows.toArray(new Map[0]));
        res.setStartRow(0L);
        res.setEndRow(rows.size());
        res.setTotalRows(rows.size());
        res.setStatus(0);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> ndjsonOrJson(String url, String method, String token, String jsonBodyOrNull) throws Exception {
        int code;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Authorization", "Bearer " + token);
        conn.setRequestProperty("Accept", "application/x-ndjson, application/json");
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(120000);
        if ("POST".equals(method) && jsonBodyOrNull != null) {
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                os.write(jsonBodyOrNull.getBytes(StandardCharsets.UTF_8));
            }
        }
        if ((code = conn.getResponseCode()) < 200 || code >= 300) {
            String msg = "HTTP " + code + " calling " + url;
            try (BufferedReader br2 = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br2.readLine()) != null) {
                    sb.append(line);
                }
                if (sb.length() > 0) {
                    msg = msg + " \u2014 " + String.valueOf(sb);
                }
            }
            catch (Exception br2) {
                // empty catch block
            }
            conn.disconnect();
            throw new RuntimeException(msg);
        }
        ArrayList<String> out = new ArrayList<String>();
        String ct = conn.getContentType();
        String contentType = ct == null ? "" : ct.toLowerCase(Locale.ROOT);
        boolean looksNdjson = contentType.contains("ndjson");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            if (looksNdjson) {
                String line;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    out.add(line);
                }
            } else {
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String raw = sb.toString().trim();
                if (raw.isEmpty()) {
                    ArrayList<String> arrayList = out;
                    return arrayList;
                }
                char first = DeltaShareCatalogFetch.firstNonWs(raw);
                if (first == '[') {
                    out.addAll(DeltaShareCatalogFetch.splitTopLevelObjectsFromArray(raw));
                } else if (first == '{') {
                    String itemsArray = DeltaShareCatalogFetch.extractArray(raw, "items");
                    if (itemsArray != null) {
                        out.addAll(DeltaShareCatalogFetch.splitTopLevelObjectsFromArray(itemsArray));
                    } else {
                        out.add(raw);
                    }
                }
            }
        }
        finally {
            conn.disconnect();
        }
        return out;
    }

    private static String extractString(String json, String key) {
        int keyPos = DeltaShareCatalogFetch.indexOfKey(json, key);
        if (keyPos < 0) {
            return null;
        }
        int colon = DeltaShareCatalogFetch.nextNonWs(json, json.indexOf(58, keyPos));
        if (colon < 0) {
            return null;
        }
        int i = DeltaShareCatalogFetch.nextNonWs(json, colon + 1);
        if (i < 0 || i >= json.length() || json.charAt(i) != '\"') {
            return null;
        }
        ParseResult r = DeltaShareCatalogFetch.parseJsonString(json, i);
        return r == null ? null : r.text;
    }

    private static Long extractLong(String json, String key) {
        int keyPos = DeltaShareCatalogFetch.indexOfKey(json, key);
        if (keyPos < 0) {
            return null;
        }
        int colon = DeltaShareCatalogFetch.nextNonWs(json, json.indexOf(58, keyPos));
        if (colon < 0) {
            return null;
        }
        int i = DeltaShareCatalogFetch.nextNonWs(json, colon + 1);
        if (i < 0) {
            return null;
        }
        int j = i;
        if (j < json.length() && json.charAt(j) == '-') {
            ++j;
        }
        int start = j;
        while (j < json.length() && Character.isDigit(json.charAt(j))) {
            ++j;
        }
        if (start == j) {
            return null;
        }
        try {
            return Long.parseLong(json.substring(i, j));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String extractObject(String json, String key) {
        int keyPos = DeltaShareCatalogFetch.indexOfKey(json, key);
        if (keyPos < 0) {
            return null;
        }
        int colon = json.indexOf(58, keyPos);
        if (colon < 0) {
            return null;
        }
        int i = DeltaShareCatalogFetch.nextNonWs(json, colon + 1);
        if (i < 0 || i >= json.length() || json.charAt(i) != '{') {
            return null;
        }
        int end = DeltaShareCatalogFetch.matchBrace(json, i, '{', '}');
        if (end < 0) {
            return null;
        }
        return json.substring(i, end + 1);
    }

    private static String extractArray(String json, String key) {
        int keyPos = DeltaShareCatalogFetch.indexOfKey(json, key);
        if (keyPos < 0) {
            return null;
        }
        int colon = json.indexOf(58, keyPos);
        if (colon < 0) {
            return null;
        }
        int i = DeltaShareCatalogFetch.nextNonWs(json, colon + 1);
        if (i < 0 || i >= json.length() || json.charAt(i) != '[') {
            return null;
        }
        int end = DeltaShareCatalogFetch.matchBrace(json, i, '[', ']');
        if (end < 0) {
            return null;
        }
        return json.substring(i, end + 1);
    }

    private static Map<String, String> parseFlatStringMap(String obj) {
        int i;
        LinkedHashMap<String, String> out = new LinkedHashMap<String, String>();
        if (obj == null) {
            return out;
        }
        int n = obj.length();
        for (i = 0; i < n && obj.charAt(i) != '{'; ++i) {
        }
        if (i == n) {
            return out;
        }
        ++i;
        while (i < n && (i = DeltaShareCatalogFetch.skipWsAndCommas(obj, i)) < n && obj.charAt(i) != '}') {
            if (obj.charAt(i) != '\"') {
                i = DeltaShareCatalogFetch.skipValue(obj, i);
                continue;
            }
            ParseResult k = DeltaShareCatalogFetch.parseJsonString(obj, i);
            if (k == null || (i = DeltaShareCatalogFetch.nextNonWs(obj, k.next)) < 0 || i >= n || obj.charAt(i) != ':' || (i = DeltaShareCatalogFetch.nextNonWs(obj, i + 1)) < 0 || i >= n) break;
            if (obj.charAt(i) != '\"') {
                i = DeltaShareCatalogFetch.skipValue(obj, i);
                continue;
            }
            ParseResult v = DeltaShareCatalogFetch.parseJsonString(obj, i);
            if (v == null) break;
            out.put(k.text, v.text);
            i = v.next;
        }
        return out;
    }

    private static List<String> splitTopLevelObjectsFromArray(String jsonArray) {
        int i;
        ArrayList<String> out = new ArrayList<String>();
        int n = jsonArray.length();
        for (i = 0; i < n && jsonArray.charAt(i) != '['; ++i) {
        }
        if (i == n) {
            return out;
        }
        ++i;
        while (i < n && (i = DeltaShareCatalogFetch.skipWsAndCommas(jsonArray, i)) < n && jsonArray.charAt(i) != ']') {
            if (jsonArray.charAt(i) == '{') {
                int end = DeltaShareCatalogFetch.matchBrace(jsonArray, i, '{', '}');
                if (end < 0) break;
                out.add(jsonArray.substring(i, end + 1));
                i = end + 1;
                continue;
            }
            i = DeltaShareCatalogFetch.skipValue(jsonArray, i);
        }
        return out;
    }

    private static Map<String, Object> node(String id, String parentId, String name, String type, String url) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("id", id);
        if (parentId != null) {
            m.put("parentId", parentId);
        }
        m.put("name", name);
        m.put("type", type);
        if (url != null) {
            m.put("url", url);
        }
        m.put("isFolder", !"file".equals(type));
        return m;
    }

    private static String shortUrl(String u) {
        if (u == null) {
            return null;
        }
        int q = u.indexOf(63);
        if (q > 0) {
            u = u.substring(0, q);
        }
        if (u.length() > 80) {
            return u.substring(0, 77) + "...";
        }
        return u;
    }

    private static String trim(Map<String, Object> m, String k) {
        if (m == null) {
            return null;
        }
        Object v = m.get(k);
        if (v == null) {
            return null;
        }
        String s = String.valueOf(v).trim();
        return s.isEmpty() ? null : s;
    }

    private static String enc(String s) throws Exception {
        return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
    }

    private static String base64url(String s) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(s.getBytes(StandardCharsets.UTF_8));
    }

    private static DSResponse error(DSResponse res, String msg) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("error", msg);
        res.setData(new Map[]{m});
        res.setStatus(-1);
        return res;
    }

    private static int indexOfKey(String json, String key) {
        return json.indexOf("\"" + key + "\"");
    }

    private static int nextNonWs(String s, int i) {
        if (i < 0) {
            return -1;
        }
        int n = s.length();
        while (i < n && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return i < n ? i : -1;
    }

    private static int skipWsAndCommas(String s, int i) {
        char c;
        int n = s.length();
        while (i < n && (Character.isWhitespace(c = s.charAt(i)) || c == ',')) {
            ++i;
        }
        return i;
    }

    private static int skipValue(String s, int i) {
        char d;
        int j;
        int n = s.length();
        if (i >= n) {
            return i;
        }
        char c = s.charAt(i);
        if (c == '\"') {
            ParseResult r = DeltaShareCatalogFetch.parseJsonString(s, i);
            return r == null ? n : r.next;
        }
        if (c == '{') {
            int end = DeltaShareCatalogFetch.matchBrace(s, i, '{', '}');
            return end < 0 ? n : end + 1;
        }
        if (c == '[') {
            int end = DeltaShareCatalogFetch.matchBrace(s, i, '[', ']');
            return end < 0 ? n : end + 1;
        }
        for (j = i; j < n && (d = s.charAt(j)) != ',' && d != '}' && d != ']'; ++j) {
        }
        return j;
    }

    private static int matchBrace(String s, int start, char open, char close) {
        int n = s.length();
        int depth = 0;
        boolean inStr = false;
        for (int i = start; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\"' && (i == start || s.charAt(i - 1) != '\\')) {
                boolean bl = inStr = !inStr;
            }
            if (inStr) continue;
            if (c == open) {
                ++depth;
                continue;
            }
            if (c != close || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private static ParseResult parseJsonString(String s, int quoteIdx) {
        int n = s.length();
        if (quoteIdx < 0 || quoteIdx >= n || s.charAt(quoteIdx) != '\"') {
            return null;
        }
        StringBuilder out = new StringBuilder();
        int i = quoteIdx + 1;
        block13: while (i < n) {
            char c;
            if ((c = s.charAt(i++)) == '\"') {
                return new ParseResult(out.toString(), i);
            }
            if (c == '\\') {
                if (i >= n) break;
                char e = s.charAt(i++);
                switch (e) {
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '/': {
                        out.append('/');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'u': {
                        if (i + 3 >= n) continue block13;
                        String hex = s.substring(i, Math.min(i + 4, n));
                        try {
                            out.append((char)Integer.parseInt(hex, 16));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        i += 4;
                        break;
                    }
                    default: {
                        out.append(e);
                        break;
                    }
                }
                continue;
            }
            out.append(c);
        }
        return null;
    }

    private static char firstNonWs(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return s.charAt(i);
        }
        return '\u0000';
    }

    private static final class ParseResult {
        final String text;
        final int next;

        ParseResult(String t, int n) {
            this.text = t;
            this.next = n;
        }
    }
}

