/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.datasource.FileParquetDataSource;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class DSParquetGenerator
implements DynamicDSGenerator {
    private static final String BASE_PATH = "https://www.tablab.app/sample-datasets/";

    @Override
    public DataSource getDataSource(String dsID, DSRequest dsRequest) {
        try {
            String parquetUrl = DSParquetGenerator.resolveParquetUrl(dsID);
            List<Map<String, Object>> schemaFields = DSParquetGenerator.deriveParquetSchema(parquetUrl);
            String xml = DSParquetGenerator.buildDataSourceXml(dsID, parquetUrl, schemaFields);
            return DataSource.fromXML(xml);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating DataSource for: " + dsID, e);
        }
    }

    private static String resolveParquetUrl(String dsID) {
        if (dsID == null) {
            throw new IllegalArgumentException("dsID is null");
        }
        if (dsID.startsWith("parquet-url-")) {
            String b64 = dsID.substring("parquet-url-".length());
            try {
                byte[] decoded = Base64.getUrlDecoder().decode(b64);
                return new String(decoded, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid base64url in dsID: " + dsID, ex);
            }
        }
        if (dsID.startsWith("parquet-")) {
            String idSuffix = dsID.substring("parquet-".length());
            return BASE_PATH + idSuffix + ".parquet";
        }
        if (dsID.startsWith("http://") || dsID.startsWith("https://")) {
            return dsID;
        }
        throw new IllegalArgumentException("Unsupported dsID prefix: " + dsID);
    }

    public static List<Map<String, Object>> deriveParquetSchema(String parquetURL) throws Exception {
        MessageType schema;
        FileParquetDataSource input = new FileParquetDataSource(new URL(parquetURL));
        ParquetReadOptions options = new ParquetReadOptions.Builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
        try (ParquetFileReader r = ParquetFileReader.open((InputFile)input, (ParquetReadOptions)options);){
            ParquetMetadata meta = r.getFooter();
            schema = meta.getFileMetaData().getSchema();
        }
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        for (Type f : schema.getFields()) {
            PrimitiveType.PrimitiveTypeName pt = f.asPrimitiveType().getPrimitiveTypeName();
            LinkedHashMap<String, Object> fd = new LinkedHashMap<String, Object>();
            fd.put("name", f.getName());
            fd.put("type", DSParquetGenerator.mapType(pt));
            fd.put("title", DSParquetGenerator.formatTitle(f.getName()));
            try {
                fd.put("length", f.asPrimitiveType().getTypeLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            fields.add(fd);
        }
        return fields;
    }

    private static String mapType(PrimitiveType.PrimitiveTypeName pt) {
        switch (pt) {
            case INT32: 
            case INT64: {
                return "integer";
            }
            case FLOAT: 
            case DOUBLE: {
                return "float";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return "text";
            }
            case INT96: {
                return "datetime";
            }
        }
        return "text";
    }

    public static String buildDataSourceXml(String dsID, String parquetUrl, List<Map<String, Object>> schemaFields) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<DataSource ").append("ID=\"").append(DSParquetGenerator.xmlEscape(dsID)).append("\" ").append("serverType=\"parquet\" ").append("fetchUrl=\"").append(DSParquetGenerator.xmlEscape(parquetUrl)).append("\">\n\n");
        xml.append("  <fields>\n");
        for (Map<String, Object> field : schemaFields) {
            String name = String.valueOf(field.get("name"));
            String title = String.valueOf(field.get("title"));
            String type = String.valueOf(field.get("type"));
            Object length = field.get("length");
            xml.append("    <field ").append("name=\"").append(DSParquetGenerator.xmlEscape(name)).append("\" ").append("title=\"").append(DSParquetGenerator.xmlEscape(title)).append("\" ").append("type=\"").append(DSParquetGenerator.xmlEscape(type)).append("\" ").append("width=\"100\"");
            if (length != null && !"null".equals(String.valueOf(length))) {
                xml.append(" length=\"").append(DSParquetGenerator.xmlEscape(String.valueOf(length))).append("\"");
            }
            xml.append("/>\n");
        }
        xml.append("  </fields>\n");
        xml.append("  <operationBinding operationType=\"fetch\">\n").append("    <serverObject className=\"com.isomorphic.datasource.ParquetDataFetch\" methodName=\"executeFetch\"/>\n").append("  </operationBinding>\n");
        xml.append("</DataSource>\n");
        return xml.toString();
    }

    private static String formatTitle(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return fieldName;
        }
        StringBuilder title = new StringBuilder();
        boolean capNext = true;
        for (char c : fieldName.toCharArray()) {
            if (c == '_' || c == '-') {
                title.append(' ');
                capNext = true;
                continue;
            }
            if (Character.isUpperCase(c) && title.length() > 0) {
                title.append(' ').append(c);
                capNext = false;
                continue;
            }
            if (capNext) {
                title.append(Character.toUpperCase(c));
                capNext = false;
                continue;
            }
            title.append(c);
        }
        return title.toString();
    }

    private static String xmlEscape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

