var addDemographicsButton,
    aiDemographicsFieldName = "aiDemographics",
    addReligionsButton,
    aiReligionsFieldName = "aiReligions",
    addLandmarkButton,
    aiLandmarkFieldName = "aiLandmark";

isc.ListGrid.create({
    ID: "grid",
    autoDraw: false,
    width: "100%", height: "100%",
    dataSource: "worldDS",
    fields:[
        {name:"countryCode", title:"Code", width:70},
        {name:"countryName", width:235},
        {name:"independence", title:"Nationhood", width:125},
        {name:"population", width:125},
        {name:"gdp", width:125}
    ],
    initialCriteria: {
        "continent": "South America"
    },
    initialSort: [{
        property: "countryName",
        direction: "ascending"
    }],
    autoFetchData: true, dataFetchMode: "paged",
    autoFitData: "horizontal",
    autoFitWidthApproach: "both",
    minFieldWidth: 70,
    wrapCells: true,
    fixedRecordHeights: false,

    canAddAISummaryFields: true,

    // To display the hover when an AI-generated field's value is being computed, or an error
    // occurs during that asynchronous computation, we need canHover:true and showHover:true.
    canHover: true,
    showHover: true,
    showClippedValuesOnHover: true,
    cellHover : function (record, rowNum, colNum) {
        if (this.cellValueIsClipped(rowNum, colNum)) return;
        var field = this.getField(colNum);
        if (this.isValuePendingAsyncOrAsyncError(record, field)) return;
        return false;
    },
    cellHoverHTML : function (record, rowNum, colNum) {
        var field = this.getField(colNum);
        // Customize the hover contents if the value for a cell is being computed.
        if (this.isValuePendingAsync(record, field)) {
            return "This value for " + record.countryName + " is being computed.";
        }
        // Otherwise (if an error occurred trying to calculate a value, or a value is clipped)
        // defer to the standard cellHoverHTML() implementation.
        return this.Super("cellHoverHTML", arguments);
    },

    userRemovedField : function (field) {
        if (field.name == aiDemographicsFieldName) {
            addDemographicsButton.enable();
        } else if (field.name == aiReligionsFieldName) {
            addReligionsButton.enable();
        } else if (field.name == aiLandmarkFieldName) {
            addLandmarkButton.enable();
        }
        // The "Custom Prompt" button is always enabled.
    }
});

function addAISummaryField(fieldProps, aiFieldPrompt, listGrid) {
    var fields = listGrid.getFields();
    // Duplicate the array because the result of getFields() must be treated as read-only.
    fields = fields.duplicate();

    var existingIndex = fields.findIndex("name", fieldProps.name);
    if (existingIndex >= 0) fields.removeAt(existingIndex);

    fieldProps = isc.addProperties({
        width: 180,
        wrap: true,
        showHover: true
    }, fieldProps);
    fieldProps.aiFieldPrompt = aiFieldPrompt;
    fields.addAt(fieldProps, existingIndex < 0 ? fields.length : existingIndex);
    listGrid.setFields(fields);
}



var buttonsLayout = isc.HStack.create({
    autoDraw: false,
    height: "*",
    membersMargin: 8,
    members: [
        addDemographicsButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Demographics",
            prompt: "A 2-4 sentence demographic and economic description of the country",
            click : function () {
                addAISummaryField({name:aiDemographicsFieldName, title:"Demographics Summary", width:"*", minWidth: 300},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        addReligionsButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Religions",
            prompt: "Most common religions, as a comma-separated list",
            click : function () {
                addAISummaryField({name:aiReligionsFieldName, title:"Common Religions"},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        addLandmarkButton = isc.Button.create({
            autoDraw: false,
            autoFit: true,
            title: "Add Landmark",
            prompt: "Most famous landmark",
            click : function () {
                addAISummaryField({name:aiLandmarkFieldName, title:"Famous Landmark"},
                                  this.prompt, grid);
                this.disable();
            }
        }),
        isc.IButton.create({
          title:"Custom Prompt",
          click: function () {
              grid.addAISummaryField();
          }
        })
    ]
});

isc.VLayout.create({
    width: "100%", height: "100%",
    membersMargin: 15,
    members: [
        isc.DynamicForm.create({
            ID: "form",
            width: 600,
            items: [
                {
                    name: "dsSelector",
                    editorType: "SelectItem",
                    required: true,
                    title: "DataSource",
                    valueMap: ["UserIssues","ScienceStudies","Legal","worldDS"],
                    defaultValue: "UserIssues",
                    changed : function (form, item, value) {
                        if (value == "UserIssues") {
                            scienceStudiesLayout.hide();
                            userIssuesLayout.show();
                            worldLayout.hide();
                            legalLayout.hide();
                        } else if (value == "ScienceStudies") {
                            scienceStudiesLayout.show();
                            userIssuesLayout.hide();
                            worldLayout.hide();
                            legalLayout.hide();
                        } else if (value == "Legal") {
                            legalLayout.show();
                            userIssuesLayout.hide();
                            worldLayout.hide();
                            scienceStudiesLayout.hide();
                        } else {
                            legalLayout.hide();
                            scienceStudiesLayout.hide();
                            userIssuesLayout.hide();
                            worldLayout.show();
                        }
                    }
                }
           ]
        }),
        isc.VLayout.create({
            ID: "scienceStudiesLayout",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            visibility: "hidden",
            members: [
                isc.HLayout.create({
                    ID: "buttonLayoutScience",
                    width: "*",
                    members: [
                      isc.IButton.create({
                          title: "Sort by Relevance to IV Pump Safety",
                          width: 260,
                          prompt: "Read each Abstract and assign it an importance score from 1 (least) to 10 (most) based on its relevance to IV Pump Safety",
                          click : function () {
                              addAISummaryField({name: "relevance", title: "Relevance", width: 175, type: "integer"}, 
                                                        this.prompt, lgScienceStudies);

                              lgScienceStudies.setSort([{
                                  property: "relevance",
                                  direction: "descending"
                              }, {
                                  property: "Study_ID",
                                  direction: "ascending"
                              }]);
                          }
                      }),
                      isc.IButton.create({
                        title:"Custom Prompt",
                        click: function () {
                            lgScienceStudies.addAISummaryField();
                        }
                      })
                    ],
                    membersMargin: 10
                }),
                isc.HTMLFlow.create({
                    width: "100%",
                    height: "*",
                    contents:
                        "<b>Science Studies</b>"+
                        "<ul>"+
                        "   <li><b>Sort by Relevance to IV Pump Safety</b>: Adds a numeric Relevance field (1–10) by analyzing each abstract and "+
                        "    scoring its importance to IV Pump Safety.</li>"+
                        "</ul>"+
                        "<b>Try creating your own Custom questions</b>: Maybe: <i>For each study, assign a single Decision Readiness label of Act "+
                        "Now, Pilot / Validate, or Informational Only, based on that study’s content</i>."
                }),
                isc.ListGrid.create({
                    ID: "lgScienceStudies",
                    width: "100%", height: "100%",
                    dataSource: "ScienceStudies", 
                    autoFetchData: true,
                    sortViaAIMode: "hybrid",
                    fields: [
                        {name:"Study_ID", width:150},
                        {name:"Title", width:150, showHover:true, hoverWidth:300},
                        {name:"Authors", width:150},
                        {name:"Journal", width:150},
                        {name:"Year", width:150},
                        {name:"Abstract", width:"*", showHover:true, hoverWidth:500}
                    ],
                    canAddAISummaryFields: true
                })
            ]
        }),
        isc.VLayout.create({
            ID: "userIssuesLayout",
            width: "100%", height: "100%",
            membersMargin: 15,
            members: [
                isc.HLayout.create({
                    ID: "buttonLayout",
                    width: "*",
                    members: [
                        isc.IButton.create({
                            title: "Urgency",
                            prompt: "Assess the urgency to the Department of the reported issue",
                            width: 150,
                            click : function () {
                                addAISummaryField({name: "urgencyLevel", title: "Urgency Level", width: 175},
                                                  this.prompt, lgIssues);

                                lgIssues.setSort([{
                                    property: "urgencyLevel",
                                    direction: "ascending"
                                }, {
                                    property: "Issue_ID",
                                    direction: "ascending"
                                }]);
                            }
                        }),
                        isc.IButton.create({
                            title: "Impact",
                            width: 150,
                            prompt: "Select the issue category based on its impact: Critical (threatens core functions/safety), High (major disruptions needing immediate attention), Moderate (manageable disruptions), or Low (minimal effect on operations)",
                            click : function () {
                                addAISummaryField({name: "impactLevel", title: "Impact Level", width: 175}, 
                                                  this.prompt, lgIssues);

                                lgIssues.setSort([{
                                    property: "impactLevel",
                                    direction: "ascending"
                                }, {
                                    property: "Issue_ID",
                                    direction: "ascending"
                                }]);
                            }
                        }),
                        isc.IButton.create({
                          title:"Custom Prompt",
                          click: function () {
                              lgIssues.addAISummaryField();
                          }
                        })
                    ],
                    membersMargin: 10
                }),
                isc.HTMLFlow.create({
                    width: "100%",
                    height: "*",
                    contents:
                        "<b>UserIssues</b>"+
                        "<ul>"+
                        "    <li>"+
                        "        <b>Urgency</b>: Adds an Urgency Level field by evaluating the prompt: \"Assess the urgency of the reported issue.\"</li>"+
                        "    <li>"+
                        "        <b>Impact</b>: Adds an Impact Level field by evaluating the prompt: \"Assess the potential impact of the issue on "+
                        "        the Department.\"</li>"+
                        "</ul>"+
                        "<b>Try creating your own Custom questions</b>: Maybe: <i>For each issue, classify whether it is a duplicate report, part of an ongoing incident, or a standalone case</i>"
                }),
                isc.ListGrid.create({
                    ID: "lgIssues",
                    width: "100%", height: "100%",
                    dataSource: "UserIssues", 
                    autoFetchData: true,
                    fields: [
                        {name:"Issue_ID", width:235},
                        {name:"Reported_By", width:125},
                        {name:"Department", width:235},
                        {name:"Category", width:235},
                        {name:"Issue_Description", width:235}
                    ],
                    sortViaAIMode: "hybrid",
                    canAddAISummaryFields: true
                })
            ]
        }),
        isc.VLayout.create({
            ID: "legalLayout",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            visibility: "hidden",
            members: [
                isc.HLayout.create({
                    ID: "buttonLegal",
                    width: "*",
                    members: [
                      isc.IButton.create({
                          title: "Contract Dispute",
                          width: 170,
                          prompt: "For each record, assign one category that best reflects how the June 2022 pricing concession is treated: Explicitly Temporary Accommodation; Temporary in Form, Ongoing in Practice; Implicitly Normalized in Practice; Embedded as Ongoing Baseline; Mixed or Contradictory Signals. Return only the category label.",
                          click : function () {
                              var prompt = "For each record, assign one category that best reflects how the June 2022 pricing concession is treated: Explicitly Temporary Accommodation; Temporary in Form, Ongoing in Practice; Implicitly Normalized in Practice; Embedded as Ongoing Baseline; Mixed or Contradictory Signals. Return only the category label.";
                              addAISummaryField({name: "relevance", title: "Relevance", width: 175, type: "integer"}, 
                                                        prompt, lgLegal);

                              lgLegal.setSort([{
                                  property: "relevance",
                                  direction: "ascending"
                              }]);
                          }
                      }),
                      isc.IButton.create({
                          title: "Classify Documents",
                          width: 170,
                          prompt: "For each record, label its litigation sensitivity around the June 2022 concession using one of: Routine Business; Reliance Risk; Messaging Control; Legal Exposure; Post-Hoc Justification.",
                          click : function () {
                              var prompt = "For each record, label its litigation sensitivity around the June 2022 concession using one of: Routine Business; Reliance Risk; Messaging Control; Legal Exposure; Post-Hoc Justification.";
                              addAISummaryField({name: "relevance", title: "Relevance", width: 175, type: "integer"}, 
                                                        prompt, lgLegal);

                              lgLegal.setSort([{
                                  property: "relevance",
                                  direction: "ascending"
                              }]);
                          }
                      }),
                      isc.IButton.create({
                        title:"Custom Prompt",
                        click: function () {
                            lgLegal.addAISummaryField();
                        }
                      })
                    ],
                    membersMargin: 10
                }),
                isc.HTMLFlow.create({
                    width: "100%",
                    height: "*",
                    contents:
                        "<b>Legal</b>"+
                        "<ul>"+
                        "   <li><b>Contract Dispute</b>: Identifies records that indicate whether a pricing concession was intended as "+
                        "        a temporary measure or was treated in practice as a normalized, ongoing price change.</li>"+
                        "   <li><b>Classify Documents</b>: Identify which documents are routine versus potentially legally sensitive based "+
                        "       on what they reveal about the situation.</li>"+
                        "</ul>"+
                        "<b>Try creating your own Custom questions</b>: Maybe: <i>For each record, assess whether it reflects a one-time action, a transitional state, or an institutionalized practice, based on how the underlying assumption is described, reused, or embedded</i>"
                }),
                isc.ListGrid.create({
                    ID: "lgLegal",
                    width: "100%", height: "100%",
                    dataSource: "dealDocumentDS", 
                    autoFetchData: true,
                    sortViaAIMode: "hybrid",
                    enforceVClipping: true,
                    fields: [
                        {name:"documentId", width:150},
                        {name:"title", width:250, showHover:true, hoverWidth:300},
                        {name:"docType", width:150},
                        {name:"createdDate", width:150},
                        {name:"from", width:150, showHover:true},
                        {name:"to", width:150, showHover:true},
                        {name:"contentFile", title:"Content File", width:400, showHover:true, hoverWidth:800, 
                            formatCellValue: function(value, record, rowNum, colNum, grid) {
                                return value
                                    ? value.replace(/<[^>]+>/g, "").substring(0, 500) + "…"
                                    : "";
                            },
                            hoverHTML:"return record.contentFile"
                        }
                    ],
                    canAddAISummaryFields: true
                })
            ]
        }),
        isc.VLayout.create({
            ID: "worldLayout",
            visibility: "hidden",
            width: "100%",
            height: "100%",
            membersMargin: 10,
            members: [
                buttonsLayout, 
                isc.HTMLFlow.create({
                    width: "100%",
                    height: "*",
                    contents:
                        "<b>WorldDS</b>"+
                        "<ul>"+
                        "   <li><b>Add Demographics</b>: Adds a 2–4 sentence demographic and economic summary of the country.</li>"+
                        "   <li><b>Add Religions</b>: Adds the most common religions as a comma-separated list.</li>"+
                        "   <li><b>Add Landmark</b>: Adds the country’s most famous landmark.</li>"+
                        "</ul>"+
                        "<b>Try creating your own Custom questions</b>: Maybe: <i>For each country, assess whether its structure suggests low, moderate, or high institutional complexity.</i>"
                }),
                grid]
        })
    ]
});

