/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, DSField, DataSource, DynamicForm, IButton, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onUsersTransformResponse = function (dsResponse, dsRequest, xmlData) {
    var status = isc.XMLTools.selectString(xmlData, '/response/status');
    if (status != 'success') {
        dsResponse.status = isc.RPCResponse.STATUS_VALIDATION_ERROR;
        var errors = isc.XMLTools.selectNodes(xmlData, '/response/errors');
        dsResponse.errors = isc.XMLTools.toJS(errors);
    }
};
let onSaveClick = function () {
    if (boundForm.validate())
        boundForm.saveData();
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <>
        <DataSource ID="users" dataFormat="xml" dataURL="[ISOMORPHIC]/system/reference/inlineExamples/dataIntegration/xml/serverValidationErrors/serverResponse.xml" title="users" transformResponse={onUsersTransformResponse}>
            <fields>
                <DSField length="50" name="userName" type="text" required="true" title="Username"/>
                <DSField length="50" name="firstName" type="text" required="true" title="First Name"/>
                <DSField length="50" name="lastName" type="text" required="true" title="Last Name"/>
                <DSField length="100" name="email" type="text" required="true" title="Email"/>
                <DSField length="20" name="password" type="password" required="true" title="Password"/>
            </fields>
        </DataSource>

        <VLayout>
            <members>
                <DynamicForm ID="boundForm" dataSource="users">
                    <values userName="bsmith" firstName="Bob" lastName="Smith" email="bob@smith.com" password="sekrit"/>
                </DynamicForm>
                <IButton title="Save" click={onSaveClick}/>
            </members>
        </VLayout>
    </>,
    document.getElementById(target)
);
