/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, HLayout, ListGrid, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

var exampleFilterDescriptions = [
    'population less than 1 million',
    'in South America',
    'nationhood prior to 1900',
    'area more than 500K square miles',
    'country name starts with a vowel',
    'member of the G8'
];

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="12" width="100%" height="100%">
        <members>
            <HLayout members={[isc.Label.create({
        height: '30',
        contents: 'Examples: ',
        autoFit: true
    })].concat(exampleFilterDescriptions.map(function (exampleFilterDescription) {
    return isc.IButton.create({
        title: '"' + exampleFilterDescription + '"',
        prompt: exampleFilterDescription,
        autoFit: true,
        click: function () {
            grid.filterViaAI(exampleFilterDescription);
        }
    });
})).concat([isc.IButton.create({
        title: 'Custom Prompt',
        click: function () {
            grid.showAIFilterWindow();
        }
    })])} membersMargin="6" width="100%" height="*"/>
            <ListGrid ID="grid" showFilterEditor="true" sortField="countryName" dataSource="worldDS" autoFetchData="true" width="100%" height="100%" dataFetchMode="local" filterViaAIMode="aiAssist"/>
        </members>
    </VLayout>,
    document.getElementById(target)
);
