import React from 'react';
import { ILogicalComponent } from './core/ILogicalComponent';
import { AsComponentXML } from './core/ReactComponent';


declare interface PartialPromptConfigProps {

/**
 * See {@link isc.PartialPromptConfig.omitStateVars PartialPromptConfig.omitStateVars}.
 */
omitStateVars?: string[];

/**
 * See {@link isc.PartialPromptConfig.mode PartialPromptConfig.mode}.
 */
mode?: string;

/**
 * See {@link isc.PartialPromptConfig.add PartialPromptConfig.add}.
 */
add?: string[];

/**
 * See {@link isc.PartialPromptConfig.omit PartialPromptConfig.omit}.
 */
omit?: string[];

/**
 * See {@link isc.PartialPromptConfig.truncateHistory PartialPromptConfig.truncateHistory}.
 */
truncateHistory?: number;

/**
 * See {@link isc.PartialPromptConfig.remove PartialPromptConfig.remove}.
 */
remove?: string[];

/**
 * See {@link isc.PartialPromptConfig.truncateErrors PartialPromptConfig.truncateErrors}.
 */
truncateErrors?: number;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * PartialPromptConfig wraps the SmartClient object
 * {@link isc.PartialPromptConfig PartialPromptConfig} for React, allowing you to import
 * PartialPromptConfig for use in React JS and JSX.
 * @class
 */
declare class PartialPromptConfig extends ILogicalComponent {
    props: AsComponentXML<PartialPromptConfigProps>;
}
