/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.UnexpectedAlertBehaviour;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class WebDriverProvider
extends Base {
    private static Logger log = new Logger(WebDriverProvider.class.getName());
    public static int DRIVER_TIMEOUT = 60;
    public static int DRIVER_CREATE_MAX_WAIT_MS = 10000;
    public static int N_DRIVER_ATTEMPTS = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebDriver get(String webDriver) throws Exception {
        for (int i = 0; i < N_DRIVER_ATTEMPTS; ++i) {
            WebDriver webDriver2;
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<WebDriver> future = executor.submit(new WebDriverCreator(webDriver));
            try {
                webDriver2 = future.get(DRIVER_TIMEOUT, TimeUnit.SECONDS);
                executor.shutdownNow();
            }
            catch (TimeoutException e) {
                try {
                    try {
                        future.cancel(true);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        executor.shutdownNow();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"Hit exception trying to create a WebDriver", (Throwable)e2);
                }
            }
            return webDriver2;
            try {
                Thread.sleep(DRIVER_CREATE_MAX_WAIT_MS);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new Exception("Unable to create WebDriver: " + webDriver);
    }

    private static class WebDriverCreator
    implements Callable<WebDriver> {
        protected String webDriver;
        protected Config driverConfig;
        protected String browser;
        protected Config driverOptions;

        public WebDriverCreator(String webDriver) throws Exception {
            this.webDriver = webDriver;
            this.driverConfig = Base.config.getSubtree("webDriver." + webDriver);
            if (this.driverConfig.size() == 0) {
                throw new Exception("Unable to find config block webDriver." + webDriver);
            }
            this.browser = this.driverConfig.getString((Object)"browser");
            if (this.browser == null) {
                throw new Exception("Unable to find config: webDriver." + webDriver + ".browser");
            }
            this.driverOptions = this.driverConfig.getSubtree("options");
        }

        @Override
        public WebDriver call() throws Exception {
            log.info((Object)("Creating a WebDriver for: " + this.browser));
            if ("firefox".equals(this.browser)) {
                String unhandledPromptBehaviour;
                String pageLoadStrategy;
                FirefoxOptions options = new FirefoxOptions();
                Config capabilities = this.driverOptions.getSubtree("capabilities");
                if (capabilities.size() > 0) {
                    for (String key : capabilities.keySet()) {
                        String value = capabilities.getString((Object)key);
                        if ("true".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        options.setCapability(key, value);
                    }
                }
                boolean headless = this.driverOptions.getBoolean((Object)"headless", false);
                options.setHeadless(headless);
                String binary = this.driverOptions.getString((Object)"binary", null);
                if (binary != null) {
                    options.setBinary(binary);
                }
                boolean acceptInsecureCerts = this.driverOptions.getBoolean((Object)"acceptInsecureCerts", false);
                options.setAcceptInsecureCerts(acceptInsecureCerts);
                List arguments = this.driverOptions.getList((Object)"arguments", null);
                if (arguments != null) {
                    options.addArguments(arguments);
                }
                if ((pageLoadStrategy = this.driverOptions.getString((Object)"pageLoadStrategy", null)) != null) {
                    options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
                }
                if ((unhandledPromptBehaviour = this.driverOptions.getString((Object)"unhandledPromptBehaviour", null)) != null) {
                    options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.fromString((String)unhandledPromptBehaviour));
                }
                boolean legacy = this.driverOptions.getBoolean((Object)"legacy", false);
                options.setLegacy(legacy);
                Config preferences = this.driverOptions.getSubtree("preferences");
                if (preferences.size() > 0) {
                    for (String key : preferences.keySet()) {
                        String value = preferences.getString((Object)key);
                        if ("true".equals(value)) {
                            options.addPreference(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.addPreference(key, true);
                            continue;
                        }
                        try {
                            Integer asInt = Integer.valueOf(value);
                            options.addPreference(key, asInt.intValue());
                        }
                        catch (NumberFormatException mustBeAString) {
                            options.addPreference(key, value);
                        }
                    }
                }
                return new FirefoxDriver(options);
            }
            if ("googlechrome".equals(this.browser)) {
                List extensions;
                Config experimentalOptions;
                String unhandledPromptBehaviour;
                String pageLoadStrategy;
                ChromeOptions options = new ChromeOptions();
                Config capabilities = this.driverOptions.getSubtree("capabilities");
                if (capabilities.size() > 0) {
                    for (String key : capabilities.keySet()) {
                        String value = capabilities.getString((Object)key);
                        if ("true".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        options.setCapability(key, value);
                    }
                }
                boolean headless = this.driverOptions.getBoolean((Object)"headless", false);
                options.setHeadless(headless);
                String binary = this.driverOptions.getString((Object)"binary", null);
                if (binary != null) {
                    options.setBinary(binary);
                }
                boolean acceptInsecureCerts = this.driverOptions.getBoolean((Object)"acceptInsecureCerts", false);
                options.setAcceptInsecureCerts(acceptInsecureCerts);
                List arguments = this.driverOptions.getList((Object)"arguments", null);
                if (arguments != null) {
                    options.addArguments(arguments);
                }
                if ((pageLoadStrategy = this.driverOptions.getString((Object)"pageLoadStrategy", null)) != null) {
                    options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
                }
                if ((unhandledPromptBehaviour = this.driverOptions.getString((Object)"unhandledPromptBehaviour", null)) != null) {
                    options.setUnhandledPromptBehaviour(UnexpectedAlertBehaviour.fromString((String)unhandledPromptBehaviour));
                }
                if ((experimentalOptions = this.driverOptions.getSubtree("experimentalOptions")).size() > 0) {
                    for (String key : experimentalOptions.keySet()) {
                        Object value = experimentalOptions.get((Object)key);
                        options.setExperimentalOption(key, value);
                    }
                }
                if ((extensions = this.driverOptions.getList((Object)"extensions", null)) != null) {
                    ArrayList<File> paths = new ArrayList<File>();
                    for (String s : extensions) {
                        paths.add(new File(s));
                    }
                    options.addExtensions(paths);
                }
                return new ChromeDriver(options);
            }
            if ("safari".equals(this.browser)) {
                SafariOptions options = new SafariOptions();
                Config capabilities = this.driverOptions.getSubtree("capabilities");
                if (capabilities.size() > 0) {
                    for (String key : capabilities.keySet()) {
                        String value = capabilities.getString((Object)key);
                        if ("true".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        options.setCapability(key, value);
                    }
                }
                return new SafariDriver(options);
            }
            if ("MicrosoftEdge".equals(this.browser)) {
                String pageLoadStrategy;
                EdgeOptions options = new EdgeOptions();
                Config capabilities = this.driverOptions.getSubtree("capabilities");
                if (capabilities.size() > 0) {
                    for (String key : capabilities.keySet()) {
                        String value = capabilities.getString((Object)key);
                        if ("true".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        options.setCapability(key, value);
                    }
                }
                if ((pageLoadStrategy = this.driverOptions.getString((Object)"pageLoadStrategy", null)) != null) {
                    options.setPageLoadStrategy(pageLoadStrategy);
                }
                return new EdgeDriver(options);
            }
            if ("opera".equals(this.browser)) {
                List extensions;
                Config experimentalOptions;
                List arguments;
                boolean headless;
                String binary;
                OperaOptions options = new OperaOptions();
                Config capabilities = this.driverOptions.getSubtree("capabilities");
                if (capabilities.size() > 0) {
                    for (String key : capabilities.keySet()) {
                        String value = capabilities.getString((Object)key);
                        if ("true".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        if ("false".equals(value)) {
                            options.setCapability(key, true);
                            continue;
                        }
                        options.setCapability(key, value);
                    }
                }
                if ((binary = this.driverOptions.getString((Object)"binary", null)) != null) {
                    options.setBinary(binary);
                }
                if (headless = this.driverOptions.getBoolean((Object)"headless", false)) {
                    options.addArguments(new String[]{"--headless=new"});
                }
                if ((arguments = this.driverOptions.getList((Object)"arguments", null)) != null) {
                    options.addArguments(arguments);
                }
                if ((experimentalOptions = this.driverOptions.getSubtree("experimentalOptions")).size() > 0) {
                    for (String key : experimentalOptions.keySet()) {
                        Object value = experimentalOptions.get((Object)key);
                        options.setExperimentalOption(key, value);
                    }
                }
                if ((extensions = this.driverOptions.getList((Object)"extensions", null)) != null) {
                    ArrayList<File> paths = new ArrayList<File>();
                    for (String s : extensions) {
                        paths.add(new File(s));
                    }
                    options.addExtensions(paths);
                }
                return new OperaDriver(options);
            }
            throw new UnsupportedOperationException("Unsupported browser: " + this.browser);
        }
    }
}

