/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.PlaywrightResultParser;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class PlaywrightTestRunner {
    private static Logger log = new Logger(PlaywrightTestRunner.class.getName());
    public static final String MODE_SINGLE = "single";
    public static final String MODE_LINEAR = "linear";
    public static final String MODE_PARALLEL = "parallel";
    private final TestRunnerConfiguration config;
    private final String executionMode;
    private final int parallelWorkers;

    public PlaywrightTestRunner(TestRunnerConfiguration config) {
        this(config, MODE_SINGLE, 4);
    }

    public PlaywrightTestRunner(TestRunnerConfiguration config, String executionMode, int parallelWorkers) {
        this.config = config;
        this.executionMode = executionMode;
        this.parallelWorkers = parallelWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests(List<String> testFiles, TestRunnerHelper.TestCallback callback) throws IOException, InterruptedException {
        if (testFiles == null || testFiles.isEmpty()) {
            log.warn((Object)"No test files provided to PlaywrightTestRunner");
            return;
        }
        this.validateOptions();
        List<String> command = this.buildCommand(testFiles);
        log.info((Object)("Starting Playwright test runner: " + String.join((CharSequence)" ", command)));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(false);
        String qaPath = this.config.getFileRoot() + "/smartclient/QA";
        File qaDir = new File(qaPath);
        if (qaDir.exists()) {
            pb.directory(qaDir);
        }
        pb.environment().putAll(System.getenv());
        Process process = pb.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder stderrCapture = new StringBuilder();
        Thread stderrThread = new Thread(() -> {
            try {
                String line;
                BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = stderr.readLine()) != null) {
                    log.warn((Object)("Playwright stderr: " + line));
                    StringBuilder stringBuilder = stderrCapture;
                    synchronized (stringBuilder) {
                        if (stderrCapture.length() > 0) {
                            stderrCapture.append("\n");
                        }
                        stderrCapture.append(line);
                    }
                }
                return;
            }
            catch (IOException e) {
                log.error((Object)"Error reading Playwright stderr", (Throwable)e);
            }
        });
        stderrThread.setDaemon(true);
        stderrThread.start();
        try {
            PlaywrightResultParser.parseAndCallback(stdout, callback);
        }
        finally {
            int exitCode = process.waitFor();
            stderrThread.join(5000L);
            if (exitCode != 0) {
                String stderrContent;
                StringBuilder stringBuilder = stderrCapture;
                synchronized (stringBuilder) {
                    stderrContent = stderrCapture.toString();
                }
                if (stderrContent.isEmpty()) {
                    log.warn((Object)("Playwright runner exited with code: " + exitCode));
                } else {
                    log.warn((Object)("Playwright runner exited with code: " + exitCode + "\nStderr output:\n" + stderrContent));
                }
            }
        }
    }

    private void validateOptions() throws IOException, InterruptedException {
        List<String> command = this.buildCommand(null);
        log.debug((Object)("Validating Playwright options: " + String.join((CharSequence)" ", command)));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        String qaPath = this.config.getFileRoot() + "/smartclient/QA";
        File qaDir = new File(qaPath);
        if (qaDir.exists()) {
            pb.directory(qaDir);
        }
        pb.environment().putAll(System.getenv());
        Process process = pb.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IllegalArgumentException("Invalid Playwright runner options: " + output.toString().trim());
        }
    }

    private List<String> buildCommand(List<String> testFiles) {
        int timeout;
        int port;
        ArrayList<String> command = new ArrayList<String>();
        command.add("node");
        String runnerPath = this.config.getFileRoot() + "/isomorphic/QA/pwRunner.js";
        command.add(runnerPath);
        if (testFiles == null) {
            command.add("--list-tags");
        } else {
            command.add("--java");
        }
        command.add("--mode");
        command.add(this.executionMode);
        if (MODE_PARALLEL.equals(this.executionMode)) {
            command.add("--workers");
            command.add(String.valueOf(this.parallelWorkers));
        }
        if ((port = this.config.getHttpPort(null)) > 0) {
            command.add("--port");
            command.add(String.valueOf(port));
        }
        if ((timeout = this.config.getSeleniumTimeout()) > 0) {
            command.add("--timeout");
            command.add(String.valueOf(timeout * 1000));
        }
        if (this.config instanceof TestRunnerLauncher && !((TestRunnerLauncher)this.config).getHeadless()) {
            command.add("--no-headless");
        }
        if (testFiles != null) {
            for (String testFile : testFiles) {
                Object urlPath = testFile;
                String fileRoot = this.config.getFileRoot();
                if (testFile.startsWith(fileRoot)) {
                    urlPath = testFile.substring(fileRoot.length());
                }
                if (!((String)urlPath).startsWith("/")) {
                    urlPath = "/" + (String)urlPath;
                }
                command.add((String)urlPath);
            }
        }
        return command;
    }

    public String getExecutionMode() {
        return this.executionMode;
    }

    public int getParallelWorkers() {
        return this.parallelWorkers;
    }
}

