/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BranchSummary;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.base.ISCInit;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.devenv.DevUtil;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.TemplatedMailMessage;
import com.isomorphic.velocity.Velocity;
import jakarta.mail.Message;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BatchReporter {
    private static Logger log = new Logger(BatchReporter.class.getName());
    private static List<BranchSummary> branches = new LinkedList<BranchSummary>();
    private static String outputDir = null;

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)BatchReporter.class.getName());
        DefaultParser parser = new DefaultParser();
        Options options = new Options();
        Option emailOption = new Option("e", "email", true, "Recipient(s) to email");
        emailOption.setRequired(true);
        options.addOption(emailOption);
        Option outputOption = new Option("o", "outputDir", true, "Directory to save email files (optional)");
        options.addOption(outputOption);
        TestRunnerLauncher config = new TestRunnerLauncher();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            TestRunner.setConfiguration(config);
            config.installOptionValues(line);
            config.initFileRoot();
            outputDir = line.getOptionValue("outputDir");
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp("batchReporter [OPT1] [ARG1] [OPT2] [ARG2] ...", options, moe.getMessage());
            System.exit(5);
        }
        config.setMailHost("wrath.isomorphic.com");
        config.setMailTemplate("_internalSource/mailTemplates/nightlyBuildStatus.template");
        config.configureMailHost();
        for (String branch : DevUtil.branchesDescending()) {
            DataTypeMap branchConf = DevUtil.branchConf(branch);
            if (!branchConf.getBoolean((Object)"autoTest", false)) continue;
            String sgwtVersionNumberString = branchConf.getString((Object)"sgwtVersionNumber");
            double autoTestThresholdForNightlyBuild = branchConf.getDouble((Object)"autoTestThresholdForNightlyBuild", 0.9);
            branches.add(new BranchSummary(branch, sgwtVersionNumberString, autoTestThresholdForNightlyBuild));
        }
        BatchReporter.sendReport();
    }

    public static void sendReport() throws Exception {
        TestRunnerLauncher launcher = (TestRunnerLauncher)TestRunner.getConfiguration();
        TemplatedMailMessage msg = new TemplatedMailMessage();
        msg.setFrom("packager@wrath.isomorphic.com");
        msg.addRecipients(launcher.getAlertEmail(), Message.RecipientType.TO);
        Calendar calendar = Calendar.getInstance();
        DecimalFormat decimal = new DecimalFormat("00");
        String subject = "Nightly Build Status " + calendar.get(1) + "." + decimal.format(calendar.get(2) + 1) + "." + decimal.format(calendar.get(5));
        msg.setSubject(subject);
        msg.addHeader("Content-Type", "text/html");
        HashMap<String, List<BranchSummary>> dataMap = new HashMap<String, List<BranchSummary>>();
        dataMap.put("branches", branches);
        msg.setContextMap(dataMap);
        String mailTemplate = launcher.getMailTemplate();
        msg.setTemplateFile(mailTemplate);
        msg.buildMessage(dataMap, mailTemplate);
        try {
            msg.send();
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception in sendReport", (Throwable)e);
        }
        if (outputDir != null) {
            try {
                File dir = new File(outputDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String mdTemplate = "_internalSource/markdownTemplates/nightlyBuildStatus.template";
                String markdown = (String)Velocity.evaluateTemplateFile((String)mdTemplate, dataMap);
                String filename = subject.replace(" ", "_").replace("/", "-").replace(":", "-") + ".md";
                File outFile = new File(dir, filename);
                FileWriter fw = new FileWriter(outFile);
                fw.write(markdown);
                fw.close();
                log.info((Object)("Saved report to " + outFile.getAbsolutePath()));
            }
            catch (Exception e) {
                log.warn((Object)"Failed to save report to file", (Throwable)e);
            }
        }
    }
}

