/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import java.util.List;
import java.util.Map;

public class SubqueryMetadata {
    private static Logger log = new Logger(SubqueryMetadata.class);
    public String fromFieldName;
    public String toFieldName;
    public String outputFieldName;
    public Relation relation;
    public boolean joinToParentDS;

    public static SubqueryMetadata fromConfig(Map subqueryConfig, BasicDataSource subDs, BasicDataSource parentDs, boolean rejectIndirectRelations) throws Exception {
        SubqueryMetadata meta = new SubqueryMetadata();
        String fk = (String)subqueryConfig.get("queryFK");
        boolean bl = meta.joinToParentDS = !"*none*".equals(fk);
        if (meta.joinToParentDS) {
            meta.relation = subDs.getRelation(new DataSource[]{parentDs}, null, fk, true, null);
            if (meta.relation == null) {
                throw new Exception("DataSource '" + subDs.getID() + "' specified on a 'fieldQuery' or 'valueQuery' criteria element, but that dataSource is not related to the parent DataSource '" + parentDs.getID() + "'" + (String)(fk == null ? "" : " via the named FK field '" + fk + "'") + ". Cannot continue");
            }
            if (rejectIndirectRelations && meta.relation.getNextRelation() != null) {
                throw new Exception("An indirect relation is required to resolve a subquery, but indirect relations are not supported for separated subqueries. DataSource chain: " + subDs.getID() + " -> " + parentDs.getID());
            }
            List<DSField> from = meta.relation.getFromFields();
            List<DSField> to = meta.relation.getToFields();
            if (from.size() > 1) {
                throw new Exception("The AdvancedCriteria Subquery feature does not support composite keys, so cannot use the relation from '" + subDs.getID() + "' to '" + parentDs.getID() + "' via foreignKeys: " + String.valueOf(from));
            }
            meta.fromFieldName = from.get(0).getName();
            meta.toFieldName = to.get(0).getName();
        }
        meta.outputFieldName = SubqueryMetadata.resolveOutputFieldName(subqueryConfig, subDs);
        return meta;
    }

    public static String resolveOutputFieldName(Map subqueryConfig, BasicDataSource subDs) {
        String queryOutput;
        Map sf = (Map)subqueryConfig.get("summaryFunctions");
        if (sf != null && !sf.isEmpty()) {
            return (String)sf.keySet().iterator().next();
        }
        Object groupByObj = subqueryConfig.get("groupBy");
        if (groupByObj != null) {
            if (groupByObj instanceof List && !((List)groupByObj).isEmpty()) {
                return (String)((List)groupByObj).get(0);
            }
            if (groupByObj instanceof String) {
                return (String)groupByObj;
            }
        }
        if ((queryOutput = (String)subqueryConfig.get("queryOutput")) != null) {
            return queryOutput;
        }
        return subDs.getDefaultSubqueryOutputFieldName();
    }
}

