/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDriver;
import java.util.Iterator;
import java.util.Map;

public class SelectClause
extends Base {
    private static Logger log = new Logger(SelectClause.class.getName());
    private Map remapTable;

    public SelectClause(Map remapTable) {
        this.remapTable = remapTable;
    }

    public String toString(SQLDriver driver) throws Exception {
        if (this.remapTable == null || this.remapTable.size() == 0) {
            log.warning((Object)"SelectClause is null or zero size, remap and conversions won't work!");
            return "*";
        }
        StringBuilder result = new StringBuilder();
        Iterator e = this.remapTable.keySet().iterator();
        while (e.hasNext()) {
            String columnName = (String)e.next();
            String rsName = (String)this.remapTable.get(columnName);
            result.append(driver.sqlOutTransform(columnName, rsName));
            if (!e.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

