/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.CriteriaUtils;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.OtherFieldCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DeclarativeSecurity;
import com.isomorphic.datasource.FullTextSearchHandler;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.StreamingResponseIterator;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.interfaces.ISpringTransactionObjectProvider;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.CacheDriver;
import com.isomorphic.sql.DBSandbox;
import com.isomorphic.sql.EscapedValuesMap;
import com.isomorphic.sql.OracleDriver;
import com.isomorphic.sql.SQLAnsiJoinClause;
import com.isomorphic.sql.SQLClauseType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDSGenerator;
import com.isomorphic.sql.SQLDataSource$;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLExpressions;
import com.isomorphic.sql.SQLJoinWhereClause;
import com.isomorphic.sql.SQLLogger;
import com.isomorphic.sql.SQLOrderClause;
import com.isomorphic.sql.SQLSelectClause;
import com.isomorphic.sql.SQLServerDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.sql.SQLTableClause;
import com.isomorphic.sql.SQLTableCreator;
import com.isomorphic.sql.SQLTransaction;
import com.isomorphic.sql.SQLTransform;
import com.isomorphic.sql.SQLUtils;
import com.isomorphic.sql.SQLValuesClause;
import com.isomorphic.sql.SQLWhereClause;
import com.isomorphic.sql.cachesync.SQLGetKeysStrategy;
import com.isomorphic.sql.cachesync.SQLRefetchStrategy;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class SQLDataSource
extends BasicDataSource
implements ISQLDataSource {
    private static Logger log = new Logger(SQLDataSource.class.getName());
    private static Logger logSqlError = new Logger("com.isomorphic.SQL_ERROR");
    private static long count = 0L;
    private static Map<String, Long> countsById = new HashMap<String, Long>();
    private static Map<String, List<Long>> instancesById = new HashMap<String, List<Long>>();
    private static List<Map> createTrace;
    private static final String TIMING_LOG_PAGED_FETCH = "Paged fetch";
    private static final String TIMING_LOG_GET_CONNECTION = "get connection";
    private static final String TIMING_LOG_QUERY = "query";
    private static final String TIMING_LOG_SQLTRANSFORM = "SQLTransform";
    private static final String TIMING_LOG_JDBCSCROLL_FETCH = "JDBC scroll fetch";
    private static final String TIMING_LOG_JDBCSCROLL_FETCH_SCROLL = "scroll";
    private static final String TIMING_LOG_COUNT_QUERY = "Rowcount query";
    protected String dbName;
    private SQLTable table;
    protected SQLDriver driver;
    private List<String> tableColumns;
    private static final String SLOW_SQL_LOGGING_CATEGORY = "com.isomorphic.SLOW_SQL";
    private static Map<String, Logger> slowSQLLoggers;
    private static int queriesSlowerThan;
    private static Logger logAlias;
    private static Logger logFK;
    private static final List supportedSummaryFunctions;
    private Map<String, Class> _generatedKeyTypes = null;

    public static long getCreationCount() {
        return count;
    }

    public static long getCreationCount(String dsId) {
        return countsById.get(dsId) == null ? 0L : countsById.get(dsId);
    }

    public static List<Long> getInstanceIds(String dsId) {
        return instancesById.get(dsId) == null ? new ArrayList() : instancesById.get(dsId);
    }

    public static Map<String, List<Long>> getInstanceIdsForPrefix(String prefix) {
        HashMap<String, List<Long>> rtn = new HashMap<String, List<Long>>();
        for (String key : instancesById.keySet()) {
            if (!key.startsWith(prefix)) continue;
            rtn.put(key, instancesById.get(key));
        }
        return rtn;
    }

    public static void clearInstanceIds(String dsId) {
        instancesById.remove(dsId);
    }

    public static void clearCreateTrace() {
        if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
    }

    public static void dumpCreateTrace(String dsName, String filename, boolean dumpStack, boolean dumpConfig) throws Exception {
        if (!config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            return;
        }
        SQLDataSource.dumpCreateTrace(createTrace, (String)dsName, (String)filename, (boolean)dumpStack, (boolean)dumpConfig);
    }

    public void setTable(SQLTable table) {
        if (table == null) {
            log.error((Object)("The following stacktrace is setting 'table' to null for SQLDataSource '" + ((Object)((Object)this)).hashCode() + "'"), (Throwable)new Exception());
        }
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        Object ID;
        this.registerCacheSyncStrategy("refetch", (CacheSyncStrategy)new SQLRefetchStrategy());
        this.registerCacheSyncStrategy("requestValuesPlusSequences", (CacheSyncStrategy)new SQLGetKeysStrategy());
        Object obj = theConfig.get("fields");
        Map fields = obj instanceof List ? DataTools.makeIndex((Collection)((List)obj), (String)"name") : (Map)obj;
        if (this.shouldAutoDerive(theConfig)) {
            ID = (String)theConfig.get("ID") + "_inheritsFrom";
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile((String)ID);
            if (dsObject instanceof DataSource) {
                this.autoDeriveDS = (DataSource)dsObject;
            } else {
                this.createAutoDeriveDS(theConfig);
                if (this.autoDeriveDS == null) {
                    String tableName = (String)theConfig.get("tableName");
                    if (tableName == null) {
                        tableName = (String)theConfig.get("ID");
                    }
                    String serverType = (String)theConfig.get("serverType");
                    String dsName = (String)theConfig.get("ID");
                    String dbName = (String)theConfig.get("dbName");
                    String schema = this.getSchemaName(theConfig);
                    Map autoDeriveSchemaOperation = null;
                    List operationBindings = DataSource.getOperationBindings((Map)theConfig);
                    if (operationBindings != null) {
                        for (Map operationBinding : operationBindings) {
                            String isAutoDeriveSchemaOperation = (String)operationBinding.get("autoDeriveSchemaOperation");
                            if (!"true".equals(isAutoDeriveSchemaOperation)) continue;
                            autoDeriveSchemaOperation = operationBinding;
                        }
                    }
                    log.info((Object)("Deriving dataSource " + dsName + (String)(tableName != null ? " from table: " + tableName : "") + (String)(autoDeriveSchemaOperation != null ? " using operation: " + DataTools.prettyPrint(autoDeriveSchemaOperation) : "")));
                    this.autoDeriveDS = SQLDataSource.fromTable(null, tableName, schema, (String)ID, serverType, dbName, autoDeriveSchemaOperation, true, fields, (Boolean)theConfig.get("autoDeriveFKs"));
                }
                if (this.autoDeriveDS != null) {
                    theConfig.put("autoDeriveSchema", true);
                    if (theConfig.get("quoteTableName") != null) {
                        this.autoDeriveDS.getConfig().put((Object)"quoteTableName", theConfig.get("quoteTableName"));
                    }
                    if (this.autoDeriveDS.getConfig().get((Object)"sequenceMode") != null && theConfig.get("sequenceMode") == null) {
                        theConfig.put("sequenceMode", this.autoDeriveDS.getConfig().get((Object)"sequenceMode"));
                    }
                }
            }
        }
        super.init(theConfig, dsRequest);
        ID = SQLDataSource.class;
        synchronized (SQLDataSource.class) {
            ++count;
            String id = (String)theConfig.get("ID");
            Long c = countsById.get(id);
            countsById.put(id, c == null ? 1L : c + 1L);
            if (config.getBoolean((Object)"datasources.sql.maintain.instanceId.map", false)) {
                List<Long> ids = instancesById.get(id);
                if (ids == null) {
                    ids = new ArrayList<Long>();
                    instancesById.put(id, ids);
                }
                ids.add(this.instanceId);
            }
            // ** MonitorExit[ID] (shouldn't be in output)
            if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("time", System.currentTimeMillis());
                map.put("ID", theConfig.get("ID"));
                map.put("instanceId", this.instanceId);
                map.put("config", theConfig);
                map.put("stack", new Exception().getStackTrace());
                List<Map> list = createTrace;
                synchronized (list) {
                    createTrace.add(map);
                }
            }
            this.setTable(this.buildSQLTable());
            this.dbName = this.dsConfig.getString((Object)"dbName");
            if (this.dbName == null) {
                this.dbName = config.getString((Object)"sql.defaultDatabase");
            }
            if (this.dbName == null) {
                throw new Exception("datasource '" + this.dsName + "' does not define a target database and sql.defaultDatabase is not specified in the master config.  Unable to determine target database");
            }
            this.normalizeFieldNamesForHSQLDB();
            return;
        }
    }

    private void normalizeFieldNamesForHSQLDB() {
        String dbType = config.getString((Object)("sql." + this.dbName + ".database.type"));
        if (dbType == null || !dbType.equalsIgnoreCase("hsqldb")) {
            return;
        }
        boolean modified = false;
        for (Object fieldNameObj : this._getFieldNames()) {
            DSField field;
            char first;
            String fieldName = (String)fieldNameObj;
            if (fieldName.length() == 0 || Character.isLetter(first = fieldName.charAt(0)) || (field = this.getField(fieldName)) == null || field.get((Object)"nativeName") != null) continue;
            String normalized = SQLDataSource.normalizeColumnName(fieldName);
            if (this.ds2NativeFieldMap.containsValue(normalized)) {
                log.warn((Object)("DataSource '" + this.dsName + "': cannot normalize HSQLDB column name for field '" + fieldName + "' to '" + normalized + "' because that column name is already in use"));
                continue;
            }
            field.put((Object)"nativeName", (Object)normalized);
            this.ds2NativeFieldMap.put(fieldName, normalized);
            modified = true;
            log.info((Object)("DataSource '" + this.dsName + "': field '" + fieldName + "' has a name that is not a valid HSQLDB identifier - using nativeName '" + normalized + "' as the database column name"));
        }
        if (modified) {
            this.native2DSFieldMap = DataTools.reverseMap((Map)this.ds2NativeFieldMap);
        }
    }

    private static String normalizeColumnName(String fieldName) {
        int start;
        for (start = 0; start < fieldName.length() && !Character.isLetter(fieldName.charAt(start)); ++start) {
        }
        Object normalized = fieldName.substring(start);
        if (((String)normalized).length() == 0) {
            normalized = "col" + fieldName.replace("_", "");
        }
        if (((String)normalized).length() == 0) {
            normalized = "col";
        }
        return normalized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<String> getTableColumns() {
        block15: {
            block16: {
                if (this.tableColumns != null) break block15;
                this.tableColumns = new ArrayList<String>();
                String tableName = this.getTableName();
                if (tableName == null) break block16;
                Connection conn = null;
                SQLDSGenerator dsGen2333333332 = new SQLDSGenerator(tableName, this.getSchemaName(), this.getDBName());
                conn = this.getConnection();
                dsGen2333333332.setConn(conn);
                List tableFields = dsGen2333333332.getFieldsFromTable();
                for (Map tableField : tableFields) {
                    String nativeName = (String)tableField.get("nativeName");
                    if (nativeName != null && !"".equals(nativeName.trim())) {
                        this.tableColumns.add(nativeName);
                        continue;
                    }
                    this.tableColumns.add((String)tableField.get("name"));
                }
                try {
                    if (conn != null) {
                        this.freeConnection(conn);
                    }
                    break block15;
                }
                catch (Exception dsGen2333333332) {}
                break block15;
                catch (Exception ex) {
                    List<String> list;
                    try {
                        log.warn((Object)("Failed to getTableColumns() for the '" + tableName + "' table. Returning null. Error: " + ex.getMessage()));
                        list = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (conn != null) {
                                this.freeConnection(conn);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (conn != null) {
                            this.freeConnection(conn);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return list;
                }
            }
            return this.getDirectFields();
        }
        return this.tableColumns;
    }

    private SQLTable buildSQLTable() throws Exception {
        HashMap<String, String> sequences = new HashMap<String, String>();
        HashMap<String, String> fieldTypes = new HashMap<String, String>();
        Map fieldMap = this.native2DSFieldMap;
        if (this.getSuper() != null) {
            fieldMap.putAll(this.getSuper().native2DSFieldMap());
        }
        Iterator i = fieldMap.keySet().iterator();
        while (i.hasNext()) {
            String column = (String)i.next();
            if (column == null || !column.contains(".")) continue;
            i.remove();
        }
        for (String columnName : fieldMap.keySet()) {
            Object fieldNameObj = fieldMap.get(columnName);
            String fieldName = null;
            fieldName = fieldNameObj instanceof List ? (String)((List)fieldNameObj).get(0) : (String)fieldNameObj;
            DSField field = this.getField(fieldName);
            String fieldType = field.getType();
            fieldTypes.put(columnName, fieldType);
            if (!"sequence".equals(fieldType) && (!"integer".equals(fieldType) || !field.isAutoGenerated() || field.containsKey((Object)"customInsertExpression"))) continue;
            String sequenceName = (String)field.get((Object)"sequenceName");
            if (sequenceName == null) {
                sequenceName = "__default";
            }
            sequences.put(columnName, sequenceName);
        }
        String tableName = this.dsConfig.getString((Object)"tableName");
        if (tableName == null) {
            tableName = this.getName();
        }
        boolean quoteColumnNames = this.dsConfig.getBoolean((Object)"quoteColumnNames", false) || this.dsConfig.getBoolean((Object)"OracleQuotedColumnNames", false) || this.dsConfig.getBoolean((Object)"quotedColumnNames", false);
        return new SQLTable(tableName, this.primaryKeys, fieldTypes, fieldMap, sequences, quoteColumnNames);
    }

    public String getColumnName(String fieldName) {
        return (String)this.getCorrectDs2NativeFieldMap().get(fieldName);
    }

    public String getFieldNameFromColumnName(String columnName) {
        return (String)this.native2DSFieldMap.get(columnName);
    }

    public String getType() {
        return "sql";
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    public DSResponse executeCustom(DSRequest req) throws Exception {
        return this.processRequest(req);
    }

    protected DSResponse processRequest(DSRequest req) throws Exception {
        String operationType = req.getOperationType();
        if (SQLDataSource.isFetch((String)operationType) || SQLDataSource.isAdd((String)operationType) || SQLDataSource.isRemove((String)operationType) || SQLDataSource.isUpdate((String)operationType) || SQLDataSource.isCustom((String)operationType) || operationType.equals("replace")) {
            DSResponse resp;
            Object dsProperty;
            DSResponse validationFailure = this.validateDSRequest(req);
            if (validationFailure != null) {
                return validationFailure;
            }
            req.setRequestStarted(true);
            Map opConfig = req.operationConfig();
            SQLDataSource dsObject = null;
            if (opConfig != null && (dsProperty = opConfig.get("dataSource")) != null && dsProperty instanceof List && ((List)dsProperty).size() > 1) {
                dsObject = dsProperty;
            }
            if ((resp = SQLDataSource.SQLExecute(req, (Object)(dsObject != null ? dsObject : this))) != null) {
                resp.setCacheSyncContext(req);
            }
            return resp;
        }
        throw new Exception("Unrecognized operationType '" + operationType + "'.  If you intended to create a new custom operationType with this name, override SQLDataSource.execute() and handle it there");
    }

    public DSResponse executeDownload(DSRequest req) throws Exception {
        String fieldName = req.getDownloadFieldName();
        Map criteria = req.getCriteria();
        DSRequest downloadDsRequest = new DSRequest(this.getName(), "fetch");
        downloadDsRequest.setRPCManager(req.getRPCManager());
        downloadDsRequest.setCriteria((Object)criteria);
        downloadDsRequest.setFreeOnExecute(req.getFreeOnExecute());
        DSResponse resp = downloadDsRequest.execute();
        req.setFreeOnExecute(downloadDsRequest.getFreeOnExecute());
        req.setAttribute("_downloadDsRequest", (Object)downloadDsRequest);
        if (resp.getData() instanceof List) {
            try {
                resp.setData(this.forceSingleObject(resp.getDataList()));
            }
            catch (Exception e) {
                String msg = "Found more than one record when looking up a binary value on DataSource '" + this.getID() + "' with criteria " + String.valueOf(req.getCriteria()) + ". Does the DataSource have a primaryKey declared?";
                log.error((Object)msg);
                throw new Exception(msg);
            }
        }
        return resp;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDatabaseName() {
        return config.getString((Object)("sql." + this.dbName + ".driver.databaseName"));
    }

    public SQLDriver getDriver() throws Exception {
        if (this.driver == null) {
            this.driver = SQLDriver.instance(this.dbName, this.getTable());
            log.debug((Object)("DataSource " + this.instanceId + " acquired SQLDriver instance " + ((Object)((Object)this.getDriver())).hashCode() + " during initialization"));
        }
        return this.driver;
    }

    public String getDBType() throws Exception {
        return this.getDriver().getDBType().toString();
    }

    public Connection getExistingTransactionalConnection(DSRequest dsRequest) throws Exception {
        Connection conn = null;
        DSTransaction dsTransaction = dsRequest.getDsTransaction();
        if (dsTransaction != null) {
            conn = (Connection)dsTransaction.getAttribute(this.getTransactionObjectKey(true));
        }
        return conn;
    }

    public Connection getTransactionalConnection(DSRequest dsRequest) throws Exception {
        if (this.shouldAutoJoinTransaction(dsRequest)) {
            DSTransaction dsTransaction = dsRequest.getDsTransaction();
            Connection conn = null;
            if (dsTransaction != null) {
                conn = (Connection)dsTransaction.getAttribute(this.getTransactionObjectKey(true));
            }
            if (conn == null && this.shouldAutoStartTransaction(dsRequest, false)) {
                if (SQLDataSource.usesSpringTransaction((DSRequest)dsRequest, (String)this.getTransactionObjectKey(false))) {
                    ISpringTransactionObjectProvider provider = (ISpringTransactionObjectProvider)InterfaceProvider.load((String)"ISpringTransactionObjectProvider");
                    conn = (Connection)provider.getSpringTransactionObject(this.getTransactionObjectKey(false));
                    if (dsTransaction != null) {
                        dsTransaction.setAttribute(this.getTransactionObjectKey(true), (Object)conn);
                        dsTransaction.setUsingSpringTransaction(true);
                    }
                } else {
                    SQLTransaction.startTransaction(dsTransaction, this.dbName);
                }
                if (dsTransaction != null) {
                    conn = (Connection)dsTransaction.getAttribute(this.getTransactionObjectKey(true));
                }
            }
            if (conn != null && dsRequest != null) {
                log.debug((Object)("Setting DSRequest as being part of a transaction on connection " + conn.hashCode()));
                dsRequest.setPartOfTransaction(true);
            }
            return conn;
        }
        return null;
    }

    public Connection getConnection() throws Exception {
        return SQLConnectionManager.getConnection(this.dbName);
    }

    public void freeConnection(Connection conn) throws Exception {
        SQLConnectionManager.free(conn);
    }

    public SQLTable getTable() {
        return this.table;
    }

    public List executeNativeQuery(String nativeCommand) throws Exception {
        return this.executeNativeQuery(nativeCommand, null, null);
    }

    public List executeNativeQuery(String nativeCommand, DSRequest req) throws Exception {
        return this.executeNativeQuery(nativeCommand, null, req);
    }

    public List executeNativeQuery(String nativeCommand, List dataSources, DSRequest req) throws Exception {
        return this.executeNativeQuery(nativeCommand, dataSources, null, req, null);
    }

    public List executeNativeQuery(String nativeCommand, DataSource ds, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        if (ds == null) {
            return this.executeNativeQuery(nativeCommand, (List)null, opConfig, req, resp);
        }
        return this.executeNativeQuery(nativeCommand, DataTools.makeList((Object)ds), opConfig, req, resp);
    }

    public List executeNativeQuery(String nativeCommand, List dataSources, Map opConfig, DSRequest req, DSResponse resp) throws Exception {
        return this.getDriver().executeQuery(nativeCommand, dataSources, opConfig, req, resp);
    }

    public int executeNativeUpdate(String nativeCommand) throws Exception {
        return this.executeNativeUpdate(nativeCommand, null);
    }

    public int executeNativeUpdate(String nativeCommand, List data, DSRequest req) throws Exception {
        return this.getDriver().executeUpdate(nativeCommand, data, req);
    }

    public int executeNativeUpdate(String nativeCommand, DSRequest req) throws Exception {
        return this.getDriver().executeUpdate(nativeCommand, req);
    }

    public Map getSequences() {
        Map localSequences = this.getTable().getSequences();
        if (localSequences != null && localSequences.keySet().size() > 0) {
            return localSequences;
        }
        Map seq = new HashMap();
        if (this.getSuper() != null) {
            try {
                seq = ((SQLDataSource)this.getSuper()).getSequences();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return seq;
    }

    public void clearCache() {
    }

    public void finalize() throws Throwable {
        if (this.driver != null) {
            log.debug((Object)("About to clear SQLDriver state for DS instance " + this.instanceId + " from Finalizer"));
            this.getDriver().clearState();
        }
    }

    public void clearState() {
        if (this.stateCleared()) {
            return;
        }
        this.clearCache();
        if (this.driver != null) {
            log.debug((Object)("About to clear SQLDriver state for DS instance " + this.instanceId));
            try {
                this.getDriver().clearState();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.clearState();
        this.setStateCleared(true);
    }

    public String getSequenceModeName() throws Exception {
        String sequenceMode = this.dsConfig.getString((Object)"sequenceMode");
        if (sequenceMode != null && SequenceMode.fromString(sequenceMode) == null) {
            log.warn((Object)("Invalid SequenceMode '" + sequenceMode + "' used in DataSource '" + this.getName() + "'.  Ignoring."));
            sequenceMode = null;
        }
        if (sequenceMode == null && (sequenceMode = this.getDriver().getSqlConfig().getString((Object)"sequence.mode")) != null && SequenceMode.fromString(sequenceMode) == null) {
            log.warn((Object)("Invalid SequenceMode '" + sequenceMode + "' used in database '" + this.getDriver().getDBName() + "' server.properties config in setting 'sequence.mode'.  Ignoring."));
            sequenceMode = null;
        }
        if (sequenceMode == null && (sequenceMode = this.getDriver().getSqlConfig().getString((Object)"default.sequence.mode")) != null && SequenceMode.fromString(sequenceMode) == null) {
            log.warn((Object)("Invalid SequenceMode '" + sequenceMode + "' used in database '" + this.getDriver().getDBName() + "' server.properties config in setting 'default.sequence.mode'.  Ignoring."));
            sequenceMode = null;
        }
        if (sequenceMode == null && (sequenceMode = config.getString((Object)"sql.default.sequence.mode")) != null && SequenceMode.fromString(sequenceMode) == null) {
            log.warn((Object)("Invalid SequenceMode '" + sequenceMode + "' used in server.properties setting 'sql.default.sequence.mode'.  Ignoring."));
            sequenceMode = null;
        }
        if (sequenceMode == null) {
            sequenceMode = "native";
        }
        return sequenceMode;
    }

    public SequenceMode getSequenceMode() throws Exception {
        return SequenceMode.fromString(this.getSequenceModeName());
    }

    public boolean isSequenceModeNone() {
        try {
            return SequenceMode.NONE.equals((Object)this.getSequenceMode());
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception trying to obtain sequenceMode", (Throwable)e);
            return false;
        }
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, DSRequest req) throws Exception {
        return this.getDriver().fetchLastPrimaryKeys(primaryKeysPresent, sequencesNotPresent, this, req);
    }

    public String escapeColumnName(Object columnName) throws Exception {
        return this.getDriver().escapeColumnName(columnName);
    }

    public String escapeValue(Object value) throws Exception {
        return this.getDriver().escapeValue(value);
    }

    public String escapeValueForFilter(Object value) throws Exception {
        return this.getDriver().escapeValueForFilter(value, null);
    }

    public String escapeValueForWhereClause(Object value, Object field) throws Exception {
        return this.valueForWhereClause(value, field, false);
    }

    public String valueForWhereClause(Object value, Object field) throws Exception {
        return this.valueForWhereClause(value, field, false);
    }

    public String valueForWhereClause(Object value, Object field, boolean filter) throws Exception {
        String columnType = null;
        DSField dsField = this.getField(field.toString());
        if (dsField != null) {
            columnType = dsField.getType();
        }
        try {
            if (columnType != null) {
                columnType = this.getSimpleBaseType(columnType);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Exception trying to get simpleBaseType for field " + field.toString()), (Throwable)e);
        }
        if (columnType == null) {
            columnType = value instanceof Date ? "date" : (value instanceof Number ? (value instanceof Float || value instanceof Double ? "float" : "integer") : "text");
        }
        if ("text".equals(columnType) || "string".equals(columnType)) {
            if (!filter) {
                return this.getDriver().sqlInTransform(value, dsField, this);
            }
            return this.getDriver().sqlFilterTransform(value, dsField, this, null);
        }
        if (SQLDataSource.typeIsNumeric(columnType)) {
            if (value instanceof String) {
                try {
                    value = SQLDataSource.typeIsDecimal(columnType) ? new BigDecimal((String)value).toString() : new BigInteger((String)value).toString();
                }
                catch (Exception e) {
                    log.warn((Object)("Got non-numeric value '" + String.valueOf(value) + "' for numeric column '" + field.toString() + "', creating literal false expression"));
                    return "'0'='1'";
                }
            }
            return value.toString();
        }
        return this.getDriver().sqlInTransform(value, dsField, this);
    }

    public static boolean typeIsDate(String type) {
        return "date".equals(type) || "time".equals(type) || "datetime".equals(type);
    }

    public static boolean typeIsBoolean(String type) {
        return "boolean".equals(type);
    }

    public static boolean typeIsDecimal(String type) {
        return "float".equals(type) || "decimal".equals(type) || "double".equals(type);
    }

    public static boolean typeIsNumeric(String type) {
        return "number".equals(type) || "float".equals(type) || "decimal".equals(type) || "double".equals(type) || "int".equals(type) || "intEnum".equals(type) || "integer".equals(type) || "sequence".equals(type);
    }

    public String getNextSequenceValue(String columnName) throws Exception {
        return this.getDriver().getNextSequenceValue(columnName, this);
    }

    public String sqlValueForFieldValue(String columnName, Object columnValue) throws Exception {
        return this.sqlValueForFieldValue(columnName, columnValue, null);
    }

    public String sqlValueForFieldValue(String columnName, Object columnValue, DSRequest req) throws Exception {
        DSField field = this.getField(columnName);
        String columnType = field.getType();
        if (columnValue == null) {
            return "NULL";
        }
        if (!(!"".equals(columnValue.toString().trim()) || !this.simpleTypeInheritsFrom(columnType, "date") && !this.simpleTypeInheritsFrom(columnType, "datetime") || field.isMultiple() && "simpleString".equals(field.getMultipleStorage()))) {
            return "NULL";
        }
        if (field.isMultiple() && columnValue instanceof Collection && field.getMultipleStorage() == null) {
            Object sqlValue = "";
            Collection coll = (Collection)columnValue;
            for (Object entry : coll) {
                if (((String)sqlValue).length() != 0) {
                    sqlValue = (String)sqlValue + ",";
                }
                sqlValue = (String)sqlValue + String.valueOf(entry);
            }
            columnValue = sqlValue;
        }
        SQLDriver driver = this.getDriver();
        if (SQLDataSource.typeIsNumeric(columnType)) {
            if (field.getProperty("sqlStorageStrategy") == null) {
                if (field.getMultipleStorage() == null) {
                    if ("".equals(columnValue)) {
                        return driver.prepareSQLParam(req, (DataSource)this, field, columnValue, "NULL");
                    }
                    return driver.prepareSQLParam(req, (DataSource)this, field, columnValue, columnValue.toString());
                }
                return driver.prepareSQLParam(req, (DataSource)this, field, columnValue, driver.escapeValue(columnValue));
            }
            if ("text".equals("sqlStorageStrategy")) {
                return driver.prepareSQLParam(req, (DataSource)this, field, columnValue, driver.escapeValue(columnValue));
            }
            log.warn((Object)("Column is numeric, but skipping escape because sqlStorageStrategy=" + field.getProperty("sqlStorageStrategy") + " multipleStorage=" + field.getMultipleStorage()));
        }
        return driver.prepareSQLParam(req, (DataSource)this, field, columnValue, driver.sqlInTransform(columnValue, field, this));
    }

    private static String getClause(DSRequest request, String clauseName, String defaultValue) throws Exception {
        Object clauseValue = SQLDataSource.getOperationProperty((DSRequest)request, (String)clauseName, (Object)defaultValue);
        return clauseValue != null ? clauseValue.toString() : null;
    }

    private static String getWhereClause(DSRequest request, Map parameters, List<SQLDataSource> dataSources, String selectClause, String tableClause, String ansiJoinClause, String joinWhereClause, String groupClause, String groupWhereClause) throws Exception {
        String opType = request.getOperationType();
        if (SQLDataSource.isFetch((String)opType)) {
            // empty if block
        }
        return SQLDataSource.getClause(request, "whereClause", "$defaultWhereClause");
    }

    private static String _getPartialWhereClause(DSRequest dsRequest, boolean dropOrKeep, boolean postAggregation, String ... fieldNames) throws Exception {
        String after;
        Object requestAfterCriteria;
        ArrayList<SQLDataSource> dataSources = new ArrayList<SQLDataSource>();
        SQLDataSource ds = (SQLDataSource)dsRequest.getDataSource();
        dataSources.add(ds);
        DataTypeMap opBinding = ds.getOperationBinding(dsRequest);
        List customFields = SQLDataSource.getCustomFields((Map)opBinding);
        List customCriteriaFields = SQLDataSource.getCustomCriteriaFields((Map)opBinding);
        List customValueFields = SQLDataSource.getCustomValueFields((Map)opBinding);
        List excludeValueFields = SQLDataSource.getExcludeValueFields((Map)opBinding);
        if (customCriteriaFields == null) {
            customCriteriaFields = customFields;
        }
        if (customValueFields == null) {
            customValueFields = customFields;
        }
        String opType = dsRequest.getOperationType();
        boolean qualifyColumnNames = SQLDataSource.shouldQualifyColumnNames((Map)opBinding, (DataSource)ds);
        boolean isFilter = "filter".equals(opType) || ("fetch".equals(opType) || "select".equals(opType)) && ("substring".equals(dsRequest.getTextMatchStyle()) || "startsWith".equals(dsRequest.getTextMatchStyle()));
        SQLWhereClause whereClause = new SQLWhereClause(dsRequest, dataSources, isFilter, dsRequest.getTextMatchStyle(), dropOrKeep, Arrays.asList(fieldNames), postAggregation);
        whereClause.setCustomCriteriaFields(customCriteriaFields);
        whereClause.setExcludeCriteriaFields(excludeValueFields);
        String afterWhereString = null;
        if (dsRequest.isSummary() && postAggregation && (requestAfterCriteria = dsRequest.getParameter((Object)"afterCriteria")) != null) {
            afterWhereString = new SQLWhereClause(dsRequest, dataSources, isFilter, dsRequest.getTextMatchStyle(), dropOrKeep, Arrays.asList(fieldNames), postAggregation, requestAfterCriteria).getSQLString();
        }
        String string = after = afterWhereString == null ? null : afterWhereString.trim();
        if (after != null && !after.isEmpty() && !SQLWhereClause.isDefaultPositiveClause(after)) {
            return whereClause.getSQLString() + " AND " + after;
        }
        return whereClause.getSQLString();
    }

    public static String getPartialWhere(DSRequest dsRequest, String ... fieldNames) throws Exception {
        return SQLDataSource._getPartialWhereClause(dsRequest, false, false, fieldNames);
    }

    public static String getWhereWithout(DSRequest dsRequest, String ... fieldNames) throws Exception {
        return SQLDataSource._getPartialWhereClause(dsRequest, true, false, fieldNames);
    }

    public static String getPartialHaving(DSRequest dsRequest, String ... fieldNames) throws Exception {
        return SQLDataSource._getPartialWhereClause(dsRequest, false, true, fieldNames);
    }

    public static String getHavingWithout(DSRequest dsRequest, String ... fieldNames) throws Exception {
        return SQLDataSource._getPartialWhereClause(dsRequest, true, true, fieldNames);
    }

    public static Map addMissingClausesToContext(Map context) {
        HashMap<String, String> contextWithDummies = new HashMap<String, String>(context);
        if (!contextWithDummies.containsKey("defaultAnsiJoinClause")) {
            contextWithDummies.put("defaultAnsiJoinClause", "");
        }
        if (!contextWithDummies.containsKey("defaultJoinWhereClause")) {
            contextWithDummies.put("defaultJoinWhereClause", "");
        }
        return contextWithDummies;
    }

    public static String generateSQLStatement(DSRequest request, Map parameters) throws Exception {
        return SQLDataSource.generateSQLStatement(request, parameters, null);
    }

    private static String generateSQLStatement(DSRequest request, Map parameters, List<SQLDataSource> dataSources) throws Exception {
        Object statement;
        boolean queryIsDefault;
        String opType = request.getOperationType();
        String command = (String)request.getOperationProperty("command");
        SQLDataSource ds = (SQLDataSource)request.getDataSource();
        if (command != null) {
            return Velocity.evaluateWithSnippets((String)command, (Map)SQLDataSource.addMissingClausesToContext(parameters), (String)opType, (DSRequest)request, (boolean)true, (boolean)false);
        }
        String customSQL = SQLDataSource.getClause(request, "customSQL", null);
        if (customSQL != null) {
            String trimmed = new String(customSQL.trim());
            if (trimmed.endsWith(";")) {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
            }
            return Velocity.evaluateWithSnippets((String)trimmed, (Map)SQLDataSource.addMissingClausesToContext(parameters), (String)opType, (DSRequest)request, (boolean)true, (boolean)false);
        }
        String selectClause = SQLDataSource.getClause(request, "selectClause", null);
        if (selectClause == null) {
            selectClause = "$defaultSelectClause";
        }
        boolean selectClauseIsDefault = "$defaultSelectClause".equals(selectClause.trim());
        String tableClause = SQLDataSource.getClause(request, "tableClause", null);
        if (tableClause == null) {
            tableClause = "$defaultTableClause";
        }
        boolean tableClauseIsDefault = "$defaultTableClause".equals(tableClause.trim());
        String ansiJoinClause = SQLDataSource.getClause(request, "ansiJoinClause", null);
        if (ansiJoinClause == null) {
            ansiJoinClause = "$defaultAnsiJoinClause";
        }
        boolean ansiJoinClauseIsDefault = "$defaultAnsiJoinClause".equals(ansiJoinClause.trim());
        String joinWhereClause = SQLDataSource.getClause(request, "joinWhereClause", null);
        if (joinWhereClause == null) {
            joinWhereClause = "$defaultJoinWhereClause";
        }
        boolean joinWhereClauseIsDefault = "$defaultJoinWhereClause".equals(joinWhereClause.trim());
        String valuesClause = SQLDataSource.getClause(request, "valuesClause", null);
        if (valuesClause == null) {
            valuesClause = "$defaultValuesClause";
        }
        boolean valuesClauseIsDefault = "$defaultValuesClause".equals(valuesClause.trim());
        String groupClause = SQLDataSource.getClause(request, "groupClause", null);
        if (groupClause == null) {
            groupClause = "$defaultGroupClause";
        }
        boolean groupClauseIsDefault = "$defaultGroupClause".equals(groupClause.trim());
        String groupWhereClause = SQLDataSource.getClause(request, "groupWhereClause", null);
        if (groupWhereClause == null) {
            groupWhereClause = "$defaultGroupWhereClause";
        }
        boolean groupWhereClauseIsDefault = "$defaultGroupWhereClause".equals(groupWhereClause.trim());
        String afterWhereClause = SQLDataSource.getClause(request, "afterWhereClause", null);
        if (afterWhereClause == null) {
            afterWhereClause = "$defaultAfterWhereClause";
        }
        boolean afterWhereClauseIsDefault = "$defaultAfterWhereClause".equals(afterWhereClause.trim());
        String orderClause = SQLDataSource.getClause(request, "orderClause", null);
        if (orderClause == null) {
            orderClause = "$defaultOrderClause";
        }
        boolean orderClauseIsDefault = "$defaultOrderClause".equals(orderClause.trim());
        String whereClause = SQLDataSource.getWhereClause(request, parameters, dataSources, selectClause, tableClause, ansiJoinClause, joinWhereClause, groupClause, groupWhereClause);
        boolean whereClauseIsDefault = "$defaultWhereClause".equals(whereClause.trim());
        boolean bl = queryIsDefault = selectClauseIsDefault && tableClauseIsDefault && ansiJoinClauseIsDefault && joinWhereClauseIsDefault && valuesClauseIsDefault && groupClauseIsDefault && groupWhereClauseIsDefault && afterWhereClauseIsDefault && orderClauseIsDefault && whereClauseIsDefault;
        if (SQLDataSource.isFetch((String)opType)) {
            StringBuilder statementBuilder = new StringBuilder();
            boolean emitJoinClause = !ansiJoinClauseIsDefault || parameters.get("defaultAnsiJoinClause") != null;
            boolean emitJoinWhereClause = (!emitJoinClause || request.isValueOperation() || request.isSummaryFunction()) && (!joinWhereClauseIsDefault || parameters.get("defaultJoinWhereClause") != null && !"".equals(parameters.get("defaultJoinWhereClause")));
            String defaultGroupClause = (String)parameters.get("defaultGroupClause");
            boolean emitGroupClause = !groupClauseIsDefault || defaultGroupClause != null && !"".equals(defaultGroupClause.trim());
            SQLDataSource.append(statementBuilder, "SELECT ", selectClause.toString(), " FROM ", tableClause.toString());
            if (emitJoinClause) {
                SQLDataSource.append(statementBuilder, " ", ansiJoinClause.toString());
            }
            boolean emittedWhere = false;
            if (!whereClauseIsDefault || parameters.get("defaultWhereClause") != null) {
                SQLDataSource.append(statementBuilder, " WHERE ", whereClause.toString());
                emittedWhere = true;
            }
            if (emitJoinWhereClause) {
                SQLDataSource.append(statementBuilder, emittedWhere ? " AND " : " WHERE ", joinWhereClause.toString());
            }
            if (emitGroupClause) {
                SQLDataSource.append(statementBuilder, " GROUP BY ", groupClause.toString());
            }
            DataTypeMap operationBinding = ds.getOperationBinding(request);
            Boolean useHavingClause = null;
            if (operationBinding != null) {
                useHavingClause = DataTools.getBooleanObject((Map)operationBinding, (Object)"useHavingClause", null);
            }
            if (useHavingClause == null) {
                useHavingClause = ds.getDriver().useHavingClause();
            }
            String defaultGroupWhereClause = (String)parameters.get("defaultGroupWhereClause");
            String defaultAfterWhereClause = (String)parameters.get("defaultAfterWhereClause");
            if (!groupWhereClauseIsDefault && afterWhereClauseIsDefault) {
                if (Boolean.TRUE.equals(useHavingClause)) {
                    if (!groupWhereClauseIsDefault || defaultGroupWhereClause != null && !SQLWhereClause.isDefaultPositiveClause(defaultGroupWhereClause)) {
                        SQLDataSource.append(statementBuilder, " HAVING ", groupWhereClauseIsDefault ? defaultGroupWhereClause : groupWhereClause.toString());
                    }
                } else {
                    statementBuilder = SQLDataSource.addGroupWhereClause(statementBuilder, groupWhereClause.toString(), defaultGroupWhereClause, false);
                }
            } else if (Boolean.TRUE.equals(useHavingClause)) {
                if (!afterWhereClauseIsDefault || defaultAfterWhereClause != null && !SQLWhereClause.isDefaultPositiveClause(defaultAfterWhereClause)) {
                    SQLDataSource.append(statementBuilder, " HAVING ", afterWhereClauseIsDefault ? defaultAfterWhereClause : afterWhereClause.toString());
                }
            } else {
                statementBuilder = SQLDataSource.addGroupWhereClause(statementBuilder, afterWhereClause.toString(), defaultAfterWhereClause, true);
            }
            Object defaultOrderClause = parameters.get("defaultOrderClause");
            if (!orderClauseIsDefault || defaultOrderClause != null && !defaultOrderClause.equals("")) {
                SQLDataSource.append(statementBuilder, " ORDER BY ", orderClause.toString());
            }
            statement = statementBuilder.toString();
            if (!queryIsDefault && log.isInfoEnabled() && (request == null || !"fileSourceDataSources".equals(request.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true))) {
                ds.getDriver();
                log.info((Object)("derived query: " + SQLDriver.formatSQL((String)statement)));
            }
        } else if (SQLDataSource.isAdd((String)opType)) {
            statement = "INSERT INTO " + tableClause + " " + valuesClause;
        } else if (SQLDataSource.isUpdate((String)opType)) {
            statement = "UPDATE " + tableClause + " SET " + valuesClause + " WHERE " + whereClause;
        } else if (SQLDataSource.isRemove((String)opType)) {
            statement = "DELETE FROM " + tableClause + " WHERE " + whereClause;
        } else if ("replace".equals(opType)) {
            statement = "REPLACE INTO " + tableClause + " " + valuesClause;
        } else if ("custom".equals(opType)) {
            statement = "";
        } else {
            throw new Exception("Operation type " + opType + " not supported by generateSQLStatement");
        }
        return Velocity.evaluateWithSnippets((String)statement, (Map)SQLDataSource.addMissingClausesToContext(parameters), (String)opType, (DSRequest)request, (boolean)true, (boolean)false);
    }

    private static String applyPrefixAndSuffix(String sql, DSRequest req) throws Exception {
        return SQLDataSource.applyPrefixAndSuffix(sql, req, null);
    }

    private static String applyPrefixAndSuffix(String sql, DSRequest req, SQLDataSource ds) throws Exception {
        return SQLDataSource.applyPrefixAndSuffix(sql, req, ds, false);
    }

    private static String applyPrefixAndSuffix(String sql, DSRequest req, SQLDataSource ds, boolean isRowCount) throws Exception {
        String suffix;
        String prefix = (ds = ds == null ? (SQLDataSource)req.getDataSource() : ds).getSQLPrefix(req);
        if (prefix != null && (!isRowCount || ds.shouldApplyPrefixToRowCount(req))) {
            sql = prefix + " " + (String)sql;
        }
        if ((suffix = ds.getSQLSuffix(req)) != null && (!isRowCount || ds.shouldApplySuffixToRowCount(req))) {
            sql = (String)sql + " " + suffix;
        }
        return sql;
    }

    protected String getSQLPrefix(DSRequest req) throws Exception {
        String prefix = (String)SQLDataSource.getOperationProperty((DSRequest)req, (String)"sqlPrefix", null);
        if (prefix == null) {
            prefix = (String)req.getDataSource().getObjectProperty("sqlPrefix");
        }
        if (prefix != null) {
            prefix = Velocity.evaluateAsString((String)prefix, (Map)Velocity.getStandardContextMap((DSRequest)req));
        }
        return prefix;
    }

    protected String getSQLSuffix(DSRequest req) throws Exception {
        String suffix = (String)SQLDataSource.getOperationProperty((DSRequest)req, (String)"sqlSuffix", null);
        if (suffix == null) {
            suffix = (String)req.getDataSource().getObjectProperty("sqlSuffix");
        }
        if (suffix != null) {
            suffix = Velocity.evaluateAsString((String)suffix, (Map)Velocity.getStandardContextMap((DSRequest)req));
        }
        return suffix;
    }

    protected boolean shouldApplyPrefixToRowCount(DSRequest req) throws Exception {
        Boolean prefix = DataTools.asBooleanObject((Object)SQLDataSource.getOperationProperty((DSRequest)req, (String)"applySqlPrefixToRowCount", null));
        if (prefix == null) {
            prefix = DataTools.asBooleanObject((Object)req.getDataSource().getObjectProperty("applySqlPrefixToRowCount"));
        }
        if (prefix == null) {
            prefix = true;
        }
        return prefix;
    }

    protected boolean shouldApplySuffixToRowCount(DSRequest req) throws Exception {
        Boolean suffix = DataTools.asBooleanObject((Object)SQLDataSource.getOperationProperty((DSRequest)req, (String)"applySqlSuffixToRowCount", null));
        if (suffix == null) {
            suffix = DataTools.asBooleanObject((Object)req.getDataSource().getObjectProperty("applySqlSuffixToRowCount"));
        }
        if (suffix == null) {
            suffix = true;
        }
        return suffix;
    }

    static String addMDCKey(String statement) {
        String sqlCommentMDCValue;
        String sqlCommentMDCKey = config.getString((Object)"sql_comment_mdc_key");
        if (sqlCommentMDCKey != null && !"".equals(sqlCommentMDCKey) && (sqlCommentMDCValue = (String)Logger.getMDC((String)sqlCommentMDCKey)) != null && !"".equals(sqlCommentMDCValue.trim())) {
            statement = (String)statement + " -- " + sqlCommentMDCValue;
        }
        return statement;
    }

    private static void append(StringBuilder sb, String ... strings) {
        for (String s : strings) {
            sb.append(s);
        }
    }

    private static StringBuilder addGroupWhereClause(StringBuilder statement, String groupWhereClause, String defaultGroupWhereClause, boolean after) {
        boolean isDefault = (after ? "$defaultAfterWhereClause" : "$defaultGroupWhereClause").equals(groupWhereClause);
        if (!isDefault || defaultGroupWhereClause != null && !SQLWhereClause.isDefaultPositiveClause(defaultGroupWhereClause)) {
            StringBuilder wrapper = new StringBuilder("SELECT * FROM (");
            wrapper.append((CharSequence)statement);
            SQLDataSource.append(wrapper, ") wrk WHERE ", isDefault ? defaultGroupWhereClause : groupWhereClause);
            return wrapper;
        }
        return statement;
    }

    public boolean shouldInvalidateCache(DSRequest req) throws Exception {
        SQLDataSource ds = (SQLDataSource)req.getDataSource();
        return SQLDataSource.shouldInvalidateCache(req, ds.getDriver());
    }

    private static boolean shouldInvalidateCache(DSRequest req, SQLDriver driver) throws Exception {
        Object invalCache;
        if (req.forceInvalidateCache()) {
            return true;
        }
        DataTypeMap opBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        if (opBinding != null && (invalCache = opBinding.get("invalidateCache")) != null && invalCache.toString().toLowerCase().equals("true")) {
            return true;
        }
        if (driver instanceof CacheDriver) {
            return true;
        }
        Object work = SQLDataSource.getOperationProperty((DSRequest)req, (String)"canSyncCache", null);
        if (work != null) {
            return work.toString().toLowerCase().equals("false");
        }
        if (SQLDataSource.getOperationProperty((DSRequest)req, (String)"cacheSyncOperation", null) != null) {
            return false;
        }
        if (req.getDataSource().getPrimaryKeys().isEmpty()) {
            return true;
        }
        if (req.getOperationProperty("command") != null) {
            return true;
        }
        if (SQLDataSource.getClause(req, "customSQL", null) != null) {
            return true;
        }
        String opType = req.getOperationType();
        if (SQLDataSource.isAdd((String)opType) || "replace".equals(opType)) {
            return SQLDataSource.getClause(req, "valuesClause", null) != null;
        }
        if (SQLDataSource.isRemove((String)opType) || SQLDataSource.isUpdate((String)opType)) {
            return SQLDataSource.getClause(req, "whereClause", null) != null;
        }
        return false;
    }

    public static boolean needJSONFiltering(DSRequest req) {
        List propsToKeep = req.getConsolidatedOutputs();
        List groupByColumns = req.getSummaryFields();
        if (propsToKeep != null && req.isSummary()) {
            groupByColumns.removeAll(propsToKeep);
            if (!groupByColumns.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static DSResponse SQLExecute(DSRequest req) throws Exception {
        return SQLDataSource.SQLExecute(req, null);
    }

    public static DSResponse SQLExecute(DSRequest req, Object dsObject) throws Exception {
        return SQLDataSource.SQLExecute(req, dsObject, false);
    }

    public static DSResponse SQLExecute(DSRequest req, Object dsObject, boolean generateSQLOnly) throws Exception {
        List<SQLDataSource> dataSources;
        Map opConfig = req.operationConfig();
        String opType = req.getOperationType();
        String opID = req.getOperationId();
        if (dsObject == null) {
            if (opConfig == null) {
                throw new Exception("no datasources specified in argument and no operation config to look them up; can't proceed");
            }
            dsObject = opConfig.get("dataSource");
        }
        if (dsObject instanceof String || dsObject instanceof SQLDataSource) {
            dataSources = SQLDataSource.getDataSources(DataTools.makeList((Object)dsObject), req);
        } else if (dsObject instanceof List) {
            dataSources = SQLDataSource.getDataSources((List)dsObject, req);
        } else {
            throw new Exception("in the app operation config, datasource must be set to a string or list");
        }
        SQLDataSource firstDS = dataSources.get(0);
        req.resolveSeparatedSubqueries();
        if (req.getIsAdvancedCriteria()) {
            req.collectQueryFieldsFromAdvancedCriteria(req.getCriteria(false));
        }
        List valueSets = req.getValueSets();
        boolean isBatchAdding = Boolean.TRUE.equals(req.getAttribute("isBatchAdding"));
        if (SQLDataSource.isAdd((String)opType) && valueSets.size() > 1 && !isBatchAdding) {
            return SQLDataSource.executeMultipleInsert(req, valueSets, dataSources);
        }
        if (opType.equals("replace") && !firstDS.getDriver().supportsNativeReplace()) {
            req.setOperationType("remove");
            SQLDataSource.SQLExecute(req, dataSources);
            req.setOperationType("add");
            return SQLDataSource.SQLExecute(req, dataSources);
        }
        DataTypeMap operationBinding = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        List customFields = SQLDataSource.getCustomFields((Map)operationBinding);
        List customCriteriaFields = SQLDataSource.getCustomCriteriaFields((Map)operationBinding);
        List customValueFields = SQLDataSource.getCustomValueFields((Map)operationBinding);
        List excludeValueFields = SQLDataSource.getExcludeValueFields((Map)operationBinding);
        if (customCriteriaFields == null) {
            customCriteriaFields = customFields;
        }
        if (customValueFields == null) {
            customValueFields = customFields;
        }
        boolean qualifyColumnNames = SQLDataSource.shouldQualifyColumnNames((Map)operationBinding, (DataSource)firstDS);
        if ("add".equals(opType)) {
            int loopMax = isBatchAdding ? valueSets.size() : 1;
            for (int i = 0; i < loopMax; ++i) {
                List keysMissing = isBatchAdding ? req.getMissingPrimaryKeysForAdd(i) : req.getMissingPrimaryKeysForAdd();
                if (keysMissing.size() <= 0) continue;
                throw new UpdateWithoutPKException("Criteria received from the client for add operation is missing the following non-sequence primary key fields: " + keysMissing.toString() + (String)(isBatchAdding ? " in valueSet " + i : "") + ". Either provide all primary key fields that are not sequences, or set allowMultiUpdate on the OperationBinding");
            }
        }
        firstDS.clearCache();
        Map context = SQLDataSource.getClausesContext(req, dataSources, qualifyColumnNames, customCriteriaFields, customValueFields, excludeValueFields, (Map)operationBinding);
        if (!(!SQLDataSource.isAdd((String)opType) && !SQLDataSource.isUpdate((String)opType) && !opType.equals("replace") || req.getOperationProperty("command") != null || operationBinding != null && operationBinding.containsKey("customSQL") || operationBinding != null && operationBinding.containsKey("valuesClause") || req.getOperationProperty("valuesClause") != null || context.get("defaultValuesClause") != null)) {
            log.warn((Object)"Insert, update or replace operation is not a full query; check DataSource configuration (operationBinding, valuesClause);check submitted parameters (valuesClause, command) for operation.");
            throw new Exception("Insert, update or replace operation is not a full query; check DataSource configuration (operationBinding, valuesClause);check submitted parameters (valuesClause, command) for operation.");
        }
        if (opConfig != null || operationBinding != null) {
            context.putAll(SQLDataSource.getVariablesContext(req, dataSources));
        }
        String statement = SQLDataSource.generateSQLStatement(req, context, dataSources);
        if (SQLDataSource.isFetch((String)opType)) {
            String paging = SQLDataSource.getPaging(req, (Map)operationBinding, firstDS);
            if (!req.isPaged() || !"sqlLimit".equals(paging)) {
                statement = SQLDataSource.applyPrefixAndSuffix(statement, req);
            }
        }
        if (generateSQLOnly) {
            return new DSResponse((Object)statement);
        }
        DSResponse result = new DSResponse((DataSource)firstDS);
        if (SQLDataSource.isCustom((String)opType) && "".equals(statement)) {
            result.setStatus(0);
        } else if (SQLDataSource.isFetch((String)opType) || SQLDataSource.isCustom((String)opType) && operationBinding != null && !"update".equals(operationBinding.get("sqlType"))) {
            String paging = SQLDataSource.getPaging(req, (Map)operationBinding, firstDS);
            if (req.isPaged() && !"none".equals(paging)) {
                long start = System.currentTimeMillis();
                result = SQLDataSource.executeWindowedSelect(req, dataSources, context, statement, paging);
                log.debug((Object)("Paged fetch returned " + (result.getEndRow() - result.getStartRow()) + " records"));
                SQLDataSource.fetchAdditionalConcatFields(req, (DataSource)firstDS, result.getDataList());
                long end = System.currentTimeMillis();
                Logger.timing.debug((Object)("Query time: " + (end - start) + "ms"));
            } else {
                if (SQLLogger.isDebugEnabled() && (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true))) {
                    SQLLogger.debug((Object)(firstDS.getInstanceId() + ": Executing SQL query on '" + firstDS.getDBName() + "'"), statement);
                }
                List results = firstDS.executeNativeQuery(statement, (DataSource)firstDS, (Map)operationBinding, req, result);
                SQLDataSource.fetchAdditionalConcatFields(req, (DataSource)firstDS, results);
                if (!req.shouldStreamResults()) {
                    if (SQLDataSource.needJSONFiltering(req)) {
                        result.setData((Object)new JSONFilter((Object)results, (Collection)req.getConsolidatedOutputs()));
                    } else {
                        result.setData((Object)results);
                    }
                    result.setTotalRows((long)results.size());
                    result.setStartRow(0L);
                    result.setEndRow((long)results.size());
                    log.debug((Object)("Non-streamed fetch returned " + results.size() + " records"));
                }
            }
        } else {
            ArrayList streams = new ArrayList();
            List binaryStreams = config.getBoolean((Object)"oldBinaryStreamHandling", false) ? req.getUploadedFileStreams() : req.getBinaryStreams();
            int binaryStreamsIndex = 0;
            List sortedFields = DataTools.getSortedList((List)firstDS._getFieldNames());
            for (int k = 0; k < req.getValueSets().size(); ++k) {
                Map values = (Map)req.getValueSets().get(k);
                for (String fieldName : sortedFields) {
                    DSField dsField = firstDS.getField(fieldName);
                    if (firstDS.getDriver().fieldAssignableInline(dsField)) continue;
                    if (dsField.isBinary()) {
                        boolean skipCustomSQLCheck = false;
                        if (customValueFields != null) {
                            Iterator iter = customValueFields.iterator();
                            while (iter.hasNext()) {
                                if (!iter.next().equals(dsField.getName())) continue;
                                skipCustomSQLCheck = true;
                                break;
                            }
                        }
                        if (!skipCustomSQLCheck && (dsField.getBoolean("customSQL") || dsField.get((Object)"customSelectExpression") != null)) continue;
                        if (binaryStreams != null && binaryStreams.size() > binaryStreamsIndex && values.containsKey(fieldName)) {
                            streams.add(binaryStreams.get(binaryStreamsIndex++));
                            continue;
                        }
                        if (values == null || !values.containsKey(fieldName)) continue;
                        streams.add(null);
                        continue;
                    }
                    boolean customExpression = SQLDataSource.isAdd((String)opType) && dsField.get((Object)"customInsertExpression") != null || SQLDataSource.isAddOrUpdate((String)opType) && dsField.get((Object)"customUpdateExpression") != null;
                    Object value = values.get(fieldName);
                    if (value != null) {
                        if (customExpression) continue;
                        streams.add(new StringReader(firstDS.getDriver().sqlInTransform(value, dsField, null, firstDS, false, true)));
                        continue;
                    }
                    if (!values.containsKey(fieldName) || customExpression && !config.getBoolean((Object)"sql.prioritizeClientNullValueOverServerCustomExpression", false)) continue;
                    streams.add(null);
                }
            }
            int rowsAffected = firstDS.executeNativeUpdate(statement, streams, req);
            result.setAffectedRows((long)rowsAffected);
            req.setAttribute("_affectedRows", (Object)rowsAffected);
            req.setLastPrimaryKeysData(req.getCriteria(false));
            CacheSyncStrategy syncStrategy = req.getCacheSyncStrategy();
            if (rowsAffected > 0) {
                Boolean makeKeysAvailable;
                Boolean bl = makeKeysAvailable = operationBinding == null ? null : DataTools.getBooleanObject((Map)operationBinding, (Object)"makeKeysAvailable", null);
                if (makeKeysAvailable == null) {
                    makeKeysAvailable = config.getBoolean((Object)"sql.always.makeKeysAvailable", false);
                }
                if (firstDS.getSequenceMode() == SequenceMode.JDBC_DRIVER || makeKeysAvailable.booleanValue() || !SQLDataSource.shouldInvalidateCache(req, firstDS.getDriver())) {
                    HashMap storeValues = req.getCriteria(false);
                    if (SQLDataSource.isAdd((String)opType) && req.getValueSets().size() == 1) {
                        storeValues = new HashMap(req.getCriteria());
                        Iterator i = storeValues.keySet().iterator();
                        while (i.hasNext()) {
                            String fieldName = (String)i.next();
                            DSField field = firstDS.getField(fieldName);
                            if (field == null || !"sequence".equals(field.getType())) continue;
                            i.remove();
                        }
                    }
                    req.setLastPrimaryKeysData((Map)storeValues);
                    if (firstDS.getSequenceMode() == SequenceMode.JDBC_DRIVER && SQLDataSource.isAdd((String)opType)) {
                        Map jdbcPKs = firstDS.getDriver().getJdbcPKs();
                        if (jdbcPKs != null && jdbcPKs.size() > 0) {
                            req.addToLastPrimaryKeys(result, jdbcPKs);
                            log.debug((Object)"Added JDBC-generated values to the list of primaryKeys");
                        }
                        result.setKeys(req.getLastPrimaryKeys(result));
                    }
                    if (req.isCacheSyncSkipped()) {
                        log.debug((Object)"cache sync skipped by dsRequest.setSkipCacheSync() directive - setting invalidateCache: true on response");
                        result.setInvalidateCache(true);
                    } else if (syncStrategy.shouldRunCacheSync(req) && !req.shouldDeferCacheSync() || firstDS.getSequenceMode() == SequenceMode.NATIVE && makeKeysAvailable.booleanValue()) {
                        Map keys = req.getLastPrimaryKeys(result);
                        log.debug((Object)("Gathered all keys.  lastPrimaryKeys is now " + String.valueOf(keys)));
                        result.setKeys(keys);
                    }
                }
            }
            if (!SQLDataSource.isCustom((String)opType)) {
                if (rowsAffected > 0) {
                    log.debug((Object)(opType + " operation affected " + rowsAffected + " rows"));
                    if (SQLDataSource.shouldInvalidateCache(req, firstDS.getDriver())) {
                        result.setInvalidateCache(true);
                    } else if (req.isCacheSyncSkipped()) {
                        log.debug((Object)"cache sync skipped by dsRequest.setSkipCacheSync() directive - setting invalidateCache: true on response");
                        result.setInvalidateCache(true);
                    } else if ((DataSource.isRemove((String)req.getOperationType()) || DataSource.isUpdate((String)req.getOperationType())) && "none".equals(req.getCacheSyncStrategyName())) {
                        result.setInvalidateCache(true);
                    } else {
                        List data = null;
                        if (syncStrategy.shouldRunCacheSync(req) && !req.shouldDeferCacheSync()) {
                            data = syncStrategy.getCacheSyncData(req, result);
                            result.setCacheSyncComplete(true);
                        }
                        result.setData((Object)(data instanceof JSONFilter ? data : DataTools.makeListIfSingle(data)));
                    }
                } else {
                    log.debug((Object)(opType + " operation affected no rows"));
                }
            }
        }
        return result;
    }

    public boolean requestRequiresChildUpdates(DSRequest req) throws Exception {
        boolean requiresChildUpdates = false;
        String opType = req.getOperationType();
        DataSource ds = req.getDataSource();
        List fieldNames = ds._getFieldNames();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = (String)fieldNames.get(i);
            DSField field = ds.getField((String)fieldNames.get(i));
            if (!field.isMultiple() || field.getForeignKey() == null) continue;
            if (req.getFieldValue((Object)fieldName) == null) {
                if (!DataSource.isRemove((String)opType)) continue;
            }
            String[] fkElements = field.getForeignKey().split("\\.");
            IncludeFromDefinition incFrom = field.getIncludeFromDefinition(req);
            if (incFrom == null) {
                log.warn((Object)("Field " + fieldName + " on DataSource " + ds.getName() + " appears to be a multiple foreignKey field (one-to-many or many-to-many), but there is no associated includeFrom (this should have been added automatically during DataSource instantiation).  Cannot continue"));
                continue;
            }
            requiresChildUpdates = true;
            break;
        }
        return requiresChildUpdates;
    }

    protected void performChildUpdates(DSRequest req, DSResponse resp) throws Exception {
        String opType = req.getOperationType();
        DataSource ds = req.getDataSource();
        List fieldNames = ds._getFieldNames();
        Map values = null;
        for (int i = 0; i < fieldNames.size(); ++i) {
            List newKeys;
            String fieldName = (String)fieldNames.get(i);
            DSField field = ds.getField((String)fieldNames.get(i));
            if (!field.isMultiple() || field.getForeignKey() == null || field.isCustomSQL()) continue;
            ArrayList<String> summaryFunctionFields = req.getSummaryFunctionFields();
            if (summaryFunctionFields == null) {
                summaryFunctionFields = new ArrayList<String>();
                req.setSummaryFunctionFields(summaryFunctionFields);
            }
            if (!summaryFunctionFields.contains(fieldName)) {
                summaryFunctionFields.add(fieldName);
            }
            if (req.getFieldValue((Object)fieldName) == null) {
                if (!DataSource.isRemove((String)opType)) continue;
            }
            String[] fkElements = field.getForeignKey().split("\\.");
            IncludeFromDefinition incFrom = field.getIncludeFromDefinition(req);
            if (incFrom == null) {
                log.warn((Object)("Field " + fieldName + " on DataSource " + ds.getName() + " is a " + (field.is1ManyRelation() ? "one" : "many") + "-to-many Relation Field (marked multiple:true and has a foreignKey declaration) but there is no associated includeFrom (this should have been added automatically during DataSource instantiation).  Cannot continue"));
                continue;
            }
            boolean isOneToMany = true;
            Relation relation = incFrom.getRelation();
            if (relation == null) {
                relation = ds.getRelation(incFrom.getDataSource());
            }
            if (fkElements.length > 2 && fkElements[0].equals(relation.getToDataSource().getName()) && relation.getNextRelation() != null && fkElements[1].equals(relation.getNextRelation().getToDataSource().getName())) {
                isOneToMany = false;
            }
            if (values == null && (values = resp.getDataMap()) == null) {
                return;
            }
            List existingKeys = (List)values.get(fieldName);
            values.put(fieldName, req.getFieldValue((Object)fieldName));
            if (DataSource.isRemove((String)opType)) {
                if (isOneToMany) {
                    SQLDataSource.updateChildRecordsByFK(field.getForeignKey(), values.get(this.getPrimaryKey()), field.get((Object)"defaultFKValue"), req);
                    continue;
                }
                SQLDataSource.removeJoinRecordsByThisFK(relation, values.get(this.getPrimaryKey()), req);
                continue;
            }
            if (SQLDataSource.isUpdate((String)opType)) {
                if (existingKeys == null || existingKeys.size() == 0) {
                    existingKeys = SQLDataSource.getExistingSubRecords(ds, values, fieldName, req);
                }
                newKeys = (List)values.get(fieldName);
                List removedKeys = SQLDataSource.setDisjunction(existingKeys, newKeys);
                newKeys = SQLDataSource.setDisjunction(newKeys, existingKeys);
                if (isOneToMany) {
                    SQLDataSource.updateChildRecords(removedKeys, req, field.getForeignKey(), field.get((Object)"defaultFKValue"));
                    boolean generateRelatedUpdates = !Boolean.FALSE.equals(req.getGenerateRelatedUpdates());
                    List<Map> previousParents = null;
                    if (generateRelatedUpdates) {
                        previousParents = SQLDataSource.getCurrentParentRecords(newKeys, req, field.getForeignKey());
                    }
                    SQLDataSource.updateChildRecords(newKeys, req, field.getForeignKey(), values.get(ds.getPrimaryKey()));
                    if (!generateRelatedUpdates) continue;
                    List<DSResponse> relatedUpdates = SQLDataSource.generateRelatedUpdatesForPreviousParents(previousParents, req);
                    resp.addRelatedUpdates(relatedUpdates);
                    continue;
                }
                SQLDataSource.removeJoinRecordsByOtherFK(relation, values.get(ds.getPrimaryKey()), removedKeys, req);
                SQLDataSource.addJoinRecords(relation, values.get(ds.getPrimaryKey()), newKeys, req);
                continue;
            }
            if (!DataSource.isAdd((String)opType)) continue;
            newKeys = (List)values.get(fieldName);
            if (isOneToMany) {
                boolean generateRelatedUpdates = !Boolean.FALSE.equals(req.getGenerateRelatedUpdates());
                List<Map> previousParents = null;
                if (generateRelatedUpdates) {
                    previousParents = SQLDataSource.getCurrentParentRecords(newKeys, req, field.getForeignKey());
                }
                SQLDataSource.updateChildRecords(newKeys, req, field.getForeignKey(), values.get(ds.getPrimaryKey()));
                if (!generateRelatedUpdates) continue;
                List<DSResponse> relatedUpdates = SQLDataSource.generateRelatedUpdatesForPreviousParents(previousParents, req);
                resp.addRelatedUpdates(relatedUpdates);
                continue;
            }
            SQLDataSource.addJoinRecords(relation, values.get(ds.getPrimaryKey()), newKeys, req);
        }
    }

    protected boolean childUpdatesRequireRefetch(DSRequest req) {
        List fields = req.getConsolidatedOutputs();
        if (fields == null || fields.isEmpty()) {
            fields = this._getFieldNames();
        }
        for (int i = 0; i < fields.size(); ++i) {
            DSField field = this.getField((String)fields.get(i));
            if (field == null || field.getIncludeFrom() == null || field.get((Object)"includeSummaryFunction") == null) continue;
            return true;
        }
        return false;
    }

    private static List setDisjunction(List left, List right) {
        ArrayList result = new ArrayList();
        if (right == null || right.size() == 0) {
            if (left != null) {
                result.addAll(left);
            }
        } else if (left != null) {
            for (Object leftObj : left) {
                if (leftObj == null || SQLDataSource.listContains(right, leftObj)) continue;
                result.add(leftObj);
            }
        }
        return result;
    }

    private static boolean listContains(List list, Object object) {
        Number leftNumber = null;
        if (object instanceof Number) {
            leftNumber = (Number)object;
        }
        for (int j = 0; j < list.size(); ++j) {
            Object rightObj = list.get(j);
            if (leftNumber != null) {
                if (!(rightObj instanceof Number)) continue;
                Number rightNumber = (Number)rightObj;
                double diff = Math.abs(leftNumber.doubleValue() - rightNumber.doubleValue());
                if (!(diff < 1.0E-5)) continue;
                return true;
            }
            if (!object.equals(rightObj)) continue;
            return true;
        }
        return false;
    }

    private static List getExistingSubRecords(DataSource ds, Map values, String fieldName, DSRequest req) throws Exception {
        DSRequest fetchExisting = new DSRequest(ds, "fetch", req.getRPCManager());
        HashMap criteria = new HashMap();
        criteria.put(ds.getPrimaryKey(), values.get(ds.getPrimaryKey()));
        fetchExisting.setCriteria(criteria);
        ArrayList<String> outputs = new ArrayList<String>();
        outputs.add(fieldName);
        fetchExisting.setOutputs(outputs);
        List data = fetchExisting.execute().getRecords();
        if (data.size() == 0) {
            log.warn((Object)("No record found in getExistingSubRecords for criteria " + String.valueOf(criteria)));
            return new ArrayList();
        }
        return (List)((Map)data.get(0)).get(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateChildRecords(List keys, DSRequest req, String fkDefn, Object newFKValue) throws Exception {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        DataSource ds = null;
        try {
            if (keys != null && keys.size() > 0) {
                String[] fkElements = fkDefn.split("\\.");
                String dsName = fkElements[0];
                ds = DataSourceManager.get((String)dsName, (DSRequest)req);
                String fieldName = fkElements[1];
                DSRequest updateReq = new DSRequest(ds, "update", req.getRPCManager());
                HashMap<String, List> criteria = new HashMap<String, List>();
                criteria.put(ds.getPrimaryKey(), keys);
                updateReq.setCriteria(criteria);
                updateReq.setAllowMultiUpdate(true);
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put(fieldName, newFKValue);
                updateReq.setValues(values);
                updateReq.execute();
            }
        }
        finally {
            if (ds != null) {
                DataSourceManager.free(ds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Map> getCurrentParentRecords(List keys, DSRequest req, String fkDefn) throws Exception {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        DataSource ds = null;
        boolean isSelfRef = false;
        List data = null;
        try {
            String[] fkElements = fkDefn.split("\\.");
            if (fkElements.length > 1) {
                String dsName = fkElements[0];
                ds = DataSourceManager.get((String)dsName, (DSRequest)req);
            } else {
                ds = req.getDataSource();
                isSelfRef = true;
            }
            final String fieldName = isSelfRef ? fkElements[0] : fkElements[1];
            DSRequest fetchReq = new DSRequest(ds, "fetch", req.getRPCManager());
            HashMap<String, List> criteria = new HashMap<String, List>();
            criteria.put(ds.getPrimaryKey(), keys);
            fetchReq.setCriteria(criteria);
            fetchReq.setOutputs((List)new ArrayList(){
                {
                    this.add(fieldName);
                }
            });
            data = fetchReq.execute().getDataList();
            DSField childFK = ds.getField(fieldName);
            String childFKDefn = childFK.getForeignKey();
            String[] childFKElements = childFKDefn.split("\\.");
            String childFKFieldName = isSelfRef ? childFKElements[0] : childFKElements[1];
            Iterator i = data.iterator();
            while (i.hasNext()) {
                Map parentKeyRec = (Map)i.next();
                if (parentKeyRec.get(fieldName) == null) {
                    i.remove();
                    continue;
                }
                parentKeyRec.put(childFKFieldName, parentKeyRec.get(fieldName));
                parentKeyRec.remove(fieldName);
            }
            if (ds == null || isSelfRef) return data;
        }
        catch (Throwable throwable) {
            if (ds == null || isSelfRef) throw throwable;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free((DataSource)ds);
        return data;
    }

    private static List<DSResponse> generateRelatedUpdatesForPreviousParents(List<Map> previousParents, DSRequest req) throws Exception {
        ArrayList<DSResponse> relatedUpdates = new ArrayList<DSResponse>();
        if (previousParents != null) {
            for (int i = 0; i < previousParents.size(); ++i) {
                Map parentKeys = previousParents.get(i);
                DSRequest fetchReq = new DSRequest(req.getDataSourceName(), "fetch", req.getRPCManager());
                fetchReq.setCriteria((Object)parentKeys);
                Map parentRec = fetchReq.execute()._getDataMap();
                DSResponse relatedUpdate = new DSResponse((Object)parentRec);
                relatedUpdate.setOperationType("update");
                relatedUpdates.add(relatedUpdate);
            }
        }
        return relatedUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void updateChildRecordsByFK(String fkDefn, Object oldFKValue, Object newFKValue, DSRequest req) throws Exception {
        DataSource ds = null;
        try {
            String[] fkElements = fkDefn.split("\\.");
            String dsName = fkElements[0];
            ds = DataSourceManager.get((String)dsName, (DSRequest)req);
            String fieldName = fkElements[1];
            if (ds._getFieldNames().contains(fieldName)) {
                if (oldFKValue != null) {
                    if (!oldFKValue.equals(newFKValue)) {
                        DSRequest removeReq = new DSRequest(ds, "update", req.getRPCManager());
                        HashMap<String, Object> criteria = new HashMap<String, Object>();
                        criteria.put(fieldName, oldFKValue);
                        removeReq.setCriteria(criteria);
                        removeReq.setAllowMultiUpdate(true);
                        HashMap<String, Object> values = new HashMap<String, Object>();
                        values.put(fieldName, newFKValue);
                        removeReq.setValues(values);
                        removeReq.execute();
                    } else {
                        log.warn((Object)"updateChildRecordsByFK was called with the same value for old and new FK.  No updates performed");
                    }
                } else {
                    log.warn((Object)"updateChildRecordsByFK was called with a null value for old FK. This would cause all records in the dataSource to be updated, so we are declining.  No updates performed");
                }
            } else {
                log.warn((Object)("updateChildRecordsByFK was called, but the field named in the foreignKey definition (" + fkDefn + ") does not exist in that dataSource. No updates performed"));
            }
            if (ds == null) return;
        }
        catch (Throwable throwable) {
            if (ds == null) throw throwable;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free((DataSource)ds);
    }

    private static void removeJoinRecordsByThisFK(Relation relation, Object thisFKValue, DSRequest req) throws Exception {
        if (relation.isValid()) {
            DataSource ds = relation.getToDataSource();
            DSField field = (DSField)relation.getToFields().get(0);
            DSRequest removeReq = new DSRequest(ds, "remove", req.getRPCManager());
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put(field.getName(), thisFKValue);
            removeReq.setCriteria(criteria);
            removeReq.setAllowMultiUpdate(true);
            removeReq.execute();
        } else {
            log.warn((Object)("The Relation passed into removeJoinRecordsByThisFK() was not valid: " + String.valueOf(relation)));
        }
    }

    private static void removeJoinRecordsByOtherFK(Relation relation, Object thisFKValue, List otherFKValues, DSRequest req) throws Exception {
        if (otherFKValues == null || otherFKValues.isEmpty()) {
            return;
        }
        if (relation.isValid()) {
            DataSource ds = relation.getToDataSource();
            DSField field = (DSField)relation.getToFields().get(0);
            DSRequest removeReq = new DSRequest(ds, "remove", req.getRPCManager());
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put(field.getName(), thisFKValue);
            Relation nextRel = relation.getNextRelation();
            if (nextRel != null && nextRel.isValid()) {
                field = (DSField)nextRel.getFromFields().get(0);
                criteria.put(field.getName(), otherFKValues);
                removeReq.setCriteria(criteria);
                removeReq.setAllowMultiUpdate(true);
                removeReq.execute();
            } else {
                log.warn((Object)("The NextRelation of the Relation passed into removeJoinRecordsByOtherFK() was null or not valid: " + String.valueOf(relation)));
            }
        } else {
            log.warn((Object)("The Relation passed into removeJoinRecordsByOtherFK() was not valid: " + String.valueOf(relation)));
        }
    }

    private static void addJoinRecords(Relation relation, Object thisFKValue, List otherFKValues, DSRequest req) throws Exception {
        if (otherFKValues == null || otherFKValues.isEmpty()) {
            return;
        }
        if (relation.isValid()) {
            DataSource ds = relation.getToDataSource();
            DSField field = (DSField)relation.getToFields().get(0);
            Relation nextRel = relation.getNextRelation();
            if (nextRel != null && nextRel.isValid()) {
                DSField nextField = (DSField)nextRel.getFromFields().get(0);
                ArrayList valueSets = new ArrayList();
                for (int i = 0; i < otherFKValues.size(); ++i) {
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    String fieldName = field.getName();
                    values.put(fieldName, thisFKValue);
                    values.put(nextField.getName(), otherFKValues.get(i));
                    DSRequest fetchReq = new DSRequest(ds, "fetch", req.getRPCManager());
                    fetchReq.setCriteria(values);
                    DSResponse fetchResp = fetchReq.execute();
                    if (fetchResp.getRowCount() != 0L) continue;
                    valueSets.add(values);
                }
                if (!valueSets.isEmpty()) {
                    DSRequest addReq = new DSRequest(ds, "add", req.getRPCManager());
                    addReq.setValues(valueSets);
                    addReq.execute();
                }
            } else {
                log.warn((Object)("The NextRelation of the Relation passed into addJoinRecords() was null or not valid: " + String.valueOf(relation)));
            }
        } else {
            log.warn((Object)("The Relation passed into addJoinRecords() was not valid: " + String.valueOf(relation)));
        }
    }

    private static void fetchAdditionalConcatFields(DSRequest request, DataSource ds, List results) throws Exception {
        AdvancedCriteria criteria;
        List summaryFunctionFields = request.getSummaryFunctionFields();
        if (request.isConcatFetchRequest()) {
            return;
        }
        if (summaryFunctionFields == null || summaryFunctionFields.isEmpty()) {
            return;
        }
        boolean concatOnPrimaryDS = false;
        HashMap concatParams = new HashMap();
        Iterator ii = summaryFunctionFields.iterator();
        while (ii.hasNext()) {
            String fieldName = (String)ii.next();
            DSField field = ds.getField(fieldName);
            String function = (String)field.get((Object)"includeSummaryFunction");
            if (!"concat".equalsIgnoreCase(function) && !"array".equalsIgnoreCase(function)) {
                ii.remove();
                continue;
            }
            String joinPrefix = field.getProperty("joinPrefix");
            String joinSuffix = field.getProperty("joinSuffix");
            String joinString = field.getProperty("joinString");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("joinPrefix", joinPrefix == null ? "" : joinPrefix);
            params.put("joinSuffix", joinSuffix == null ? "" : joinSuffix);
            params.put("joinString", joinString == null ? ", " : joinString);
            concatParams.put(fieldName, params);
            if (concatOnPrimaryDS) continue;
            concatOnPrimaryDS = field.getIncludeFrom() == null;
        }
        if (summaryFunctionFields.isEmpty()) {
            return;
        }
        DSRequest concatFetch = new DSRequest(ds.getName(), "fetch", request.getRPCManager());
        concatFetch.setOperationId(request.getOperationId());
        ArrayList pkList = ds.getPrimaryKeys();
        List mainOutputs = request.getConsolidatedOutputs();
        List groupBy = request.getGroupBy();
        boolean isSummary = request.isSummary();
        if (mainOutputs != null && !mainOutputs.isEmpty() || isSummary && concatOnPrimaryDS) {
            pkList = new ArrayList(pkList);
            for (int i = pkList.size() - 1; i >= 0; --i) {
                if (mainOutputs != null && !mainOutputs.isEmpty() && !mainOutputs.contains(pkList.get(i))) {
                    pkList.remove(i);
                }
                if (!isSummary || !concatOnPrimaryDS || groupBy != null && groupBy.contains(pkList.get(i))) continue;
                log.warn((Object)("'CONCAT' function is not natively supported by '" + request.getDataSourceName() + "' DataSource and additional request to fetch values for concatenation cannot be performed, cause primary key is not directly included in the outputs of the primary request. See \"concat\" SummaryFunction type description in the SmartClient Reference."));
                return;
            }
        }
        ArrayList outputs = new ArrayList();
        outputs.addAll(pkList);
        outputs.addAll(summaryFunctionFields);
        concatFetch.setOutputs(outputs);
        concatFetch.setCriteria((Object)request.getCriteria());
        if (pkList.size() == 1) {
            String pkField = ds.getPrimaryKey();
            ArrayList pkValues = new ArrayList();
            for (Map recordData : results) {
                pkValues.add(recordData.get(pkField));
            }
            criteria = new AdvancedCriteria((Criterion)new SetCriterion(pkField, DefaultOperators.InSet, (Collection)pkValues));
        } else {
            ArrayList<LogicalCriterion> lc = new ArrayList<LogicalCriterion>();
            for (Map recordData : results) {
                ArrayList<SimpleCriterion> lcCrit = new ArrayList<SimpleCriterion>();
                for (String pk : pkList) {
                    lcCrit.add(new SimpleCriterion(pk, DefaultOperators.Equals, recordData.get(pk)));
                }
                lc.add(new LogicalCriterion(DefaultOperators.And, lcCrit));
            }
            criteria = new AdvancedCriteria((Operator)DefaultOperators.Or, lc.toArray(new Criterion[0]));
        }
        concatFetch.addToCriteria(criteria);
        concatFetch.markAsConcatFetchRequest();
        concatFetch.inheritClientContext(request);
        concatFetch.setPrimaryDSRequest(request);
        request.addSubRequest(concatFetch);
        DSResponse response = concatFetch.execute();
        long start = System.currentTimeMillis();
        HashMap seenBefore = new HashMap();
        for (Map recordData : results) {
            for (Map concatData : response.getDataList()) {
                boolean pkMatch = true;
                Object pkHash = "";
                for (String pk : pkList) {
                    pkHash = (String)pkHash + concatData.get(pk).toString();
                    if (recordData.get(pk).equals(concatData.get(pk))) continue;
                    pkMatch = false;
                    break;
                }
                if (!pkMatch) continue;
                if (seenBefore.get(pkHash) == null) {
                    seenBefore.put((String)pkHash, new HashMap());
                }
                Map seenBeforeForThisPK = (Map)seenBefore.get(pkHash);
                for (String concatFieldName : summaryFunctionFields) {
                    if (concatData.get(concatFieldName) == null) continue;
                    DSField field = ds.getField(concatFieldName);
                    Object concatFieldObject = concatData.get(concatFieldName);
                    if (concatFieldObject instanceof Object[] && ((Object[])concatFieldObject).length == 1) {
                        concatFieldObject = ((Object[])concatFieldObject)[0];
                    }
                    if (seenBeforeForThisPK.get(concatFieldName) == null) {
                        seenBeforeForThisPK.put(concatFieldName, new HashSet());
                    } else if (((Set)seenBeforeForThisPK.get(concatFieldName)).contains(concatFieldObject)) continue;
                    ((Set)seenBeforeForThisPK.get(concatFieldName)).add(concatFieldObject);
                    if ("ARRAY".equalsIgnoreCase(field.getProperty("includeSummaryFunction"))) {
                        ArrayList concatFieldListValue = (ArrayList)recordData.get(concatFieldName);
                        if (concatFieldListValue == null) {
                            concatFieldListValue = new ArrayList();
                        }
                        concatFieldListValue.add(concatFieldObject);
                        recordData.put(concatFieldName, concatFieldListValue);
                        continue;
                    }
                    Object concatFieldValue = (String)recordData.get(concatFieldName);
                    if (concatFieldValue == null || "".equals(((String)concatFieldValue).trim())) {
                        concatFieldValue = (String)((Map)concatParams.get(concatFieldName)).get("joinPrefix") + String.valueOf(concatData.get(concatFieldName));
                        recordData.put(concatFieldName, concatFieldValue);
                        continue;
                    }
                    concatFieldValue = (String)concatFieldValue + (String)((Map)concatParams.get(concatFieldName)).get("joinString") + String.valueOf(concatData.get(concatFieldName));
                    recordData.put(concatFieldName, concatFieldValue);
                }
            }
            for (String concatFieldName : summaryFunctionFields) {
                Object concatFieldValue;
                DSField field = ds.getField(concatFieldName);
                if (!"CONCAT".equalsIgnoreCase(field.getProperty("includeSummaryFunction")) || (concatFieldValue = (String)recordData.get(concatFieldName)) == null || "".equals(((String)concatFieldValue).trim())) continue;
                concatFieldValue = (String)concatFieldValue + (String)((Map)concatParams.get(concatFieldName)).get("joinSuffix");
                recordData.put(concatFieldName, concatFieldValue);
            }
        }
        log.debug((Object)("Time to remove duplicates: " + (System.currentTimeMillis() - start) + "ms"));
    }

    public String getSQLPaging(DSRequest req, Map operationBinding) {
        return SQLDataSource.getPaging(req, operationBinding, this);
    }

    public static String getPaging(DSRequest req, Map operationBinding, SQLDataSource ds) {
        String paging = null;
        Map opConfig = req.operationConfig();
        if (req.isPaged()) {
            if (operationBinding != null) {
                paging = (String)operationBinding.get("sqlPaging");
            }
            if (paging == null && (req.getOperationProperty("command") != null || operationBinding != null && operationBinding.containsKey("customSQL"))) {
                boolean progLoading = ds.isProgressiveLoading(req);
                paging = progLoading ? config.getString((Object)"sql.defaultCustomSQLProgressivePaging") : config.getString((Object)"sql.defaultCustomSQLPaging");
                if (paging == null) {
                    paging = config.getBoolean((Object)"sql.customSQLReturnsAllRows", true) ? "none" : "jdbcScroll";
                }
            } else if (paging == null) {
                if (paging == null) {
                    paging = ds.getProperty("sqlPaging");
                }
                if (paging == null && (paging = config.getString((Object)"sql.defaultPaging")) == null) {
                    Object useSQLLimit = ds.getConfig().get((Object)"useSQLLimit");
                    paging = useSQLLimit == null || useSQLLimit.toString().equals("true") ? "sqlLimit" : "none";
                }
            }
        }
        return paging;
    }

    public static boolean shouldQualifyColumnNames(Map operationBinding, DataSource ds) {
        boolean qualifyColumnNames = true;
        if (operationBinding != null) {
            Object qual = operationBinding.get("qualifyColumnNames");
            if (qual != null) {
                if (qual.toString().toLowerCase().equals("false")) {
                    qualifyColumnNames = false;
                }
            } else {
                qual = ds.getConfig().get((Object)"qualifyColumnNames");
                if (qual != null && qual.toString().toLowerCase().equals("false")) {
                    qualifyColumnNames = false;
                }
            }
        } else {
            Object qual = ds.getConfig().get((Object)"qualifyColumnNames");
            if (qual != null && qual.toString().toLowerCase().equals("false")) {
                qualifyColumnNames = false;
            }
        }
        return qualifyColumnNames;
    }

    public static List getCustomFields(Map opBinding) {
        Object customFieldsObj;
        ArrayList<String> fieldList = null;
        if (opBinding != null && (customFieldsObj = opBinding.get("customFields")) != null) {
            List tempFieldList = DataTools.makeListIfSingle(customFieldsObj);
            fieldList = new ArrayList<String>();
            for (Object fieldObj : tempFieldList) {
                String[] fields = fieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    public static List getCustomCriteriaFields(Map opBinding) {
        Object customCriteriaFieldObj;
        ArrayList<String> fieldList = null;
        if (opBinding != null && (customCriteriaFieldObj = opBinding.get("customCriteriaFields")) != null) {
            List tempFieldList = DataTools.makeListIfSingle(customCriteriaFieldObj);
            fieldList = new ArrayList<String>();
            for (Object fieldObj : tempFieldList) {
                String[] fields = fieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    public static List getCustomValueFields(Map opBinding) {
        Object customValueFieldObj;
        ArrayList<String> fieldList = null;
        if (opBinding != null && (customValueFieldObj = opBinding.get("customValueFields")) != null) {
            List tempFieldList = DataTools.makeListIfSingle(customValueFieldObj);
            fieldList = new ArrayList<String>();
            for (Object fieldObj : tempFieldList) {
                String[] fields = fieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    public static List getExcludeValueFields(Map opBinding) {
        Object excludeCriteriaFieldObj;
        ArrayList<String> fieldList = null;
        if (opBinding != null && (excludeCriteriaFieldObj = opBinding.get("excludeCriteriaFields")) != null) {
            List tempFieldList = DataTools.makeListIfSingle(excludeCriteriaFieldObj);
            fieldList = new ArrayList<String>();
            for (Object fieldObj : tempFieldList) {
                String[] fields = fieldObj.toString().split(",");
                for (int i = 0; i < fields.length; ++i) {
                    fieldList.add(fields[i].trim());
                }
            }
        }
        return fieldList;
    }

    private static DSResponse executeMultipleInsert(DSRequest req, List valueSets, List dataSources) throws Exception {
        return SQLDataSource.executeMultipleInsert(req, valueSets, dataSources, false);
    }

    private static DSResponse executeMultipleInsert(DSRequest req, List valueSets, List dataSources, boolean generateSQLOnly) throws Exception {
        Long multiInsertBatchSizeObj;
        Boolean canSyncCache;
        SQLDataSource ds = (SQLDataSource)((Object)dataSources.get(0));
        DSResponse result = generateSQLOnly ? new DSResponse() : null;
        boolean defaultCanSyncCache = config.getBoolean((Object)"multi.insert.default.cache.sync", true);
        boolean hasSequences = ds.getSequences() != null && ds.getSequences().keySet().size() > 0;
        Boolean bl = canSyncCache = ds.getOperationBinding(req) == null ? null : ds.getOperationBinding(req).getBoolean((Object)"canSyncCache");
        if (canSyncCache == null) {
            canSyncCache = defaultCanSyncCache;
        }
        boolean invalidateCache = canSyncCache == false || !req.getCacheSyncStrategy().worksForBatchAdd(req) || "none".equals(req.getCacheSyncStrategyName());
        ArrayList resultSets = new ArrayList();
        String multiInsertStrategy = req.getMultiInsertStrategy();
        if (!"simple".equals(multiInsertStrategy) && !ds.getDriver().supportsMultipleValuesClauses(ds)) {
            log.warn((Object)("A multi-record add on dataSource " + ds.getName() + " was configured to use multiInsertStrategy '" + multiInsertStrategy + "', but this is not supported by the database (" + ds.getDriver().getDatabaseProductName() + "). Falling back to 'simple'"));
            multiInsertStrategy = "simple";
        }
        int multiInsertBatchSize = (multiInsertBatchSizeObj = req.getMultiInsertBatchSize()) == null ? 1 : multiInsertBatchSizeObj.intValue();
        int batchCounter = 0;
        ArrayList<Map> valueBatch = new ArrayList<Map>();
        req.setAttribute("originalValueSets", (Object)valueSets);
        for (Object values : valueSets) {
            if (!(values instanceof Map)) {
                throw new Exception("values must be set to a map or list of maps; was set to list of " + values.getClass().getName());
            }
            Map valueMap = (Map)values;
            if (multiInsertStrategy == null || multiInsertStrategy.equals("simple") || multiInsertBatchSize <= 1) {
                req.clearCache();
                req.setSkipCacheSync(canSyncCache == false);
                req.setValues(values);
                if (generateSQLOnly) {
                    req.setSkipCacheSync(true);
                    return SQLDataSource.SQLExecute(req, dataSources, true);
                }
                result = SQLDataSource.SQLExecute(req, dataSources);
                List currentRS = result.getDataList();
                if (currentRS != null && !currentRS.isEmpty()) {
                    resultSets.add(currentRS.get(0));
                }
                if (!result.getInvalidateCache()) continue;
                invalidateCache = true;
                continue;
            }
            if (++batchCounter <= multiInsertBatchSize) {
                valueBatch.add(valueMap);
                continue;
            }
            req.setAttribute("isBatchAdding", (Object)true);
            req.setValues(valueBatch);
            req.setSkipCacheSync(true);
            if (generateSQLOnly) {
                return SQLDataSource.SQLExecute(req, dataSources, true);
            }
            result = SQLDataSource.SQLExecute(req, dataSources);
            if (!invalidateCache && result.getDataList() != null) {
                resultSets.addAll(result.getDataList());
            }
            batchCounter = 1;
            valueBatch.clear();
            valueBatch.add(valueMap);
        }
        if (multiInsertStrategy != null && !multiInsertStrategy.equals("simple") && multiInsertBatchSize > 1 && batchCounter > 0) {
            req.setAttribute("isBatchAdding", (Object)true);
            req.setValues(valueBatch);
            if (generateSQLOnly) {
                req.setSkipCacheSync(true);
                return SQLDataSource.SQLExecute(req, dataSources, true);
            }
            result = SQLDataSource.SQLExecute(req, dataSources);
            if (!invalidateCache && result.getDataList() != null) {
                resultSets.addAll(result.getDataList());
            }
        }
        result.setAffectedRows((long)valueSets.size());
        result.setData(resultSets);
        result.setInvalidateCache(invalidateCache);
        return result;
    }

    public boolean isProgressiveLoading(DSRequest req) {
        DataTypeMap opConfig = this.getOperationBinding(req.getOperationType(), req.getOperationId());
        boolean progLoading = DataTools.asBoolean((Object)this.getConfig().get((Object)"progressiveLoading"), (boolean)false);
        if (opConfig != null && opConfig.containsKey("progressiveLoading")) {
            progLoading = DataTools.asBoolean(opConfig.get("progressiveLoading"), (boolean)false);
        }
        if (req.getParameter((Object)"progressiveLoading") != null) {
            progLoading = DataTools.asBoolean((Object)req.getParameter((Object)"progressiveLoading"), (boolean)false);
        }
        return progLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DSResponse executeWindowedSelect(DSRequest req, List<SQLDataSource> dataSources, Map context, String rowFetchQuery, String paging) throws Exception {
        ResultSet rs;
        Statement s;
        SQLDataSource firstDS = dataSources.get(0);
        DSResponse result = new DSResponse((DataSource)firstDS);
        SQLDriver driver = firstDS.getDriver();
        String dbName = driver.getDBName();
        DataTypeMap opConfig = req.getDataSource().getOperationBinding(req.getOperationType(), req.getOperationId());
        boolean progLoading = firstDS.isProgressiveLoading(req);
        result.setProgressiveLoading(progLoading);
        boolean skipRowCount = opConfig != null && DataTools.asBoolean(opConfig.get("skipRowCount"));
        boolean useRowCount = !progLoading && !skipRowCount && !req.isCacheSyncRequest();
        boolean ranThroughRetry = false;
        boolean wrapSqlForRowCount = false;
        if (opConfig != null && (opConfig.containsKey("customSQL") || opConfig.containsKey("command"))) {
            useRowCount = false;
            Boolean work = null;
            if (opConfig.containsKey("useSubselectForRowCount")) {
                work = DataTools.getBooleanObject((Map)opConfig, (Object)"useSubselectForRowCount");
            }
            if (work == null && firstDS.getConfig().containsKey((Object)"useSubselectForRowCount")) {
                work = DataTools.getBooleanObject((Map)firstDS.getConfig(), (Object)"useSubselectForRowCount");
            }
            if (work == null) {
                work = config.getBoolean((Object)"useSubselectForRowCount", false);
            }
            wrapSqlForRowCount = Boolean.TRUE.equals(work);
        }
        String selectString = SQLDataSource.getClause(req, "selectClause", "$defaultSelectClause");
        String tableString = SQLDataSource.getClause(req, "tableClause", "$defaultTableClause");
        String ansiJoinString = SQLDataSource.getClause(req, "ansiJoinClause", "$defaultAnsiJoinClause");
        String joinWhereString = SQLDataSource.getClause(req, "joinWhereClause", "$defaultJoinWhereClause");
        String groupString = SQLDataSource.getClause(req, "groupClause", "$defaultGroupClause");
        String groupWithAliasString = SQLDataSource.getClause(req, "groupWithAliasClause", "$defaultGroupWithAliasClause");
        String groupWhereString = SQLDataSource.getClause(req, "groupWhereClause", "$defaultGroupWhereClause");
        String whereString = SQLDataSource.getWhereClause(req, context, dataSources, selectString, tableString, ansiJoinString, joinWhereString, groupString, groupWhereString);
        String orderClause = SQLDataSource.getClause(req, "orderClause", "$defaultOrderClause");
        long start = System.currentTimeMillis();
        if (useRowCount) {
            if (req.isSummary() && (req.getGroupBy() == null || req.getGroupBy().isEmpty())) {
                result.setTotalRows(1L);
                if (req.getStartRow() > 1L) {
                    req.setStartRow(Math.max(1L - Math.abs(req.getBatchSize()), 0L));
                }
            } else {
                Boolean useHavingClause = opConfig != null ? DataTools.getBooleanObject((Map)opConfig, (Object)"useHavingClause", null) : null;
                String rowCountQueryString = driver.getRowCountQueryString(selectString, tableString, ansiJoinString, whereString, joinWhereString, groupString, groupWithAliasString, groupWhereString, context, useHavingClause);
                try {
                    progLoading = SQLDataSource.runRowCountQuery(rowCountQueryString, context, req, result, firstDS);
                }
                catch (Exception e) {
                    throw new Exception("Caught exception running rowcount query: " + e.getMessage(), e);
                }
                if (progLoading) {
                    result.setProgressiveLoading(progLoading);
                }
                if (result.getTotalRows() == 0L) {
                    return result;
                }
            }
        } else if (!(progLoading || wrapSqlForRowCount || req.isCacheSyncRequest())) {
            log.info((Object)"Skipping row count query - Row count will be obtained by traversing the entire dataset");
        }
        if (req.getEndRow() != -1L && req.getEndRow() - req.getStartRow() > req.getBatchSize()) {
            req._setBatchSize(req.getEndRow() - req.getStartRow());
        }
        if (progLoading) {
            req._setBatchSize(req.getBatchSize() + (long)firstDS.getLookAhead());
            result.setRequestEndRow(req.getStartRow() + req.getBatchSize());
        }
        if (req.getEndRow() != -1L && req.getEndRow() <= req.getStartRow()) {
            result.setData(new ArrayList());
            return result;
        }
        if (paging.equals("sqlLimit") && !driver.supportsSQLLimit()) {
            if (opConfig != null && opConfig.get("sqlPaging") != null) {
                log.warn((Object)("DataSource '" + firstDS.getName() + "'" + (String)(opConfig == null ? "" : ", OperationBinding '" + String.valueOf(opConfig.get("operationId"))) + ": sqlPaging was explicitly specified as 'sqlLimit', but the underlying database (" + String.valueOf((Object)driver.getDBType()) + ") does not support SQL limit queries.  Falling back to 'jdbcScroll'"));
            }
            paging = "jdbcScroll";
        }
        if (wrapSqlForRowCount) {
            String rowCountQuery = "SELECT COUNT(*) FROM (" + rowFetchQuery + ")";
            if (!driver.aliasForbiddenForSubselect()) {
                rowCountQuery = rowCountQuery + " rc";
            }
            SQLLogger.debug("SQL windowed select - using subselect to obtain rowCount: " + rowCountQuery);
            try {
                progLoading = SQLDataSource.runRowCountQuery(rowCountQuery, context, req, result, firstDS);
            }
            catch (Exception e) {
                log.error((Object)("We attempted to use a subselect to form a rowCount query for customSQL operation " + (String)(opConfig.get("operationName") == null ? "{default}" : "'" + String.valueOf(opConfig.get("operationName'"))) + ", but an exception was thrown.  Please disable subselect counting by setting useSubselectForRowCount: false in your server.properties file or DataSource/Operation config"));
                throw e;
            }
            if (result.getTotalRows() == 0L) {
                return result;
            }
            if (progLoading) {
                req._setBatchSize(req.getBatchSize() + (long)firstDS.getLookAhead());
                result.setRequestEndRow(req.getStartRow() + req.getBatchSize());
            }
        }
        if (paging.equals("sqlLimit")) {
            rowFetchQuery = SQLDataSource.getDatabaseSpecificFetchQuery(rowFetchQuery, dataSources, req, driver, orderClause, result, context);
            rowFetchQuery = SQLDataSource.applyPrefixAndSuffix(rowFetchQuery, req);
            s = null;
            rs = null;
            Connection conn = null;
            boolean userTransaction = true;
            boolean streaming = req.shouldStreamResults();
            req.recordTimingData(TIMING_LOG_PAGED_FETCH, DSRequest.TimingLogType.START);
            try {
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
                boolean mdcKeyAdded = false;
                try {
                    conn = firstDS.getTransactionalConnection(req);
                    if (conn == null) {
                        if (driver.dbConnection != null) {
                            conn = driver.dbConnection;
                        } else {
                            driver.dbConnection = conn = SQLConnectionManager.getConnection(dbName);
                        }
                        userTransaction = false;
                    }
                    req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
                    rowFetchQuery = SQLDataSource.addMDCKey(rowFetchQuery);
                    mdcKeyAdded = true;
                    start = System.currentTimeMillis();
                    req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
                    s = driver.createFetchStatement(conn, rowFetchQuery, streaming, req.getBatchSize(), req);
                    if (SQLLogger.isInfoEnabled()) {
                        SQLLogger.info((Object)(firstDS.getInstanceId() + ": Executing " + (req.getPrimaryDSRequest() != null ? "cache sync" : "") + " query on '" + driver.dbName + "'"), SQLDriver.formatSQL(rowFetchQuery));
                    }
                    long executionTimeStart = System.currentTimeMillis();
                    if (SQLLogger.isDebugEnabled() && (req == null || !"fileSourceDataSources".equals(req.getDataSourceName()) || config.getBoolean((Object)"sql.log.fileSourceDataSources.queries", true))) {
                        SQLLogger.debug((Object)("SQL windowed select rows " + req.getStartRow() + "->" + req.getEndRow() + ", result size " + req.getBatchSize() + ". Query"), SQLDriver.formatSQL(rowFetchQuery));
                    }
                    rs = SQLDriver.executeStatement(s, rowFetchQuery);
                    SQLDataSource.logSlowQuery(rowFetchQuery, executionTimeStart, -1L, req);
                }
                catch (SQLException se) {
                    if (!userTransaction) {
                        SQLConnectionManager.free(conn);
                        driver.dbConnection = conn = SQLConnectionManager.getNewConnection(dbName);
                        if (!mdcKeyAdded) {
                            rowFetchQuery = SQLDataSource.addMDCKey(rowFetchQuery);
                        }
                        s = driver.createFetchStatement(conn, rowFetchQuery, streaming, req.getBatchSize(), req);
                        long executionTimeStart = System.currentTimeMillis();
                        try {
                            rs = SQLDriver.executeStatement(s, rowFetchQuery);
                        }
                        catch (SQLException se2) {
                            logSqlError.debug((Object)("Failed to execute query: " + rowFetchQuery + ", SQL error: " + se2.getMessage()));
                            throw se2;
                        }
                        SQLDataSource.logSlowQuery(rowFetchQuery, executionTimeStart, -1L, req);
                    }
                    logSqlError.debug((Object)("Failed to execute query: " + rowFetchQuery + ", SQL error: " + se.getMessage()));
                    throw se;
                }
                Logger.timing.debug((Object)("Time to execute fetch query: " + (System.currentTimeMillis() - start) + "ms"));
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
                if (driver.canSetFetchSize() && driver.shouldSetFetchSize(req, req.getBatchSize())) {
                    rs.setFetchSize((int)(req.getBatchSize() + 1L));
                    if (config.getBoolean((Object)"devenv", false)) {
                        req.setAttribute("_jdbcFetchSize", (Object)(req.getBatchSize() + 1L));
                    }
                }
                if (streaming) {
                    log.debug((Object)"Streaming the response");
                    result.setData((Object)new StreamingResponseIterator(result));
                    HashMap<String, Object> sContext = new HashMap<String, Object>();
                    sContext.put("resultSet", rs);
                    sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                    sContext.put("dataSources", dataSources);
                    sContext.put("opConfig", opConfig);
                    sContext.put("dsRequest", req);
                    sContext.put("progLoading", progLoading);
                    sContext.put("lookahead", firstDS.getLookAhead());
                    result.setStreamingContext(sContext);
                    result.setStartRow(req.getStartRow());
                    result.setEndRow(req.getStartRow());
                    result._setHasNextRecord(rs.next());
                    if (!result.hasNextRecord() && progLoading && req.getStartRow() != 0L && firstDS.getReturnToTop()) {
                        ranThroughRetry = true;
                        result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                    }
                } else {
                    long ss = System.currentTimeMillis();
                    req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
                    List rows = SQLTransform.toListOfMapsOrBeans(rs, driver, dataSources, (Map)opConfig, req);
                    int fetchedRowCount = rows.size();
                    if (progLoading && (long)rows.size() == req.getBatchSize()) {
                        for (int i = 0; i < firstDS.getLookAhead(); ++i) {
                            rows.remove(rows.size() - 1);
                        }
                    }
                    Logger.timing.debug((Object)("SQLTransform took: " + (System.currentTimeMillis() - ss) + "ms"));
                    req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
                    result.setData((Object)rows);
                    result.setEndRow(req.getStartRow() + (long)rows.size());
                    result.setStartRow(req.getStartRow());
                    if (rows.size() == 0 && progLoading && req.getStartRow() != 0L && firstDS.getReturnToTop()) {
                        ranThroughRetry = true;
                        result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                    }
                    if (!(req.isCacheSyncRequest() || useRowCount || progLoading || wrapSqlForRowCount)) {
                        if (paging.equals("jdbcScroll")) {
                            rs.last();
                            int rowNum = rs.getRow();
                            result.setTotalRows((long)(rowNum - 1));
                        }
                        Object error = "";
                        if (skipRowCount) {
                            error = "DataSource '" + firstDS.getName() + "', operationId: '" + String.valueOf(opConfig.get("operationId")) + "' specifies skipRowCount=true but also specifies or defaults to sqlPaging='sqlLimit'.  SmartClient/SmartGWT Server does not support sqlLimit paging without a rowcount query; only the first page will be returned.";
                        } else if (opConfig == null && "sqlLimit".equals(config.get((Object)"sql.defaultCustomSQLPaging"))) {
                            error = "server.properties entry 'defaultCustomSQLPaging' is set to 'sqlLimit'.  SmartClient/SmartGWT Server does not currently support sqlLimit paging for customSQL operations: only the first page will be returned.";
                        } else if (opConfig != null && "sqlLimit".equals(opConfig.get("sqlPaging"))) {
                            error = "DataSource '" + firstDS.getName() + "', operationId: '" + String.valueOf(opConfig.get("operationId")) + "' is a customSQL operation, but specifies sqlPaging: 'sqlLimit'.  SmartClient/SmartGWT Server does not currently support sqlLimit paging for customSQL operations: only the first page will be returned.";
                        }
                        if (((String)error).length() > 0) {
                            error = (String)error + "  Consider using progressiveLoading, or a different sqlPaging setting";
                            log.warn(error);
                        }
                    } else if (progLoading) {
                        if ((long)fetchedRowCount == req.getBatchSize()) {
                            result.setTotalRows(req.getEndRow() + (long)firstDS.getEndGap());
                        } else if (!ranThroughRetry) {
                            result.setTotalRows(result.getEndRow());
                        }
                    }
                    if (!progLoading && (long)rows.size() < req.getBatchSize()) {
                        result.setTotalRows(result.getEndRow());
                    }
                }
                DSResponse ss = result;
                return ss;
            }
            finally {
                if (!streaming) {
                    try {
                        rs.close();
                    }
                    catch (Exception executionTimeStart) {}
                    try {
                        s.close();
                    }
                    catch (Exception executionTimeStart) {}
                }
                req.recordTimingData(TIMING_LOG_PAGED_FETCH, DSRequest.TimingLogType.END);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JDBC driver windowed select rows " + req.getStartRow() + "->" + req.getEndRow() + ", result size " + req.getBatchSize() + ". Query"), (Object)SQLDriver.formatSQL(rowFetchQuery));
        }
        s = null;
        rs = null;
        Connection conn = null;
        boolean userTransaction = true;
        boolean streaming = req.shouldStreamResults();
        req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH, DSRequest.TimingLogType.START);
        try {
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.START);
            boolean mdcKeyAdded = false;
            try {
                conn = firstDS.getTransactionalConnection(req);
                if (conn == null) {
                    if (driver.dbConnection != null) {
                        conn = driver.dbConnection;
                    } else {
                        driver.dbConnection = conn = SQLConnectionManager.getConnection(dbName);
                    }
                    userTransaction = false;
                }
                req.recordTimingData(TIMING_LOG_GET_CONNECTION, DSRequest.TimingLogType.END);
                rowFetchQuery = SQLDataSource.addMDCKey(rowFetchQuery);
                mdcKeyAdded = true;
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.START);
                s = streaming ? driver.createFetchStatement(conn, rowFetchQuery, streaming, req.getBatchSize() + 1L, req) : driver.createScrollableFetchStatement(conn, rowFetchQuery, req.getBatchSize() + 1L, req);
                long executionTimeStart = System.currentTimeMillis();
                rs = SQLDriver.executeStatement(s, rowFetchQuery);
                SQLDataSource.logSlowQuery(rowFetchQuery, executionTimeStart, -1L, req);
            }
            catch (SQLException se) {
                if (!userTransaction) {
                    SQLConnectionManager.free(conn);
                    driver.dbConnection = conn = SQLConnectionManager.getNewConnection(dbName);
                    if (!mdcKeyAdded) {
                        rowFetchQuery = SQLDataSource.addMDCKey(rowFetchQuery);
                    }
                    s = streaming ? driver.createFetchStatement(conn, rowFetchQuery, streaming, req.getBatchSize() + 1L, req) : driver.createScrollableFetchStatement(conn, rowFetchQuery, req.getBatchSize() + 1L, req);
                    long executionTimeStart = System.currentTimeMillis();
                    try {
                        rs = SQLDriver.executeStatement(s, rowFetchQuery);
                    }
                    catch (Exception se2) {
                        logSqlError.debug((Object)("Failed to execute query: " + rowFetchQuery + ", SQL error: " + se2.getMessage()));
                        throw se2;
                    }
                    SQLDataSource.logSlowQuery(rowFetchQuery, executionTimeStart, -1L, req);
                }
                logSqlError.debug((Object)("Failed to execute query: " + rowFetchQuery + ", SQL error: " + se.getMessage()));
                throw se;
            }
            long executeTime = System.currentTimeMillis() - start;
            req.recordTimingData(TIMING_LOG_QUERY, DSRequest.TimingLogType.END);
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH_SCROLL, DSRequest.TimingLogType.START);
            if (paging.equals("jdbcScroll") && !streaming) {
                log.debug((Object)("Using paging strategy 'jdbcScroll' - scrolling to absolute position " + (req.getStartRow() + 1L)));
                rs.absolute((int)req.getStartRow() + 1);
            } else {
                log.debug((Object)("Using fallback paging strategy 'dropAtServer' - scrolling to absolute position " + (req.getStartRow() + 1L) + " by reading and discarding all intervening rows"));
                int i = 0;
                while ((long)i <= req.getStartRow() && rs.next()) {
                    ++i;
                }
            }
            long scrollTime = System.currentTimeMillis() - start;
            log.debug((Object)("Scrolling / positioning took " + scrollTime + "ms"));
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH_SCROLL, DSRequest.TimingLogType.END);
            if (streaming) {
                log.debug((Object)"Streaming the response");
                result.setData((Object)new StreamingResponseIterator(result));
                HashMap<String, Object> sContext = new HashMap<String, Object>();
                sContext.put("resultSet", rs);
                sContext.put("brokenCursorAPIs", SQLTransform.hasBrokenCursorAPIs(driver));
                sContext.put("dataSources", dataSources);
                sContext.put("opConfig", opConfig);
                sContext.put("dsRequest", req);
                result.setStreamingContext(sContext);
                result.setStartRow(req.getStartRow());
                result.setEndRow(req.getStartRow());
                result._setHasNextRecord(rs.next());
                if (!result.hasNextRecord() && progLoading && req.getStartRow() != 0L && firstDS.getReturnToTop()) {
                    ranThroughRetry = true;
                    result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                }
            } else {
                if (driver.canSetFetchSize() && driver.shouldSetFetchSize(req, req.getBatchSize())) {
                    rs.setFetchSize((int)(req.getBatchSize() + 1L));
                    if (config.getBoolean((Object)"devenv", false)) {
                        req.setAttribute("_jdbcFetchSize", (Object)(req.getBatchSize() + 1L));
                    }
                }
                start = System.currentTimeMillis();
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.START);
                List rows = SQLTransform.toListOfMapsOrBeans(rs, req.getBatchSize(), driver, dataSources, (Map)opConfig, req);
                long fetchTime = System.currentTimeMillis() - start;
                Logger.timing.debug((Object)("Execute: " + executeTime + "ms, Scroll: " + scrollTime + "ms, Fetch: " + fetchTime + "ms, Total: " + (executeTime + scrollTime + fetchTime) + "ms"));
                req.recordTimingData(TIMING_LOG_SQLTRANSFORM, DSRequest.TimingLogType.END);
                int fetchedRowCount = rows.size();
                if (progLoading && (long)rows.size() == req.getBatchSize()) {
                    for (int i = 0; i < firstDS.getLookAhead(); ++i) {
                        rows.remove(rows.size() - 1);
                    }
                }
                result.setData((Object)rows);
                result.setEndRow(req.getStartRow() + (long)rows.size());
                result.setStartRow(req.getStartRow());
                if (rows.size() == 0 && progLoading && req.getStartRow() != 0L && firstDS.getReturnToTop()) {
                    result = SQLDataSource.retryProgressiveFetch(req, dataSources, context, paging);
                }
                if (!(useRowCount || progLoading || wrapSqlForRowCount)) {
                    long rc = result.getEndRow() + 1L;
                    rs.last();
                    rc = rs.getRow();
                    result.setTotalRows(rc);
                } else if (progLoading) {
                    if ((long)fetchedRowCount == req.getBatchSize()) {
                        result.setTotalRows(req.getEndRow() + (long)firstDS.getEndGap());
                    } else if (!ranThroughRetry) {
                        result.setTotalRows(result.getEndRow());
                    }
                }
                if (!progLoading && (long)rows.size() < req.getBatchSize()) {
                    result.setTotalRows(result.getEndRow());
                }
            }
            DSResponse dSResponse = result;
            return dSResponse;
        }
        finally {
            if (!streaming) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
            req.recordTimingData(TIMING_LOG_JDBCSCROLL_FETCH, DSRequest.TimingLogType.END);
        }
    }

    protected static void logSlowQuery(String sql, long start, long end, DSRequest req) {
        String category;
        Logger logger;
        if (end < 0L) {
            end = System.currentTimeMillis();
        }
        String dsName = null;
        String opType = null;
        String opId = null;
        if (req != null) {
            dsName = req.getDataSourceName();
            opType = req.getOperationType();
            opId = req.getOperationId();
        }
        if ((logger = slowSQLLoggers.get(category = SLOW_SQL_LOGGING_CATEGORY + (String)(opType != null ? "." + opType : ""))) == null) {
            logger = new Logger(category);
            slowSQLLoggers.put(category, logger);
        }
        if (!logger.isDebugEnabled()) {
            return;
        }
        Integer threshold = null;
        if (req != null) {
            try {
                DataSource ds = req.getDataSource();
                DataTypeMap binding = ds.getOperationBinding(req);
                if (binding != null) {
                    threshold = DataTools.getInteger((Map)binding, (Object)"logSlowSQL");
                }
                if (threshold == null && opType != null && !opType.isEmpty()) {
                    String key = "logSlow" + opType.substring(0, 1).toUpperCase() + opType.substring(1).toLowerCase();
                    threshold = DataTools.getInteger((Map)ds.getConfig(), (Object)key);
                }
                if (threshold == null) {
                    threshold = DataTools.getInteger((Map)ds.getConfig(), (Object)"logSlowSQL");
                }
            }
            catch (Exception ds) {
                // empty catch block
            }
        }
        if (threshold == null) {
            threshold = queriesSlowerThan;
        }
        long duration = end - start;
        if ((long)threshold.intValue() < duration) {
            logger.debug((Object)("\n\r    SlowQuery: " + duration + " milliseconds" + (String)(!"".equals(dsName) ? "\n\r    DataSource: " + dsName : "") + (String)(!"".equals(opType) ? "\n\r    OperationType: " + opType : "") + (String)(!"".equals(opId) ? "\n\r    OperationId: " + opId : "") + "\n\r    SQL: " + SQLDriver.formatSQL(sql, true)));
        }
    }

    public static String getSingleRowForSubquery(String baseFetchQuery, SQLDataSource dataSource, DSRequest req, SQLDriver driver) throws Exception {
        ArrayList<SQLDataSource> dataSources = new ArrayList<SQLDataSource>();
        dataSources.add(dataSource);
        req.setStartRow(0L);
        req._setBatchSize(1L);
        return SQLDataSource.getDatabaseSpecificFetchQuery(baseFetchQuery, dataSources, req, driver, "", null, null);
    }

    public static String getDatabaseSpecificFetchQuery(String baseFetchQuery, List<SQLDataSource> dataSources, DSRequest req, SQLDriver driver, String orderClause, DSResponse result, Map context) throws Exception {
        boolean forceSort;
        List outputs;
        List list;
        String rowFetchQuery = baseFetchQuery;
        log.debug((Object)"Using SQL Limit query");
        Map<String, String> remap = new HashMap();
        for (SQLDataSource sQLDataSource : dataSources) {
            remap = DataTools.orderedMapUnion(remap, (Map)sQLDataSource.ds2NativeFieldMap());
        }
        List incFrom = req.getIncludeFrom();
        if (incFrom != null) {
            for (IncludeFromDefinition def : incFrom) {
                String fieldName = def.getThisFieldName();
                if (remap.containsKey(fieldName)) continue;
                remap.put(fieldName, fieldName);
            }
        }
        if ((list = (List)req.constraints()) != null) {
            remap = DataTools.subsetMap((Map)remap, (List)list);
        }
        if ((outputs = req.outputs()) != null) {
            remap = DataTools.subsetMap((Map)remap, (List)outputs);
        }
        if (forceSort = dataSources.get(0).shouldForceSort(req)) {
            boolean generateOrderClause;
            String computedOrderClause = null;
            String defaultOrderClause = context == null ? null : context.get("defaultOrderClause");
            boolean nullOrderClause = orderClause == null || orderClause.equals("");
            boolean usingNullDefaultOrderClause = "$defaultOrderClause".equals(orderClause) && (defaultOrderClause == null || defaultOrderClause.equals(""));
            boolean legacySQLServer = driver instanceof SQLServerDriver && config.getBoolean((Object)"sql.sqlserver.legacyLimitBehavior", false);
            boolean unionSummary = context != null && Boolean.TRUE.equals(context.get("isUnionFetch")) && Boolean.TRUE.equals(context.get("isUnionSummary"));
            boolean bl = generateOrderClause = nullOrderClause || usingNullDefaultOrderClause;
            if (generateOrderClause || !legacySQLServer && !unionSummary) {
                DataSource ds = result != null ? result.getDataSource() : (DataSource)dataSources.get(0);
                List pkList = ds.getPrimaryKeys();
                List sortBy = null;
                if (driver instanceof OracleDriver) {
                    computedOrderClause = "rownum";
                } else {
                    sortBy = req.getForceSortFieldNames();
                }
                if (computedOrderClause == null) {
                    if (sortBy != null && !sortBy.isEmpty()) {
                        Iterator i = sortBy.iterator();
                        while (i.hasNext()) {
                            String fieldName = (String)i.next();
                            if (req.getSortByFields() == null) continue;
                            for (String sortByName : req.getSortByFields()) {
                                if (sortByName == null) continue;
                                if (sortByName.startsWith("-")) {
                                    sortByName = sortByName.substring(1);
                                }
                                if (!sortByName.equals(fieldName)) continue;
                                i.remove();
                            }
                        }
                        SQLOrderClause oc = new SQLOrderClause(req);
                        oc.setSortBy(sortBy);
                        if (driver instanceof SQLServerDriver) {
                            boolean useOffset = driver.supportsOffsetFetch();
                            oc.setSqlLimit(!useOffset);
                        }
                        computedOrderClause = oc.getSQLString();
                    }
                    if (computedOrderClause != null) {
                        log.debug((Object)("Using PK as default sorter: " + computedOrderClause));
                    }
                }
                if (computedOrderClause == null) {
                    List summaryFields = req.isSummary() ? req.getSummaryFields() : null;
                    for (String fieldName : remap.keySet()) {
                        if (summaryFields != null && !summaryFields.contains(fieldName) || (computedOrderClause = fieldName) == null) continue;
                        if (computedOrderClause.contains(".")) {
                            computedOrderClause = computedOrderClause.substring(computedOrderClause.lastIndexOf(".") + 1);
                        }
                        computedOrderClause = driver.escapeColumnName(computedOrderClause);
                        break;
                    }
                    if (computedOrderClause != null) {
                        log.debug((Object)("Using first field as default sorter: " + computedOrderClause));
                    }
                }
            }
            rowFetchQuery = driver.limitQuery(rowFetchQuery, req.getStartRow(), req.getBatchSize(), DataTools.enumToList(remap.values().iterator()), orderClause, computedOrderClause, req, dataSources, context);
        } else {
            rowFetchQuery = driver.limitQuery(rowFetchQuery, req.getStartRow(), req.getBatchSize(), DataTools.enumToList(remap.values().iterator()), req, context);
        }
        return rowFetchQuery;
    }

    protected boolean shouldForceSort(DSRequest dsRequest) {
        Boolean forceSort = null;
        DataTypeMap op = this.getOperationBinding(dsRequest);
        if (op != null) {
            forceSort = op.getBoolean((Object)"forceSort");
        }
        if (forceSort == null) {
            forceSort = this.getConfig().getBoolean((Object)"forceSort");
        }
        if (forceSort == null) {
            SQLDriver workDriver = this.driver;
            if (workDriver == null) {
                try {
                    workDriver = this.getDriver();
                }
                catch (Exception e) {
                    log.warn((Object)("Caught exception attempting to acquire SQLDriver for DataSource " + this.getID()), (Throwable)e);
                }
            }
            forceSort = workDriver == null ? false : workDriver.limitRequiresSQLOrderClause();
            workDriver = null;
        }
        return forceSort.equals(Boolean.TRUE);
    }

    private static DSResponse retryProgressiveFetch(DSRequest req, List<SQLDataSource> dataSources, Map context, String paging) throws Exception {
        req.setStartRow(0L);
        BasicDataSource firstDS = dataSources.get(0);
        req._setBatchSize(req.getBatchSize() - (long)firstDS.getLookAhead());
        req.setEndRow(req.getBatchSize());
        String statement = SQLDataSource.generateSQLStatement(req, context, dataSources);
        log.debug((Object)("Fetched no records, attempting refetch from 0 to " + req.getEndRow()));
        DSResponse result = SQLDataSource.executeWindowedSelect(req, dataSources, context, statement, paging);
        if (firstDS.getReturnToTop()) {
            result.setInvalidateCache(true);
        }
        return result;
    }

    private static boolean runRowCountQuery(String rowCountQueryString, Map context, DSRequest req, DSResponse result, SQLDataSource firstDS) throws Exception {
        Integer count;
        long start;
        block7: {
            start = System.currentTimeMillis();
            req.recordTimingData(TIMING_LOG_COUNT_QUERY, DSRequest.TimingLogType.START);
            SQLDriver driver = firstDS.getDriver();
            rowCountQueryString = SQLDataSource.applyPrefixAndSuffix(rowCountQueryString, req, firstDS, true);
            SQLLogger.debug((Object)"Executing row count query", rowCountQueryString);
            String rowCountQuery = Velocity.evaluateWithSnippets((String)rowCountQueryString, (Map)SQLDataSource.addMissingClausesToContext(context), (String)req.getOperationType(), (DSRequest)req, (boolean)true, (boolean)false);
            if (req != null) {
                req.setAttribute("_runningRowCountQuery", (Object)true);
            }
            String sCount = driver.executeScalar(rowCountQuery, req).toString();
            if (req != null) {
                req.removeAttribute("_runningRowCountQuery");
            }
            count = null;
            try {
                count = Integer.valueOf(sCount);
            }
            catch (NumberFormatException nfe) {
                int dotIndex = sCount.indexOf(".");
                if (dotIndex == -1) break block7;
                sCount = sCount.substring(0, dotIndex);
                count = Integer.valueOf(sCount);
            }
        }
        long end = System.currentTimeMillis();
        req.recordTimingData(TIMING_LOG_COUNT_QUERY, DSRequest.TimingLogType.END);
        boolean dsRequestProgressiveLoading = DataTools.asBoolean((Object)req.getParameter((Object)"progressiveLoading"), (boolean)true);
        if (count != null && count > firstDS.getProgressiveLoadingThreshold() && firstDS.getProgressiveLoadingThreshold() >= 0 && dsRequestProgressiveLoading) {
            log.info((Object)("Row count query found " + count + " rows, which exceeds the DataSource's progressiveLoadingThreshold of " + firstDS.getProgressiveLoadingThreshold() + ".  Switching to progressive loading mode."));
            result.setEstimatedTotalRows(count.toString());
            return true;
        }
        result.setTotalRows((long)count.intValue());
        Logger.timing.debug((Object)("Counted " + result.getTotalRows() + " total rows in result set: " + (end - start) + "ms"));
        if (result.getTotalRows() == 0L) {
            result.setData(new ArrayList());
            result.setStartRow(0L);
            result.setEndRow(0L);
        }
        if (req.getStartRow() > result.getTotalRows() || result.getTotalRows() - req.getStartRow() < req.getBatchSize()) {
            long newStartRow = Math.max(result.getTotalRows() - req.getBatchSize(), 0L);
            req.setStartRow(newStartRow);
        }
        return false;
    }

    private static void _createAliases(DSRequest req, Map<String, String> aliases, int lengthLimit, IncludeFromDefinition incFrom, String fromAlias, String prefix, String fkFields) {
        if (incFrom == null) {
            return;
        }
        boolean forcedAlias = (!req.isSummary() || req.isSummaryFunction()) && fromAlias == null && (incFrom.getThisField() != null && incFrom.getThisField().getProperty("includeSummaryFunction") != null && !req.isConcatFetchRequest() && req.isSummaryFunction() || req.isValueOperation());
        Object nextPrefix = null;
        Object relatedTableAlias = null;
        Relation relation = incFrom.getRelation();
        String includeVia = incFrom.getIncludeVia();
        relation.setFromAlias(fromAlias);
        while (relation != null && relation.isValid()) {
            int counter = aliases.size();
            String fkField = null;
            for (DSField fromField : relation.getFromFields()) {
                fkField = fromField.getName();
                relatedTableAlias = fromField.getProperty("relatedTableAlias");
                if (fkFields == null) {
                    fkFields = "";
                }
                if (!"".equals(fkFields)) {
                    fkFields = (String)fkFields + "*";
                }
                fkFields = (String)fkFields + fkField;
            }
            boolean sameDS = relation.getFromDataSource().getName().equals(relation.getToDataSource().getName());
            if (relatedTableAlias == null || "".equals(((String)relatedTableAlias).trim())) {
                if (!(includeVia != null || prefix != null || sameDS || forcedAlias || relation.getOtherFK())) {
                    aliases.put((String)fkFields, null);
                    relation = relation.getNextRelation();
                    continue;
                }
                Object object = relatedTableAlias = forcedAlias && fromAlias == null ? "_" + incFrom.getThisFieldName() : fkField;
            }
            if (relation.getOtherFK()) {
                String dsAlias = relation.getToDataSource().getRelatedTableAlias();
                if (dsAlias == null || "".equals(dsAlias)) {
                    dsAlias = relation.getToDataSource().getName();
                }
                fkFields = (String)fkFields + "*" + dsAlias.trim();
                Object object = relatedTableAlias = relatedTableAlias == null || "".equals(relatedTableAlias) ? dsAlias : (String)relatedTableAlias + "_" + dsAlias;
            }
            if (!forcedAlias && aliases.containsKey(fkFields)) {
                relatedTableAlias = aliases.get(fkFields);
            } else {
                relatedTableAlias = (String)(prefix == null ? "" : (String)prefix + "_") + (String)relatedTableAlias;
                if (!forcedAlias) {
                    aliases.put((String)fkFields, (String)relatedTableAlias);
                }
            }
            nextPrefix = relatedTableAlias;
            if (relatedTableAlias != null && ((String)relatedTableAlias).length() > lengthLimit) {
                log.info((Object)("Generated alias length exceeds " + lengthLimit + " characters, which is allowed maximum according to configuration. Alias '" + (String)relatedTableAlias + "' will be replaced by randomly generated. To avoid this you may shorten field names involved.Search for 'aliasLengthLimit' in SQL setting overview in Smartclient reference for more details including configuration instructions."));
                relatedTableAlias = "a" + counter;
                aliases.put((String)fkFields, (String)relatedTableAlias);
            }
            relation.setToAlias((String)relatedTableAlias);
            if ((relation = relation.getNextRelation()) == null) continue;
            relation.setFromAlias((String)relatedTableAlias);
            if (nextPrefix != null) {
                prefix = nextPrefix;
            }
            relatedTableAlias = null;
        }
        SQLDataSource._createAliases(req, aliases, lengthLimit, incFrom.getTargetIncludeFrom(), relatedTableAlias, nextPrefix, (String)fkFields);
    }

    private static Map getClausesContext(DSRequest req, List dataSources, boolean qualifyColumnNames, List customCriteriaFields, List customValueFields, List excludeCriteriaFields, Map operationBinding) throws Exception {
        if (!req.hasBeenThroughFieldLevelSecurity()) {
            DeclarativeSecurity.performFieldLevelDSRequestChecks((DSRequest)req);
        }
        String opType = req.getOperationType();
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
        List includeFrom = req.getIncludeFrom();
        if (includeFrom != null && !includeFrom.isEmpty()) {
            SQLDriver driver;
            int aliasLengthLimit = 128;
            DataSource reqDS = req.getDataSource();
            if (reqDS instanceof SQLDataSource && (driver = ((SQLDataSource)reqDS).getDriver()) != null) {
                aliasLengthLimit = driver.aliasLengthLimit();
            }
            LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
            for (IncludeFromDefinition incFrom : includeFrom) {
                SQLDataSource._createAliases(req, aliases, aliasLengthLimit, incFrom, null, null, null);
            }
        }
        if (logAlias.isDebugEnabled()) {
            boolean fkLogEnabled = logFK.isDebugEnabled();
            for (IncludeFromDefinition incFrom : includeFrom) {
                Object fk;
                Relation r;
                logAlias.debug((Object)("Aliases field " + incFrom.getThisDataSource().getName() + "." + incFrom.getThisFieldName() + " includes " + incFrom.getIncludePath() + "." + incFrom.getIncludedFieldName() + (String)(incFrom.getIncludeVia() != null ? " via " + incFrom.getIncludeVia() : "") + (String)(incFrom.getAlias() != null ? " using alias " + incFrom.getAlias() : "")));
                for (r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
                    fk = "";
                    if (fkLogEnabled) {
                        fk = "[";
                        for (DSField f : r.getFromFields()) {
                            fk = (String)fk + (String)(((String)fk).endsWith("[") ? f.getName() : ", " + f.getName());
                        }
                        fk = (String)fk + "] -> [";
                        for (DSField f : r.getToFields()) {
                            fk = (String)fk + (String)(((String)fk).endsWith("[") ? f.getName() : ", " + f.getName());
                        }
                        fk = (String)fk + "]";
                    }
                    logAlias.debug((Object)("Aliases relation " + r.getFromDataSource().getName() + (String)(r.getFromAlias() != null ? " AS " + r.getFromAlias() : "") + " -> " + r.getToDataSource().getName() + (String)(r.getToAlias() != null ? " AS " + r.getToAlias() : "") + (String)(fkLogEnabled ? ", FK fields " + (String)fk + (r.getOtherFK() ? " otherFK" : "") : "")));
                }
                while ((incFrom = incFrom.getTargetIncludeFrom()) != null) {
                    logAlias.debug((Object)("Aliases target field " + incFrom.getThisDataSource().getName() + "." + incFrom.getThisFieldName() + " includes " + incFrom.getIncludePath() + "." + incFrom.getIncludedFieldName() + (String)(incFrom.getIncludeVia() != null ? " via " + incFrom.getIncludeVia() : "") + (String)(incFrom.getAlias() != null ? " using alias " + incFrom.getAlias() : "")));
                    for (r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
                        fk = "";
                        if (fkLogEnabled) {
                            fk = "[";
                            for (DSField f : r.getFromFields()) {
                                fk = (String)fk + (String)(((String)fk).endsWith("[") ? f.getName() : ", " + f.getName());
                            }
                            fk = (String)fk + "] -> [";
                            for (DSField f : r.getToFields()) {
                                fk = (String)fk + (String)(((String)fk).endsWith("[") ? f.getName() : ", " + f.getName());
                            }
                            fk = (String)fk + "]";
                        }
                        logAlias.debug((Object)("Aliases relation " + r.getFromDataSource().getName() + (String)(r.getFromAlias() != null ? " AS " + r.getFromAlias() : "") + " -> " + r.getToDataSource().getName() + (String)(r.getToAlias() != null ? " AS " + r.getToAlias() : "") + (String)(fkLogEnabled ? ", FK fields " + (String)fk + (r.getOtherFK() ? " otherFK" : "") : "")));
                    }
                }
            }
        }
        ArrayList<DataSource> includeDataSources = new ArrayList<DataSource>(dataSources);
        for (int i = 0; i < dataSources.size(); ++i) {
            BasicDataSource ds = (BasicDataSource)dataSources.get(i);
            if (!(ds.autoDeriveDS instanceof BasicDataSource)) continue;
            includeDataSources.add(ds.autoDeriveDS);
        }
        SQLExpressions sqlExpressions = new SQLExpressions(req, includeDataSources, qualifyColumnNames, customValueFields, customCriteriaFields);
        if (SQLDataSource.isFetch((String)opType) || SQLDataSource.isCustom((String)opType)) {
            SQLSelectClause selectClause = new SQLSelectClause(sqlExpressions);
            context.put("defaultSelectClause", selectClause.getSQLString());
            if (selectClause.isGroupBy()) {
                context.put("defaultGroupClause", selectClause.getGroupByString());
                context.put("defaultGroupWithAliasClause", selectClause.getGroupByWithAliasString());
            }
            SQLOrderClause orderClause = new SQLOrderClause(req);
            context.put("defaultOrderClause", orderClause.getSQLString());
        }
        if (SQLDataSource.isAdd((String)opType) || SQLDataSource.isUpdate((String)opType) || SQLDataSource.isCustom((String)opType) || "replace".equals(opType)) {
            Map values = SQLDataSource.isAdd((String)opType) && req.getValueSets().size() > 1 ? (Map)req.getValueSets().get(0) : req.getValues();
            SQLValuesClause valuesClause = new SQLValuesClause(req, values, (SQLDataSource)((Object)dataSources.get(0)), (List)req.constraints());
            valuesClause.setCustomValueFields(customValueFields);
            if (valuesClause.size() > 0) {
                if (SQLDataSource.isUpdate((String)opType)) {
                    context.put("defaultValuesClause", valuesClause.getSQLStringForUpdate());
                } else {
                    context.put("defaultValuesClause", valuesClause.getSQLStringForInsert());
                }
            }
        }
        SQLTableClause tableClause = new SQLTableClause(req, dataSources);
        tableClause.setCustomValueFields(customValueFields);
        tableClause.setCustomCriteriaFields(customCriteriaFields);
        Object tableClauseString = tableClause.getSQLString();
        if (!SQLDataSource.isAdd((String)opType)) {
            boolean isFilter = "filter".equals(opType) || ("fetch".equals(opType) || "select".equals(opType)) && ("substring".equals(req.getTextMatchStyle()) || "startsWith".equals(req.getTextMatchStyle()));
            boolean criteriaBeforeAggregation = false;
            Object criteriaBeforeAggregationObj = req.getApplyCriteriaBeforeAggregation();
            criteriaBeforeAggregation = criteriaBeforeAggregationObj != null ? Boolean.TRUE.equals(criteriaBeforeAggregationObj) : operationBinding != null && DataTools.getBoolean((Map)operationBinding, (Object)"applyCriteriaBeforeAggregation", (boolean)criteriaBeforeAggregation);
            ArrayList aggregatedFields = null;
            if (!criteriaBeforeAggregation) {
                Map functions = req.getSummaryFunctions();
                aggregatedFields = functions != null ? new ArrayList(functions.keySet()) : null;
            }
            SQLWhereClause whereClause = new SQLWhereClause(req, dataSources, isFilter, req.getTextMatchStyle(), true, aggregatedFields, false);
            whereClause.setCustomCriteriaFields(customCriteriaFields);
            whereClause.setExcludeCriteriaFields(excludeCriteriaFields);
            if (SQLDataSource.isRemove((String)opType) && whereClause.isEmpty() && (operationBinding == null || !operationBinding.containsKey("customSQL") && !operationBinding.containsKey("whereClause"))) {
                throw new SQLException("empty where clause on delete operation - would  destroy table - ignoring.");
            }
            String whereClauseStr = whereClause.getSQLString();
            whereClauseStr = SQLDataSource.appendOracleTextPredicates(req, whereClauseStr, dataSources);
            context.put("defaultWhereClause", whereClauseStr);
            Object requestAfterCriteria = req.getParameter((Object)"afterCriteria");
            if (!req.isSummary() && requestAfterCriteria != null) {
                log.warn((Object)"Ignoring 'afterCriteria' for non-summary request.");
                requestAfterCriteria = null;
            }
            if (!criteriaBeforeAggregation && aggregatedFields != null || requestAfterCriteria != null) {
                boolean after;
                String groupWhereString = null;
                if (!criteriaBeforeAggregation && aggregatedFields != null) {
                    SQLWhereClause groupWhereClause = new SQLWhereClause(req, dataSources, isFilter, req.getTextMatchStyle(), false, aggregatedFields, true);
                    groupWhereClause.setCustomCriteriaFields(customCriteriaFields);
                    groupWhereClause.setExcludeCriteriaFields(excludeCriteriaFields);
                    groupWhereString = groupWhereClause.getSQLString();
                }
                String afterWhereString = null;
                if (requestAfterCriteria != null) {
                    afterWhereString = new SQLWhereClause(req, dataSources, isFilter, req.getTextMatchStyle(), req.getCriteria(true, requestAfterCriteria)).getSQLString();
                }
                StringBuffer result = new StringBuffer();
                boolean group = groupWhereString != null && !SQLWhereClause.isDefaultPositiveClause(groupWhereString);
                boolean bl = after = afterWhereString != null && !SQLWhereClause.isDefaultPositiveClause(afterWhereString);
                if (group && after) {
                    result.append(groupWhereString);
                    result.append(" AND ");
                    result.append(afterWhereString);
                } else if (after) {
                    result.append(afterWhereString);
                } else if (group) {
                    result.append(groupWhereString);
                } else {
                    result.append(groupWhereString != null ? groupWhereString : afterWhereString);
                }
                String resultClause = result.toString();
                context.put("defaultAfterWhereClause", resultClause);
                context.put("defaultGroupWhereClause", resultClause);
            }
            String ansiJoinString = null;
            boolean createdJoinWhereClause = false;
            if (req.getIncludeFrom() != null && req.getIncludeFrom().size() > 0 || req.isValueOperation() || req.isSummaryFunction()) {
                boolean oneSQLIncludeFrom = false;
                Iterator i = req.getIncludeFrom().iterator();
                while (i.hasNext()) {
                    if (!SQLDataSource.isAllSql((IncludeFromDefinition)i.next())) continue;
                    oneSQLIncludeFrom = true;
                    break;
                }
                if (oneSQLIncludeFrom || req.isValueOperation() || req.isSummaryFunction()) {
                    boolean useAnsiJoins = SQLDataSource.getUseAnsiJoins(req);
                    if (useAnsiJoins) {
                        SQLAnsiJoinClause ansiJoinClause = new SQLAnsiJoinClause(req, dataSources, qualifyColumnNames);
                        ansiJoinClause.setCustomValueFields(customValueFields);
                        ansiJoinClause.setCustomCriteriaFields(customCriteriaFields);
                        ansiJoinString = ansiJoinClause.getSQLString();
                        boolean includeAnsiJoinsInTableClause = config.getBoolean((Object)"sql.includeAnsiJoinsInTableClause", false);
                        if (operationBinding != null) {
                            includeAnsiJoinsInTableClause = DataTools.getBoolean((Map)operationBinding, (Object)"includeAnsiJoinsInTableClause", (boolean)includeAnsiJoinsInTableClause);
                        }
                        if (includeAnsiJoinsInTableClause && ansiJoinString != null && !DataSource.isModificationOperation((String)opType)) {
                            tableClauseString = (String)tableClauseString + " " + ansiJoinString;
                        } else {
                            context.put("defaultAnsiJoinClause", ansiJoinString);
                        }
                    }
                    if (!useAnsiJoins || req.isValueOperation() || req.isSummaryFunction()) {
                        SQLJoinWhereClause joinWhereClause = new SQLJoinWhereClause(req, dataSources);
                        joinWhereClause.setCustomValueFields(customValueFields);
                        joinWhereClause.setCustomCriteriaFields(customCriteriaFields);
                        context.put("defaultJoinWhereClause", joinWhereClause.getSQLString());
                        createdJoinWhereClause = true;
                    }
                }
            }
            if ((req.isValueOperation() || req.isSummaryFunction()) && !createdJoinWhereClause) {
                SQLJoinWhereClause joinWhereClause = new SQLJoinWhereClause(req, dataSources);
                joinWhereClause.setCustomValueFields(customValueFields);
                joinWhereClause.setCustomCriteriaFields(customCriteriaFields);
                context.put("defaultJoinWhereClause", joinWhereClause.getSQLString());
            }
        }
        context.put("defaultTableClause", (String)tableClauseString);
        return context;
    }

    protected static boolean getUseAnsiJoins(DSRequest req) throws Exception {
        Boolean useAnsiJoins = DataTools.asBooleanObject((Object)req.getDataSource().getConfig().get((Object)"useAnsiJoins"));
        if (useAnsiJoins == null) {
            useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
        }
        return useAnsiJoins != null && useAnsiJoins == true;
    }

    private static DSField getField(List<SQLDataSource> dataSources, String fieldName) {
        if (dataSources != null) {
            for (SQLDataSource ds : dataSources) {
                DSField field = ds.getField(fieldName);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    private static SQLUtils.Pair<Object, Object> splitCriteriaOnFieldName(List<SQLDataSource> dataSources, String fieldName, Object criteria) {
        if (criteria instanceof List) {
            List listCriteria = (List)criteria;
            boolean first = true;
            boolean include = true;
            Object value = null;
            for (Object item : listCriteria) {
                if (!(item instanceof Map)) {
                    return null;
                }
                Map mapItem = (Map)item;
                if (first) {
                    if (mapItem == null || mapItem.isEmpty()) continue;
                    first = false;
                    include = mapItem.containsKey(fieldName);
                    if (!include) continue;
                    value = mapItem.get(fieldName);
                    continue;
                }
                if (include != mapItem.containsKey(fieldName)) {
                    return null;
                }
                if (!include) continue;
                Object v = mapItem.get(fieldName);
                if (value != null ? value.equals(v) : v == null) continue;
                return null;
            }
            if (first) {
                return null;
            }
            if (include) {
                HashMap<String, Object> includesFieldName = new HashMap<String, Object>();
                includesFieldName.put(fieldName, value);
                ArrayList ignoresFieldName = new ArrayList(listCriteria.size());
                for (Object item : listCriteria) {
                    HashMap itemWithoutFieldName = new HashMap((Map)item);
                    itemWithoutFieldName.remove(fieldName);
                    ignoresFieldName.add(itemWithoutFieldName);
                }
                return new SQLUtils.Pair<Object, Object>(includesFieldName, ignoresFieldName);
            }
            return new SQLUtils.Pair<Object, Object>(null, criteria);
        }
        if (criteria instanceof Map) {
            Map mapCriteria = (Map)criteria;
            if (SQLDataSource.isAdvancedCriteria(dataSources, mapCriteria)) {
                AdvancedCriteria parsedCriteria = DataSource.parseAdvancedCriteria((Map)mapCriteria);
                if (parsedCriteria != null) {
                    SQLUtils.Pair<Criterion, Criterion> split = SQLDataSource.splitCriteriaOnFieldName(fieldName, parsedCriteria.asCriterion());
                    if (split == null || split.getFirst() == null && split.getSecond() == null) {
                        return null;
                    }
                    Criterion includesFieldName = split.getFirst();
                    Criterion ignoresFieldName = split.getSecond();
                    return new SQLUtils.Pair<Object, Object>(SQLDataSource.criterionAsAdvancedCriteriaMap(includesFieldName), SQLDataSource.criterionAsAdvancedCriteriaMap(ignoresFieldName));
                }
                return null;
            }
            return SQLDataSource.splitCriteriaOnFieldName(fieldName, mapCriteria);
        }
        return null;
    }

    private static <V> SQLUtils.Pair<Map<String, V>, Map<String, V>> splitCriteriaOnFieldName(String fieldName, Map<String, V> criteria) {
        Map<Object, V> includesFieldName = null;
        Map<String, V> ignoresFieldName = null;
        if (criteria == null || criteria.isEmpty()) {
            return null;
        }
        if (criteria.size() == 1) {
            if (criteria.containsKey(fieldName)) {
                includesFieldName = criteria;
            } else {
                ignoresFieldName = criteria;
            }
        } else {
            includesFieldName = new HashMap();
            ignoresFieldName = new HashMap<String, V>();
            for (Map.Entry<String, V> entry : criteria.entrySet()) {
                String key = entry.getKey();
                if (key == null ? fieldName == null : key.equals(fieldName)) {
                    includesFieldName.put(key, entry.getValue());
                    continue;
                }
                ignoresFieldName.put(key, entry.getValue());
            }
        }
        return new SQLUtils.Pair<Map<String, V>, Map<String, V>>(includesFieldName, ignoresFieldName);
    }

    private static SQLUtils.Pair<Criterion, Criterion> splitCriteriaOnFieldName(String fieldName, Criterion criterion) {
        switch (SQLDataSource.criterionIncludesField(fieldName, criterion)) {
            case INVALID: 
            case INSEPARABLE: {
                return null;
            }
            case TOTAL: {
                return new SQLUtils.Pair<Criterion, Object>(criterion, null);
            }
            case NONE: {
                return new SQLUtils.Pair<Object, Criterion>(null, criterion);
            }
            case PARTIAL: {
                List subcriteria;
                if (!(criterion instanceof LogicalCriterion)) {
                    return null;
                }
                AndCriterion ac = CriteriaUtils.rewriteToAnd((Criterion)criterion);
                if (ac == null || (subcriteria = ac.getCriteria()) == null) break;
                ArrayList<Criterion> includes = new ArrayList<Criterion>();
                ArrayList<Criterion> ignores = new ArrayList<Criterion>();
                for (Object subcriterion : subcriteria) {
                    if (!(subcriterion instanceof Criterion)) continue;
                    switch (SQLDataSource.criterionIncludesField(fieldName, (Criterion)subcriterion)) {
                        case INVALID: 
                        case INSEPARABLE: {
                            return null;
                        }
                        case TOTAL: {
                            includes.add((Criterion)subcriterion);
                            break;
                        }
                        case NONE: {
                            ignores.add((Criterion)subcriterion);
                        }
                        case PARTIAL: {
                            SQLUtils.Pair<Criterion, Criterion> pair = SQLDataSource.splitCriteriaOnFieldName(fieldName, (Criterion)subcriterion);
                            if (pair == null) {
                                return null;
                            }
                            if (pair.getFirst() != null) {
                                includes.add(pair.getFirst());
                            }
                            if (pair.getSecond() == null) break;
                            ignores.add(pair.getSecond());
                        }
                    }
                }
                int includesSize = includes.size();
                int ignoresSize = ignores.size();
                Object first = includesSize == 0 ? null : (includesSize == 1 ? (Criterion)includes.get(0) : new AndCriterion(includes));
                Object second = ignoresSize == 0 ? null : (ignoresSize == 1 ? (Criterion)ignores.get(0) : new AndCriterion(ignores));
                return new SQLUtils.Pair<Criterion, Object>((Criterion)first, second);
            }
        }
        return null;
    }

    private static boolean isAdvancedCriteria(List dataSources, Map criteria) {
        if (criteria == null) {
            return false;
        }
        if ("AdvancedCriteria".equals(criteria.get("_constructor"))) {
            return true;
        }
        if (dataSources == null) {
            return false;
        }
        for (Object ds : dataSources) {
            if (!(ds instanceof DataSource) || !((DataSource)ds).isAdvancedCriteria(criteria)) continue;
            return true;
        }
        return false;
    }

    private static Map criterionAsAdvancedCriteriaMap(Criterion criterion) {
        if (criterion == null) {
            return null;
        }
        return new AdvancedCriteria(criterion).getCriteriaAsMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CriterionFieldInclusion criterionIncludesField(String fieldName, Criterion criterion) {
        CriterionFieldInclusion ret;
        if (criterion == null) {
            return CriterionFieldInclusion.INVALID;
        }
        String name = criterion.getFieldName();
        if (name == null && !(criterion instanceof LogicalCriterion)) {
            return CriterionFieldInclusion.INVALID;
        }
        if (name == null) {
            ret = null;
        } else if (criterion instanceof OtherFieldCriterion) {
            String otherName = ((OtherFieldCriterion)criterion).getOtherFieldName();
            if (otherName == null) {
                return CriterionFieldInclusion.INVALID;
            }
            if (!name.equals(fieldName) && !otherName.equals(fieldName)) {
                ret = CriterionFieldInclusion.NONE;
            } else {
                if (!name.equals(fieldName) || !otherName.equals(fieldName)) return CriterionFieldInclusion.INSEPARABLE;
                ret = CriterionFieldInclusion.TOTAL;
            }
        } else {
            ret = name.equals(fieldName) ? CriterionFieldInclusion.TOTAL : CriterionFieldInclusion.NONE;
        }
        if (criterion instanceof LogicalCriterion) {
            List subcriteria = ((LogicalCriterion)criterion).getCriteria();
            if (subcriteria == null || subcriteria.isEmpty()) {
                return CriterionFieldInclusion.INVALID;
            }
            for (Object subcriterion : subcriteria) {
                if (!(subcriterion instanceof Criterion)) {
                    return CriterionFieldInclusion.INVALID;
                }
                CriterionFieldInclusion inclusion = SQLDataSource.criterionIncludesField(fieldName, (Criterion)subcriterion);
                switch (inclusion) {
                    case INVALID: 
                    case INSEPARABLE: {
                        return inclusion;
                    }
                }
                if (ret == null) {
                    ret = inclusion;
                    continue;
                }
                if (ret == inclusion) continue;
                ret = CriterionFieldInclusion.PARTIAL;
            }
        }
        if (ret != null) return ret;
        return CriterionFieldInclusion.INVALID;
    }

    private static boolean isAllSql(IncludeFromDefinition incFrom) throws Exception {
        while (incFrom != null) {
            if (!incFrom.getDataSource().canJoinIncludedFields()) {
                return false;
            }
            incFrom = incFrom.getTargetIncludeFrom();
        }
        return true;
    }

    public List extractFieldNamesRecursively(List criteria, List fieldNames) {
        for (Map criterion : criteria) {
            String fieldName;
            String fieldName2;
            if (criterion.containsKey("criteria")) {
                this.extractFieldNamesRecursively((List)criterion.get("criteria"), fieldNames);
                continue;
            }
            if (criterion.containsKey("fieldName") && !fieldNames.contains(fieldName2 = (String)criterion.get("fieldName"))) {
                fieldNames.add(fieldName2);
            }
            String operator = (String)criterion.get("operator");
            Object value = criterion.get("value");
            if (operator == null || value == null || !operator.equals("equalsField") && !operator.equals("notEqualField") && !operator.equals("greaterThanField") && !operator.equals("greaterOrEqualField") && !operator.equals("lessThanField") && !operator.equals("lessOrEqualField") && !operator.equals("containsField") && !operator.equals("iContainsField") && !operator.equals("startsWithField") && !operator.equals("iStartsWithField") && !operator.equals("endsWithField") && !operator.equals("iEndsWithField") && !operator.equals("iEqualsField") && !operator.equals("notContainsField") && !operator.equals("iNotContainsField") && !operator.equals("notStartsWithField") && !operator.equals("iNotStartsWithField") && !operator.equals("notEndsWithField") && !operator.equals("iNotEndsWithField") && !operator.equals("iNotEqualField") || this.getField(fieldName = value.toString()) == null || fieldNames.contains(fieldName)) continue;
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    private static Map getVariablesContext(final DSRequest req, List dataSources) throws Exception {
        String opType = req.getOperationType();
        Map context = Velocity.getStandardContextMap((DSRequest)req);
        context.put("sql", new $SQL(){

            @Override
            public String partialWhere(String ... fieldNames) throws Exception {
                return SQLDataSource.getPartialWhere(req, fieldNames);
            }

            @Override
            public String whereWithout(String ... fieldNames) throws Exception {
                return SQLDataSource.getWhereWithout(req, fieldNames);
            }

            @Override
            public String partialHaving(String ... fieldNames) throws Exception {
                return SQLDataSource.getPartialHaving(req, fieldNames);
            }

            @Override
            public String havingWithout(String ... fieldNames) throws Exception {
                return SQLDataSource.getHavingWithout(req, fieldNames);
            }
        });
        Map crit = req.getCriteria(false);
        context.put("where", crit);
        context.put("filter", new EscapedValuesMap(crit, dataSources, 2));
        context.put("equals", new EscapedValuesMap(crit, dataSources, 3));
        context.put("substringMatches", new EscapedValuesMap(crit, dataSources, 4));
        if (!(dataSources.get(0) instanceof SQLDataSource)) {
            return context;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        HashMap<String, String> qfields = new HashMap<String, String>();
        SQLDataSource firstDS = (SQLDataSource)((Object)dataSources.get(0));
        Map remapTable = SQLDataSource.getField2ColumnMap(dataSources);
        Map column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        for (String key : firstDS._getFieldNames()) {
            String tableName;
            String columnName = (String)remapTable.get(key);
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            if ((tableName = (String)column2TableMap.get(columnName)) == null) {
                tableName = firstDS.getTable().getNameQuotedIfNecessary(firstDS);
            }
            for (int j = 0; j < dataSources.size(); ++j) {
                DataSource ds = (DataSource)dataSources.get(j);
                DSField field = ds.getField(key);
                if (field == null) continue;
                if (field.get((Object)"tableName") == null) break;
                tableName = field.get((Object)"tableName").toString();
                break;
            }
            if (columnName == null) continue;
            qfields.put(key, firstDS.getDriver().sqlOutTransform(columnName, key, tableName));
            fields.put(key, firstDS.getDriver().sqlOutTransform(columnName, key, null));
        }
        context.put("fields", fields);
        context.put("qfields", qfields);
        Velocity.addRawValuesToContextMap((Map)context, (boolean)true);
        return context;
    }

    private static List<SQLDataSource> getDataSources(List dataSourceList, DSRequest dsRequest) throws Exception {
        ArrayList<SQLDataSource> dataSources = new ArrayList<SQLDataSource>();
        for (Object ds : dataSourceList) {
            if (ds instanceof SQLDataSource) {
                dataSources.add((SQLDataSource)((Object)ds));
                continue;
            }
            SQLDataSource SQLds = (SQLDataSource)DataSourceManager.getDataSource((String)((String)ds), (DSRequest)dsRequest);
            if (SQLds == null) continue;
            dataSources.add(SQLds);
        }
        return dataSources;
    }

    public static Map getField2ColumnMap(List dataSources) {
        return SQLDataSource.getField2ColumnMap(dataSources, false);
    }

    public static Map getField2ColumnMap(List dataSources, boolean primaryKeysOnly) {
        LinkedHashMap combinedRemap = new LinkedHashMap();
        for (SQLDataSource ds : dataSources) {
            Map singleRemap = ds.getCorrectDs2NativeFieldMap();
            if (primaryKeysOnly) {
                singleRemap = DataTools.subsetMap((Map)singleRemap, (List)ds.getPrimaryKeys());
            }
            combinedRemap = DataTools.orderedMapUnion(combinedRemap, (Map)singleRemap);
        }
        return combinedRemap;
    }

    public static Map getColumn2TableMap(List dataSources) throws Exception {
        return SQLDataSource.getColumn2TableMap(dataSources, false);
    }

    public static Map getColumn2TableMap(List dataSources, boolean primaryKeysOnly) throws Exception {
        HashMap column2TableMap = new HashMap();
        for (SQLDataSource ds : dataSources) {
            Map singleRemap = ds.ds2NativeFieldMap();
            if (primaryKeysOnly) {
                singleRemap = DataTools.subsetMap((Map)singleRemap, (List)ds.getPrimaryKeys());
            }
            for (Object field : singleRemap.keySet()) {
                Object column = singleRemap.get(field);
                if (column instanceof List) {
                    column = ((List)column).get(0);
                }
                String columnName = (String)column;
                if (column2TableMap.containsKey(field)) continue;
                if (columnName != null && columnName.contains(".")) {
                    column2TableMap.put(field, SQLTable.getNameQuotedIfNecessary(ds, columnName.substring(0, columnName.indexOf("."))));
                    continue;
                }
                column2TableMap.put(field, ds.getTable().getNameQuotedIfNecessary(ds));
            }
        }
        return column2TableMap;
    }

    public static Map getCombinedValueMaps(List dataSources, List sortBy) {
        LinkedHashMap valueMaps = new HashMap();
        for (SQLDataSource ds : dataSources) {
            valueMaps = DataTools.orderedMapUnion(valueMaps, (Map)ds.getValueMaps(sortBy));
        }
        return valueMaps;
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, tableName, schema, null, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, null, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, null, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, dbName, null, true, null, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map properties) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, dbName, null, true, null, null, properties);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map autoDeriveSchemaOperation, boolean cacheDS, Map overriddenFields, Boolean autoDeriveFKs) throws Exception {
        return SQLDataSource.fromTable(conn, tableName, schema, ID, serverType, dbName, autoDeriveSchemaOperation, cacheDS, overriddenFields, autoDeriveFKs, null);
    }

    public static DataSource fromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map autoDeriveSchemaOperation, boolean cacheDS, Map overriddenFields, Boolean autoDeriveFKs, Map properties) throws Exception {
        if (serverType == null) {
            serverType = "sql";
        }
        if (tableName == null) {
            tableName = ID;
        }
        if (ID == null) {
            ID = tableName;
        }
        String wkTableName = tableName.endsWith("_inheritsFrom") ? tableName.substring(0, tableName.lastIndexOf("_inheritsFrom")) : tableName;
        Map config = SQLDataSource.getConfigFromTable(conn, wkTableName, schema, ID, serverType, dbName, autoDeriveSchemaOperation, overriddenFields, autoDeriveFKs);
        config.put("__autoConstruct", "DataSource");
        if ("hibernate".equals(serverType) && tableName.endsWith("_inheritsFrom")) {
            config.put("_inheritsFrom", "true");
        }
        if (cacheDS) {
            config.put("dbName", dbName);
        }
        if (properties != null) {
            DataTools.mapMerge((Map)properties, (Map)config);
        }
        DataSource ds = DataSource.fromConfig((Map)config, null);
        if (cacheDS) {
            if (tableName.endsWith("_inheritsFrom")) {
                DataStructCache.addCachedObjectWithNoConfigFile((String)(ID + "_inheritsFrom"), (Object)ds);
            } else {
                DataStructCache.addCachedObjectWithNoConfigFile((String)ID, (Object)ds);
            }
        }
        return ds;
    }

    public static Map getConfigFromTable(String tableName, String schema, String serverType, String dbName) throws Exception {
        return SQLDataSource.getConfigFromTable(null, tableName, tableName, schema, serverType, dbName, null, null, null);
    }

    public static Map getConfigFromTable(Connection conn, String tableName, String schema, String ID, String serverType, String dbName, Map autoDeriveSchemaOperation, Map overriddenFields, Boolean autoDeriveFKs) throws Exception {
        SQLDSGenerator generator = new SQLDSGenerator(tableName, schema, dbName, serverType);
        generator.setConn(conn);
        generator.setID(ID);
        generator.setOverriddenFields(overriddenFields);
        if (autoDeriveSchemaOperation != null) {
            generator.setAutoDeriveSchemaOperation(autoDeriveSchemaOperation);
        }
        generator.setAutoDeriveFKs(autoDeriveFKs);
        return generator.generate();
    }

    public static List getFieldsFromTable(Connection conn, String tableName, String schema) throws Exception {
        return SQLDataSource.getFieldsFromTable(conn, tableName, schema, null);
    }

    public static List getFieldsFromTable(Connection conn, String tableName, String schema, String dbName) throws Exception {
        return SQLDSGenerator.getFieldsFromTable(conn, tableName, schema, dbName);
    }

    protected Boolean autoJoinAtProviderLevel(DSRequest dsRequest) throws Exception {
        String autoJoin;
        String dbName = this.dsConfig.getString((Object)"dbName");
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if ((autoJoin = this.getDriver().getSqlConfig().getString((Object)"autoJoinTransactions")) == null) {
            return null;
        }
        if (autoJoin.toLowerCase().equals("true") || autoJoin.equals("ALL")) {
            return Boolean.TRUE;
        }
        if (autoJoin.toLowerCase().equals("false") || autoJoin.equals("NONE")) {
            return Boolean.FALSE;
        }
        if (dsRequest != null && dsRequest.getDsTransaction() != null) {
            if (autoJoin.equals("FROM_FIRST_CHANGE")) {
                return dsRequest.getDsTransaction().requestQueueIncludesUpdates();
            }
            if (autoJoin.equals("ANY_CHANGE")) {
                return dsRequest.getDsTransaction().requestQueueIncludesUpdates();
            }
        }
        return null;
    }

    public int getProviderLevelTransactionPolicy(DSRequest req) throws Exception {
        String autoJoin;
        String dbName = this.dsConfig.getString((Object)"dbName");
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        if ((autoJoin = this.getDriver().getSqlConfig().getString((Object)"autoJoinTransactions")) == null) {
            return 0;
        }
        if (autoJoin.equalsIgnoreCase("true") || autoJoin.equalsIgnoreCase("ALL")) {
            return 3;
        }
        if (autoJoin.equalsIgnoreCase("false") || autoJoin.equalsIgnoreCase("NONE")) {
            return 4;
        }
        if (req != null && req.getDsTransaction() != null) {
            if (autoJoin.equalsIgnoreCase("FROM_FIRST_CHANGE")) {
                return 1;
            }
            if (autoJoin.equalsIgnoreCase("ANY_CHANGE")) {
                return 2;
            }
        }
        return 0;
    }

    public String getTransactionObjectKey(boolean longForm) throws Exception {
        return (longForm ? "_isc_sql_connection_" : "sql.") + this.dbName;
    }

    public void freeResources(DSRequest req) {
        try {
            if (req != null) {
                if (req.getDsTransaction() != null && !req.getFreeOnExecute() && !req.getDsTransaction().isUsingSpringTransaction() && SQLTransaction.getConnection(req.getDsTransaction(), this.dbName) != null) {
                    SQLTransaction.endTransaction(req.getDsTransaction(), this.dbName);
                } else if (req.getFreeOnExecute()) {
                    this.clearState();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception while ending transaction connection", (Throwable)e);
        }
        super.freeResources(req);
    }

    public boolean canJoinIncludedFields() {
        return true;
    }

    public boolean inheritsParentForJoin() throws Exception {
        if (this.dsConfig.getBoolean((Object)"autoInheritParent", false)) {
            return false;
        }
        if (DataSource.DSInheritanceMode.FULL.equals((Object)this.getInheritanceMode()) || DataSource.DSInheritanceMode.NONE.equals((Object)this.getInheritanceMode())) {
            return false;
        }
        if (!(this.getSuper() instanceof SQLDataSource)) {
            return false;
        }
        return this.isRelatedThroughPrimaryKey((DataSource)this.getSuper());
    }

    public List getPrimaryKeys() {
        if (this.primaryKeys != null && this.primaryKeys.size() > 0) {
            return this.primaryKeys;
        }
        List pks = new ArrayList();
        if (this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        return pks;
    }

    public List getPrimaryKeyColumnNames() {
        List pks = null;
        if (this.primaryKeys != null && this.primaryKeys.size() > 0) {
            pks = this.primaryKeys;
        }
        if (pks == null && this.getSuper() != null) {
            pks = this.getSuper().getPrimaryKeys();
        }
        for (int i = 0; i < pks.size(); ++i) {
            String fieldName = (String)pks.get(i);
            pks.set(i, this.getColumnName(fieldName));
        }
        return pks;
    }

    public DSField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        DSField field = (DSField)this.dsFields.get(fieldName);
        if (field != null) {
            return field;
        }
        if (this.getSuper() != null) {
            field = this.getSuper().getField(fieldName);
        }
        if (field != null && "sequence".equals(field.getType())) {
            Iterator i = this.dsFields.keySet().iterator();
            while (i.hasNext()) {
                DSField localField = (DSField)this.dsFields.get(i.next());
                if (localField == null || !"sequence".equals(localField.getType())) continue;
                DSField changedField = new DSField((Map)field);
                changedField.put((Object)"type", (Object)"integer");
                return changedField;
            }
        }
        return field;
    }

    public Map getCorrectDs2NativeFieldMap() {
        if (DataSource.DSInheritanceMode.NONE.equals((Object)this.getInheritanceMode())) {
            return this.ds2NativeFieldMap;
        }
        return this.getExpandedDs2NativeFieldMap();
    }

    public boolean supportsSummaryFunction(String functionName) {
        if (functionName == null) {
            return false;
        }
        return supportedSummaryFunctions.contains(functionName.toUpperCase());
    }

    public boolean shouldUseUTCDateTimes() {
        Boolean useUTCDateTimes = this.dsConfig.getBoolean((Object)"useUTCDateTimes");
        if (useUTCDateTimes != null) {
            return useUTCDateTimes;
        }
        if (this.driver != null) {
            return this.driver.useUTCDateTimes;
        }
        return true;
    }

    public static String getSQLClause(SQLClauseType clauseType, DSRequest dsRequest) throws Exception {
        return SQLDataSource.getSQLClause(clauseType, dsRequest, false, null);
    }

    public static String getSQLClause(SQLClauseType clauseType, DSRequest dsRequest, boolean includeSQLLimitCode) throws Exception {
        return SQLDataSource.getSQLClause(clauseType, dsRequest, includeSQLLimitCode, null);
    }

    public String getSQLClauseForThisDS(SQLClauseType clauseType, DSRequest dsRequest, boolean includeSQLLimitCode) throws Exception {
        return SQLDataSource.getSQLClause(clauseType, dsRequest, includeSQLLimitCode, this);
    }

    public static String getSQLClause(SQLClauseType type, DSRequest dsRequest, boolean includeSQLLimitCode, SQLDataSource ds) throws Exception {
        ArrayList<SQLDataSource> dataSources = new ArrayList<SQLDataSource>();
        ds = ds == null ? (SQLDataSource)dsRequest.getDataSource() : ds;
        dataSources.add(ds);
        DataTypeMap opBinding = ds.getOperationBinding(dsRequest);
        List customFields = SQLDataSource.getCustomFields((Map)opBinding);
        List customCriteriaFields = SQLDataSource.getCustomCriteriaFields((Map)opBinding);
        List customValueFields = SQLDataSource.getCustomValueFields((Map)opBinding);
        List excludeValueFields = SQLDataSource.getExcludeValueFields((Map)opBinding);
        if (customCriteriaFields == null) {
            customCriteriaFields = customFields;
        }
        if (customValueFields == null) {
            customValueFields = customFields;
        }
        Map context = SQLDataSource.getVariablesContext(dsRequest, dataSources);
        dsRequest.buildFieldData(false);
        DSTransaction dsTransaction = dsRequest.getDsTransaction();
        if (dsTransaction == null) {
            log.info((Object)"dsTransaction was null in getSQLClause() - cannot apply declarative criteria");
        } else {
            dsTransaction.applyEarlierResponseValues(dsRequest);
        }
        context.putAll(SQLDataSource.getClausesContext(dsRequest, dataSources, SQLDataSource.shouldQualifyColumnNames((Map)opBinding, (DataSource)ds), customCriteriaFields, customValueFields, excludeValueFields, (Map)opBinding));
        String clauseName = String.valueOf((Object)type) + "Clause";
        String defaultClause = "$default" + clauseName;
        clauseName = clauseName.substring(0, 1).toLowerCase() + clauseName.substring(1);
        String sql = null;
        if (type == SQLClauseType.All) {
            if (SQLDataSource.isAdd((String)dsRequest.getOperationType()) && dsRequest.getValueSets().size() > 1) {
                sql = (String)SQLDataSource.executeMultipleInsert(dsRequest, dsRequest.getValueSets(), dataSources, true).getData();
            }
            if (sql == null) {
                sql = SQLDataSource.generateSQLStatement(dsRequest, context);
                if (DataSource.isFetch((String)dsRequest.getOperationType()) && includeSQLLimitCode) {
                    DataTypeMap operationBinding = dsRequest.getDataSource().getOperationBinding(dsRequest.getOperationType(), dsRequest.getOperationId());
                    String paging = SQLDataSource.getPaging(dsRequest, (Map)operationBinding, ds);
                    if (dsRequest.isPaged() && "sqlLimit".equals(paging)) {
                        DSResponse result = new DSResponse((DataSource)ds);
                        String orderClause = SQLDataSource.getClause(dsRequest, "orderClause", "$defaultOrderClause");
                        if (dsRequest.getEndRow() != -1L && dsRequest.getEndRow() - dsRequest.getStartRow() > dsRequest.getBatchSize()) {
                            dsRequest._setBatchSize(dsRequest.getEndRow() - dsRequest.getStartRow());
                        }
                        sql = SQLDataSource.getDatabaseSpecificFetchQuery(sql, dataSources, dsRequest, ds.getDriver(), orderClause, result, context);
                    }
                }
            }
        } else {
            sql = SQLDataSource.getClause(dsRequest, clauseName, defaultClause);
        }
        sql = SQLDataSource.applyPrefixAndSuffix(sql, dsRequest, ds);
        return Velocity.evaluateWithSnippets((String)sql, (Map)SQLDataSource.addMissingClausesToContext(context), (String)("getSQLClause(" + String.valueOf((Object)type) + ")"), (DSRequest)dsRequest, (boolean)true, (boolean)false);
    }

    public Object streamNextRecordAsObject(DSResponse response) throws StreamingResponseException {
        return this._streamNextRecord(response, true);
    }

    public Map streamNextRecord(DSResponse response) throws StreamingResponseException {
        Object obj = this._streamNextRecord(response, false);
        if (obj == null || obj instanceof Map) {
            return (Map)obj;
        }
        throw new StreamingResponseException("Unexpected object type " + obj.getClass().getName() + "returned from SQLTransform");
    }

    private Object _streamNextRecord(DSResponse response, boolean convertToBeans) throws StreamingResponseException {
        try {
            Map context = response._getStreamingContext();
            ResultSet resultSet = (ResultSet)context.get("resultSet");
            List dataSources = (List)context.get("dataSources");
            Boolean brokenCursorAPIs = (Boolean)context.get("brokenCursorAPIs");
            Map opConfig = (Map)context.get("opConfig");
            DSRequest dsRequest = (DSRequest)context.get("dsRequest");
            List work = SQLTransform.toListOfMapsOrBeans(resultSet, 1L, brokenCursorAPIs, dataSources, opConfig, dsRequest, convertToBeans, response);
            return work.get(0);
        }
        catch (Exception e) {
            if (e instanceof StreamingResponseException) {
                throw (StreamingResponseException)e;
            }
            StreamingResponseException sre = new StreamingResponseException("Exception trying to stream the next record in a SQLDataSource DSResponse");
            sre.initCause((Throwable)e);
            throw sre;
        }
    }

    protected boolean getDefaultAllowAdvancedCriteria() {
        return true;
    }

    public DataSource.DSInheritanceMode getInheritanceMode() {
        return "none".equals(this.dsConfig.get((Object)"inheritanceMode")) ? DataSource.DSInheritanceMode.NONE : DataSource.DSInheritanceMode.FULL;
    }

    public Relation getRelation(DataSource[] relatedDSArray, String includeVia, String queryFK, boolean logProblems, DSRequest dsRequest) throws Exception {
        Relation relation = super.getRelation(relatedDSArray, includeVia, queryFK, false, dsRequest);
        if (relation == null) {
            StringBuilder warningMessageBuilder = new StringBuilder("NOTE: This failure to find a relation happened despite an attempt to use native FKs derived from the schema metadata.");
            for (DataSource relatedDS : relatedDSArray) {
                if (!(relatedDS instanceof SQLDataSource)) continue;
                SQLDataSource relatedSQLDS = (SQLDataSource)relatedDS;
                String relatedTableName = (String)relatedSQLDS.getConfig().get((Object)"tableName");
                if (relatedTableName == null) {
                    relatedTableName = (String)relatedSQLDS.getConfig().get((Object)"ID");
                }
                CaseInsensitiveMap native2DS = new CaseInsensitiveMap(relatedSQLDS.native2DSFieldMap());
                Object fields = "";
                for (DSField field : this.getFields()) {
                    String nativeFK = field.getNativeFK();
                    String fkDefinition = null;
                    if (nativeFK != null) {
                        String relatedFieldName;
                        String[] parts = nativeFK.split("\\.");
                        if (parts.length < 2 || !parts[0].equalsIgnoreCase(relatedTableName) || (relatedFieldName = (String)native2DS.get((Object)parts[1])) == null) continue;
                        fkDefinition = relatedSQLDS.getID() + "." + relatedFieldName;
                    }
                    String fkTableCode = field.getProperty("fkTableCode");
                    String fkColumnCode = field.getProperty("fkColumnCode");
                    if (fkTableCode != null && fkColumnCode != null) {
                        String relatedTableCode = (String)relatedSQLDS.getConfig().get((Object)"tableCode");
                        if (relatedTableCode == null) {
                            try {
                                relatedTableCode = DataTools.hashValue((String)relatedTableName.toLowerCase());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (fkTableCode.equals(relatedTableCode)) {
                            for (DSField relatedField : relatedDS.getFields()) {
                                String relatedColumnCode = (String)relatedField.get((Object)"columnCode");
                                if (relatedColumnCode == null) {
                                    String _relatedFieldName = relatedField.getNativeName();
                                    if (_relatedFieldName == null) {
                                        _relatedFieldName = relatedField.getName();
                                    }
                                    try {
                                        relatedColumnCode = DataTools.hashValue((String)_relatedFieldName.toLowerCase());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!fkColumnCode.equals(relatedColumnCode)) continue;
                                fkDefinition = relatedSQLDS.getID() + "." + relatedField.getName();
                                break;
                            }
                        }
                    }
                    if (fkDefinition == null) continue;
                    field.setForeignKey(fkDefinition);
                    fields = (String)fields + ("".equals(fields) ? "" : ", ") + field.getName();
                }
                if (relatedDSArray.length > 1) {
                    warningMessageBuilder.append("For datasource ").append(relatedDS.getName());
                }
                warningMessageBuilder.append((String)(((String)fields).equals("") ? "No valid native FK fields were found" : "We found the following native FK fields: " + (String)fields)).append(".");
            }
            relation = super.getRelation(relatedDSArray, includeVia, queryFK, logProblems, dsRequest);
            if (relation == null) {
                log.warn((Object)warningMessageBuilder.toString());
            }
        }
        return relation;
    }

    public void createStorage(boolean dropFirst) throws Exception {
        try {
            SQLTableCreator.createTable(this, dropFirst);
        }
        catch (Exception ex) {
            log.warn((Object)("Error creating storage for DataSource " + this.getName() + (dropFirst ? " after dropping tables" : " without dropping tables") + " first"), (Throwable)ex);
            throw ex;
        }
    }

    public static List<Integer> executeAsBatch(List<DSRequest> dsRequests) throws Exception {
        int[] results = SQLDataSource.executeAsBatch(dsRequests.toArray(new DSRequest[dsRequests.size()]));
        ArrayList<Integer> rtn = new ArrayList<Integer>();
        for (int i = 0; i < results.length; ++i) {
            rtn.add(results[i]);
        }
        return rtn;
    }

    public static int[] executeAsBatch(DSRequest[] dsRequests) throws Exception {
        if (dsRequests.length == 0) {
            return null;
        }
        DataSource ds = dsRequests[0].getDataSource();
        if (!(ds instanceof SQLDataSource)) {
            throw new Exception(ds.getName() + " is not a SQLDataSource - cannot use executeAsBatch");
        }
        SQLDataSource sqlds = (SQLDataSource)ds;
        String dbName = sqlds.getDBName();
        Connection conn = null;
        Statement stmt = null;
        int[] sqlResult = null;
        StringBuilder batch = null;
        try {
            conn = SQLConnectionManager.getConnection(dbName);
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            boolean debug = log.isDebugEnabled();
            for (int i = 0; i < dsRequests.length; ++i) {
                if (SQLDataSource.isFetch((String)dsRequests[i].getOperationType())) {
                    throw new Exception("DSRequest " + i + " in the list sent to executeAsBatch() is a 'fetch' request, which does not make sense. Abandoning the entire batch");
                }
                String sql = SQLDataSource.getSQLClause(SQLClauseType.All, dsRequests[i]);
                if (debug) {
                    log.debug((Object)("Adding SQL query to batch: " + sql));
                }
                stmt.addBatch(sql);
                if (!logSqlError.isDebugEnabled()) continue;
                if (batch == null) {
                    batch = new StringBuilder();
                } else {
                    batch.append(System.lineSeparator());
                }
                batch.append(sql);
            }
            sqlResult = stmt.executeBatch();
            conn.commit();
        }
        catch (Exception e) {
            if (e instanceof SQLException && batch != null) {
                logSqlError.debug((Object)("Failed to execute batch: " + batch.toString() + ", SQL error: " + e.getMessage()));
            }
            if (conn != null) {
                conn.rollback();
            }
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                SQLConnectionManager.freeConnection(conn);
            }
        }
        return sqlResult;
    }

    public boolean canQueryTable() throws Exception {
        return this.getDriver().canQueryTable(this.getTable().getNameQuotedIfNecessary(this), this.getSchemaName());
    }

    public void commit(DSTransaction dsTransaction) throws Exception {
        if (!dsTransaction.isUsingSpringTransaction() && SQLTransaction.isConnectionAvailable(dsTransaction, this.dbName)) {
            SQLTransaction.commitTransaction(dsTransaction, this.dbName);
        }
    }

    public void rollback(DSTransaction dsTransaction) throws Exception {
        if (SQLTransaction.isConnectionAvailable(dsTransaction, this.dbName)) {
            SQLTransaction.rollbackTransaction(dsTransaction, this.dbName);
        }
    }

    public String getEnumTranslateStrategy() {
        String value = this.dsConfig.getString((Object)"enumTranslateStrategy");
        if (value == null) {
            value = "string";
        }
        return value;
    }

    public String getTestFileName() throws Exception {
        List configTestFiles = (List)this.dsConfig.get((Object)"sandboxedTestFiles");
        if (configTestFiles == null) {
            return super.getTestFileName();
        }
        DBSandbox sandbox = DBSandbox.getPrevailingSandbox(this.dbName);
        if (sandbox == null) {
            log.info((Object)("No sandbox asserted for " + this.dbName + "; using legacy test file logic"));
            return super.getTestFileName();
        }
        String ownerId = sandbox.getOwnerId();
        if (ownerId == null) {
            log.info((Object)("No ownerId set for sandbox: " + sandbox.getSandboxName() + "; using legacy test file logic"));
            return super.getTestFileName();
        }
        for (Map testFile : configTestFiles) {
            if (!ownerId.equals(testFile.get("ownerId"))) continue;
            String fileName = (String)testFile.get("fileName");
            if (fileName == null) {
                log.warn((Object)("Can't return sandboxed test file for user '" + ownerId + "' as no fileName is declared"));
                continue;
            }
            log.info((Object)("Retrieving test file for user '" + ownerId + "'"));
            return this.canonicalizeTestFileName(fileName);
        }
        log.warn((Object)("No valid test file found for user '" + ownerId + "'"));
        return null;
    }

    public boolean isSQLDataSource() {
        return true;
    }

    public String getMultiInsertStrategy() {
        return this.dsConfig.getString((Object)"multiInsertStrategy");
    }

    public Long getMultiInsertBatchSize() {
        return this.dsConfig.getLong((Object)"multiInsertBatchSize");
    }

    public String getMultiInsertNonMatchingStrategy() {
        return this.dsConfig.getString((Object)"multiInsertNonMatchingStrategy");
    }

    public boolean handlesRelations() {
        return true;
    }

    public boolean handlesNto1Relations() {
        return false;
    }

    protected boolean useArrayFunctionForNToNRelations() {
        return true;
    }

    public String getDefaultCacheSyncStrategyName() {
        return config.getString((Object)"default.sql.cache.sync.strategy");
    }

    public String getDefaultCacheSyncTiming() {
        return config.getString((Object)"default.sql.cache.sync.timing");
    }

    public boolean shouldDeferCacheSync(DSRequest request) throws Exception {
        if (!super.shouldDeferCacheSync(request)) {
            return false;
        }
        boolean isBatchAdding = Boolean.TRUE.equals(request.getAttribute("isBatchAdding"));
        if (this.getSequenceMode() != SequenceMode.JDBC_DRIVER && (request.getFreeOnExecute() || isBatchAdding)) {
            List keys = this.getPrimaryKeys();
            for (int i = 0; i < keys.size(); ++i) {
                if (!"sequence".equals(this.getField((String)keys.get(i)).getType())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldAutoSwitchCacheSyncTiming() {
        return true;
    }

    public String getSchemaName(Map theConfig) {
        log.debug((Object)("In getSchemaName(); for DataSource " + this.getName()));
        String schema = (String)theConfig.get("schema");
        if (schema == null) {
            schema = config.getString((Object)("sql." + this.dbName + ".default.schema"));
        }
        log.debug((Object)("'schema' retrieved from config is '" + (schema == null ? "NULL" : schema) + "'"));
        if (schema != null && schema.indexOf("$") != -1) {
            try {
                log.debug((Object)"Running schema value through Velocity");
                schema = Velocity.evaluateAsString((String)schema, (Map)Velocity.getStandardContextMap(null));
                log.debug((Object)("Evaluated schema value is '" + schema + "'"));
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception while trying to parse schema name as a Velocity template", (Throwable)e);
            }
        }
        return schema;
    }

    protected Map<String, Class> getGeneratedKeyTypes(String seqFieldName, DSRequest addDsRequest) {
        return this.getGeneratedKeyTypes(DataTools.makeList((Object)seqFieldName), addDsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Class> getGeneratedKeyTypes(List<String> seqOrGenFieldList, DSRequest addDsRequest) {
        Connection conn = null;
        Statement stmt = null;
        boolean freeConnection = false;
        if (this._generatedKeyTypes != null) {
            log.debug((Object)("Reusing cache of Java types of generated keys in DataSource " + this.getName()));
            return this._generatedKeyTypes;
        }
        log.info((Object)("Issuing query to determine Java types of generated keys in DataSource " + this.getName()));
        String sql = null;
        try {
            DSRequest req = new DSRequest((DataSource)this, "fetch", addDsRequest.getRPCManager());
            req.setOutputs(seqOrGenFieldList);
            req.setStartRow(0L);
            req.setEndRow(1L);
            sql = SQLDataSource.getSQLClause(SQLClauseType.All, req, true);
            if (addDsRequest.getDsTransaction() != null) {
                conn = (Connection)addDsRequest.getDsTransaction().getAttribute(this.getTransactionObjectKey(true));
            } else {
                SQLDataSource sqlds = (SQLDataSource)addDsRequest.getDataSource();
                conn = SQLConnectionManager.getConnection(sqlds.getDatabaseName());
                freeConnection = true;
            }
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            this._generatedKeyTypes = new HashMap<String, Class>();
            int i = 0;
            while (true) {
                String nativeName;
                DSField field;
                if (i < seqOrGenFieldList.size()) {
                    field = this.getField(seqOrGenFieldList.get(i));
                    nativeName = field.getNativeName();
                    if (nativeName == null) {
                        nativeName = field.getName();
                    }
                } else {
                    if (stmt == null) return this._generatedKeyTypes;
                    try {
                        stmt.close();
                        if (!freeConnection) return this._generatedKeyTypes;
                        SQLConnectionManager.free(conn);
                        return this._generatedKeyTypes;
                    }
                    catch (Exception e) {
                        log.warn((Object)("Caught Exception trying to close JDBC statement " + (freeConnection ? "or connection " : "") + "when determining Generated Key Types"), (Throwable)e);
                        return this._generatedKeyTypes;
                    }
                }
                for (int j = 0; j < seqOrGenFieldList.size(); ++j) {
                    String type;
                    String columnName = rsmd.getColumnName(j + 1);
                    if (nativeName.equalsIgnoreCase(columnName)) {
                        type = rsmd.getColumnClassName(j + 1);
                        this._generatedKeyTypes.put(field.getName(), Class.forName(type));
                        break;
                    }
                    columnName = rsmd.getColumnLabel(j + 1);
                    if (!nativeName.equalsIgnoreCase(columnName)) continue;
                    type = rsmd.getColumnClassName(j + 1);
                    this._generatedKeyTypes.put(field.getName(), Class.forName(type));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            try {
                if (e instanceof SQLException) {
                    logSqlError.debug((Object)("Failed to execute query: " + sql + ", SQL error: " + e.getMessage()));
                }
                log.warn((Object)"Caught Exception trying to determine Generated Key Types", (Throwable)e);
                if (stmt == null) return this._generatedKeyTypes;
            }
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                    if (!freeConnection) throw throwable;
                    SQLConnectionManager.free(conn);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.warn((Object)("Caught Exception trying to close JDBC statement " + (freeConnection ? "or connection " : "") + "when determining Generated Key Types"), (Throwable)e2);
                }
                throw throwable;
            }
            try {
                stmt.close();
                if (!freeConnection) return this._generatedKeyTypes;
                SQLConnectionManager.free(conn);
                return this._generatedKeyTypes;
            }
            catch (Exception e3) {
                log.warn((Object)("Caught Exception trying to close JDBC statement " + (freeConnection ? "or connection " : "") + "when determining Generated Key Types"), (Throwable)e3);
                return this._generatedKeyTypes;
            }
        }
    }

    public boolean supportsCorrelatedSubqueries(DSRequest req) {
        Boolean support = null;
        DataTypeMap opConfig = new DataTypeMap(req.getOperationConfig());
        if (opConfig != null && (support = opConfig.getBoolean((Object)"supportsCorrelatedSubqueries")) != null) {
            return support;
        }
        support = this.getConfig().getBoolean((Object)"supportsCorrelatedSubqueries");
        if (support != null) {
            return support;
        }
        Config dbConfig = Config.getGlobal().getSubtree("sql." + this.getDBName());
        return dbConfig.getBoolean((Object)"supportsCorrelatedSubqueries", true);
    }

    public void _clearGeneratedKeyTypes() {
        this._generatedKeyTypes = null;
    }

    public boolean supportsAggregationInherently() {
        return true;
    }

    private static String appendOracleTextPredicates(DSRequest req, String whereClause, List<SQLDataSource> dataSources) {
        SQLDriver driver;
        FullTextSearchHandler ftsHandler = req.getFTSHandler();
        if (ftsHandler == null || !ftsHandler.hasOracleTextTriggers()) {
            return whereClause;
        }
        SQLDataSource firstDS = null;
        if (dataSources != null && !dataSources.isEmpty()) {
            firstDS = dataSources.get(0);
        } else {
            try {
                firstDS = (SQLDataSource)req.getDataSource();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get DataSource for Oracle Text: " + e.getMessage()));
                return whereClause;
            }
        }
        if (firstDS == null) {
            return whereClause;
        }
        try {
            driver = firstDS.getDriver();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to get SQL driver for Oracle Text: " + e.getMessage()));
            return whereClause;
        }
        if (driver == null || !driver.supportsOracleText() || !(driver instanceof OracleDriver)) {
            log.warn((Object)"Oracle Text FTS triggers present but driver does not support Oracle Text");
            return whereClause;
        }
        OracleDriver oracleDriver = (OracleDriver)driver;
        StringBuilder oracleTextPredicates = new StringBuilder();
        int scoreLabel = 1;
        for (FullTextSearchHandler.FTSTrigger trigger : ftsHandler.getOracleTextTriggers()) {
            String columnName = firstDS.getQualifiedColumnName(trigger.fieldName);
            String predicate = oracleDriver.getOracleTextContainsPredicate(columnName, trigger.queryText, trigger.operator, scoreLabel);
            if (oracleTextPredicates.length() > 0) {
                oracleTextPredicates.append(" AND ");
            }
            oracleTextPredicates.append(predicate);
            ++scoreLabel;
        }
        if (oracleTextPredicates.length() == 0) {
            return whereClause;
        }
        if (whereClause == null || whereClause.trim().isEmpty()) {
            return oracleTextPredicates.toString();
        }
        return whereClause + " AND " + oracleTextPredicates.toString();
    }

    private String getQualifiedColumnName(String fieldName) {
        try {
            DSField field = this.getField(fieldName);
            if (field != null) {
                String dbName = field.getProperty("columnName");
                if (dbName == null) {
                    dbName = fieldName;
                }
                String tableName = this.getTableName();
                return tableName + "." + dbName;
            }
        }
        catch (Exception e) {
            log.debug((Object)("Could not get qualified column name for " + fieldName));
        }
        return fieldName;
    }

    static {
        if (config.getBoolean((Object)"datasources.sql.trace.creation", false)) {
            createTrace = new ArrayList<Map>();
        }
        slowSQLLoggers = new HashMap<String, Logger>();
        queriesSlowerThan = config.getInt((Object)"sql.log.queriesSlowerThan", 10000);
        logAlias = new Logger(SQLDataSource.class.getName() + ".Alias");
        logFK = new Logger(SQLDataSource.class.getName() + ".FK");
        supportedSummaryFunctions = new ArrayList(){
            {
                this.add("MIN");
                this.add("MAX");
                this.add("AVG");
                this.add("SUM");
                this.add("COUNT");
                this.add("CONCAT");
                this.add("ARRAY");
            }
        };
    }

    public static enum SequenceMode {
        JDBC_DRIVER("jdbcDriver"),
        NATIVE("native"),
        NONE("none");

        private String string;

        private SequenceMode(String string2) {
            this.string = string2;
        }

        public static SequenceMode fromString(String string) {
            if (string == null) {
                return null;
            }
            for (SequenceMode mode : SequenceMode.values()) {
                if (!string.equals(mode.string)) continue;
                return mode;
            }
            return null;
        }
    }

    private static enum CriterionFieldInclusion {
        TOTAL,
        PARTIAL,
        NONE,
        INSEPARABLE,
        INVALID;

    }
}

