/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.io.IByteCounter;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCFileItem;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;

public class ISCFileItemFactory
implements FileItemFactory<ISCFileItem> {
    private static Logger log = new Logger(ISCFileItemFactory.class.getName());
    private static Config config = Config.getGlobal();
    IByteCounter byteCounter;
    int sizeThreshold;
    Path tempDirectory;

    public ISCFileItemFactory() {
        this(null);
    }

    public ISCFileItemFactory(IByteCounter byteCounter) {
        this.byteCounter = byteCounter;
        this.sizeThreshold = (int)config.getDataSizeNumBytes((Object)"fileUpload.sizeThreshold", 10240L);
        String tempDirPath = config.getString("fileUpload.tempDirectory", null);
        if (tempDirPath != null && !tempDirPath.isEmpty()) {
            File tempDir = new File(tempDirPath);
            if (!tempDir.exists()) {
                if (!tempDir.mkdirs()) {
                    log.warn("Failed to create temp directory: " + tempDirPath + ", using system default");
                    tempDirPath = null;
                }
            } else if (!tempDir.isDirectory() || !tempDir.canWrite()) {
                log.warn("Temp directory not writable: " + tempDirPath + ", using system default");
                tempDirPath = null;
            }
            if (tempDirPath != null) {
                this.tempDirectory = Paths.get(tempDirPath, new String[0]);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("ISCFileItemFactory configured: sizeThreshold=" + this.sizeThreshold + " bytes, tempDirectory=" + String.valueOf(this.tempDirectory != null ? this.tempDirectory : "system default"));
        }
    }

    public ISCFileItem.Builder fileItemBuilder() {
        return ISCFileItem.builder().setByteCounter(this.byteCounter).setSizeThreshold(this.sizeThreshold).setTempDirectory(this.tempDirectory);
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        ISCFileItem.Builder builder = (ISCFileItem.Builder)((ISCFileItem.Builder)((ISCFileItem.Builder)((ISCFileItem.Builder)this.fileItemBuilder().setFieldName(fieldName)).setContentType(contentType)).setFormField(isFormField)).setFileName(fileName);
        return builder.get();
    }
}

