/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import java.util.Map;

class ValidatedSubqueryResolver
implements SubqueryResolver {
    private static Logger log = new Logger(ValidatedSubqueryResolver.class);
    private DSRequest parentRequest;

    ValidatedSubqueryResolver(DSRequest parentRequest) {
        this.parentRequest = parentRequest;
    }

    @Override
    public Map resolveSubquery(Map subquery, boolean isFieldQuery) throws Exception {
        Boolean shouldSeparate = (Boolean)subquery.get("_shouldSeparate");
        if (!Boolean.TRUE.equals(shouldSeparate)) {
            return null;
        }
        DSRequest subReq = (DSRequest)subquery.get("_validatedDSRequest");
        if (subReq == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query is marked for separation but has no _validatedDSRequest.  This indicates the subquery was not validated by SubqueryValidator.");
        }
        return this.parentRequest.processCriteriaSubquery(subReq, false);
    }
}

