/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.SubqueryResolver;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSRequestDoNotSerialize;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.SummaryFunctionType;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SubqueryValidator
implements SubqueryResolver {
    private static Logger log = new Logger(SubqueryValidator.class);
    private DSRequest parentRequest;
    private Map subQuerySeparation;

    SubqueryValidator(DSRequest parentRequest, Map subQuerySeparation) {
        this.parentRequest = parentRequest;
        this.subQuerySeparation = subQuerySeparation;
    }

    @Override
    public Map resolveSubquery(Map subquery, boolean isFieldQuery) throws Exception {
        DSRequestDoNotSerialize subReq;
        Config config = Config.getGlobal();
        boolean globalAllowed = config.getBoolean((Object)"allowCriteriaSubqueries", true);
        Boolean dsAllowed = this.parentRequest.getDataSource().getConfig().getBoolean("allowCriteriaSubqueries");
        boolean subqueriesAllowed = dsAllowed != null ? dsAllowed : globalAllowed;
        if (!subqueriesAllowed) {
            throw new Exception("Encountered a " + (isFieldQuery ? "field" : "value") + "Query definition in an AdvancedCriteria, but this feature is disallowed " + (String)(Boolean.FALSE.equals(dsAllowed) ? "for DataSource " + this.parentRequest.getDataSourceName() : "globally"));
        }
        String dataSourceName = (String)subquery.get("dataSource");
        if (dataSourceName == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query does not specify a dataSource");
        }
        BasicDataSource ds = (BasicDataSource)DataSourceManager.get(dataSourceName);
        if (ds == null) {
            throw new Exception((isFieldQuery ? "field" : "value") + "Query specifies dataSource '" + dataSourceName + "', which is not known");
        }
        BasicDataSource thisDS = (BasicDataSource)this.parentRequest.getDataSource();
        if (!this.parentRequest.isClientRequest() && this.parentRequest.allowArbitrarySubqueries()) {
            log.info("Server-initiated DSRequest allows arbitrary subqueries: creating a sub-DSRequest with every property specified in the subquery config");
            subReq = new DSRequestDoNotSerialize(subquery);
        } else {
            log.info("Client-initiated DSRequest, or does not allow arbitrary subqueries: creating a sub-DSRequest with just the properties allowed for restricted subqueries");
            subReq = new DSRequestDoNotSerialize(dataSourceName, "fetch", this.parentRequest.getRPCManager());
            if (subquery.containsKey("criteria")) {
                subReq.setCriteria(subquery.get("criteria"));
            }
            if (subquery.containsKey("operationId")) {
                subReq.setOperationId((String)subquery.get("operationId"));
            }
            if (subquery.containsKey("queryFK")) {
                subReq.setParameter("queryFK", subquery.get("queryFK"));
            }
            if (subquery.containsKey("queryOutput")) {
                subReq.setQueryOutput(subquery.get("queryOutput").toString());
            }
        }
        if (subquery.containsKey("summaryFunctions")) {
            Map sf = (Map)subquery.get("summaryFunctions");
            HashMap<String, SummaryFunctionType> sfConverted = new HashMap<String, SummaryFunctionType>();
            int c = 0;
            Iterator iter = sf.keySet().iterator();
            while (iter.hasNext()) {
                if (c++ > 0) {
                    log.warn((isFieldQuery ? "field" : "value") + "Query specifies multiple summaryFunctions, which is not supported (and does not make sense).  Discarding all but the first");
                    break;
                }
                String key = (String)iter.next();
                if (ds.getField(key) == null) {
                    log.warn("A " + (isFieldQuery ? "field" : "value") + "Query on dataSource '" + dataSourceName + "' specifies a summaryFunction on field '" + key + "' but the dataSource does not have a field of that name.  Expect incorrect results.");
                }
                sfConverted.put(key, SummaryFunctionType.valueOf(((String)sf.get(key)).toUpperCase()));
            }
            subReq.setSummaryFunctions(sfConverted);
        }
        if (subquery.containsKey("groupBy")) {
            Object groupByObj = subquery.get("groupBy");
            ArrayList<String> groupBy = null;
            if (!(groupByObj instanceof List)) {
                groupBy = new ArrayList<String>();
                groupBy.add((String)groupByObj);
            } else {
                groupBy = (ArrayList<String>)groupByObj;
            }
            subReq.setGroupBy(groupBy);
        }
        subReq.setWarnIfFieldLevelSecurityFails(true);
        subReq.setIsSubquery(true);
        this.parentRequest.addSubRequest(subReq);
        SubqueryValidator nestedResolver = new SubqueryValidator(subReq, this.subQuerySeparation);
        AdvancedCriteria.resolveSubqueries(subReq.getCriteria(), nestedResolver);
        this.parentRequest.processCriteriaSubquery(subReq, true);
        subquery.put("_validatedDSRequest", subReq);
        boolean shouldSeparate = thisDS.shouldSeparateSubquery(subquery, ds, this.parentRequest);
        subquery.put("_shouldSeparate", shouldSeparate);
        return null;
    }
}

